<?php
#error_reporting(E_ALL );
#ini_set( 'display_errors' , true );
/*
#
# +------------------------------------------------------------------------------+
# | Sitemap Creator 0.2 beta  build 20080514                                     |
# +------------------------------------------------------------------------------+
# | Sitemap Creator crawls/spiders your website, creates XML sitemaps , pings    |
# | Search Engine bots to crawl them, tracks bots and send it by mail.           |
# +------------------------------------------------------------------------------+
# | Email         gadelkareem@gmail.com                                          |
# | Web           www.gadelkareem.com                                            |
# |                                                                              |
# | Before using, modifying or publishing this class, you should refer to the    |
# | GNU GENERAL PUBLIC LICENSE. This is available at:                            |
# | http://www.gnu.org/licenses/gpl.txt                                          | 
# +------------------------------------------------------------------------------+
# | sitemap.php : start file , do not edit                                       |
# +------------------------------------------------------------------------------+
#
*/

require_once realpath(dirname(__FILE__)).'/.config.inc.php';
require_once realpath(dirname(__FILE__)).'/.function.inc.php';
$fbug = false;
if(isset($_GET['do']))
	if($_GET['do'] == 'showsitemap'){
		get_sitemap();
		exit;
	}elseif($_GET['do'] == 'gss.xsl'){
		header('Content-type: text/xml; charset=UTF-8');
		readfile(SMC_DATA.'gss.xsl');
		exit;
	}
if( SMC_PASS && isset($_POST['pass']) && $_POST['pass'] == SMC_PASS)
	setcookie('smc_pass', md5(SMC_PASS), time()+86400);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Sitemap Creator By GadElKareem</title>
<script language="javascript" type="text/javascript">
<!--
var d=document,t=0;
function countdown(s){
	if(t==0 && s > 0) t = s;
	$('count').style['display'] = 'block';
	$('content').style['display'] = 'none';
	$('content').style['display'] = 'none';
	$('progress').style['width'] = (100-(s*100)/t)+'%';
	$('counter').innerHTML = s;
	s = s > 0 ? s-1 : 0;
	setTimeout( 'countdown('+s+')',1400 );
}
function $(id){
	return (d.getElementById) ? d.getElementById(id) : d.all[id];
}
//-->
</script>
<style type="text/css">
<!--
html,body {
margin:0;
padding:0;
font: normal 1em "Trebuchet MS","Lucida Grande",Arial;
}
h1{
padding:0.12em;
font: bold 2.6em  , "Times New Roman", Times;
}
h1 a,h1 a:visited{
color:#000066;
border-bottom:#000066 1px solid;
}
a, a:visited{
color:#0000CC;
text-decoration:none;
}
a:hover{
color:#FF0000;
}
li a{
font-weight:bold;
}
li a:hover{
color:#fff;
background:#0000FF;
}
#err {
background:#FFFF99;
cursor:default;
text-align:center;
border:#999999 1px solid;
border-bottom:none;
padding:2px;
}
#err:hover {
background:#000099;
color:#FFFFFF;
}
#content{
padding:5px 15px;
} 
#count, #counter{
font:italic 2em Georgia, "Times New Roman", Times;text-align:center
}
#count{
display:none;
min-height:30em;
}
#counter{
font-size:6em !important;
}
#progress{
width:1%;
height:20px;
background:#FF0000;
}
#progress img{
float:right;
}
.cp{
font-size:1em;
text-align:center;
clear:both;
margin-top:100px;
}
table {
font: 11px/24px Verdana, Arial, Helvetica, sans-serif;
border-collapse: collapse;
}
th {
padding: 0 0.5em;
text-align: left;
}
tr th {
border-top: 1px solid #FB7A31;
border-bottom: 1px solid #FB7A31;
background: #FFC;
cursor:default;
white-space:nowrap;
}
td {
border-bottom: 1px solid #CCC;
padding: 0 0.5em;
}
tr:hover{
background:#F5F5F5;
font-weight:bold;
}
table a {
display:block;
}
table td div{
max-width:100%;
overflow:hidden;
}
.secure{
background:#E6E6E6;
padding:4px;
color:#333333;
font:bold 1em "Courier New", Courier, monospace;
}
#numbers {
	font:normal 100%/200% Georgia, "Times New Roman", Times, serif;
	padding:2px 20px;
	clear:both;
	text-align:center;
}
#numbers a {
	border:1px #0066FF solid;
	padding:3px 4px;
	margin:2px;
	text-decoration:none;
}
#numbers a:hover, #numbers u {
	border:1px #0066FF solid;
	padding:3px 4px;
	margin:2px;
	background:#000099;
	color:#FFF;
}

-->
</style>
</head>
<body>
<?php

login();

if(!@touch(SMC_DATA.'check') )
	echo '<div id="err">Please make sure data directory <strong>'.SMC_DATA.'</strong> exists and is writtable</div>';
csv(true);


?>
<h1><a href="<?php echo SMC_SELF ?>" >Sitemap Creator <?php echo SMC_VERSION ?></a></h1>
<ul>
<li><a href="<?php echo SMC_SELF ?>?do=crawl" onclick="countdown(<?php echo SMC_CRAWL_TIME_OUT ?>)"><?php echo !empty($urls) ? 'Resume Crawling <strong>'.SMC_SITE.'</strong></a> ( '.count($urls).' Links)' : 'Crawl <strong>'.SMC_SITE.'</strong></a>'; ?></li>
<li><a href="<?php echo SMC_SELF ?>?do=createsitemap">Create Sitemaps</a></li>
<li><a href="<?php echo SMC_SELF ?>?do=readcsv" title="<?php echo SMC_DATA_SITES.SMC_SITE; ?>" >Display CSV File</a></li>
<li><a href="<?php echo SMC_SELF ?>?do=cleancache">Clean cache directory</a> ( <?php echo clean_dir(true); ?> Pages )</li>
<li><a href="<?php echo SMC_SELF ?>?do=cleanerr">Clean BlackList directory</a> ( <?php echo clean_dir(true,2); ?> URLs )</li>
<li><a href="<?php echo SMC_SELF ?>?do=robots">Add reference to robots.txt</a> </li>
</ul>
<hr />
<div id="count">Crawling <strong><?php echo SMC_SITE; ?></strong><br />Please wait...<br /><span id="counter"></span><div id="progress"><img src="data/img/spider.gif" /></div></div>
<div id="content">
<?php

$do = isset($_GET['do']) ? $_GET['do'] : '';

if( _mem() === false || intval(@ini_get("memory_limit")) < SMC_MEMORY_LIMIT )
	@ini_set("memory_limit", (SMC_MEMORY_LIMIT+10).'M');

@set_time_limit(0);
switch($do){

	case 'crawl':
		$start_time = _time();
		
		$redirect = array();
		
		$urls = array();
		
		crawl( SMC_SCHEME . SMC_SITE . '/' , 1, 0, true);
		
		if(empty($urls)){
			echo '<p>No Pages were crawled, Please make sure you have set your site domain correctly and you have valid connection to host</p>';
			exit;
		}else{
		
			calc();
	
			if(csv())
				$csv = true;
			
			$took = round(_time()-$start_time, 2);
			if( $took > SMC_CRAWL_TIME_OUT )
				$finish = '<strong>Crawler Timed out after '.SMC_CRAWL_TIME_OUT.' seconds while ' ;
			elseif( _mem() > SMC_MEMORY_LIMIT )
				$finish = '<strong>Memory Limit '.SMC_MEMORY_LIMIT.'MB reached while ';
			elseif( SMC_URLS_LIMIT && count($urls) > SMC_URLS_LIMIT )
				$finish = '<strong>URLs Limit ' . SMC_URLS_LIMIT . ' URLs reached while ';
			else
				$finish = '<strong>Finished ';
			
			echo '<br />'. $finish .'crawling '.SMC_SITE.'</strong>, Crawled '.count($urls).' links<br>Took '.$took.' Seconds, using '._mem().'MB of memory<br />';
			
			if( isset($csv) ) 
				echo 'CSV File Created at <br /><strong><a href="'.SMC_SELF.'?do=readcsv">'.SMC_DATA_SITES.SMC_SITE.'</a></strong><br />edit this file in a text editor to make changes to sitemap';
			
			draw_table();
			
			
		}
		
	break;
	case 'cleancache':
		clean_dir();
	break;
	case 'createsitemap':
		if(isset($_GET['secure']) && SMC_CRAWL_FIRST){
			$start_time = _time();
			$urls = array();
			crawl('http://'.SMC_SITE.'/');
			if(!empty($urls)){
				calc();
				csv();
			}
		}

		if(!empty($urls))
			create_sitemap();
		else
			echo 'Please <a href="'.SMC_SELF.'?do=crawl" onclick="countdown('.SMC_CRAWL_TIME_OUT.')">crawl <strong>'.SMC_SITE.'</strong> first</a>.';
	break;
	case 'readcsv':
		if(@file_exists(SMC_DATA_SITES.SMC_SITE))
			_echo(SMC_DATA_SITES.SMC_SITE);
		else
			echo 'Please <a href="'.SMC_SELF.'?do=crawl" onclick="countdown('.SMC_CRAWL_TIME_OUT.')">crawl <strong>'.SMC_SITE.'</strong> first</a>.';
	break;
	case 'ping':
		ping_em(intval($_GET['sm']));
	break;
	case 'cleanerr':
		clean_dir(false,2);
	break;
	case 'robots':
		robots();
	break;
	default:
		if(!empty($urls)){
			
			draw_table();
		
		}else
			echo '<strong>No crawl History Found for '.SMC_SITE.'</strong>, <a href="'.SMC_SELF.'?do=crawl" onclick="countdown('.SMC_CRAWL_TIME_OUT.')">click here to start crawling</a>';
	break;
}
?>
<br clear="all" />
</div>
<div class="cp"><hr /><a href="<?php echo SMC_SM_URL; ?>" >Sitemap Creator <?php echo SMC_VERSION ?></a> By <a href="<?php echo SMC_URL; ?>">GadElKareem</a></div>
</body>
</html>
