<?php

/*
////////////////////////////////////////////////////////////////////////////////
// JohnCMS                Mobile Content Management System                    //
// Project site:          http://johncms.com                                  //
// Support site:          http://gazenwagen.com                               //
////////////////////////////////////////////////////////////////////////////////
// Lead Developer:        Oleg Kasyanov   (AlkatraZ)  alkatraz@gazenwagen.com //
// Development Team:      Eugene Ryabinin (john77)    john77@gazenwagen.com   //
//                        Dmitry Liseenko (FlySelf)   flyself@johncms.com     //
////////////////////////////////////////////////////////////////////////////////
*/

define('_IN_JOHNCMS', 1);
require('../incfiles/core.php');
$textl = 'FAQ';
$headmod = 'faq';
require('../incfiles/head.php');

// Обрабатываем ссылку для возврата
if (empty($_SESSION['ref'])) {
    $_SESSION['ref'] = htmlspecialchars($_SERVER['HTTP_REFERER']);
}
switch ($act) {
    case 'forum':
        /*
        -----------------------------------------------------------------
        Правила Форума
        -----------------------------------------------------------------
        */
        echo '<div class="phdr"><a href="faq.php"><b>F.A.Q.</b></a> | Правила Форума</div>' .
            '<div class="menu"><p><b>1) НА ФОРУМЕ ЗАПРЕЩЕНО:</b><br/><br/>
            <b>1.1</b> Сообщения рекламного характера.<br/>
            <b>1.2</b> Сообщения, содержащие прямую пропаганду расовой, национальной и религиозной вражды.<br/>
            <b>1.3</b> Сообщения, содержащие ненормативную лексику и/или сексуальные домогательства.<br/>
            <b>1.4</b> Сообщения, явно оскорбляющие кого-либо, а тем более участников форума.<br/>
            <b>1.5</b> Преднамеренно искажать написание ников других участников форума с целью придания сообщению оскорбительного оттенка.<br/>
            <b>1.6</b> Публиковать одно и то же сообщение несколько раз в одном или разных топиках форума.<br/>
            <b>1.7</b> Повторно публиковать сообщения, удаленные модераторами.<br/>
            <b>1.8</b> Публиковать сообщения, не относящиеся к заявленной теме.<br/>
            <b>1.9</b> Продолжать темы, закрытые модераторами.<br/><br/><b>2) КАТЕГОРИЧЕСКИ ЗАПРЕЩАЕТСЯ:</b><br/><br/>
            <b>2.1</b> Высказывать в публичных топиках недовольство некорректными действиями участников форума и обсуждать действия модераторов. Для этого есть приватная почта.<br/>
            <b>2.2</b> Использовать при регистрации ники,имеющие оскорбительный для других пользователей характер.<br/><br/>
            <b>3) КРАЙНЕ НЕЖЕЛАТЕЛЬНО:</b><br/><br/><b>3.1</b> Цитировать сообщения предыдущего посетителя целиком и цитировать сообщения, уже содержащие цитаты предыдущих сообщений..<br/>
            <b>3.2</b> Публиковать сообщения, состоящие только из ссылки на другой сайт. <br/>
            <b>3.3</b> Публиковать текст, написанный на латинице.<br/>
            <b>3.4</b> Публиковать сообщения без признаков дискуссии: состоящие только из смайликов и/или фраз типа &quot;Ну-ну&quot;, &quot;И чо?&quot;, &quot;Кто здесь?&quot; и тому подобных. <br/>
            <br/>Сообщения, опубликованные вопреки указанным выше предупреждениям, будут изменены либо удалены.
            <br />За неоднократные нарушения настоящих правил адмиристрация вправе применять к виновным штрафные санкции вплоть до удаления учетной записи.</p></div>' .
            '<div class="phdr"><a href="' . $_SESSION['ref'] . '">Назад</a></div>';
        break;

    case 'tags':
        /*
        -----------------------------------------------------------------
        Справка по BBcode
        -----------------------------------------------------------------
        */
   echo '<div class="phdr"><a href="faq.php"><b>F.A.Q.</b></a> | FAQ по тэгам</div>' .
            '<div class="menu"><p><table cellpadding="2" cellspacing="0">
            <tr><td align="right"><h3>BBcode</h3></td></tr>
            <tr><td align="right">[php]...[/php]</td><td>исходный код PHP</td></tr>
            <tr><td align="right">Ссылка</td><td>[url=http://адрес_ссылки]название ссылки[/url]</td></tr>
            <tr><td align="right">[b]...[/b]</td><td><b>жирный</b></td></tr>
            <tr><td align="right">[i]...[/i]</td><td><i>наклонный</i></td></tr>
            <tr><td align="right">[u]...[/u]</td><td><u>подчеркнутый</u></td></tr>
            <tr><td align="right">[s]...[/s]</td><td><strike>перечеркнутый</strike></td></tr>
            <tr><td align="right">[red]...[/red]</td><td><span style="color:red">Красный</span></td></tr>
            <tr><td align="right">[green]...[/green]</td><td><span style="color:green">Зеленый</span></td></tr>
            <tr><td align="right">[blue]...[/blue]</td><td><span style="color:blue">Синий</span></td></tr>
            <tr><td align="right">[c]...[/c]</td><td><span class="quote">текст в блоке</span></td></tr></table></p></div>' .
            '<div class="phdr"><a href="' . $_SESSION['ref'] . '">Назад</a></div>';
        break;

    case 'trans':
        /*
        -----------------------------------------------------------------
        Справка по Транслиту
        -----------------------------------------------------------------
        */
        echo '<div class="phdr"><a href="faq.php"><b>F.A.Q.</b></a> | Справка по транслиту</div>' .
            '<div class="menu"><p><h3>Правила транслита</h3>а - a
            <br/>б - b
            <br/>в - v
            <br/>г - g
            <br/>д - d
            <br/>е - e
            <br/>ё - yo
            <br/>ж - zh
            <br/>з - z
            <br/>и - i
            <br/>й - j
            <br/>к - k
            <br/>л - l
            <br/>м - m
            <br/>н - n
            <br/>о - o
            <br/>п - p
            <br/>р - r
            <br/>с - s
            <br/>т - t
            <br/>у - u
            <br/>ф - f
            <br/>х - h
            <br/>ц - c
            <br/>ч - ch
            <br/>ш - w
            <br/>щ - sh
            <br/>ъ - q
            <br/>ы - y
            <br/>э - x
            <br/>ю - yu
            <br/>я - ya
            <br/>
            <br/>А - A
            <br/>Б - B
            <br/>В - V
            <br/>Г - G
            <br/>Д - D
            <br/>Е - E
            <br/>Ё - YO
            <br/>Ж - ZH
            <br/>З - Z
            <br/>И - I
            <br/>Й - J
            <br/>К - K
            <br/>Л - L
            <br/>М - M
            <br/>Н - N
            <br/>О - O
            <br/>П - P
            <br/>Р - R
            <br/>С - S
            <br/>Т - T
            <br/>У - U
            <br/>Ф - F
            <br/>Х - H
            <br/>Ц - C
            <br/>Ч - CH
            <br/>Ш - W
            <br/>Щ - SH
            <br/>Ъ - Q
            <br/>Ы - Y
            <br/>Э - X
            <br/>Ю - YU
            <br/>Я - YA</p></div>' .
            '<div class="phdr"><a href="' . $_SESSION['ref'] . '">Назад</a></div>';
        break;

    case 'smusr':
        /*
        -----------------------------------------------------------------
        Каталог пользовательских Смайлов
        -----------------------------------------------------------------
        */
        if (!is_dir($rootpath . 'images/smileys/user/' . $id)) {
            echo functions::display_error('Неверные данные <a href="faq.php?act=smileys">Назад</a>');
            require('../incfiles/end.php');
            exit;
        }
        echo '<div class="phdr"><a href="faq.php?act=smileys"><b>Смайлы</b></a> | ' . htmlentities(file_get_contents($rootpath . 'images/smileys/user/' . $id . '/name.dat'), ENT_QUOTES, 'utf-8') . '</div>';
        $array = array ();
        $dir = opendir('../images/smileys/user/' . $id);
        while ($file = readdir($dir)) {
            if (($file != '.') && ($file != "..") && ($file != "name.dat") && ($file != ".svn") && ($file != "index.php")) {
                $array[] = $file;
            }
        }
        closedir($dir);
        $total = count($array);
        $end = $start + $kmess;
        if ($end > $total)
            $end = $total;
        if ($total > 0) {
            for ($i = $start; $i < $end; $i++) {
                $smile = preg_replace('#^(.*?).(gif|jpg|png)$#isU', '$1', $array[$i], 1);
                echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
                echo '<img src="../images/smileys/user/' . $id . '/' . $array[$i] . '" alt="" /> - :' . $smile . ': или :' . functions::trans($smile) . ':</div>';
            }
        } else {
            echo '<div class="menu"><p>Список пуст</p></div>';
        }
        echo '<div class="phdr">Всего: ' . $total . '</div>';
        if ($total > $kmess) {
            echo '<p>' . functions::display_pagination('faq.php?act=smusr&amp;id=' . $id . '&amp;', $start, $total, $kmess) . '</p>';
            echo '<p><form action="faq.php?act=smusr&amp;id=' . $id . '" method="post">' .
                '<input type="text" name="page" size="2"/>' .
                '<input type="submit" value="К странице &gt;&gt;"/></form></p>';
        }
        echo '<p><a href="' . $_SESSION['ref'] . '">Назад</a></p>';
        break;

    case 'smadm':
        /*
        -----------------------------------------------------------------
        Каталог Админских Смайлов
        -----------------------------------------------------------------
        */
        if ($rights < 1) {
            echo functions::display_error('Неверные данные<a href="faq.php?act=smileys">Назад</a>');
            require('../incfiles/end.php');
            exit;
        }
        echo '<div class="phdr"><a href="faq.php?act=smileys"><b>Смайлы</b></a> | Для администрации</div>';
        $array = array ();
        $dir = opendir('../images/smileys/admin');
        while ($file = readdir($dir)) {
            if (($file != '.') && ($file != "..") && ($file != "name.dat") && ($file != ".svn") && ($file != "index.php")) {
                $array[] = $file;
            }
        }
        closedir($dir);
        $total = count($array);
        if ($total > 0) {
            $end = $start + $kmess;
            if ($end > $total)
                $end = $total;
            for ($i = $start; $i < $end; $i++) {
                $smile = preg_replace('#^(.*?).(gif|jpg|png)$#isU', '$1', $array[$i], 1);
                echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
                echo '<img src="../images/smileys/admin/' . $array[$i] . '" alt="" /> - :' . $smile . ': или :' . trans($smile) . ':</div>';
            }
        } else {
            echo '<div class="menu"><p>Список пуст</p></div>';
        }
        echo '<div class="phdr">Всего: ' . $total . '</div>';
        if ($total > $kmess) {
            echo '<p>' . functions::display_pagination('faq.php?act=smadm&amp;', $start, $total, $kmess) . '</p>';
            echo '<p><form action="faq.php?act=smadm" method="post">' .
                '<input type="text" name="page" size="2"/>' .
                '<input type="submit" value="К странице &gt;&gt;"/></form></p>';
        }
        echo '<p><a href="' . $_SESSION['ref'] . '">Назад</a></p>';
        break;

    case 'smileys':
        /*
        -----------------------------------------------------------------
        Главное меню каталога смайлов
        -----------------------------------------------------------------
        */
        echo '<div class="phdr"><a href="faq.php"><b>F.A.Q.</b></a> | Смайлы</div>';
        if ($rights >= 1) {
            echo '<div class="gmenu"><a href="faq.php?act=smadm">Для администрации</a> (' . (int)count(glob($rootpath . 'images/smileys/admin/*.gif')) . ')</div>';
        }
        $dir = glob($rootpath . 'images/smileys/user/*', GLOB_ONLYDIR);
        $total_dir = count($dir);
        for ($i = 0; $i < $total_dir; $i++) {
            echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
            echo '<a href="faq.php?act=smusr&amp;id=' . preg_replace('#^' . $rootpath . 'images/smileys/user/#isU', '', $dir[$i], 1) . '">' . htmlentities(file_get_contents($dir[$i] . '/name.dat'), ENT_QUOTES, 'utf-8') . '</a> ('
                . (int)count(glob($dir[$i] . '/*.gif')) . ')</div>';
        }
        echo '<div class="phdr"><a href="' . $_SESSION['ref'] . '">Назад</a></div>';
        break;

    case 'avatars':
        /*
        -----------------------------------------------------------------
        Каталог пользовательских Аватаров
        -----------------------------------------------------------------
        */
        if ($id && is_dir($rootpath . 'images/avatars/' . $id)) {
            $avatar = isset($_GET['avatar']) ? intval($_GET['avatar']) : false;
            if ($user_id && $avatar && is_file('../images/avatars/' . $id . '/' . $avatar . '.png')) {
                // Устанавливаем пользовательский Аватар
                if(@copy('../images/avatars/' . $id . '/' . $avatar . '.png', '../files/users/avatar/' . $user_id . '.png'))
                    echo '<div class="gmenu"><p>Аватар успешно установлен<br />' .
                        '<a href="../users/profile.php?act=edit">Далее</a></p></div>';
                else
                    echo functions::display_error('Ошибка выбора Аватара <a href="' . $_SESSION['ref'] . '">Назад</a>');
            } else {
                // Показываем список Аватаров
                echo '<div class="phdr"><a href="faq.php?act=avatars"><b>Аватары</b></a> | ' . htmlentities(file_get_contents($rootpath . 'images/avatars/' . $id . '/name.dat'), ENT_QUOTES, 'utf-8') . '</div>';
                $array = glob($rootpath . 'images/avatars/' . $id . '/*.png');
                $total = count($array);
                $end = $start + $kmess;
                if ($end > $total)
                    $end = $total;
                if ($total > 0) {
                    for ($i = $start; $i < $end; $i++) {
                        $ava = preg_replace('#^' . $rootpath . 'images/avatars/' . $id . '/(.*?).png$#isU', '$1', $array[$i], 1);
                        echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
                        echo '<img src="' . $array[$i] . '" alt="" />';
                        if ($user_id)
                            echo ' - <a href="faq.php?act=avatars&amp;id=' . $id . '&amp;avatar=' . $ava . '">Выбрать</a>';
                        echo '</div>';
                    }
                } else {
                    echo '<div class="menu">Список пуст</div>';
                }
                echo '<div class="phdr">Всего: ' . $total . '</div>';
                if ($total > $kmess) {
                    echo '<p>' . functions::display_pagination('faq.php?act=avatars&amp;id=' . $id . '&amp;', $start, $total, $kmess) . '</p>' .
                        '<p><form action="faq.php?act=avatars&amp;id=' . $id . '" method="post">' .
                        '<input type="text" name="page" size="2"/>' .
                        '<input type="submit" value="К странице &gt;&gt;"/>' .
                        '</form></p>';
                }
                echo '<p><a href="faq.php?act=avatars">Каталог</a><br />' .
                    '<a href="' . $_SESSION['ref'] . '">Назад</a></p>';
            }
        } else {
            // Показываем каталоги с Аватарами
            echo '<div class="phdr"><a href="faq.php"><b>F.A.Q.</b></a> | аватары</div>';
            $dir = glob($rootpath . 'images/avatars/*', GLOB_ONLYDIR);
            $total = 0;
            $total_dir = count($dir);
            for ($i = 0; $i < $total_dir; $i++) {
                $count = (int)count(glob($dir[$i] . '/*.png'));
                $total = $total + $count;
                echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
                echo '<a href="faq.php?act=avatars&amp;id=' . preg_replace('#^' . $rootpath . 'images/avatars/#isU', '', $dir[$i], 1) . '">' . htmlentities(file_get_contents($dir[$i] . '/name.dat'), ENT_QUOTES, 'utf-8') .
                    '</a> (' . $count . ')</div>';
            }
            echo '<div class="phdr">Всего: ' . $total . '</div>' .
                '<p><a href="' . $_SESSION['ref'] . '">Назад</a></p>';
        }
        break;

    default:
        /*
        -----------------------------------------------------------------
        Главное меню FAQ
        -----------------------------------------------------------------
        */
        echo '<div class="phdr"><b>F.A.Q.</b></div>' .
            '<div class="menu"><a href="faq.php?act=forum">Правила Форума</a></div>' .
            '<div class="menu"><a href="faq.php?act=tags">FAQ по тэгам</a></div>' .
            '<div class="menu"><a href="faq.php?act=trans">Справка по транслиту</a></div>' .
            '<div class="menu"><a href="faq.php?act=avatars">Аватары</a></div>' .
            '<div class="menu"><a href="faq.php?act=smileys">Смайлы</a></div>' .
            '<div class="phdr"><a href="' . $_SESSION['ref'] . '">Назад</a></div>';
}

require('../incfiles/end.php');
?>