<?php
/*
 * Naijadev Clone 3.1.0 (http://naijadev.ml or http://naijadev.in)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Project
 * @email		Tunzxywalex@gmail.com
 * @Whatsapp	+2349076642400
 * @copyright   Copyright (C) Naijadev Community 2018
 * @license     Premium Version Licence
 */

namespace Johncms\Forum;

trait SQLHelper
{
    private function getPicks() {
        $array = $this->diff($this->getInts(), $this->bans()->get());
        return count($array) > 0 ? ' AND `id` IN(' . implode(',', $array) . ')' : '';
    }
    
    private function getBans() {
        $array = $this->diff($this->getInts('ban'), $this->picks()->get());
        return count($array) > 0 ? ' AND `id` NOT IN(' . implode(',', $array) . ')' : '';
    }
    
    private function getTime() {
        return $this->time;
    }
    
    public function where() {
        return $this->getPicks() . (!$this->getPicks() ? $this->getBans() : '');
    }
    
    public function whereTime() {
        return $this->where() . ($this->getTime() ? ' AND `time` > ' . $this->getTime() : '');
    }
}
