<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

@ini_set("max_execution_time", "600");
define('_IN_JOHNCMS', 1);
define('_IN_JOHNADM', 1);

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';
$do = isset($_REQUEST['do']) ? trim($_REQUEST['do']) : false;

require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

// Проверяем права доступа
if ($systemUser->rights < 1) {
    header('Location: http://johncms.com/?err');
    exit;
}

$headmod = 'admin';
$textl = _t('Admin Panel');
require('../system/head.php');

$array = [
    'forum',
    'news',
    'ads',
    'counters',
    'ip_whois',
    'languages',
    'settings',
    'themes',
    'smilies',
    'access',
    'antispy',
    'httpaf',
    'ipban',
    'antiflood',
    'ban_panel',
    'karma',
    'reg',
    'mail',
    'search_ip',
    'usr',
    'usr_adm',
    'usr_clean',
    'usr_del',
];

if ($act && ($key = array_search($act, $array)) !== false && file_exists('includes/' . $array[$key] . '.php')) {
    require('includes/' . $array[$key] . '.php');
} else {
    $regtotal = $db->query("SELECT COUNT(*) FROM `users` WHERE `preg`='0'")->fetchColumn();
    $bantotal = $db->query("SELECT COUNT(*) FROM `cms_ban_users` WHERE `ban_time` > '" . time() . "'")->fetchColumn();
 echo '<div class="phdr"><b>' . _t('Admin Panel') . '</b></div>';

    // Блок пользователей
    echo '<div class="user"><p><h3>' . _t('Users') . '</h3><left><table>';
   
    if ($regtotal && $systemUser->rights >= 6) {
        echo '<tr><td class=""><span class="red"><b><a href="index.php?act=reg">' . _t('On registration') . '</a>&#160;(' . $regtotal . ')</b></span><p>Total Register members on community</p>';
    }

    echo '<tr><td class=""><a href="index.php?act=usr"><b>' . _t('Users') . '</b></a>&#160;<span style="color:#006"><b>(' . $container->get('counters')->users() . ')</span></b><p>Membership on site</p>' .
        '<tr><td class="w"><a href="index.php?act=usr_adm"><b>' . _t('Administration') . '</b></a>&#160;(' . $db->query("SELECT COUNT(*) FROM `users` WHERE `rights` >= '1'")->fetchColumn() . ')<p>Supporting staffs that moderate the community</p>' .
        ($systemUser->rights >= 7 ? '<tr><td class=""><a href="index.php?act=usr_clean"><b>' . _t('Database cleanup') . '</b></a><p>Flush users databases who has not login for past 90days</p>' : '') .
        '<tr><td class="w"><a href="index.php?act=ban_panel"><b>' . _t('Ban Panel') . '</a>&#160;(' . $bantotal . ')</b><p>Total of members who goes against community rules or violated</p>' .
        ($systemUser->rights >= 7 ? '<tr><td class=""><a href="index.php?act=antiflood"><b>' . _t('Antiflood') . '</b></a><p>Violation members</p>' : '') .
        ($systemUser->rights >= 7 ? '<tr><td class="w"><a href="index.php?act=karma"><b>' . _t('Karma') . '</b></a><p>Point achieved either Good or Bad</p>' : '') .
        //'<br>' .
        '<tr><td class=""><a href="../users/search.php"><b>' . _t('Search by Nickname') . '</b></a><p>Search any user on community</p>' .
        '<tr><td class="w"><a href="index.php?act=search_ip"><b>' . _t('Search IP') . '</b></a><p>IP finder to locate user easy.</p>' .
        '</table>';

    if ($systemUser->rights >= 7) {
        // Блок модулей
        $spam = $db->query("SELECT COUNT(*) FROM `cms_mail` WHERE `spam`='1';")->fetchColumn();

        echo '<div class="gmenu"><p>';
        echo '<h3>' . _t('Modules') . '</h3><table>' .
            '<tr><td class=""><a href="index.php?act=forum"><b>' . _t('Forum') . '</b></a><p>Forum panel, categories managements</p>' .
            '<tr><td class="w"><a href="index.php?act=news"><b>' . _t('News') . '</b></a><p>Set news setting delete unwanted news from community</p>' .
            '<tr><td class=""><a href="index.php?act=ads"><b>' . _t('Advertisement') . '</b></a><p>Create Advertisement words or link for the community to access the portal</p>';

        if ($systemUser->rights == 9) {
            echo '<tr><td class="w"><a href="index.php?act=counters"><b>' . _t('Counters') . '</b></a><p>Counters management</p>';
        }

        echo '</table>';

        // Блок системных настроек
        echo '<div class="menu"><p>' .
            '<h3>' . _t('System') . '</h3>' .
            '<table>' .
            ($systemUser->rights == 9 ? '<tr><td class=""><a href="index.php?act=settings"><b>' . _t('System Settings') . '</b></a><p>Configures site basic settings </p>' : '') .
            ($systemUser->rights == 9 ? '<tr><td class=""><a href="index.php?act=themes"><b>' . _t('Theme Settings') . '</b></a><p>Choose preffer theme for the site </p>' : '') .
            '<tr><td class="w"><a href="index.php?act=smilies"><b>' . _t('Update Smilies') . '</b></a><p>Updates site smilies</p>' .
            ($systemUser->rights == 9 ? '<tr><td class=""><a href="index.php?act=languages"><b>' . _t('Language Settings') . '</b></a><p>choose prefer site language general</p>' : '') .
            '<tr><td class="w"><a href="index.php?act=access"><b>' . _t('Permissions') . '</b></a><p>Grant permission, switch community</p>' .
            '</table>';

        // Блок безопасности
        echo '<div class="rmenu"><p>' .
            '<h3>' . _t('Security') . '</h3>' .
            '<table>' .
            '<tr><td class=""><a href="index.php?act=antispy"><b>' . _t('Anti-Spyware') . '</b></a><p>Scan all files here, help you to verify if there is no error in any databases</p></a>' .
            ($systemUser->rights == 9 ? '<tr><td class="w"><a href="index.php?act=ipban"><b>' . _t('Ban by IP') . '</b></a><p>Banner IP members are added here</p>' : '') .
            '</table></left>';
    }
   // echo '<div class="phdr" style="font-size: x-small"><b>JohnCMS 7.1.0</b></div>';
}

require('../system/end.php');

