<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);

/** @var Johncms\Counters $counters */
$counters = $container->get('counters');

/** @var Johncms\Api\EnvironmentInterface $env */
$env = $container->get(Johncms\Api\EnvironmentInterface::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

$act = isset($_REQUEST['act']) ? trim($_REQUEST['act']) : '';
$headmod = isset($headmod) ? $headmod : '';
$textl = isset($textl) ? $textl : $config['copyright'];
$keywords = isset($keywords) ? htmlspecialchars($keywords) : $config->meta_key;
$descriptions = isset($descriptions) ? htmlspecialchars($descriptions) : $config->meta_desc;

echo '<!DOCTYPE html>' .
    "\n" . '<html lang="' . $config->lng . '">' .
    "\n" . '<head>' .
    "\n" . '<meta charset="utf-8">' .
    "\n" . '<meta http-equiv="X-UA-Compatible" content="IE=edge">' .
    "\n" . '<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes">' .
    "\n" . '<meta name="HandheldFriendly" content="true">' .
    "\n" . '<meta name="MobileOptimized" content="width">' .
    "\n" . '<meta content="yes" name="apple-mobile-web-app-capable">' .
    "\n" . '<meta name="Generator" content="JohnCMS, http://johncms.com">' .
    "\n" . '<meta name="keywords" content="' . $keywords . '">' .
    "\n" . '<meta name="description" content="' . $descriptions . '">' .
 //   "\n" . '<link rel="stylesheet" href="' . $config->homeurl . '/theme/' . $tools->getSkin() . '/style.css">' .
    "\n" . '<link rel="shortcut icon" href="' . $config->homeurl . '/favicon.ico">' .
    "\n" . '<link rel="alternate" type="application/rss+xml" title="RSS | ' . _t('Site News', 'system') . '" href="' . $config->homeurl . '/rss/rss.php">' .
    "\n" . '<title>' . $textl . '</title>' .
    "\n" . '</head>';

// Рекламный модуль
$cms_ads = [];

if (!isset($_GET['err']) && $act != '404' && $headmod != 'admin') {
    $view = $systemUser->id ? 2 : 1;
    $layout = ($headmod == 'mainpage' && !$act) ? 1 : 2;
    $req = $db->query("SELECT * FROM `cms_ads` WHERE `to` = '0' AND (`layout` = '$layout' or `layout` = '0') AND (`view` = '$view' or `view` = '0') ORDER BY  `mesto` ASC");

    if ($req->rowCount()) {
        while ($res = $req->fetch()) {
            $name = explode("|", $res['name']);
            $name = htmlentities($name[mt_rand(0, (count($name) - 1))], ENT_QUOTES, 'UTF-8');

            if (!empty($res['color'])) {
                $name = '<span style="color:#' . $res['color'] . '">' . $name . '</span>';
            }

            // Если было задано начертание шрифта, то применяем
            $font = $res['bold'] ? 'font-weight: bold;' : false;
            $font .= $res['italic'] ? ' font-style:italic;' : false;
            $font .= $res['underline'] ? ' text-decoration:underline;' : false;

            if ($font) {
                $name = '<span style="' . $font . '">' . $name . '</span>';
            }

            @$cms_ads[$res['type']] .= '<a href="' . ($res['show'] ? $tools->checkout($res['link']) : $config['homeurl'] . '/go.php?id=' . $res['id']) . '">' . $name . '</a><br>';

            if (($res['day'] != 0 && time() >= ($res['time'] + $res['day'] * 3600 * 24))
                || ($res['count_link'] != 0 && $res['count'] >= $res['count_link'])
            ) {
                $db->exec('UPDATE `cms_ads` SET `to` = 1  WHERE `id` = ' . $res['id']);
            }
        }
    }
}

//adding header for member only not admin
if ($systemUser->id && $systemUser->isValid()) {
//End Web Displayed Header When Login Page
echo'<link rel="stylesheet" href="' . $config->homeurl . '/theme/' . $tools->getSkin() . '/dash.css">';
echo'<body class="nontouch x1 _513c _55wm">';
echo'<div class="mfsm"><div><div class="_xj7"><div class="_32ji"><div class="_46d_"><div class="_129- _6dr5"><div class="acb aps"><form method="post" action="' . $config['homeurl'] . '/users/search.php" class="_1_9_ _3ysw"><table class="_4g33"><tbody><tr><td class="_5s61"><a class="_4bx6 _5i6f _3ysx" href="' . $config['homeurl'] . '"><img src="' . $config['homeurl'] . '/images/s.png" width="20" height="20" class="_1_9w img" alt="' . $config->copyright . ' logo"></a></td><td class="_4g34 _1n18"><input class="_56bg _55wq _1_a1" name="search" placeholder="Search ' . $config->copyright . '" type="text"></td><td class="_5s61 _7c1b"><input value="Search" type="submit" class="_54k8 _52jg _56bs _1_a2 _56bu"></td></tr></tbody></table></form>';

echo '<nav class="_1r82"><a href="' . $config['homeurl'] . '" class="_1r83 inv">Home</a><a href="' . $config['homeurl'] . '/profile/index.php" class="_1r83 inv">Profile</a>';

   $new_mail = $db->query("SELECT COUNT(*) FROM `cms_mail`
                            LEFT JOIN `cms_contact` ON `cms_mail`.`user_id`=`cms_contact`.`from_id` AND `cms_contact`.`user_id`='" . $systemUser->id . "'
                            WHERE `cms_mail`.`from_id`='" . $systemUser->id . "'
                            AND `cms_mail`.`sys`='0'
                            AND `cms_mail`.`read`='0'
                            AND `cms_mail`.`delete`!='" . $systemUser->id . "'
                            AND `cms_contact`.`ban`!='1'")->fetchColumn();
if ($new_mail) {echo '<a href="' . $config['homeurl'] . '/mail/index.php?act=new" class="_1r83 inv"><strong class="_1r84">Messages<span aria-label="' . $new_mail . ' unread">(' . $new_mail . ')</span></strong></a>';
}else{
 echo'<a href="' . $config['homeurl'] . '/mail/index.php?act=input" class="_1r83 inv">Messages<span></span></a>';
}
 echo'<a href="' . $config['homeurl'] . '/notifications.php" class="_1r83 inv">Notifications</a>';

$users = $db->query("SELECT COUNT(*) FROM `users` WHERE `lastdate` > '" . (time() - 300) . "'")->fetchColumn();
$guests = $db->query("SELECT COUNT(*) FROM `cms_sessions` WHERE `lastdate` > '" . (time() - 300) . "'")->fetchColumn();
$online = $_GET['online'];
 echo'<a href="' . $config['homeurl'] . '/chat.php" class="_1r83 inv">Chat<span>(' . $users . ')</span></a>';
 echo'<a href="' . $config['homeurl'] . '/mail/friends.php" class="_1r83 inv">Friends</a>';

$total_cat = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 'f'")->fetchColumn();
$total_sub = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 'r'")->fetchColumn();
$total_thm = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 't'")->fetchColumn();
$total_msg = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 'm'")->fetchColumn();
$total_files = $db->query("SELECT COUNT(*) FROM `cms_forum_files`")->fetchColumn();
//} 
$db->exec("UPDATE `users` SET $sql `total_on_site` = '$totalonsite', `lastdate` = " . time() . " WHERE `id` = '" . $config->botida . "'");
$db->exec("UPDATE `users` SET $sql `total_on_site` = '$totalonsite', `lastdate` = " . time() . " WHERE `id` = '" . $config->botidb . "'");
$db->exec("UPDATE `users` SET $sql `total_on_site` = '$totalonsite', `lastdate` = " . time() . " WHERE `id` = '" . $config->botidc . "'");
 echo'<a href="' . $config['homeurl'] . '/forum/" class="_1r83 inv">Forum <strong class="_1r84">' . $total_thm . ' / ' . $total_msg . '</strong></a>';
 echo'<a href="' . $config['homeurl'] . '/library/" class="_1r83 inv"><strong class="_1r84">Blogs(' . $counters->library() . ')</strong></a> ';
 echo'<a href="' . $config['homeurl'] . '/menu.php" class="_1r83 inv">Menu</a>';

 echo'<a href="' . $config['homeurl'] . '/wallets/" class="_1r83 inv">Wallets</a>';
 
if ($systemUser->rights >= 2){echo'<a href="' . $config['homeurl'] . '/admin/" class="_1r83 inv"><strong class="_1r84">Admin CP</strong></a>';}
 echo'</nav></div></div></div></div></div>';

 // Ads under Header
if (isset($cms_ads[0])) {
    echo $cms_ads[0];
}
/*
-----------------------------------------------------------------
Hacklord Statistic
-----------------------------------------------------------------
*/
//if (!$systemUser->isValid() || ($systemUser->id && $config->mod_fstat != 0)) {
echo'<br>';
}


else 
{
echo'<link rel="stylesheet" href="' . $config->homeurl . '/theme/' . $tools->getSkin() . '/style.css">';// Главное меню пользователя
echo '<body class="b c d e f"><div class="g"><div><div class="h i"><a href="' . $config->homeurl . '"><h1 style="display:block;height:0;overflow:hidden;position:absolute;width:0;padding:0">' . $config->copyright . '</h1><img src="' . $config['homeurl'] . '/images/logo.png" width="77" height="16" class="j k" alt="' . $config->copyright . '"></a></div>';
}




// Рекламный блок сайта
if (!empty($cms_ads[1])) {
    echo '<div class="gmenu">' . $cms_ads[1] . '</div>';
}

