<?php
/*
 * Socialbux 5.0 (http://socialbux.net)
 * JohnCMS v7.1 Edition
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Dev Project
 * @email       Tunzxywalexdevmaster@gmail.com
 * @email       Tunzxy007@yahoo.com
 * @Whatsapp    +2349076642400 
 * @copyright   Copyright (C) Naijadev Community Wapego 2011-2019
 * @license     Premium Version Licence
 */


defined('_IN_JOHNADM') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

$config = $container->get('config')['johncms'];

// Проверяем права доступа
if ($systemUser->rights < 9) {
    header('Location: ../?err');
    exit;
}
echo '<div id="page-wrapper">

            <div class="container-fluid">

                <!-- Page Heading -->
                <div class="row">
                    <div class="col-lg-12">
                        <h1 class="page-header">
                            Dashboard <small></small>
                        </h1>
                        <ol class="breadcrumb">
                            <li class="active">
                                <i class="fa fa-dashboard"></i> Dashboard 
                            </li>
							<li class="active">
                                <i class="fa fa-edit"></i> Site Settings
                            </li>
                        </ol>
                    </div>
                </div>
                <!-- /.row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="alert alert-info alert-dismissable">';

if (isset($_POST['submit'])) {
    // Сохраняем настройки системы
    $config['skindef'] = isset($_POST['skindef']) ? trim($_POST['skindef']) : 'default';
    $config['skinweb'] = isset($_POST['skinweb']) ? trim($_POST['skinweb']) : 'default';
    $config['email'] = isset($_POST['madm']) ? trim($_POST['madm']) : '@';
    $config['timeshift'] = isset($_POST['timeshift']) ? intval($_POST['timeshift']) : 0;
	 $config['puf'] = isset($_POST['puf']) ? intval($_POST['puf']) : 0;
    $config['mod_ver'] = isset($_POST['mod_ver']) ? trim($_POST['mod_ver']) : 'JohnCMS711';
    $config['copyright'] = isset($_POST['copyright']) ? trim($_POST['copyright']) : 'NaijaCMS';
    $config['homeurl'] = isset($_POST['homeurl']) ? preg_replace("#/$#", '', trim($_POST['homeurl'])) : '/';
    $config['flsz'] = isset($_POST['flsz']) ? intval($_POST['flsz']) : 0;
    $config['gzip'] = isset($_POST['gz']);
    $config['firewall'] = isset($_POST['firewall']) ? intval($_POST['firewall']) : 0;
    $config['mainmenu'] = isset($_POST['mainmenu']) ? intval($_POST['mainmenu']) : 0;
    $config['meta_key'] = isset($_POST['meta_key']) ? trim($_POST['meta_key']) : 'Socialbux Premium';
    $config['meta_desc'] = isset($_POST['meta_desc']) ? trim($_POST['meta_desc']) : 'Naijadev Socialbux Clone v3';
    $config['staffnews'] = isset($_POST['staffnews']) ? trim($_POST['staffnews']) : '';

    $configFile = "<?php\n\n" . 'return ' . var_export(['johncms' => $config], true) . ";\n";

    if (!file_put_contents(ROOT_PATH . 'system/config/system.local.php', $configFile)) {
        echo 'ERROR: Can not write system.local.php</body></html>';
        exit;
    }

    echo '<div class="rmenu">' . _t('Settings are saved successfully') . '</div>';

    if (function_exists('opcache_reset')) {
        opcache_reset();
    }
}

// Форма ввода параметров системы
echo '<form action="index.php?act=settings" method="post">';

// Общие настройки
echo '<div class="row">
                    <div class="col-lg-6"><div class="form-group">' .
    '<h3>' . _t('Common Settings') . '</h3>' .
    _t('Web site address without the slash at the end') . '<br>' . '<input class="form-control" type="text" name="homeurl" value="' . htmlentities($config['homeurl']) . '"/><br>' .
    _t('Site copyright') . '<br>' . '<input class="form-control" type="text" name="copyright" value="' . htmlentities($config['copyright'], ENT_QUOTES, 'UTF-8') . '"/><br>' .
    _t('Site Email') . '<br>' . '<input class="form-control" name="madm" maxlength="50" value="' . htmlentities($config['email']) . '"/><br>' .
    _t('Max. file size') . ' (kb):<br>' . '<input class="form-control" type="text" name="flsz" value="' . intval($config['flsz']) . '"/><br>' .
    '<input class="form-control" name="gz" type="checkbox" value="1" ' . ($config['gzip'] ? 'checked="checked"' : '') . ' />&#160;' . _t('Gzip compression');
    echo '<br/><input class="form-control" name="firewall" type="checkbox" value="1" ' . ($config['firewall'] ? 'checked="checked"' : '') . ' />&#160;Firewall' . 
    '<br/><input class="form-control" name="mainmenu" type="checkbox" value="1" ' . ($config['mainmenu'] ? 'checked="checked"' : '') . ' />&#160;MainMenu Extended</p>';
	 'NaijaCms Mod Version<br>&#160;<textarea  class="form-control" rows="' . $systemUser->getConfig()->fieldHeight . '" name="mod_ver">' . $config['mod_ver'] . '</textarea><br>';




// Настройка времени
echo '<p>' .
    '<h3>' . _t('Time shift') . '</h3>' .
    '<input type="text" name="timeshift" size="2" maxlength="3" class="form-control" value="' . $config['timeshift'] . '"/> (+-12)<br>' .
    '<span style="font-weight:bold; background-color:#C0FFC0">' . date("H:i", time() + $config['timeshift'] * 3600) . '</span> ' . _t('System Time') .
    '<br><span style="font-weight:bold; background-color:#FFC0C0">' . date("H:i") . '</span> ' . _t('Server Time') .
    '</p>';
// META тэги
echo '<p>' .
    '<h3>' . _t('META tags') . '</h3>' .
    '&#160;' . _t('Keywords') . '<br>&#160;<textarea class="form-control" rows="' . $systemUser->getConfig()->fieldHeight . '" name="meta_key">' . $config['meta_key'] . '</textarea><br>' .
    '&#160;' . _t('Description') . '<br>&#160;<textarea class="form-control" rows="' . $systemUser->getConfig()->fieldHeight . '" name="meta_desc">' . $config['meta_desc'] . '</textarea><br>Please Note: HTML code is allowed to the below text area<br>' .
    '&#160;' . _t('Staff News') . '<br>&#160;<textarea class="form-control" rows="' . $systemUser->getConfig()->fieldHeight . '" name="staffnews">' . $config['staffnews'] . '</textarea>' .
    '</p>';

// Выбор темы оформления
echo '<p><h3>' . _t('Themes') . '</h3>&#160;<select name="skindef">';
$dir = opendir('../theme');

while ($skindef = readdir($dir)) {
    if (($skindef != '.') && ($skindef != '..') && ($skindef != '.svn')) {
        $skindef = str_replace('.css', '', $skindef);
        echo '<option' . ($config['skindef'] == $skindef ? ' selected="selected">' : '>') . $skindef . '</option>';
    }
}

closedir($dir);

echo '</select>' .
    '</p>';

echo '<p><h3>' . _t('Themes') . ' Web</h3>&#160;<select name="skinweb">';
$dirs = opendir('../themes');

while ($skinweb = readdir($dirs)) {
    if (($skinweb != '.') && ($skinweb != '..') && ($skinweb != '.svn')) {
        $skinweb = str_replace('.css', '', $skinweb);
        echo '<option' . ($config['skinweb'] == $skinweb ? ' selected="selected">' : '>') . $skinweb . '</option>';
    }
}

closedir($dirs);

echo '</select>' .
    '</p><input type="submit" name="submit" class="btn btn-default" value="' . _t('Save') . '"/></div>
                </div></div></form>' .
    '<div class="phdr">&#160;</div>' .
    '<p><a href="index.php">' . _t('Admin Panel') . '</a></p>';
