<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

define('_IN_JOHNCMS', 1);

require('system/bootstrap.php');

$act = isset($_GET['act']) ? trim($_GET['act']) : '';

if (isset($_SESSION['ref'])) {
    unset($_SESSION['ref']);
}

if (isset($_GET['err'])) {
    $act = 404;
}

switch ($act) {
    case '404':
			/** @var Psr\Container\ContainerInterface $container */
			$container = App::getContainer();

        /** @var Johncms\Api\ToolsInterface $tools */
        $tools = $container->get(Johncms\Api\ToolsInterface::class);

			/** @var Johncms\Api\UserInterface $systemUser */
			$systemUser = $container->get(Johncms\Api\UserInterface::class);

			/** @var Johncms\Api\ConfigInterface $config */
			$config = $container->get(Johncms\Api\ConfigInterface::class);

			/** @var Johncms\Counters $counters */
			$counters = $container->get('counters');


        $headmod = 'error404';
        require('system/head.php');
        echo $tools->displayError(_t('The requested page does not exists'));
        break;

			case 'digest':
			/*
-----------------------------------------------------------------
Welcome Note Message
-----------------------------------------------------------------
			*/
			/** @var Psr\Container\ContainerInterface $container */
			$container = App::getContainer();

        /** @var Johncms\Api\ToolsInterface $tools */
        $tools = $container->get(Johncms\Api\ToolsInterface::class);

			/** @var Johncms\Api\UserInterface $systemUser */
			$systemUser = $container->get(Johncms\Api\UserInterface::class);

			/** @var Johncms\Api\ConfigInterface $config */
			$config = $container->get(Johncms\Api\ConfigInterface::class);

			/** @var Johncms\Counters $counters */
			$counters = $container->get('counters');


        $headmod = 'digest';
        require('system/head.php');
// Проверяем права доступа
			if (!$systemUser->isValid()) {
    			echo $tools->displayError(_t('Access forbidden to guest'));
    			require('../system/end.php');
    			exit;
		}

			echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>' . _t('Welcome Back') . '</b></div>';
			echo '<div class="gmenu"><p>' . _t('Hi') . ', <b>' . $systemUser->name . '</b><br/>' . _t('Welcome back to') . ' ' . $config['copyright'] . '..!!<br/><a href="index.php">' . _t('Continue to main page') . '</a></p></div>';

			if ($systemUser['dayb'] == date('j', time()) && $systemUser['monthb'] == date('n', time())) {
echo '<div class="gmenu"><p>' . _t('Happy Birthday') . '</p></div>';
			}

			if ($systemUser->rights >= 1) {
				$new_users_total = $db->query("SELECT COUNT(*) FROM `users` WHERE `datereg` > '" . (time() - 86400) . "' AND `preg` = '1'")->fetchColumn();
$reg_total = $db->query("SELECT COUNT(*) FROM `users` WHERE `preg` = 0")->fetchColumn();
$ban_total = $db->query("SELECT COUNT(*) FROM `cms_ban_users` WHERE `ban_time` > '" . time() . "'")->fetchColumn();
echo '<div class="menu"><p><h3>' . _t('Administrative events') . '</h3><ul>';
					if ($new_users_total > 0) { 
							echo '<li><a href="users/index.php?act=userlist">' . _t('Newly Registered Members') . '</a> (' . $new_users_total . ')</li>';
				} 
					if ($reg_total > 0 && $systemUser->rights >= 7) { 
							echo '<li><a href="' . $config['homeur'] . '/admin/index.php?act=reg">' . _t('Registrations Awaiting Confirmation') . '</a> (' . $reg_total . ')</li>';
				} 
					if ($ban_total > 0) {
							echo '<li><a href="' . $config['homeurl'] . '/admin/index.php?act=ban_panel">' . _t('Banned Users') . '</a> (' . $ban_total . ')</li>';
				} 
					$total_libmod = $db->query("SELECT COUNT(*) FROM `library_texts` WHERE `premod` = '0'")->fetchColumn(); 
					if ($total_libmod > 0 && $systemUser->rights >= 6) {
							echo '<li><a href="library/index.php?act=premod">' . _t('Library for moderation') . '</a> (' . $total_libmod . ')</li>';
					} 
					$total_admin = $counters->guestbook(2);
					if ($total_admin > 0) { 
							echo '<li><a href="guestbook/index.php?act=ga&amp;do=set">' . _t('Admin Club') . '</a> (' . $total_admin . ')</li>';
				} 
					if (!$new_users_total && !$reg_total && !$ban_total && !$total_libmod && !$total_admin) { 
					echo '<li>' . _t('No administrative events') . '</li>';
				} 
			echo '</ul></p></div>';
		}

			echo '<div class="menu"><p><h3>' . _t('New Activities') . '</h3><ul>';
			$total_news = $db->query("SELECT COUNT(*) FROM `news` WHERE `time` > " . (time() - 86400))->fetchColumn();
			if ($total_news > 0) {
				echo '<li><a href="news/index.php">' . _t('News') . '</a> (' . $total_news . ')</li>';
			} 
			$total_forum = $counters->forumNew();
			if ($total_forum > 0) { 
				echo '<li><a href="forum/index.php?act=new">' . _t('Forum') . '</a> (' . $total_forum . ')</li>';
			} 
			$total_guest = $counters->guestbook(1);
			if ($total_guest > 0) { 
echo '<li><a href="guestbook/index.php?act=ga">' . _t('Guest book') . '</a> (' . $total_guest . ')</li>';
			} 
			if ($set_karma['on']) {
$total_karma = $db->query("SELECT COUNT(*) FROM `karma_users` WHERE `karma_user` = '$systemUser->id' AND `time` > " . (time() - 86400))->fetchColumn();
			if ($total_karma > 0) { 
echo '<li><a href="users/profile.php?act=karma&amp;mod=new">' . _t('New review') . '</a> (' . $total_karma . ')</li>';
			} 
		}
			$total_lib = $db->query("SELECT COUNT(*) FROM `library_texts` WHERE `time` > '" . (time() - 259200) . "' AND `premod` = '1'")->fetchColumn();
			if ($total_lib > 0) { 
				echo '<li><a href="library/index.php?act=new">' . _t('Library') . '</a> (' . $total_lib . ')</li>';
			} 
			$total_album = $db->query("SELECT COUNT(*) FROM `cms_album_files` WHERE `time` > '" . (time() - 259200) . "' AND `access` > '1'")->fetchColumn();
			if ($total_album > 0) { 
				echo '<li><a href="users/album.php?act=top">' . _t('Photo albums') . '</a> (' . $total_album . ')</li>';
			} 
			if (!$total_news && !$total_forum && !$total_guest && !$total_gal && !$total_lib && !$total_karma) {
echo '<li>' . _t('No new Activities') . '</li>';
			} 
			$last = isset($_GET['last']) ? intval($_GET['last']) : $systemUser['lastdate'];
			echo '</ul></p></div><div class="gmenu">' . _t('Last visited') . ': ' . date("d.m.Y / g:i:s a", $last) . '</div></div>';
			break;


    default:
        // Главное меню сайта
        if (isset($_SESSION['ref'])) {
            unset($_SESSION['ref']);
        }
        $headmod = 'mainpage';
        require('system/head.php');
        include 'system/mainmenu.php';
}

require('system/end.php');
