<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

define('_IN_JOHNCMS', 1);

require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);


/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

$textl = _t('Followed Topics');
$headmod = 'bookmarks';
require('../system/head.php');

if (!$systemUser->isValid()) {
    echo 'You are not logged in';
    require ('../system/end.php');
    exit;
}

echo '<div class="mainblok"><div class="phdr"><b>Bookmark forum</b></div>';

$total = $db->query("SELECT COUNT(*) FROM `forum`
LEFT JOIN `cms_forum_rdm` ON `forum`.`id` = `cms_forum_rdm`.`topic_id` AND `cms_forum_rdm`.`user_id` = '$systemUser->id'
WHERE `forum`.`type`='t'" . ($systemUser->rights >= 7 ? "" : " AND `forum`.`close` != '1'") . " AND `cms_forum_rdm`.`bookmark` = '1'")->fetchColumn();

if ($total) { 
$req = $db->query("SELECT * FROM `forum`
   LEFT JOIN `cms_forum_rdm` ON `forum`.`id` = `cms_forum_rdm`.`topic_id` AND `cms_forum_rdm`.`user_id` = '$systemUser->id'
   WHERE `forum`.`type`='t'" . ($systemUser->rights >= 7 ? "" : " AND `forum`.`close` != '1'") . "
   AND `cms_forum_rdm`.`bookmark` = '1' ORDER BY `forum`.`time` DESC LIMIT $start, $kmess");
   while (($res = $req->fetch()) !== false) {
        if ($res['close']) echo '<div class="gmenu">';
        else echo $i++ % 2 ? '<div class="menu">' : '<div class="menu">';
        $post = $db->query("SELECT * FROM `forum` WHERE `type` = 'm' AND `close` != '1' AND `refid` = '" . $res['id'] . "' ORDER BY `time` DESC LIMIT 1")->fetch();
        $totalPost = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='m' AND `refid`='" . $res['id'] . "'" . ($systemUser->rights >= 7 ? '' : " AND `close` != '1'"))->fetchColumn();
        $pagesEnd = ceil($totalPost / $kmess);
      if(!$res['vip']) echo  '<img src="../images/np.gif" alt=""/>&nbsp;';
      if($res['vip']) echo  '<img src="../images/pt.gif" alt=""/>&nbsp;';
        if($res['realid']) echo  '<img src="../images/rate.gif" alt=""/>&nbsp;';
        if($res['edit']) echo '<img src="../images/tz.gif" alt=""/>&nbsp;';
        echo $res['from'] . ' <span class="gray">(' . $tools->displayDate($res['time']) . ')</span><br />' .
      '<a href="' . $config->homeurl . '/forum/' . $tools->rewriteUrl($res['text']) . '_' . $res['id'] . '.html">' . $res['text'] . '</a> [' . $totalPost . ']';
        if ($pagesEnd > 1) 
			echo '<a href="index.php?id=' . $res['id'] . '&amp;page=' . $pagesEnd . '">&#160;&gt;&gt;</a>';
        if($post['text']) {
           $text = $tools->checkout(mb_substr($post['text'], 0, 150), 1, 1);
            if(mb_strlen($post['text']) > 150) 
					$text .= ' <a href="index.php?act=post&amp;id=' . $post['id'] . '"> &gt;&gt;</a>';
         echo '<div class="sub">' . $post['from'] . ' <span class="gray">(' . $tools->displayDate($post['time']) . ')</span><br />' . $text . '</div>';

          }
      echo '</div>';
   }
} else
   echo '<div class="gmenu"><p>Empty!</p></div>';
echo '<div class="phdr">Total: ' . $total . '</div>';

if ($total > $kmess) {
   echo '<div class="topmenu">' . $tools->displayPagination('bookmark.php?', $start, $total, $kmess) . '</div>' .
   '<p><form action="bookmark.php" method="post"><input type="text" name="page" size="2"/><input type="submit" value="' . _t('To page') . ' &gt;&gt;"/></form></p>';

}

echo '<div class="phdr"><a href="../users/profile.php?act=office">My Profile</a></div>';
echo '<div class="phdr"><a href="index.php">Forum</a></div>';

   echo '</div>';

require_once ('../system/end.php');

?>
