<?php
/**
Code by garthbale && Văn Thặch
Vui lòng tôn trọng bản quyền
**/

define('_IN_JOHNCMS', 1);

$headmod = 'guestbook';
require('system/bootstrap.php');

/** @var Interop\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\User $systemUser */
$systemUser = $container->get(Johncms\User::class);

/** @var Johncms\Tools $tools */
$tools = $container->get('tools');

/** @var Johncms\Environment $env */
$env = App::getContainer()->get('env');

/** @var Johncms\Bbcode $bbcode */
$bbcode = $container->get('bbcode');

/** @var Johncms\Config $config */
$config = $container->get(Johncms\Config::class);



function gio($gio){
    $time=time();
    $jun=round(($time-$gio)/60);

   if($jun<1){
        $jun='Has just finished';
    }
    if($jun>=1 && $jun<60){
        $jun="$jun Minutes ago";
    }
    if($jun>=60 && $jun<1440){
        $jun=round($jun/60); $jun="$jun hour ago";
    }
    if($jun>=1440){
       $jun=round($jun/60/24); $jun="$jun before";
    }
    return $jun;
}

if (isset($_POST['msg'])) {
     $admset = isset($_SESSION['ga']) ? 1 : 0; // Задаем куда вставляем, в Админ клуб (1), или в Гастивуху (0)
        // Принимаем и обрабатываем данные
     $name = isset($_POST['name']) ? mb_substr(trim($_POST['name']), 0, 20) : '';
     $msg = isset($_POST['msg']) ? mb_substr(trim($_POST['msg']), 0, 5000) : '';
    $trans = isset($_POST['msgtrans']) ? 1 : 0;
    $code = isset($_POST['code']) ? trim($_POST['code']) : '';
    $from = $systemUser->isValid() ? $systemUser->name : $name;
    // Проверяем на ошибки
    $error = [];
    $flood = false;
    if (!isset($_POST['token']) || !isset($_SESSION['token']) || $_POST['token'] != $_SESSION['token']) {
            $error[] = 'Wrong data';
    }
    if (!$systemUser->isValid() && empty($name)) {
            $error[] = 'You have not entered a name';
     }

    if (empty($msg)) {
            $error[] = 'You have not entered the message';
    }

   if ($systemUser->ban['1'] || $systemUser->ban['13']) {
            $error[] = 'Access forbidden';
   }

   // CAPTCHA для гостей
   if (!$systemUser->isValid() && (empty($code) || mb_strlen($code) < 4 || $code != $_SESSION['code'])) {
            $error[] = 'The security code is not correct';
    }

    unset($_SESSION['code']);
    if ($systemUser->isValid()) {
            // Антифлуд для зарегистрированных пользователей
            $flood = $tools->antiflood();
     } else {
            // Антифлуд для гостей
            $req = $db->query("SELECT `time` FROM `guest` WHERE `ip` = '" . $env->getIp() . "' AND `browser` = " . $db->quote($env->getUserAgent()) . " AND `time` > '" . (time() - 60) . "'");

            if ($req->rowCount()) {
                $res = $req->fetch();
                $flood = time() - $res['time'];
            }
     }

     if ($flood) {
            $error = 'You cannot add the message so often. Please, wait a view seconds.';
     }

     if (!$error) {
            // Проверка на одинаковые сообщения
            $req = $db->query("SELECT * FROM `guest` WHERE `user_id` = '" . $systemUser->id . "' ORDER BY `time` DESC");
            $res = $req->fetch();

            if ($res['text'] == $msg) {
                header("location: index.php");
                exit;
            }
      }
 
      if (!$error) {
            // Вставляем сообщение в базу
            $db->prepare("INSERT INTO `guest` SET
                `adm` = ?,
                `time` = ?,
                `user_id` = ?,
                `name` = ?,
                `text` = ?,
                `ip` = ?,
                `browser` = ?,
                `otvet` = ''
            ")->execute([
                $admset,
                time(),
                $systemUser->id,
                $from,
                $msg,
                $env->getIp(),
                $env->getUserAgent(),
            ]);

        if ($systemUser->isValid()) {
                $postguest = $systemUser->postguest + 1;
                $db->exec("UPDATE `users` SET `postguest` = '$postguest', `lastpost` = '" . time() . "' WHERE `id` = " . $systemUser->id);
         }
   
    }
}
$total = $db->query("SELECT COUNT(*) FROM `guest` WHERE `adm`='0'")->fetchColumn();
if ($total) {
     $req = $db->query("SELECT `guest`.*, `guest`.`id` AS `gid`, `users`.`rights`, `users`.`lastdate`, `users`.`sex`, `users`.`status`, `users`.`datereg`, `users`.`id`
                FROM `guest` LEFT JOIN `users` ON `guest`.`user_id` = `users`.`id`
                WHERE `guest`.`adm`='0' ORDER BY `time` DESC LIMIT 4");
          for ($i = 0; $gres = $req->fetch(); ++$i) {
               $time = time();
               $jun  = round(($time - $gres['time']) / 60);
                if ($jun < 1)
                    $jun = 'topmenu';
                else
                    $jun = 'list1';
                $post = $gres['text'];
                if (strlen($post) > 160) {
                   $post = substr($post, 0, 160) . '...';
                }
               $post = $tools->checkout($gres['text'], 1, 1);
               $post = $tools->smilies($post, $gres['rights'] >= 1 ? 1 : 0);
               $outputhtml .= (time() > $gres['lastdate'] + 300 ? ' <div class="' . $jun . '">' . $tools->image('offline.png') . '' : ' <div class="' . $jun . '">' . $tools->image('online.png') . '') . '<a href="javascript:tag(\'@'.$gres['name'].'\',\' \')">' . $gres['name'] . '</a>: ' . $post . '<br /><span style="font-size:11px;color:#777;">' . gio($gres['time']) . '</span></div>';
    }
    echo $outputhtml;
} else {
    echo '<div class="menu">No Messages</div>';
}


?>