<?php
function template($path, array $assign = []){
  extract($assign);
  ob_start();
  include($path);

  return ob_get_clean();
}

$sp = isset($sp)? $sp : [];
if(is_readable(__DIR__ . '/config.php')){
  $sp = array_merge(include(__DIR__ . '/config.php'), $sp);
}

if(isset($sp['plugins'])){
  foreach($sp['plugins'] as $plugin){
    include($plugin);
  }
}

ob_start();
register_shutdown_function(function() use($sp){
  $content = ob_get_contents();
  ob_end_clean();

  $error = error_get_last();
  if(is_array($error) && isset($sp['error'])){
    return call_user_func($sp['error'], $error, $content, $sp);
  }

  if(isset($sp['render'])){
    $content = call_user_func($sp['render'], $content, $sp);
  }

  if(isset($sp['layout'])){
    $content = template($sp['layout'], [
      'title' => isset($sp['title'])? $sp['title'] : 'SimplePage',
      'content' => $content,
    ]);
  }

  echo $content;
});
