<?php

class Kupload {
    
    private $dir;
    
    private $tmpdir;
    
    private $filestorage;
    
    private $lastInsert;
    
    private $count;
    
    public function __construct($dir = './upload') {
        $this->dir = $dir;
        $this->checkDir($dir);
        $this->tmpdir = realpath($this->dir . DIRECTORY_SEPARATOR . 'tmp');
        $res = $this->addtemp($this->checker());
        $this->filestorage = new KfileStorage($this->dir);
        if ($res) {
            $count = count($res);
            $this->filestorage->add($res);
            $this->lastInsert = $this->filestorage->lastInsert($count);
        }
        $this->count = count($this->filestorage->map());
    }
    
    public function getCount() {
        return $this->count;
    }
    
    public function getLastInsert() {
        return $this->lastInsert;
    }
    
    public function getFileStorage() {
        return $this->filestorage;
    }
    
    public static function checkDir($dir, $tmp = 1) {
        if (!is_dir($dir)) {
            mkdir(($tmp ? $dir . DIRECTORY_SEPARATOR . 'tmp' : $dir), 0750, true);
        }
    }
    
    public function addtemp($array) {
        if (count($array) > 0) {
            $result = array();
            foreach($array as $name => $file) {
                $filename = $this->tmpdir . DIRECTORY_SEPARATOR . $this->uniqid() . '__' . $name;
                rename($file, $filename);
                $result[] = new Kfile($filename);
            }
            
            return $result;
        } else {
            return false;
        }
    }
    
    public function uniqid() {
        return substr(md5(uniqid(time())), 0, 8);
    }
    
    public function checker() {
        $result = array();
        if (count($_FILES) > 0) {
            foreach($_FILES as $key => $name) {
                if (is_array($name['tmp_name'])) {
                    foreach($name as $k => $file) {
                        foreach($file as $data) {
                            if (!empty($data)) {
                                $result[$k][] = $data;
                            }
                        }
                    }
                } else {
                    if (!empty($name['tmp_name'])) {
                        $result['name'][] = $name['name'];
                        $result['type'][] = $name['type'];
                        $result['tmp_name'][] = $name['tmp_name'];
                        $result['size'][] = $name['size'];
                    }
                }
            }
            
            return array_combine($result['name'], $result['tmp_name']);
        }
        
        return $result;
    }
}