<?php

class KfileStorage {
    
    private static $dir;
    
    public function __construct($dir = './upload') {
        if (!is_dir($dir)) {
            throw new RuntimeException('Directory ' . realpath($dir) . ' not found');
        }
        
        self::$dir = $dir;
    }
    
    public function lastInsert($files = 1) {
        $map = $this->map();
        
        return (count($map) > 0 ? array_slice($map, 0, $files) : false);
    }
    
    public function add($file) {
        if (!is_array($file)) {
            $data = $file->getData();
            $md5 = $data['md5'];
            $dir = $this->createDir($md5);
            $item = $dir . DIRECTORY_SEPARATOR . $md5;
            rename($data['path'], $item);
            file_put_contents($item . '.json', $json = json_encode(array('size' => $data['size'], 'ext' => $data['ext'], 'name' => $data['name'])));
        } else {
            array_map(array($this, 'add'), $file);
        }
    }
    
    public function filesize($size) {
        $alpha = array(" Bytes", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB");
        
        return $size ? round($size/pow(1024, ($i = floor(log($size, 1024)))), 2) . $alpha[$i] : '0 Bytes';
    }
    
    public static function dirname($file) {
        $first = substr($file, 0, 2);
        $second = substr($file, 2, 2);
        
        return self::$dir . DIRECTORY_SEPARATOR . $first . DIRECTORY_SEPARATOR . $second;
    }
    
    public function getInfoFile($file) {
        return json_decode(file_get_contents(self::dirname($file) . DIRECTORY_SEPARATOR . $file . '.json'), 1);
    }
    
    public function map() {
        $files = array();
        foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator(self::$dir), RecursiveIteratorIterator::CHILD_FIRST) as $fullFileName => $SplFileObject) {
            if ($SplFileObject->isFile() && $SplFileObject->getExtension() != 'json') {
                $files[basename($fullFileName)] = array('file' => $SplFileObject->getRealPath(), 'time' => $SplFileObject->getMTime());
            }
            uasort($files, array($this, 'sortByTime'));
        }
        
        return $files;
    }
    
    private function sortByTime($a, $b) {
        if ($a['time'] == $b['time']) {
            return 0;
        }
        return ($a['time'] > $b['time']) ? -1 : 1;
    }
    
    public function createDir($md5) {
        $dir = self::dirname($md5);
        Kupload::checkDir($dir, 0);
        
        return $dir;
    }
}