<?php

class Kfile extends SplFileInfo {
    
    private $name;
    
    private $size;
    
    private $ext;
    
    private $md5;
    
    public function __construct($file) {
        parent::__construct($file);
        $name = explode('__', $file);
        $this->name = $name[1];
        $this->ext = $this->getExtension();
        $this->size = $this->getSize();
        $this->md5 = $this->generateMd5Hash();
    }
    
    public function getData() {
        return array('name' => $this->name, 'md5' => $this->md5, 'size' => $this->size, 'ext' => $this->ext, 'path' => $this->getRealPath());
    }
    
    public function generateMd5Hash() {
        return md5_file($this->getRealPath());
    }
}