<?php

/**
* Класс голосований
* @author Koenig
* tested 5.2.17
*/

/*
install sql

CREATE TABLE IF NOT EXISTS `kvoter` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `vote` varchar(255) NOT NULL,
  `user` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `vote` (`vote`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

*/

class Kvoter {
    private $settings;
    
    private $query;
    
    private $template;
    
    private $data;
    
    public function __construct($event, $settings = false) {
        $this->query = new KvoterQuery($event, core::$user_id);
        $settings = $settings ? $settings : array('event' => $event,'options' => array('yes', 'no'), 'revote' => 1, 'tpl' => 0);
        $this->settings = new KvoterSettings($settings);
        #$this->template = new KvoterTemplate($this->settings()->get('tpl'));
        $this->data = new KvoterData($event);
    }
    
    public function init() {
        $counts = array();
        $links = array();
        foreach ($this->settings()->get('options') as $value) {
            $counts[$value] = $this->query()->counter($value);
            $link = '<a href="' . $_SERVER['PHP_SELF'] . '?kvoter=event::' . $this->settings()->get('event') . ';vote::' . $value . '">' . $value . '</a>';
            $links[$value] = $this->isGuest() ? $value : ($this->settings()->get('revote') ? ((!is_null($this->query()->exists()) && $value == $this->query()->exists()) ? $value : $link) : $value);
        }
        $this->data()->add('counts', $counts);
        $this->data()->add('links', $links);
        $this->data()->add('root', core::$system_set['homeurl']);
        $this->template = new KvoterTemplate($this->settings()->get('tpl'));
        new KvoterChecker();
    }
    
    public function isGuest() {
        return !core::$user_id;
    }
   
    public function data() {
        return $this->data;
    }
    
    public function query() {
        return $this->query;
    }
    
    public function settings() {
        return $this->settings;
    }
    
    public function template() {
        return $this->template;
    }
    
    public function render() {
        return $this->template()->render($this->data()->toArray());
    }
    
    public function debug() {
        echo '<pre>' . print_r($this, 1) . '</pre>';
    }
}

class KvoterData {
    
    private $data;
    
    public function __construct($event) {
        $this->add('event', $event);
    }
    
    public function add($key, $value) {
        $this->data[$key] = $value;
        
        return $this;
    }
    
    public function toArray() {
        return $this->data;
    }
}

class KvoterSettings {
    
    private $settings;
    
    public function __construct($settings) {
        $this->settings = $settings;
    }
    
    public function set($key, $value) {
        $this->settings[$key] = $value;
        
        return $this;
    }
    
    public function sets($params) {
        foreach ($params as $key => $value) {
            $this->set($key, $value);
        }
        
        return $this;
    }
    
    public function get($key) {
        return $this->settings[$key];
    }
}

class KvoterChecker {
   
    public function __construct() {
        $this->check();
    }
    
    public function check() {
        if (isset($_REQUEST['kvoter'])) {
            $action = $_REQUEST['kvoter'];
            $query = $this->query($action);
            #echo '<pre>' . print_r($query, 1);
            $event = $query['event'];
            $action = isset($query['act']) ? $query['act'] : 'add';
            $vote = $query['vote'];
            $query = new KvoterQuery($event, core::$user_id);
            switch($action) {
                default : // add
                    $query->add($vote);
                break;    
            }
            $this->redirect();
        } else {
            #echo 'not query';
        }
    }
    
    private function element($element) {
        $res = explode('::', $element);    
        
        return array($res[0] => $res[1]);
    }    

    private function query($part) {
        $array = array();
        foreach (array_values(array_map(array($this, 'element'), explode(';', $part))) as $key => $val) {
            foreach ($val as $k => $v) {    
                $array[$k] = $v;    
            }
        }
        
        return $array;
    }
    
    public function redirect() {
        ob_get_level() and ob_end_clean();
        ob_start();    
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        ob_end_flush();
        exit;
    }
}

class KvoterQuery {
    
    private $event;
    private $user;
    
    public function __construct($event, $user) {
        $this->event = $this->escape($event);
        $this->user = $user;
    }
    
    private function escape($value) {
        return mysql_real_escape_string($value);
    }
    
    private function query($sql, $exec = 0) {
        $res = mysql_query($sql);
        
        switch ($exec) {
            case 0 :
                $ret = mysql_affected_rows();
            break;
            
            case 1 :
                $ret = mysql_fetch_row($res);
                $ret = $ret[0];
            break;
            
            case 2 :
                $ret = array();
                
                while($row = mysql_fetch_assoc($res)) {
                    array_push($ret, $row);
                }
            break;
            
            case 3 :
                $ret = array();
                
                while($row = mysql_fetch_row($res)) {
                    array_push($ret, $row[0]);
                }
            break;
        }
        return $ret;
    }
    
    public function counter($vote) {
        $sql = 'SELECT COUNT(*) FROM `kvoter` WHERE `type` = "' . $this->event . '" AND `vote` = "' . $this->escape($vote) . '" ;';
        
        return $this->query($sql, 1);
    }
    
    public function add($vote) {
        $sql = 'INSERT INTO `kvoter` SET `user` = "' . $this->user . '", `type` = "' . $this->event . '", `vote` = "' . $this->escape($vote) . '" ;';
        
        return $this->exists() ? $this->update($vote) : $this->query($sql);
    }
    
    public function delete() {
        $sql = 'DELETE FROM `kvoter` WHERE `user` = ' . $this->user . ' AND `type` = "' . $this->event . '" ;';
        
        return $this->query($sql);
    }
    
    public function update($vote) {
        $sql = 'UPDATE `kvoter` SET `vote` = "' . $this->escape($vote) . '" WHERE `user` = "' . $this->user . '" AND `type` = "' . $this->event . '" ;';
        
        return $this->query($sql);
    }
    
    public function exists() {
        $sql = 'SELECT `vote` FROM `kvoter` WHERE `user` = "' . $this->user . '" AND `type` = "' . $this->event . '" ;';
        
        return $this->query($sql, 1);
    }
    
    public function drop() {
        if (!core::$user_rights) {
            return false;
        }
        $sql = 'SELECT GROUP_CONCAT(`id`) AS `ids` FROM `kvoter` WHERE `type` = "' . $this->event . '"';
        $ids = $this->query($sql, 1);
        $sql = 'DELETE FROM `kvoter` WHERE `id` IN(' . $ids . ') ;';
        
        return $this->query($sql);
    }
}

class KvoterTemplate {
    
    private $tpl;
    
    public function __construct($tpl) {
        $this->tpl = $tpl;
    }

    public function render($data) {
        ob_start();
        $this->tpl ? include $this->tpl : print_r($data);
        
        return ob_get_clean();        
    }
}