<?php
/**
 * RBlackListSites class file.
 *
 * @author Andrey Rakovskiy <rakovskiy28@mail.ru>
 * @link http://vk.com/rakovskiy28
 * @copyright 2015 Developed by Rakovskiy
 * @version 2.0
 */

class RBlackListSites {
    /**
     * Список доменов
     * @var array
     */
    private $sites = [];

    /**
     * Список масок
     * @var array
     */
    private $mask = [];

    /**
     * На что меняем запрещённый сайт
     * @var string
     */
    private $replace;

    /**
     * @param $config array Конфигурация
     */
    public function __construct($config){
        $this->sites = isset($config['sites']) ? $config['sites'] : [];
        $this->mask = isset($config['mask']) ? $config['mask'] : [];
        $this->replace = isset($config['replace']) ? $config['replace'] : '***SPAM***';
    }

    /**
     * Заменяем все запрещённые сайты в тексте
     * @param $text string
     * @return mixed
     */
    public function run($text){
        $sites = $this->collectOptions();
        return preg_replace(array_keys($sites), array_values($sites), $text);
    }

    /**
     * Проверяем, есть ли в тексте запрещённые сайты
     * @param $text string
     * @return bool
     */
    public function has($text){
        return $this->run($text) != $text;
    }

    /**
     * Собираем в массив возможные варианты написания сайтов в тексте
     * @return array
     */
    private function collectOptions(){
        $sites = [];

        foreach ($this->sites as $site){
            foreach ($this->mask as $mask){
                if (isset($site['host'], $site['host']) === false){
                    continue;
                }
                $str = strtr($mask, [
                    '~' => '\~',
                    '\\' => '&#92;',
                    '{host}' => $site['host'],
                    '{domain}' => $site['domain']
                ]);

                $sites["~$str(.*?)(\s|$)~ui"] = $this->replace . '$2';
            }
        }

        return $sites;
    }
}