<?php
require '../src/RBlackListSitesConfig.php';
$config_file = 'data/config.json';
$config = new RBlackListSitesConfig($config_file);
$all_sites = $config->getSites();
$all_mask = $config->getMasks();
$i = 1;
?>

<div>
    &raquo; Добавить:
    <a href="add_site.php">сайт</a> | <a href="add_mask.php">маску</a>
</div>
<div>
    &raquo; <a href="view.php">Просмотр</a>
</div>
<div>
    &raquo; <a href="trunc.php?mask">Удалить все маски</a>
</div>
<div>
    &raquo; <a href="trunc.php?sites">Удалить все сайты</a>
</div>

<h1>Сайты из чёрного списка</h1>

<?php if (count($all_sites) === 0): ?>
    <div>
        Сайтов нет
    </div>
<?php else: ?>
    <table border="1" cellpadding="5" cellspacing="0">
        <th>#</th>
        <th>Хост</th>
        <th>Домен</th>
        <th>Действия</th>

        <?php foreach ($all_sites as $site): ?>
            <tr>
                <td><?= $i ?></td>
                <td><?= $site['host'] ?></td>
                <td><?= $site['domain'] ?></td>
                <td>
                    <a href="remove.php?act=site&domain=<?= rawurlencode($site['domain']) ?>&host=<?= rawurlencode($site['host']) ?>">X</a>
                    |
                    <a href="update_site.php?domain=<?= rawurlencode($site['domain']) ?>&host=<?= rawurlencode($site['host']) ?>">E</a>
                </td>
            </tr>
            <?php ++$i; ?>
        <?php endforeach; ?>

    </table>
<?php endif; ?>

<h2>Маски чёрного списка</h2>

<?php if (count($all_mask) === 0): ?>
    <div>
        Масок нет
    </div>
<?php else: ?>
    <table border="1" cellpadding="5" cellspacing="0">
        <th>#</th>
        <th>Маска</th>
        <th>Действия</th>

        <?php $i = 1; ?>
        <?php foreach ($all_mask as $key => $mask): ?>
            <tr>
                <td><?= $i ?></td>
                <td><?= $mask ?></td>
                <td>
                    <a href="remove.php?act=mask&id=<?= rawurlencode($mask) ?>">X</a>
                    |
                    <a href="set_mask.php?id=<?= rawurlencode($mask) ?>">E</a>
                </td>
            </tr>
            <?php ++$i; ?>
        <?php endforeach; ?>

    </table>
<?php endif; ?>

<h3>
    Сайты из ЧС заменять на "<?= $config->getReplaceText() ?>"
    <small>
        <a href="update_text.php">Изменить</a>
    </small>
</h3>