<?php
require '../src/RBlackListSitesConfig.php';
$config_file = 'data/config.json';

if (isset($_POST['submit'])){
    $config = new RBlackListSitesConfig($config_file);

    $host = isset($_POST['host']) ? htmlspecialchars($_POST['host']) : '';
    $domain = isset($_POST['domain']) ? htmlspecialchars($_POST['domain']) : '';

    if ($config->addSite($host, $domain) && $config->save()){
        header('Location: index.php');
    }else{
        echo '<ul>';
        foreach ($config->getErrors() as $error){
            echo '<li>' . $error . '</li>';
        }
        echo '</ul>';
    }

}

?>

<form action="?" method="post">
    <div>
        <div>
            <label>Хост:</label>
        </div>
        <input type="text" name="host" placeholder="google">
    </div>
    <div>
        <div>
            <label>Домен:</label>
        </div>
        <input type="text" name="domain" placeholder="com">
    </div>
    <div>
        <input type="submit" name="submit" value="Сохранить">
    </div>
</form>