/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class OSCJavaToByteArrayConverter {
    protected ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private byte[] intBytes = new byte[4];
    private byte[] longintBytes = new byte[8];
    private char[] stringChars = new char[2048];
    private byte[] stringBytes = new byte[2048];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private byte[] alignBigEndToFourByteBoundry(byte[] bytes) {
        int mod = bytes.length % 4;
        if (mod == 0) {
            return bytes;
        }
        int pad = 4 - mod;
        byte[] newBytes = new byte[pad + bytes.length];
        int i = 0;
        while (i < pad) {
            newBytes[i] = 0;
            ++i;
        }
        i = 0;
        while (i < bytes.length) {
            newBytes[pad + i] = bytes[i];
            ++i;
        }
        return newBytes;
    }

    public void appendNullCharToAlignStream() {
        int mod = this.stream.size() % 4;
        int pad = 4 - mod;
        int i = 0;
        while (i < pad) {
            this.stream.write(0);
            ++i;
        }
    }

    public byte[] toByteArray() {
        return this.stream.toByteArray();
    }

    public void write(byte[] bytes) {
        this.writeUnderHandler(bytes);
    }

    public void write(int i) {
        this.writeInteger32ToByteArray(i);
    }

    public void write(Float f) {
        this.writeInteger32ToByteArray(Float.floatToIntBits(f.floatValue()));
    }

    public void write(Integer i) {
        this.writeInteger32ToByteArray(i);
    }

    public void write(BigInteger i) {
        this.writeInteger64ToByteArray(i.longValue());
    }

    public void write(String aString) {
        int stringLength = aString.length();
        aString.getChars(0, stringLength, this.stringChars, 0);
        int mod = stringLength % 4;
        int pad = 4 - mod;
        int i = 0;
        while (i < pad) {
            this.stringChars[stringLength++] = '\u0000';
            ++i;
        }
        i = 0;
        while (i < stringLength) {
            this.stringBytes[i] = (byte)(this.stringChars[i] & 0xFF);
            ++i;
        }
        this.stream.write(this.stringBytes, 0, stringLength);
    }

    public void write(char c) {
        this.stream.write(c);
    }

    public void write(Object anObject) {
        if (anObject == null) {
            return;
        }
        if (anObject instanceof Object[]) {
            Object[] theArray = (Object[])anObject;
            int i = 0;
            while (i < theArray.length) {
                this.write(theArray[i]);
                ++i;
            }
            return;
        }
        if (anObject instanceof Float) {
            this.write((Float)anObject);
            return;
        }
        if (anObject instanceof String) {
            this.write((String)anObject);
            return;
        }
        if (anObject instanceof Integer) {
            this.write((Integer)anObject);
            return;
        }
        if (anObject instanceof BigInteger) {
            this.write((BigInteger)anObject);
            return;
        }
    }

    public void writeType(Class c) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(c)) {
            this.stream.write(105);
            return;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(c)) {
            this.stream.write(104);
            return;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(c)) {
            this.stream.write(102);
            return;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(c)) {
            this.stream.write(100);
            return;
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.equals(c)) {
            this.stream.write(115);
            return;
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz6.equals(c)) {
            this.stream.write(99);
            return;
        }
    }

    public void writeTypesArray(Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                if (Boolean.TRUE.equals(array[i])) {
                    this.stream.write(84);
                } else if (Boolean.FALSE.equals(array[i])) {
                    this.stream.write(70);
                } else {
                    this.writeType(array[i].getClass());
                }
            }
            ++i;
        }
    }

    public void writeTypes(Vector vector) {
        Enumeration enm = vector.elements();
        while (enm.hasMoreElements()) {
            Object nextObject = enm.nextElement();
            if (nextObject == null) continue;
            if (nextObject.getClass().isArray()) {
                this.stream.write(91);
                this.writeTypesArray((Object[])nextObject);
                this.stream.write(93);
                continue;
            }
            if (Boolean.TRUE.equals(nextObject)) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(nextObject)) {
                this.stream.write(70);
                continue;
            }
            this.writeType(nextObject.getClass());
        }
        this.appendNullCharToAlignStream();
    }

    private void writeUnderHandler(byte[] bytes) {
        try {
            this.stream.write(this.alignBigEndToFourByteBoundry(bytes));
        }
        catch (IOException e) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    private void writeInteger32ToByteArray(int value) {
        this.intBytes[3] = (byte)value;
        this.intBytes[2] = (byte)(value >>>= 8);
        this.intBytes[1] = (byte)(value >>>= 8);
        this.intBytes[0] = (byte)(value >>>= 8);
        try {
            this.stream.write(this.intBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    private void writeInteger64ToByteArray(long value) {
        this.longintBytes[7] = (byte)value;
        this.longintBytes[6] = (byte)(value >>>= 8);
        this.longintBytes[5] = (byte)(value >>>= 8);
        this.longintBytes[4] = (byte)(value >>>= 8);
        this.longintBytes[3] = (byte)(value >>>= 8);
        this.longintBytes[2] = (byte)(value >>>= 8);
        this.longintBytes[1] = (byte)(value >>>= 8);
        this.longintBytes[0] = (byte)(value >>>= 8);
        try {
            this.stream.write(this.longintBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }
}

