/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.math.BigInteger;
import java.util.Date;

public class OSCByteArrayToJavaConverter {
    byte[] bytes;
    int bytesLength;
    int streamPosition;

    public OSCPacket convert(byte[] byteArray, int bytesLength) {
        this.bytes = byteArray;
        this.bytesLength = bytesLength;
        this.streamPosition = 0;
        if (this.isBundle()) {
            return this.convertBundle();
        }
        return this.convertMessage();
    }

    private boolean isBundle() {
        String bytesAsString = new String(this.bytes, 0, 7);
        return bytesAsString.startsWith("#bundle");
    }

    private OSCBundle convertBundle() {
        this.streamPosition = 8;
        Date timestamp = this.readTimeTag();
        OSCBundle bundle = new OSCBundle(timestamp);
        OSCByteArrayToJavaConverter myConverter = new OSCByteArrayToJavaConverter();
        while (this.streamPosition < this.bytesLength) {
            int packetLength = (Integer)this.readInteger();
            byte[] packetBytes = new byte[packetLength];
            int i = 0;
            while (i < packetLength) {
                packetBytes[i] = this.bytes[this.streamPosition++];
                ++i;
            }
            OSCPacket packet = myConverter.convert(packetBytes, packetLength);
            bundle.addPacket(packet);
        }
        return bundle;
    }

    private OSCMessage convertMessage() {
        OSCMessage message = new OSCMessage();
        message.setAddress(this.readString());
        char[] types = this.readTypes();
        if (types == null) {
            return message;
        }
        this.moveToFourByteBoundry();
        int i = 0;
        while (i < types.length) {
            if ('[' == types[i]) {
                message.addArgument(this.readArray(types, ++i));
                while (']' != types[i]) {
                    ++i;
                }
            } else {
                message.addArgument(this.readArgument(types[i]));
            }
            ++i;
        }
        return message;
    }

    private String readString() {
        int strLen = this.lengthOfCurrentString();
        char[] stringChars = new char[strLen];
        int i = 0;
        while (i < strLen) {
            stringChars[i] = (char)this.bytes[this.streamPosition++];
            ++i;
        }
        this.moveToFourByteBoundry();
        return new String(stringChars);
    }

    private char[] readTypes() {
        if (this.bytes[this.streamPosition] != 44) {
            return null;
        }
        ++this.streamPosition;
        int typesLen = this.lengthOfCurrentString();
        if (typesLen == 0) {
            return null;
        }
        char[] typesChars = new char[typesLen];
        int i = 0;
        while (i < typesLen) {
            typesChars[i] = (char)this.bytes[this.streamPosition++];
            ++i;
        }
        return typesChars;
    }

    private Object readArgument(char c) {
        switch (c) {
            case 'i': {
                return this.readInteger();
            }
            case 'h': {
                return this.readBigInteger();
            }
            case 'f': {
                return this.readFloat();
            }
            case 'd': {
                return this.readDouble();
            }
            case 's': {
                return this.readString();
            }
            case 'c': {
                return this.readChar();
            }
            case 'T': {
                return Boolean.TRUE;
            }
            case 'F': {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private Object readChar() {
        return new Character((char)this.bytes[this.streamPosition++]);
    }

    private Object readDouble() {
        return this.readFloat();
    }

    private Object readFloat() {
        byte[] floatBytes = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        BigInteger floatBits = new BigInteger(floatBytes);
        return new Float(Float.intBitsToFloat(floatBits.intValue()));
    }

    private Object readBigInteger() {
        byte[] longintBytes = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        return new BigInteger(longintBytes);
    }

    private Object readInteger() {
        byte[] intBytes = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        BigInteger intBits = new BigInteger(intBytes);
        return new Integer(intBits.intValue());
    }

    private Date readTimeTag() {
        byte[] secondBytes = new byte[8];
        byte[] fractionBytes = new byte[8];
        int i = 0;
        while (i < 4) {
            secondBytes[i] = 0;
            fractionBytes[i] = 0;
            ++i;
        }
        boolean isImmediate = true;
        int i2 = 4;
        while (i2 < 8) {
            secondBytes[i2] = this.bytes[this.streamPosition++];
            if (secondBytes[i2] > 0) {
                isImmediate = false;
            }
            ++i2;
        }
        i2 = 4;
        while (i2 < 8) {
            fractionBytes[i2] = this.bytes[this.streamPosition++];
            if (i2 < 7) {
                if (fractionBytes[i2] > 0) {
                    isImmediate = false;
                }
            } else if (fractionBytes[i2] > 1) {
                isImmediate = false;
            }
            ++i2;
        }
        if (isImmediate) {
            return OSCBundle.TIMESTAMP_IMMEDIATE;
        }
        BigInteger secsSince1900 = new BigInteger(secondBytes);
        long secsSince1970 = secsSince1900.longValue() - OSCBundle.SECONDS_FROM_1900_to_1970.longValue();
        if (secsSince1970 < 0L) {
            secsSince1970 = 0L;
        }
        long fraction = new BigInteger(fractionBytes).longValue();
        fraction = (fraction = fraction * 1000L / 0x100000000L) > 0L ? fraction + 1L : 0L;
        long millisecs = secsSince1970 * 1000L + fraction;
        return new Date(millisecs);
    }

    private Object[] readArray(char[] types, int i) {
        int arrayLen = 0;
        while (types[i + arrayLen] != ']') {
            ++arrayLen;
        }
        Object[] array = new Object[arrayLen];
        int j = 0;
        while (j < arrayLen) {
            array[j] = this.readArgument(types[i + j]);
            ++j;
        }
        return array;
    }

    private int lengthOfCurrentString() {
        int i = 0;
        while (this.bytes[this.streamPosition + i] != 0) {
            ++i;
        }
        return i;
    }

    private void moveToFourByteBoundry() {
        int mod = this.streamPosition % 4;
        this.streamPosition += 4 - mod;
    }
}

