/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KeyTranslator {
    public HashMap codes;
    private int[] modifiers;
    private int[] shifts;
    private int[] ctrls;
    private int[] leftClicks;
    protected Document myDoc;

    public KeyTranslator() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String sPath = "config.xml";
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.myDoc = AppFrame.jar == null ? builder.parse(new File((String.valueOf(AppFrame.basePath) + sPath).replace('\\', '/'))) : builder.parse(AppFrame.jar.getInputStream(AppFrame.jar.getJarEntry(sPath)));
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Element config = this.myDoc.getDocumentElement();
        NodeList mods = config.getElementsByTagName("modifier");
        int l = mods.getLength();
        this.modifiers = new int[l];
        int i = 0;
        while (i < l) {
            this.modifiers[i] = Integer.parseInt(((Element)mods.item(i)).getAttribute("code"));
            ++i;
        }
        mods = config.getElementsByTagName("shift");
        l = mods.getLength();
        this.shifts = new int[l];
        i = 0;
        while (i < l) {
            this.shifts[i] = Integer.parseInt(((Element)mods.item(i)).getAttribute("code"));
            ++i;
        }
        mods = config.getElementsByTagName("ctrl");
        l = mods.getLength();
        this.ctrls = new int[l];
        i = 0;
        while (i < l) {
            this.ctrls[i] = Integer.parseInt(((Element)mods.item(i)).getAttribute("code"));
            ++i;
        }
        this.codes = new HashMap();
        mods = config.getElementsByTagName("key");
        l = mods.getLength();
        i = 0;
        while (i < l) {
            KeyCodeData data = new KeyCodeData();
            Element keydata = (Element)mods.item(i);
            data.name = keydata.getAttribute("name");
            data.modshifted = "1".compareTo(keydata.getAttribute("modshift")) == 0;
            data.localcode = Integer.parseInt(keydata.getAttribute("localcode"));
            data.modifiedcode = Integer.parseInt(keydata.getAttribute("modified"));
            data.shifted = "1".compareTo(keydata.getAttribute("shifted")) == 0;
            data.shiftedcode = Integer.parseInt(keydata.getAttribute("shiftedcode"));
            int keycode = Integer.parseInt(keydata.getAttribute("code"));
            this.codes.put(new Integer(keycode), data);
            ++i;
        }
        mods = config.getElementsByTagName("leftclick");
        l = mods.getLength();
        this.leftClicks = new int[l];
        i = 0;
        while (i < l) {
            this.leftClicks[i] = Integer.parseInt(((Element)mods.item(i)).getAttribute("code"));
            ++i;
        }
    }

    public boolean isModifier(int keycode) {
        int l = this.modifiers.length;
        int i = 0;
        while (i < l) {
            if (keycode == this.modifiers[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isShift(int keycode) {
        int l = this.shifts.length;
        int i = 0;
        while (i < l) {
            if (keycode == this.shifts[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isCtrl(int keycode) {
        int l = this.ctrls.length;
        int i = 0;
        while (i < l) {
            if (keycode == this.ctrls[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLeftClick(int keycode) {
        int l = this.leftClicks.length;
        int i = 0;
        while (i < l) {
            if (keycode == this.leftClicks[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

