<?php

/**
 * JLayer
 *
 * Layer for JohnCMS
 *
 * @package JohnCMS
 * @subpackage JLayer
 * @author Screamer
 * @copyright 2013
 */

defined('JL_MODULE_DIR') or die('Module\'s directory is not defined.');
defined('JL_TABLES_PREFIX') or die('Tables prefix is not defined');
defined('JL_DEFAULT_CONTROLLER') or die('Default controller is not defined');
defined('JL_DEFAULT_ACTION') or die('Default action is not defined');
defined('JOHNCMS_VERSION') or die('CMS version is not defined');

date_default_timezone_set('UTC');

/** Directory Separator */
define('DIR_SEP', DIRECTORY_SEPARATOR);
/** JLayer System Directory */
define('JL_DIR', rtrim(dirname(__FILE__), '/\\') . DIR_SEP);
/** Directory of engine system files */
define('ENGINE_DIR', rtrim(realpath(JL_DIR . '../incfiles'), '/\\') . DIR_SEP);
/** Path to files directory */
define('FILES_DIR', JL_MODULE_DIR . 'files' . DIR_SEP);
/** Path to output for uncaught exceptions */
define('JL_EXP_PATH', 1);
/** JLayer Logs Directory */
define('JL_LOGS', JL_DIR . 'jl' . DIR_SEP . 'logs' . DIR_SEP);
/** DBWrapper */
define('JL_DB_WRAPPER', 'MySQL');
/** HTTP Host */
define('HTTP_HOST', 'http://' . trim($_SERVER['SERVER_NAME'], '/\\') . '/');

require JL_DIR . 'functions.php';

if (!is_dir(JL_LOGS)) {
	die('Logs Directory "' . JL_LOGS . '" is not exists.');
}

// Set uncaught exceptions handler
set_exception_handler('\jl\exception_handler');

// Load exceptions handlers
$exceptions = array('exception', 'invalid_argument_exception');
foreach ($exceptions as $excp) {
	$excp = JL_DIR . 'jl' . DIR_SEP . 'exception' . DIR_SEP . $excp . '.php';
	if (is_file($excp)) {
		require $excp;
	} else {
		throw new \Exception("Unable to load exception handler: " . $excp);
	}
}

// Load JLayer Classes
$classes = array('db', 'jlayer', 'users', 'functions', 'plugin' ,'controller', 'model', 'template', 'language');
foreach ($classes as $class) {
	$class = JL_DIR . 'jl' . DIR_SEP . $class . '.php';
	if(is_file($class)) {
		require $class;
	} else {
		throw new \jl\exception\Exception("Unable to load file \"" . $class . "\"");
	}
}
unset($classes, $class);

// Load DB wrapper
$db_wrapper = JL_DIR . 'jl' . DIR_SEP . 'wrappers' . DIR_SEP . 'db' . DIR_SEP . strtolower(JL_DB_WRAPPER) . '.php';
if (is_file($db_wrapper)) {
	require $db_wrapper;
} else {
	throw new \jl\exception\Exception('Unable to load DBWrapper. File "' . $db_wrapper . '" is not exists');
}

// Load engine wrapper
$engine_wrapper_dir = JL_DIR . 'jl' . DIR_SEP . 'wrappers' . DIR_SEP . 'johncms' . DIR_SEP . JOHNCMS_VERSION . DIR_SEP;
$engine_wrapper = $engine_wrapper_dir . 'config.php';
if (is_file($engine_wrapper)) {
	$johncms = require $engine_wrapper;
} else {
	throw new \jl\exception\Exception('Unable to load engine wrapper. Version "' . JOHNCMS_VERSION . '" is not supporting.');
}

// Load engine's functions wrapper
$functions_wrapper = $engine_wrapper_dir . 'functions.php';
if (is_file($functions_wrapper)) {
	require $functions_wrapper;
} else {
	throw new \jl\exception\Exception('Unable to load functions wrapper.');
}

// Check directories for exists
$directories = array(
	'model'      => 'Models',
	'lang'       => 'Languages',
	'view'       => 'Templates',
	'controller' => 'Controllers',
);
foreach ($directories as $dir => $desc) {
	if (!is_dir(JL_MODULE_DIR . $dir)) {
		throw new \jl\exception\Exception($desc . ' directory "' . JL_MODULE_DIR . $dir . '" is not exists.');
	}
}
unset($directories);

// Init db wrapper
$wrapper = "\jl\wrappers\db\\" . JL_DB_WRAPPER;
$jl_db = new $wrapper($johncms['db']['host'], $johncms['db']['user'], $johncms['db']['password']);

$current_db = $jl_db->result("SELECT DATABASE()");
if (!$current_db) {
	if (!$jl_db->select_db($johncms['db']['name'])) {
		throw new \jl\exception\Exception('Unable to select database');
	}
}

// Controllers Templates Handler
$jl_tpl = new \jl\Template(JL_MODULE_DIR . 'view' . DIR_SEP, 'php');
$jl_tpl->set_output('', 0);

// Languages handler
try {
	$jl_lng = new jl\Language(JL_MODULE_DIR . 'lang' . DIR_SEP . $johncms['language'] . '.json');
} catch (Exception $e) {
	if (isset($johncms['system_settings']['lng'])) {
		$jl_lng = new jl\Language((JL_MODULE_DIR . 'lang' . DIR_SEP . $johncms['system_settings']['lng'] . '.json'));
		$johncms['language'] = $johncms['system_settings']['lng'];
	} else {
		throw new \jl\exception\Exception($e->getMessage());
	}
}

// JLayer
$jl = new \jl\JLayer(
	$jl_db,
	new \jl\Users($johncms['user']['data'], $johncms['user']['settings'], $johncms['user']['infringements'], $johncms['user']['table_name']),
	new \jl\wrappers\johncms\Functions(
		new \jl\Template($engine_wrapper_dir . 'view', 'php'),
		$jl_db,
		$johncms['network']['ip'],
		$johncms['network']['ip_via_proxy'],
		$johncms['network']['user_agent'],
		$johncms['network']['is_mobile'],
		$johncms['system_settings']
	),
	JL_MODULE_DIR . 'model' . DIR_SEP,
	$johncms['language']
);

// Route
$uri = explode('/', trim($_SERVER['REQUEST_URI'], '/'));
$uri = array_map('trim', $uri);
$controller = isset($uri[1]) && !empty($uri[1]) ? $uri[1] : JL_DEFAULT_CONTROLLER;
$action = isset($uri[2]) && !empty($uri[2]) ? $uri[2] : JL_DEFAULT_ACTION;
$args = sizeof($uri) > 3 ? array_slice($uri, 3) : array();
$file = JL_MODULE_DIR . 'controller' . DIR_SEP . $controller . '.php';
$redirect = true;
if (is_file($file)) {
	require $file;
	$controller = 'Controller_' .  ucwords($controller);
	if (class_exists($controller)) {
		$controller = new $controller($jl, $jl_lng, $jl_tpl);
		if ($controller instanceof \jl\Controller) {
			$method = 'action_' . $action;
			if (method_exists($controller, $method)) {
				$result = call_user_func_array(array($controller, $method), $args);
				$redirect = false;
			}
		}
	}
}
// Redirect to error page
if ($redirect === true) {
	header('Location: ' . HTTP_HOST . '?err');
	exit;
}
$jl_tpl->set_title('test');
// Handle result
if (!empty($result)) {
	if (!is_null($jl_tpl->get_title())) {
		$johncms['output']['head'] = preg_replace(
			'~<title>(.+?)</title>~ius',
			'<title>'. $jl_tpl->get_title() . '</title>',
			$johncms['output']['head']
		);
	}
	$jl_tpl->set_output($johncms['output']['head'], 0);
	$jl_tpl->set_output($result);
	$jl_tpl->set_output($johncms['output']['end']);
	$jl_tpl->output();
}