<?php
namespace jl {
	use jl\exception\InvalidArgumentException;

	/**
	 * JLayer
	 *
	 * Users handler
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */
	class Users {

		/**
		 * @var int ID of current user
		 */
		private $id;

		/**
		 * @var int Rights of current user
		 */
		private $rights;

		/**
		 * @var array Settings of current user
		 */
		private $settings;

		/**
		 * @var array Data of current user
		 */
		private $data;

		/**
		 * @var array Infringements of current user
		 */
		private $infringements;

		/**
		 * @var string Name of table with users data in database
		 */
		private $table_name;

		/**
		 * Construct
		 *
		 * @param array  $data          Data of user
		 * @param array  $settings      Settings of user
		 * @param array  $infringements Infringements of user
		 * @param string $table         Name of table with users data in database
		 *
		 * @throws exception\InvalidArgumentException
		 * @return \jl\Users
		 */
		public function __construct(array $data, array $settings, array $infringements, $table) {
			if (!is_string($table)) {
				throw new InvalidArgumentException('table', 'string');
			}

			if (isset($data['id']) && isset($data['rights'])) {
				$this->id = intval($data['id']);
				$this->rights = intval($data['rights']);
				unset($data['id'], $data['rights']);
				$this->data = $data;
			} else {
				$this->id = 0;
				$this->rights = 0;
				$this->data = array();
			}
			$this->settings = $settings;
			$this->infringements = $infringements;
			$this->table_name = $table;
		}

		/**
		 * Get ID of current user
		 *
		 * @return int
		 */
		public function get_id() {
			return $this->id;
		}

		/**
		 * Get rights of current user
		 *
		 * @return int
		 */
		public function get_rights() {
			return $this->rights;
		}

		/**
		 * Get data of current user.
		 * If empty argument passed, return all array
		 *
		 * @param string $key Item of data
		 *
		 * @return string|array
		 */
		public function get_data($key = '') {
			return $this->getter($this->data, $key);
		}

		/**
		 * Get infringements of current user.
		 *
		 * @return array
		 */
		public function get_infringements() {
			return $this->infringements;
		}

		/**
		 * Get settings of current user.
		 * If empty argument passed, return all array
		 *
		 * @param string $key Item of data
		 *
		 * @return array
		 */
		public function get_settings($key = '') {
			return $this->getter($this->settings, $key);
		}

		/**
		 * Get name of table which contains users data
		 *
		 * @return string
		 */
		public function get_table() {
			return $this->table_name;
		}

		/**
		 * Returns some item from array or all array
		 *
		 * @param array  $data Array for handle
		 * @param string $key  Item of data
		 *
		 * @throws InvalidArgumentException
		 * @return array
		 */
		private function getter(array $data, $key = '') {
			if (!is_string($key)) {
				throw new InvalidArgumentException('key', 'String');
			}

			if (!empty($key)) {
				if (array_key_exists($key, $data)) {
					return $data[$key];
				} else {
					return null;
				}
			} else {
				return $data;
			}
		}

	}
}