<?php
namespace jl {
	/**
	 * JLayer
	 * Helper
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */

	/**
	 * Anchor
	 *
	 * @param string $uri     URI
	 * @param string $title   Title
	 * @param string $options Options
	 *
	 * @return string (string)
	 */
	function anchor($uri, $title = '', $options = '') {
		$url = HTTP_HOST . $uri;
		if (!empty($title) || $title == '0') {
			return '<a href="' . $url . '"' . (!empty($options) ? ' ' . $options : '') . '>' . $title . '</a>';
		} else {
			return $url;
		}
	}

	/**
	 * Uncaught exception handler
	 *
	 * @param \Exception $exception Object of exception
	 *
	 * @return void
	 */
	function exception_handler($exception)
	{
		if (JL_EXP_PATH === false) {
			// Display exception
			echo '<pre><b>' . get_class($exception) . ' [' . $exception->getCode() . ']</b><br /><b>Message:</b> ' . nl2br($exception->getMessage())
				. '<br /><b>File:</b> ' . $exception->getFile()
				. '<br /><b>Line:</b> ' . $exception->getLine()
				. '<br /><b>Trace:</b><br />' . $exception->getTraceAsString() . '</pre>';
		} else {
			// Save exception to log
			$file = JL_LOGS . date('d-m-Y', time()) . '-exceptions.log';
			$data = is_file($file) ? file_get_contents($file) : '';
			$data = get_class($exception) . ' [' . $exception->getCode() . '] '
				. PHP_EOL . 'Time: ' . date('H:i:s', time())
				. PHP_EOL . 'Error: ' . $exception->getMessage()
				. PHP_EOL . 'File: ' . $exception->getFile()
				. PHP_EOL . 'Line: ' . $exception->getLine()
				. PHP_EOL . 'Trace: ' . $exception->getTraceAsString()
				. PHP_EOL . str_repeat('=', 100) . PHP_EOL . $data;
			file_put_contents($file, $data);
		}
		exit(1);
	}

	/**
	 * Prepare image to display
	 *
	 * @param string $image Image
	 * @param string $link  Some link
	 *
	 * @return string
	 */
	function img($image, $link = '') {
		$image = '<img src="' . anchor($image) . '" />';
		return !empty($link) ? anchor($link, $image) : $image;
	}

	/**
	 * Redirect to internal page.
	 * Error page by default
	 *
	 * @param string $uri URI
	 *
	 * @return void
	 */
	function redirect($uri = '?err') {
		header('Location: ' . HTTP_HOST . ltrim($uri, '/'));
		exit;
	}

}