
CREATE TABLE IF NOT EXISTS `forum_favourites` (
  `topic` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  KEY `topic` (`topic`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `topic` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` int(2) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `down` int(11) NOT NULL,
  `plus` int(11) NOT NULL,
  `minus` int(11) NOT NULL,
  `rating` int(1) NOT NULL,
  `tempid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`topic`,`type`,`user_id`),
  KEY `tempid` (`tempid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_forums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `realid` int(11) NOT NULL,
  `refid` int(11) NOT NULL,
  `type` int(1) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `last_topic` varchar(250) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `realid` (`realid`,`refid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_journal` (
  `time` int(11) NOT NULL,
  `user_id` int(10) NOT NULL,
  `text` text NOT NULL,
  `readed` int(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_polled` (
  `refid` int(11) NOT NULL,
  `poll` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  KEY `refid` (`refid`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `count` (`count`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user` varchar(40) NOT NULL,
  `text` text NOT NULL,
  `edit` varchar(150) NOT NULL DEFAULT '',
  `files` int(1) NOT NULL,
  `browser` varchar(250) NOT NULL,
  `ip` bigint(11) NOT NULL,
  `ip_via_proxy` bigint(11) NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`time`,`user_id`,`files`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_posts_del` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user` varchar(40) NOT NULL,
  `text` text NOT NULL,
  `edit` varchar(150) NOT NULL DEFAULT '',
  `files` int(1) NOT NULL,
  `browser` varchar(250) NOT NULL,
  `ip` bigint(11) NOT NULL,
  `ip_via_proxy` bigint(11) NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  `plus_minus` varchar(50) NOT NULL DEFAULT '0|0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`time`,`user_id`,`files`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_posts_rating` (
  `refid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  KEY `refid` (`refid`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_readed` (
  `topic` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `lastpost` int(11) NOT NULL,
  PRIMARY KEY (`topic`,`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `forum` varchar(150) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user` varchar(40) NOT NULL,
  `lastpost` varchar(250) NOT NULL,
  `count` int(11) NOT NULL,
  `close` tinyint(1) NOT NULL,
  `sticky` tinyint(1) NOT NULL,
  `clip` tinyint(1) NOT NULL,
  `poll_name` varchar(250) NOT NULL,
  `poll_set` text NOT NULL,
  `curator` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`time`,`user_id`,`sticky`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
