<?php

class Front extends Storage {
    
    /** @var (string)  имя контроллера модуля */
    protected $moduleName;
    
    /** @var (string)  путь к контроллеру модуля */
    protected $modulePath;
    
    /** @var (string)  метод контроллера модуля, который будет выполнен */
    protected $moduleAction;
    
    /** @var (string)  путь к модулю, который будет загружен при возникновении ошибки */
    protected $errorPath;
    
    /** @var (string)  имя модуля, загружаемого при ошибке */
    protected $errorName;
    
    /**
     * @param (string) $moduleName имя контроллера модуля
     * @param (string) $modulePath путь к контроллеру модуля
     * @param (string) $action метод контроллера модуля, который будет выполнен
     * @param (string) $errorPath путь к модулю, который будет загружен при возникновении ошибки
     * @param (string) $errorName имя модуля, загружаемого при ошибке
     */
    
    public function __construct($moduleName, $modulePath, $action, $errorPath, $errorName)
    {
        
        $this->moduleName = $moduleName;
        $this->modulePath = $modulePath;
        $this->moduleAction = $action;
        $this->errorName = $errorName;
        $this->errorPath = $errorPath;
        
    }
    
    /**
     * Загрузка и контроллера и выполнение запрашиваемого действия
     */
    
    public function execute()
    {
    
        $error = FALSE;
    
        if (!file_exists($this->modulePath))
        {
            
            $error = TRUE;
            
        }
        else
        {
            
            require ($this->modulePath);
            
            if (!class_exists($this->moduleName))
            {
                
                $error = TRUE;
                
                
            }
            else
            {
                
                $module = new $this->moduleName($this->storage);
                $action = $this->moduleAction;
    
                if (is_callable(array($module, $action)))
                {
                    
                    $module->$action();
                    
                }
                else
                {
                    
                    $error = TRUE;
                    
                }
                
            }
            
        }
        
        if ($error === TRUE)
        {
            
            $this->show404();
            
        }    
        
        unset($this->storage);
        
    }
    
    /**
     * 404 error
     */
    
    protected function show404()
    {
        
        if (!file_exists($this->errorPath))
        {
            
            throw new Exception($this->errorPath . ' is not exists');
            
        }
        
        require $this->errorPath;
        
        if (!class_exists($this->errorName))
        {
            
            throw new Exception('class ' . $this->errorName .  ' is not exists');
            
        }
        
        $error = new $this->errorName($this->storage);
        $error->index();
        
    }
    
}