SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
//=====================================//
CREATE TABLE IF NOT EXISTS `conclave_combats` (
  `combatid` varchar(30) NOT NULL DEFAULT '',
  `loc_id` varchar(30) NOT NULL,
  `fighters` mediumtext,
  `round` mediumint(9) NOT NULL,
  `end_round` int(9) DEFAULT NULL,
  `combatlog` mediumtext,
  PRIMARY KEY (`combatid`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;
//=====================================//
CREATE TABLE IF NOT EXISTS `conclave_effects` (
  `effid` varchar(30) NOT NULL,
  `name` tinytext,
  `info` text NOT NULL,
  `resists` text NOT NULL,
  `params` text NOT NULL,
  `noeff` text NOT NULL,
  `badeff` text NOT NULL,
  `chance` smallint(6) DEFAULT NULL,
  `end_time` int(11) NOT NULL,
  PRIMARY KEY (`effid`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;
//=====================================//
INSERT INTO `conclave_effects` (`effid`, `name`, `info`, `resists`, `params`, `noeff`, `badeff`, `chance`, `end_time`) VALUES
('baff', 'Р‘Р°С„С„', 'РџРѕРІС‹С?РµРЅРёРµ СЃРёР»С‹ РЅР° 3', '', 'a:1:{s:3:"str";s:1:"3";}', '', 'badbaff', 3, 3666),
('badbaff', 'Р—Р°РІРёСЃРёРјРѕСЃС‚СЊ РѕС‚ Р±Р°С„Р°', 'Р’С‹ СЃР»РёС?РєРѕРј РїРµСЂРµСѓСЃРµСЂРґСЃС‚РІРѕРІР°Р»Рё СЃ Р±Р°С„С„РѕРј Рё С‚РµРїРµСЂСЊ РЅРµ РјРѕР¶РµС‚Рµ Р±РµР· РЅРµРіРѕ Р¶РёС‚СЊ!', 'a:6:{s:9:"resnormal";s:2:"-5";s:9:"resplazma";s:2:"-5";s:7:"resboom";s:2:"-5";s:7:"resvolt";s:2:"-5";s:6:"resrad";s:2:"-5";s:9:"respoison";s:2:"-5";}', 'a:3:{s:3:"str";s:2:"-5";s:5:"speed";s:2:"-5";s:4:"luck";s:2:"-5";}', '', '', 0, 0),
('nobaff', 'РћС‚ Р±Р°С„С„Р°', '', '', '', 'baff', '', 0, 0),
('minus3str', 'РЎР»Р°Р±РѕСЃС‚СЊ', 'Р’С‹ С‡СѓРІСЃС‚РІСѓРµС‚Рµ СЃР»Р°Р±РѕСЃС‚СЊ', '', 'a:1:{s:3:"str";s:2:"-3";}', '', '', 0, 0),
('anasha', 'Р§СѓРґРѕ-С‚СЂР°РІР°', 'РћС‚ С‡СѓРґРѕ С‚СЂР°РІС‹ С‚Р°С‰РёС‚ РЅРµ РїРѕРґРµС‚СЃРєРё - РІ РІР°СЃ СЃС‚СЂРµР»СЏСЋС‚, Р° РІР°Рј РїРѕС…СЂРµРЅ!', '', 'a:1:{s:4:"luck";s:1:"5";}', '', 'minus3str', 33, 5000),
('anasha2', 'Р§СѓРґРѕ-С‚СЂР°РІР°', 'С‚РµСЃС‚', '', 'a:1:{s:4:"luck";s:1:"3";}', '', 'minus3str', 120, 1000);
//=====================================//
CREATE TABLE IF NOT EXISTS `conclave_forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `razdel` varchar(20) DEFAULT NULL,
  `tema` int(11) NOT NULL,
  `temaname` blob NOT NULL,
  `username` varchar(50) NOT NULL,
  `post` blob NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=802 ;
//=====================================//
CREATE TABLE IF NOT EXISTS `conclave_gameinfo` (
  `light` varchar(20) NOT NULL,
  `changetime` int(11) DEFAULT NULL,
  `dbcleartime` int(11) NOT NULL,
  PRIMARY KEY (`light`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;
//=====================================//
INSERT INTO `conclave_gameinfo` (`light`, `changetime`, `dbcleartime`) VALUES
('day', 1332073479, 0);
//=====================================//
CREATE TABLE IF NOT EXISTS `conclave_items` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `name` blob,
  `info` blob NOT NULL,
  `about_item` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=57 ;
//=====================================//
INSERT INTO `conclave_items` (`id`, `type`, `name`, `info`, `about_item`) VALUES
(1, 'bodyarm', 0xd0a0d0b2d0b0d0bdd18cd191, 0xd0a0d0b2d0b0d0bdd18bd0b520d0bed0b1d0bdd0bed181d0bad0b82c20d18fd0b2d0bdd0be20d0bdd0b0d0b9d0b4d0b5d0bdd0bdd18bd0b520d0b3d0b4d0b520d182d0be20d0bdd0b020d0bfd0bed0bcd0bed0b9d0bad0b5, 'a:10:{s:9:"req_level";s:1:"0";s:9:"resnormal";s:1:"5";s:9:"resplazma";s:1:"0";s:7:"resboom";s:1:"0";s:7:"resvolt";s:1:"0";s:9:"respoison";s:1:"0";s:6:"resrad";s:1:"0";s:8:"bonusdex";s:2:"-5";s:4:"cena";s:1:"3";s:5:"massa";s:2:"10";}'),
(2, 'weapon', 0xd09fd0b0d0bbd0bad0b0, 0xd092d18bd182d18fd0bdd183d182d18bd0b920d0bad183d181d0bed0ba20d0b4d0b5d180d0b5d0b2d0b02e20d09220d0bdd0bed181d18320d182d0b0d0bad0b8d0bc20d0bdd0b520d0bfd0bed0bad0bed0b2d18bd180d18fd0b5d188d18c2e20d097d0b0d182d0be20d0bcd0bed0b6d0bdd0be20d183d0b4d0b0d180d0b8d182d18c20d0bad0bed0b3d0be20d0bdd0b8d0b1d183d0b4d18c20d0bfd0be20d0b3d0bed0bbd0bed0b2d0b521, 'a:14:{s:9:"req_level";s:1:"0";s:6:"calibr";s:1:"0";s:10:"maxpatrons";s:1:"0";s:9:"arrayfire";s:1:"0";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"1";s:6:"maxdmg";s:1:"4";s:7:"odbonus";s:1:"0";s:9:"critbonus";s:2:"-2";s:11:"sniperbonus";s:2:"-5";s:5:"crash";s:1:"0";s:4:"cena";s:1:"2";s:5:"massa";s:1:"5";}'),
(4, 'patron', 0xd09fd0b0d182d180d0bed0bd203130d0bcd0bc, 0xd09fd0bed181d0bbd0b520d0b2d0bed0b9d0bdd18b20d0b8d0b72dd0b7d0b020d0bdd0b5d185d0b2d0b0d182d0bad0b820d0bfd0b0d182d180d0bed0bdd0bed0b220d0b1d0bed0bbd18cd188d183d18e20d187d0b0d181d182d18c20d0bed180d183d0b6d0b8d18f20d0bfd0b5d180d0b5d0b4d0b5d0bbd0b0d0bbd0b820d0bfd0bed0b420d18dd182d0bed18220d0b4d0b5d188d0b5d0b2d18bd0b920d0b820d181d0b0d0bcd18bd0b920d180d0b0d181d0bfd180d0bed181d182d180d0b0d0bdd0b5d0bdd0bdd18bd0b920d0bfd0b0d182d180d0bed0bd2e20d09ed0b4d0bdd0b0d0bad0be20d0b5d189d0b520d0bcd0bed0b6d0bdd0be20d0b2d181d182d180d0b5d182d0b8d182d18c20d0bfd183d188d0bad0b820d0b820d0bfd0bed0b420d0b1d0bed0bbd0b5d0b520d183d0b1d0bed0b9d0bdd18bd0b520d0bfd0b0d182d180d0bed0bdd18b21, 'a:4:{s:6:"calibr";s:4:"10mm";s:6:"moddmg";s:2:"-3";s:4:"cena";s:1:"1";s:5:"massa";s:1:"0";}'),
(5, 'weapon', 0xd0a1d0b0d0bcd0bed0bfd0b0d0bb, 0xd0a1d0b0d0bcd0bed0b4d0b5d0bbd18cd0bdd0bed0b520d180d183d0b6d18cd0b5202d20d180d0b6d0b0d0b2d0b0d18f2c20d181d182d180d0b5d0bbd18fd18ed189d0b0d18f20d182d180d183d0b1d0b0, 'a:14:{s:9:"req_level";s:1:"0";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:1:"1";s:9:"arrayfire";s:1:"0";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"5";s:6:"maxdmg";s:1:"7";s:7:"odbonus";s:1:"0";s:9:"critbonus";s:1:"0";s:11:"sniperbonus";s:3:"-10";s:5:"crash";s:2:"20";s:4:"cena";s:2:"15";s:5:"massa";s:2:"15";}'),
(6, 'weapon', 0xd09ad0b0d0bcd0b5d0bdd18c, 0xd09ed0b1d18bd187d0bdd18bd0b920d0b1d183d0bbd18bd0b6d0bdd0b8d0ba2e20d098d0bc20d0bcd0bed0b6d0bdd0be20d0b220d0bad0bed0b3d0be2dd0bdd0b8d0b1d183d0b4d18c20d0b7d0b0d0bfd183d181d182d0b8d182d18c21, 'a:14:{s:9:"req_level";s:1:"0";s:6:"calibr";s:1:"0";s:10:"maxpatrons";s:1:"0";s:9:"arrayfire";s:1:"0";s:9:"type_weap";s:5:"throw";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"5";s:6:"maxdmg";s:2:"10";s:7:"odbonus";s:1:"0";s:9:"critbonus";s:1:"0";s:11:"sniperbonus";s:1:"0";s:5:"crash";s:1:"0";s:4:"cena";s:1:"1";s:5:"massa";s:1:"5";}'),
(7, 'weapon', 0xd09ed0b1d180d0b5d0b7, 0xd094d0b2d183d185d181d182d0b2d0bed0bbd0bad0b020d18120d0bed0b1d180d0b5d0b7d0b0d0bdd0bdd18bd0bc20d181d182d0b2d0bed0bbd0bed0bc2e20d09ed180d183d0b6d0b8d0b520d0b1d0b0d0bdd0b4d0b8d182d0bed0b220d0b820d0bed182d0bcd0bed180d0bed0b7d0bad0bed0b22e, 'a:14:{s:9:"req_level";s:1:"0";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:1:"2";s:9:"arrayfire";s:1:"2";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"5";s:6:"maxdmg";s:2:"12";s:7:"odbonus";s:1:"0";s:9:"critbonus";s:2:"10";s:11:"sniperbonus";s:1:"5";s:5:"crash";s:1:"5";s:4:"cena";s:3:"350";s:5:"massa";s:2:"12";}'),
(8, 'misc', 0xd09ad180d18bd181d0b8d0bdd18bd0b920d185d0b2d0bed181d182, 0xd0a5d0b2d0bed181d18220d0bad180d18bd181d18b2e20d093d0bed0b2d0bed180d18fd18220d187d182d0be20d0bfd0b5d180d0b5d0b420d181d0bcd0b5d180d182d18cd18e20d0bad180d18bd181d0b820d181d0b1d180d0b0d181d18bd0b2d0b0d18ed18220d181d0b2d0bed0b820d185d0b2d0bed181d182d18b2c20d182d0be20d0bbd0b820d0bed18220d0b8d181d0bfd183d0b3d0b02c20d182d0be20d0bbd0b820d0b5d189d0b520d0bed18220d187d0b5d0b3d0be2e20d0add182d0bed0b3d0be20d0bdd0b8d0bad182d0be20d0bdd0b520d0b7d0bdd0b0d0b5d1822e2e2e, 'a:2:{s:4:"cena";s:2:"15";s:5:"massa";s:1:"2";}'),
(9, 'medicament', 0xd09cd0b0d0bbd18bd0b920d181d182d0b8d0bcd0bfd0b0d0ba, 0xd091d18bd182d0bed0b2d0bed0b920d181d182d0b8d0bcd0bfd0b0d0ba202d20d0b7d0b0d182d18fd0b3d0b8d0b2d0b0d0b5d18220d0bfd0bed180d0b5d0b7d18b20d0bed18220d0bad183d185d0bed0bdd18bd18520d0bdd0bed0b6d0b5d0b92c20d181d181d0b0d0b4d0b8d0bdd18b2c20d183efbfbd3fd0b8d0b1d18b20d0b820d183d181d182d180d0b0d0bdd18fd0b5d18220d0b4d180d183d0b3d0b8d0b520d0bcd0b5d0bbd0bad0b8d0b520d0b820d0bdd0b520d0bfd180d0b8d18fd182d0bdd18bd0b520d0b220d0b1d18bd182d18320d0b2d0b5d189d0b82e20d09bd183d187d188d0b8d0b920d0bfd0bed0bcd0bed189d0bdd0b8d0ba20d0b4d0bed0bcd0bed185d0bed0b7d18fd0b9d0bad0b8, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:10:"hit_points";s:5:"value";s:2:"10";s:4:"cena";s:2:"15";s:5:"massa";s:1:"2";}'),
(10, 'medicament', 0xd091d0b0d184d184, 0xd0a5d0b8d0bcd0b8d187d0b5d181d0bad0b8d0b920d0bfd180d0b5d0bfd0b0d180d0b0d1822c20d0b2d180d0b5d0bcd0b5d0bdd0bdd0be20d0bfd0bed0b2d18bd188d0b0d18ed189d0b8d0b920d181d0b8d0bbd18320d0bfd180d0b8d0bcd0b5d0bdd0b8d0b2d188d0b5d0b3d0be20d0b5d0b3d0be2e20d09220d180d0b5d0b4d0bad0b8d18520d181d0bbd183d187d0b0d18fd18520d0b2d18bd0b7d18bd0b2d0b0d0b5d18220d0b7d0b0d0b2d0b8d181d0b8d0bcd0bed181d182d18c21, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"effect";s:5:"value";s:4:"baff";s:4:"cena";s:2:"50";s:5:"massa";s:1:"1";}'),
(11, 'medicament', 0xd09bd0b5d0bad0b0d180d181d182d0bed0b220d0bed18220d0b1d0b0d184d184d0b0, 0xd0a1d0bdd0b8d0bcd0b0d0b5d18220d18dd184d184d0b5d0bad18220d0b1d0b0d184d184d0b0, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"effect";s:5:"value";s:6:"nobaff";s:4:"cena";s:2:"50";s:5:"massa";s:1:"1";}'),
(12, 'misc', 0xd0a1d18bd0b2d0bed180d0bed182d0bad0b020d0b7d0b4d0bed180d0bed0b2d18cd18f, 0xd0a1d18bd0b2d0bed180d0bed182d0bad0b02c20d0b4d0bed0b1d0b0d0b2d0bbd18fd18ed189d0b0d18f203120d0ba20d0bcd0b0d0bad181d0b8d0bcd0b0d0bbd18cd0bdd0bed0bcd18320d0b7d0b4d0bed180d0bed0b2d18cd18e21, 'a:3:{s:6:"on_use";s:39:"$temp[maxhp]=1;add_user($player,$temp);";s:4:"cena";s:5:"10000";s:5:"massa";s:1:"1";}'),
(13, 'medicament', 0xd0a1d0b0d0bcd0bed0bad180d183d182d0bad0b0, 0xd0a1d183d13fd0b5d0bdd0b0d18f20d182d180d0b0d0b2d0b02c20d0b7d0b0d0b2d0b5d180d0bdd183d182d0b0d18f20d0b220d0bad183d181d0bed187d0b5d0ba20d0b1d183d0bcd0b0d0b3d0b8, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"effect";s:5:"value";s:6:"anasha";s:4:"cena";s:1:"5";s:5:"massa";s:1:"1";}'),
(14, 'misc', 0xd0a7d183d0b4d0be2dd182d180d0b0d0b2d0b0, 0xd0a7d183d0b4d0be2dd182d180d0b0d0b2d0b020d180d0b0d181d182d0b5d18220d0bdd0b5d0bfd0bed0bdd18fd182d0bdd18bd0bc20d0bed0b1d180d0b0d0b7d0bed0bc20d0bdd0b020d181d0b2d0b0d0bbd0bad0b0d18520d0b820d0bfd0bed0bcd0bed0b9d0bad0b0d1852c20d0bfd180d0b0d0bad182d0b8d187d0b5d181d0bad0b820d0b1d0b5d0b720d181d0b2d0b5d182d0b02e20d0a1d0bed0b2d0b5d180d13fd0b5d0bdd0bdd0be20d0bdd0b520d0bfd0bed0bdd18fd182d0bdd0bed0b520d180d0b0d181d182d0b5d0bdd0b8d0b5, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:2:"10";s:5:"massa";s:1:"1";}'),
(15, 'medicament', 0xd09fd0b8d0b2d0be, 0xd09fd0b8d0b2d0be20d0bed0bdd0be20d0b820d0b220d090d184d180d0b8d0bad0b520d0bfd0b8d0b2d0be2e20d09820d0b4d0be20d0bad0bed0bdd186d0b020d181d0b2d0b5d182d0b020d0bed181d182d0b0d0bdd0b5d182d181d18f20d0bfd0b8d0b2d0bed0bc2c20d0b820d0bfd0bed181d0bbd0b520d0bdd0b5d0b3d0be, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:3:"rad";s:5:"value";s:3:"100";s:4:"cena";s:2:"30";s:5:"massa";s:1:"3";}'),
(16, 'medicament', 0xd0a1d0bbd0b5d0b7d0b020d0bcd0bbd0b0d0b4d0b5d0bdd186d0b0, 0xd0a1d0bbd0b5d0b7d0b020d0bcd0bbd0b0d0b4d0b5d0bdd186d0b02e20d09ad0b0d0bad0bed0b520d0bad180d0b0d181d0b8d0b2d0bed0b520d0bdd0b0d0b7d0b2d0b0d0bdd0b8d0b5202d20d0bdd0b020d0b4d0b5d0bbd0b520d0b6d0b52c20d0bed0b1d18bd187d0bdd18bd0b920d181d0b0d0bcd0bed0b3d0bed0bd2120d093d0bbd0b0d0b2d0bdd0bed0b520d0bdd0b520d0b7d0bbd0bed183d0bfd0bed182d180d0b5d0b1d0bbd18fd182d18c2e, 'a:5:{s:4:"type";s:7:"procent";s:5:"param";s:3:"rad";s:5:"value";s:2:"10";s:4:"cena";s:2:"50";s:5:"massa";s:1:"3";}'),
(17, 'medicament', 0xd09dd0b0d181d182d0bed0b9d0bad0b020d0b8d0b720d187d183d0b4d0be20d182d180d0b0d0b2d18b, 0xd09dd0b0d181d182d0bed0b9d0bad0b020d0b8d0b720d187d183d0b4d0be20d182d180d0b0d0b2d18b20d0bdd0b020d181d0bfd0b8d180d182d0bed0b2d0bed0b920d0bed181d0bdd0bed0b2d0b52e20d03fd0bdd182d0b5d180d0b5d181d0bdd0be2c20d0bed182d0bad183d0b4d0b020d0b1d0b5d180d0b5d182d181d18f20d181d0bfd0b8d180d1822e20d09dd0b520d0b2d0b0d0b6d0bdd0be2e20d092d18bd0bfd0b8d0bb202d20d0b820d183d0b2d0b8d0b4d0b5d0bb20d187d183d0b4d0be21, 'a:5:{s:4:"type";N;s:5:"param";s:6:"effect";s:5:"value";s:6:"anasha";s:4:"cena";s:2:"25";s:5:"massa";s:1:"2";}'),
(18, 'medicament', 0xd09fd180d0bed182d0b5d0b8d0bdd0bed0b2d18bd0b920d0bad0bed0bad182d0b5d0b9d0bb, 0xd09fd18ed180d0b520d0b8d0b720d184d0b0d180d188d0b020d0bfd0bed0bcd0bed0b9d0bdd18bd18520d187d0b5d180d0b2d0b5d0b92c20d181d0bcd0b5d188d0b0d0bdd0bdd0bed0b520d181d0be20d181d0bfd0b8d180d182d0bed0bc2e20d09820d0b2d18b20d0b1d183d0b4d0b5d182d0b520d18dd182d0be20d0bfd0b8d182d18c3f3f3f, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"hungry";s:5:"value";s:3:"250";s:4:"cena";s:2:"15";s:5:"massa";s:1:"2";}'),
(19, 'misc', 0xd09cd183d181d0bed180, 0xd09ad183d187d0bad0b020d0bad0b0d0bad0bed0b3d0be2dd182d0be20d0bdd0b5d0bfd0bed0bdd18fd182d0bdd0bed0b3d0be20d185d0bbd0b0d0bcd0b03a20d0bed0b1d180d18bd0b2d0bad0b820d0b3d0b0d0b7d0b5d1822c20d0b2d0b8d0bdd182d0b8d0bad0b82c20d0bfd180d183d0b6d0b8d0bdd0bad0b820d0b820d0b5d189d0b520d187d182d0be2dd182d0be2e, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:2:"10";s:5:"massa";s:1:"5";}'),
(20, 'weapon', 0xd182d180d183d0b1d0b0, 0xd09ad183d181d0bed0ba20d182d180d183d0b1d18b2c20d0bfd0bed0bbd18bd0b920d0b2d0bdd183d182d180d0b8, 'a:14:{s:9:"req_level";s:0:"";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"3";s:6:"maxdmg";s:1:"5";s:7:"odbonus";s:1:"0";s:9:"critbonus";s:2:"-3";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:1:"5";s:5:"massa";s:1:"5";}'),
(21, 'bodyarm', 0xd09ad183d180d182d0bed187d0bad0b0, 0xd098d0b720d0bad183d181d0bed187d0bad0bed0b220d182d180d18fd0bfd0bed0ba2c20d0b7d0b0d0bbd0b0d182d0b0d0bdd0bdd0b0d18f20d0b820d0b1d0b5d0b720d0b4d18bd180d0bed0ba202d20d0b1d0bed0bbd0b5d0b520d0bcd0b5d0bdd0b5d0b520d0bfd180d0b8d0bbd0b8d187d0bdd0b0d18f20d0bed0b4d0b5d0b6d0b4d0b021, 'a:10:{s:9:"req_level";s:1:"0";s:9:"resnormal";s:1:"8";s:9:"resplazma";s:1:"0";s:7:"resboom";s:1:"0";s:7:"resvolt";s:1:"0";s:9:"respoison";s:1:"5";s:6:"resrad";s:1:"5";s:8:"bonusdex";s:1:"0";s:4:"cena";s:2:"10";s:5:"massa";s:1:"3";}'),
(22, 'medicament', 0xd09cd18fd181d0be, 0xd09ad183d181d0bed0ba20d181d18bd180d0bed0b3d0be20d0bcd18fd181d0b02e20d098d0b720d0bdd0b5d0b3d0be20d0bed0b1d18bd187d0bdd0be20d0b4d0b5d0bbd0b0d18e20d0b2d0bad183d181d0bdd18bd0b520d0b1d0bbd18ed0b4d0b02e20d09020d182d0b0d0ba20d0b5d181d182d18c2e2e2e20d092d0be20d0bfd0b5d180d0b2d18bd18520d0bdd0b520d0bad183d0bbd18cd182d183d180d0bdd0be2c20d0b2d0be20d0b2d182d0bed180d18bd18520d0bdd0b520d0b2d0bad183d181d0bdd0be2e20d0a5d0bed182d18f20d0b5d181d0bbd0b820d0bed187d0b5d0bdd18c20d0bdd0b0d0b4d0be2e2e2e, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"hungry";s:5:"value";s:2:"50";s:4:"cena";s:2:"10";s:5:"massa";s:1:"2";}'),
(23, 'medicament', 0xd096d0b0d180d0b5d0bdd0bdd0bed0b520d0bcd18fd181d0be, 0xd09fd0bed0b4d0b6d0b0d180d0b5d0bdd0bdd0bed0b52c20d185d180d183d181d182d18fd189d0b5d0b52c20d0b0d180d0bed0bcd0b0d182d0bdd0bed0b52e2e2e20d09ed0b1d18ad0b5d0b4d0b5d0bdd0b8d0b5, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"hungry";s:5:"value";s:3:"450";s:4:"cena";s:2:"35";s:5:"massa";s:1:"2";}'),
(24, 'misc', 0xd09ad0bed181d182d18c, 0xd09ad0bed0b3d0be2dd182d0be20d18fd0b2d0bdd0be20d181d18ad0b5d0bbd0b821, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:2:"10";s:5:"massa";s:1:"2";}'),
(25, 'bodyarm', 0xd09ad183d180d182d0bad0b02c20d0bed0b1d188d0b8d182d0b0d18f20d0bad0bed181d182d18fd0bcd0b8, 0xd09ad182d0be2dd182d0be20d0bfd180d0b8d188d0b8d0bb20d0ba20d0bad183d180d182d0bad0b520d0bad0bed181d182d0b82c20d182d0b5d0bc20d181d0b0d0bcd18bd0bc20d183d0bad180d0b5d0bfd0b8d0b220d0b5d0b5, 'a:10:{s:9:"req_level";s:1:"3";s:9:"resnormal";s:2:"12";s:9:"resplazma";s:1:"0";s:7:"resboom";s:1:"0";s:7:"resvolt";s:1:"0";s:9:"respoison";s:1:"5";s:6:"resrad";s:1:"5";s:8:"bonusdex";s:1:"0";s:4:"cena";s:2:"50";s:5:"massa";s:1:"3";}'),
(26, 'bodyarm', 0xd09ad0bed0b6d0b0d0bdd0bdd0b0d18f20d0bad183d180d182d0bad0b0, 0xd09ad183d180d182d0bad0b02c20d181d0b4d0b5d0bbd0b0d0bdd0bdd0b0d18f20d0b8d0b720d0b3d180d183d0b1d0bed0b920d0bad0bed0b6d0b8, 'a:11:{s:9:"req_level";s:1:"4";s:9:"resnormal";s:2:"10";s:9:"resplazma";s:1:"0";s:7:"resboom";s:1:"0";s:7:"resvolt";s:1:"0";s:9:"respoison";s:1:"0";s:6:"resrad";s:1:"0";s:8:"bonusdex";s:1:"0";s:2:"kb";s:0:"";s:4:"cena";s:4:"1000";s:5:"massa";s:1:"1";}'),
(27, 'misc', 0xd0a3d185d0be20d0b1d0bed0bcd0b6d0b0, 0xd0a3d185d0be20d0b1d0bed0bcd0b6d0b02c20d0bdd0b5d0bed181d0bcd0bed182d180d0b8d182d0b5d0bbd18cd0bdd0be20d0b7d0b0d0bbd0b5d0b7d188d0b5d0b3d0be20d0bdd0b520d182d183d0b4d0b0, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:1:"5";s:5:"massa";s:1:"1";}'),
(28, 'weapon', 0xd0a2d180d0b5d18520d181d182d0b2d0bed0bbd0bad0b0, 0xd0a2d0bed0bbd18cd0bad0be20d0bdd0b5d0bed0b1d180d0b0d0b7d0bed0b2d0b0d0bdd0bdd18bd0b920d0b1d0bed0bcd0b620d0bcd0bed0b320d181d0b4d0b5d0bbd0b0d182d18c20d182d0b0d0bad0bed0b520d187d183d0b4d0be202d20d182d180d0b5d185d181d182d0b2d0bed0bbd18cd0bdd18bd0b920d181d0b0d0bcd0bed0bfd0b0d0bb21, 'a:14:{s:9:"req_level";s:1:"3";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:1:"3";s:9:"arrayfire";s:1:"3";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"10";s:6:"maxdmg";s:2:"12";s:7:"odbonus";s:1:"0";s:9:"critbonus";s:1:"5";s:11:"sniperbonus";s:1:"5";s:5:"crash";s:2:"10";s:4:"cena";s:3:"150";s:5:"massa";s:1:"5";}'),
(29, 'weapon', 0xd0a0d0b5d0b2d0bed0bbd18cd0b2d0b5d180, 0x3620d0b7d0b0d180d18fd0b4d0bdd18bd0b920d0b1d0b0d180d0b0d0b1d0b0d0bdd0bdd18bd0b920d180d0b5d0b2d0bed0bbd18cd0b2d0b5d1802e20d094d0bed0bbd0b3d0bed0b2d0b5d187d0bdd0bed0b520d0b820d0bdd0b0d0b4d0b5d0b6d0bdd0bed0b520d0bed180d183d0b6d0b8d0b5, 'a:14:{s:9:"req_level";s:1:"5";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:1:"6";s:9:"arrayfire";s:1:"0";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"10";s:6:"maxdmg";s:2:"15";s:7:"odbonus";s:0:"";s:9:"critbonus";s:1:"5";s:11:"sniperbonus";s:1:"5";s:5:"crash";s:1:"2";s:4:"cena";s:4:"1200";s:5:"massa";s:1:"4";}'),
(30, 'medicament', 0xd09ad183d0bad183d180d183d0b7d0b0, 0xd094d0b8d0bad0bed180d0b0d182d0b8d0b2d0bdd0b0d18f20d0bad180d0b0d181d0bdd0b0d18f20d0bad183d0bad183d180d183d0b7d0b02e20d098d0bdd182d0b5d180d0b5d181d0bdd0be2c20d0bfd0bed187d0b5d0bcd18320d0bed0bdd0b020d0bad180d0b0d181d0bdd0b0d18f3f, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"hungry";s:5:"value";s:2:"50";s:4:"cena";s:2:"15";s:5:"massa";s:1:"1";}'),
(31, 'weapon', 0xd0a3d0bbd183d187d188d0b5d0bdd0bdd18bd0b920d180d0b5d0b2d0bed0bbd18cd0b2d0b5d180, 0xd09ad182d0be2dd182d0be20d183d0b4d0bbd0b8d0bdd0b8d0bb20d0b4d183d0bbd0be20d18320d180d0b5d0b2d0bed0bbd18cd0b2d0b5d180d0b02e20d0add182d0be20d0bfd0bed0b7d0b2d0bed0bbd0b8d0bbd0be20d0b4d0bed181d182d0b8d187d18c20d0b1d0bed0bbd18cd188d0b5d0b3d0be20d183d180d0bed0bdd0b020d0bed180d183d0b6d0b8d18f2e, 'a:14:{s:9:"req_level";s:1:"5";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:1:"6";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"12";s:6:"maxdmg";s:2:"18";s:7:"odbonus";s:1:"0";s:9:"critbonus";s:1:"0";s:11:"sniperbonus";s:1:"5";s:5:"crash";s:1:"5";s:4:"cena";s:3:"500";s:5:"massa";s:1:"5";}'),
(32, 'medicament', 0xd0a1d0b0d0bcd0bed0bad180d183d182d0bad0b0d182d0b5d181d182, 0xd0a2d0b5d181d182, 'a:5:{s:4:"type";s:5:"const";s:5:"param";s:6:"effect";s:5:"value";s:7:"anasha2";s:4:"cena";s:1:"1";s:5:"massa";s:1:"1";}'),
(33, 'patron', 0xd0a3d0bbd183d187d188d0b5d0bdd0bdd18bd0b920d0bfd0b0d182d180d0bed0bd203130d0bcd0bc, 0xd09fd0b0d182d180d0bed0bd20313020d0bcd0bc20d181d0bed0b1d180d0b0d0bdd0bdd18bd0b920d0bdd0b020d0bed181d0bdd0bed0b2d0b520d0b1d0bed0bbd0b5d0b520d0bbd183d187d188d0b5d0b3d0be20d0bfd0bed180d0bed185d0b0, 'a:4:{s:6:"calibr";s:4:"10mm";s:6:"moddmg";s:1:"0";s:4:"cena";s:1:"2";s:5:"massa";s:1:"0";}'),
(34, 'misc', 0xd09dd0b0d0b2d0bed0b7, 0xd09ad0b0d0bb20d0b6d0b8d0b2d0bed182d0bdd18bd1852e20d09fd0b0d187d0bad0b0d0b5d182d181d18f20d0b820d0bfd0bbd0bed185d0be20d0bfd0b0d185d0bdd0b5d1822e20d097d0b0d187d0b5d0bc20d0b5d0b3d0be20d0b1d180d0b0d182d18c20d0b820d182d0b0d181d0bad0b0d182d18c20d18120d181d0bed0b1d0bed0b93f, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:1:"1";s:5:"massa";s:1:"1";}'),
(35, 'misc', 0xd0a3d0b3d0bed0bbd18c, 0xd09ed0b1d0bed0b6d0b5d0bdd0bdd18bd0b920d0bad183d181d0bed0ba20d0b4d0b5d180d0b5d0b2d0b0, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:1:"5";s:5:"massa";s:1:"5";}'),
(36, 'misc', 0xd090d0bcd0b8d0b0d187d0bdd0b0d18f20d181d0b5d0bbd0b8d182d180d0b0, 0xd0a1d0b5d0bbd0b8d182d180d0b02e20d098d181d0bfd0bed0bbd18cd0b7d183d0b5d182d181d18f20d0bfd180d0b820d0b8d0b7d0b3d0bed182d0bed0b2d0bbd0b5d0bdd0b8d0b820d0bfd0bed180d0bed185d0b0, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:2:"15";s:5:"massa";s:1:"1";}'),
(37, 'misc', 0xd09fd0bed180d0bed185, 0xd09ed181d0bdd0bed0b2d0b020d0b4d0bbd18f20d0bfd0b0d182d180d0bed0bdd0bed0b220d0b820d0b2d0b7d180d18bd0b2d187d0b0d182d18bd18520d0b2d0b5d189d0b5d181d182d0b2, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:2:"50";s:5:"massa";s:1:"1";}'),
(38, 'misc', 0xd093d0b8d0bbd18cd0b7d0b0, 0xd093d0b8d0bbd18cd0b7d0b020d0bed18220d0bfd0b0d182d180d0bed0bdd0b02e, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:1:"0";s:5:"massa";s:1:"1";}'),
(39, 'misc', 0xd0a1d0b5d180d0b0, 0xd0a1d0b5d180d0b0202d20d0b4d183d180d0bdd0bed0bfd0b0d185d0bdd183d189d0b5d0b520d0b2d0b5d189d0b5d181d182d0b2d0be20d0b6d0b5d0bbd182d0bed0b3d0be20d186d0b2d0b5d182d0b02e20d09fd180d0b8d0bcd0b5d0bdd18fd0b5d182d181d18f20d0bfd180d0b820d0b8d0b7d0b3d0bed182d0bed0b2d0bbd0b5d0bdd0b8d0b820d0bfd0bed180d0bed185d0b0, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:2:"10";s:5:"massa";s:1:"3";}'),
(40, 'misc', 0xd0a2d180d0b0d0b2d0bcd0bed0bfd0b0d0ba, 0xd098d181d0bfd180d0b0d0b2d0bbd18fd0b5d18220d0bed0b4d0bdd0be20d183d0b2d0b5d187d18cd0b52e20d09dd0b5d0b7d0b0d0bcd0b5d0bdd0b8d0bcd18bd0b920d0bfd0bed0bcd0bed189d0bdd0b8d0ba20d0bfd183d182d0bdd0b8d0bad0b0, 'a:3:{s:6:"on_use";s:168:"if (!is_array($trauma)){$trauma=unserialize($player[trauma]);} foreach($trauma as $key=>$value){if ($value==on){$temp[trauma][$key]=off;break;}}add_user($player,$temp);";s:4:"cena";s:3:"500";s:5:"massa";s:1:"1";}'),
(41, 'misc', 0xd0a3d0bad180d0b5d0bfd0bbd18fd18ed189d0b8d0b920d181d0bed181d182d0b0d0b2, 0xd0add182d0bed18220d181d0bed181d182d0b0d0b220d0bcd0bed0b6d0b5d18220d183d0bad180d0b5d0bfd0b8d182d18c20d0b8d0b7d0b4d0b5d0bbd0b8d18f20d0b8d0b720d0bad0bed0b6d18b2e, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:2:"50";s:5:"massa";s:1:"5";}'),
(42, 'bodyarm', 0xd0a3d0bad180d0b5d0bfd0bbd0b5d0bdd0bdd0b0d18f20d0bad0bed0b6d0b0d0bdd0bdd0b0d18f20d0bad183d180d182d0bad0b0, 0xd0a1d0bcd0b0d0b7d0b0d0bdd0bdd0b0d18f20d0bed181d0bed0b1d18bd0bc20d181d0bed181d182d0b0d0b2d0bed0bc2c20d0bad0bed0b6d0b0d0bdd0bdd0b0d18f20d0bad183d180d182d0bad0b020d181d182d0b0d0bbd0b020d0b1d0bed0bbd0b5d0b520d0bad180d0b5d0bfd0bad0bed0b92e, 'a:11:{s:9:"req_level";s:1:"6";s:9:"resnormal";s:2:"15";s:9:"resplazma";s:0:"";s:7:"resboom";s:0:"";s:7:"resvolt";s:0:"";s:9:"respoison";s:1:"7";s:6:"resrad";s:1:"7";s:8:"bonusdex";s:2:"10";s:2:"kb";s:1:"5";s:4:"cena";s:3:"700";s:5:"massa";s:2:"10";}'),
(43, 'weapon', 0xd09fd0b8d181d182d0bed0bbd0b5d182203130d0bcd0bc, 0xd09fd0b0d182d180d0bed0bdd18b20d0bad0b0d0bbd0b8d0b1d180d0b0203130d0bcd0bc20d0bfd180d0b820d0b4d0bed0bbd0b6d0bdd0bed0bc20d181d182d0b5d187d0b5d0bdd0b8d0b820d0bed0b1d181d182d0bed18fd182d0b5d0bbd18cd181d182d0b220d181d0bcd0bed0b3d183d18220d0bdd0b0d0bdd0b5d181d182d0b820d0bdd0b5d0bfd0bbd0bed185d0bed0b920d183d180d0bed0bd2c20d0b220d182d0be20d0b2d180d0b5d0bcd18f20d0bad0b0d0ba20d181d0b0d0bc20d09ad0bed0bbd18cd18220d0bfd0be2dd0bfd180d0b5d0b6d0bdd0b5d0bcd18320d0bdd0b0d185d0bed0b4d0b8d182d181d18f20d0b220d0bfd180d0b5d0b2d0bed181d185d0bed0b4d0bdd0bed0bc20d181d0bed181d182d0bed18fd0bdd0b8d0b82c20d187d182d0be20d0b3d0bed0b2d0bed180d0b8d18220d0be20d0b2d18bd181d0bed0bad0bed0bc20d0bad0b0d187d0b5d181d182d0b2d0b520d0b8d0b7d0b3d0bed182d0bed0b2d0bbd0b5d0bdd0b8d18f2e20d09dd0b5d0b4d0bed181d182d0b0d182d0bad0bed0bc20d18fd0b2d0bbd18fd0b5d182d181d18f20d0bbd0b8d188d18c20d182d0be2c20d187d182d0be20d0bfd0b8d181d182d0bed0bbd0b5d18220d0bdd0b520d181d182d180d0b5d0bbd18fd0b5d18220d0bed187d0b5d180d0b5d0b4d18fd0bcd0b8202d20d0bfd180d0b820d0bad0b0d0b6d0b4d0bed0bc20d0bdd0b0d0b6d0b0d182d0b8d0b820d0bdd0b020d0bad183d180d0bed0ba20d0b2d18b20d181d0bcd0bed0b6d0b5d182d0b520d0b2d18bd0bfd183d181d182d0b8d182d18c20d0b2d0be20d0b2d180d0b0d0b3d0b020d182d0bed0bbd18cd0bad0be20d0bed0b4d0bdd18320d0bfd183d0bbd18e2e20d0add182d0be20d181d0b0d0bcd0bed0b7d0b0d180d18fd0b6d0b0d18ed189d0b5d0b5d181d18f20d0bed180d183d0b6d0b8d0b52e20d098d0b720d0bcd0bed0b4d0b5d0bbd0b8203635323020d0bcd0bed0b6d0bdd0be20d0b2d0b5d181d182d0b820d0bed0b3d0bed0bdd18c20d0bad0b0d0ba20d0bed0b1d18bd187d0bdd18bd0bcd0b820d0bfd183d0bbd18fd0bcd0b820d0bad0b0d0bbd0b8d0b1d180d0b0203130d0bcd0bc20d0b4d0bbd18f20d0bed182d181d182d180d0b5d0bbd0b020d0bad180d18bd18120d0b820d0bfd180d0bed187d0b5d0b920d0bfd0bed0b4d0bed0b1d0bdd0bed0b920d0b6d0b8d0b2d0bdd0bed181d182d0b82c20d182d0b0d0ba20d0b820d0b1d180d0bed0bdd0b5d0bfd180d0bed0b1d0b8d0b2d0bdd18bd0bcd0b820d0b1d0bed0b5d0bfd180d0b8d0bfd0b0d181d0b0d0bcd0b820d0b4d0bbd18f20d0b2d0b5d0b4d0b5d0bdd0b8d18f20d181d182d180d0b5d0bbd18cd0b1d18b20d0bfd0be20d0b1d0bed0bbd0b5d0b520d0b7d0bdd0b0d187d0b8d182d0b5d0bbd18cd0bdd18bd0bc20d186d0b5d0bbd18fd0bc2e, 'a:14:{s:9:"req_level";s:1:"5";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:2:"10";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"13";s:6:"maxdmg";s:2:"16";s:7:"odbonus";s:0:"";s:9:"critbonus";s:1:"5";s:11:"sniperbonus";s:2:"10";s:5:"crash";s:1:"5";s:4:"cena";s:4:"1500";s:5:"massa";s:1:"8";}'),
(44, 'weapon', 0xd09ed185d0bed182d0bdd0b8d187d18cd0b520d180d183d0b6d18cd0b5, 0xd09fd0bed0bbd183d0b0d0b2d182d0bed0bcd0b0d182d0b8d187d0b5d181d0bad0bed0b520d0bed185d0bed182d0bdd0b8d187d18cd0b520d180d183d0b6d18cd1912c20d181d182d180d0b5d0bbd18fd0b5d18220d0b4d0b0d0bbd0b5d0bad0be2c20d182d0bed187d0bdd0be20d0b820d181d0b5d180d0b4d0b8d182d0be2e, 'a:14:{s:9:"req_level";s:1:"4";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:1:"5";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"15";s:6:"maxdmg";s:2:"18";s:7:"odbonus";s:0:"";s:9:"critbonus";s:1:"5";s:11:"sniperbonus";s:1:"5";s:5:"crash";s:1:"5";s:4:"cena";s:4:"1700";s:5:"massa";s:2:"15";}'),
(45, 'weapon', 0xd09fd0b8d181d182d0bed0bbd0b5d1822dd0a1d0bad0bed180d0bed181d182d180d0b5d0bb, 0xd091d0bbd0b0d0b3d0bed0b4d0b0d180d18f20d183d181d0bed0b2d0b5d180d188d0b5d0bdd181d182d0b2d0bed0b2d0b0d0bdd0b8d18e20d0bad0bed0bdd181d182d180d183d0bad186d0b8d0b82c20d181d0bad0bed180d0bed181d182d18c20d0b2d18bd181d182d180d0b5d0bbd0b020d183d0bcd0b5d0bdd18cd188d0b8d0bbd0b0d181d18c2c20d0bed0b4d0bdd0b0d0bad0be20d183d0bcd0b5d0bdd18cd188d0b8d0bbd181d18f20d0b820d183d180d0bed0bd2e, 'a:14:{s:9:"req_level";s:1:"7";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:2:"10";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"10";s:6:"maxdmg";s:2:"12";s:7:"odbonus";s:2:"-1";s:9:"critbonus";s:1:"0";s:11:"sniperbonus";s:1:"0";s:5:"crash";s:1:"0";s:4:"cena";s:4:"1600";s:5:"massa";s:1:"4";}'),
(46, 'weapon', 0xd09fd0b8d181d182d0bed0bbd0b5d1822dd0bfd183d0bbd0b5d0bcd0b5d182, 0xd0b8d181d182d0bed0bbd0b5d1822dd0bfd183d0bbd0b5d0bcd191d18220d09c5039202d20d0bed0b4d0bdd0be20d0b8d0b720d0bbd183d187d188d0b8d18520d0bed0b3d0bdd0b5d181d182d180d0b5d0bbd18cd0bdd18bd18520d0bed180d183d0b6d0b8d0b920d0b220d0bcd0b8d180d0b52e20d0add182d0bed18220d181d180d0b5d0b4d0bdd0b5d0b3d0be20d180d0b0d0b7d0bcd0b5d180d0b020d09fd09f20d181d0bfd0bed181d0bed0b1d0b5d0bd20d181d182d180d0b5d0bbd18fd182d18c20d0bed0b4d0b8d0bdd0bed187d0bdd18bd0bcd0b820d0b2d18bd181d182d180d0b5d0bbd0b0d0bcd0b820d0b820d0bed187d0b5d180d0b5d0b4d18fd0bcd0b82028d0b2d0bed18220d0bed0bd20d0bdd0b5d0b4d0bed181d182d0b0d182d0bed0ba20d0bed0b1d18bd187d0bdd0bed0b3d0be20d0bfd0b8d181d182d0bed0bbd0b5d182d0b0292c20d0bad0bed182d0bed180d18bd0b520d0bfd180d0b820d181d182d0b0d0bdd0b4d0b0d180d182d0bdd0bed0bc20d180d0b0d181d0bad0bbd0b0d0b4d0b520d0b3d0b0d180d0b0d0bdd182d0b8d180d183d18ed18220d18dd184d184d0b5d0bad182d0bdd0bed0b520d0b7d180d0b5d0bbd0b8d189d0b520d0b4d0bbd18f20d0b0d182d0b0d0bad183d18ed189d0b5d0b3d0be2e20d09c503920d0bbd191d0b3d0bed0ba20d0b220d0bed0b1d180d0b0d189d0b5d0bdd0b8d0b820d0b820d181d0b5d0b5d18220d181d0bcd0b5d180d182d18c203130d0bcd0bc20d0bfd183d0bbd18fd0bcd0b820d0bbd183d187d188d0b520d0bbd18ed0b1d0bed0b3d0be20d0bed180d183d0b6d0b8d18f20d181d0b2d0bed0b5d0b3d0be20d0bad0bbd0b0d181d181d0b02e, 'a:14:{s:9:"req_level";s:2:"10";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:2:"20";s:9:"arrayfire";s:1:"4";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"12";s:6:"maxdmg";s:2:"15";s:7:"odbonus";s:0:"";s:9:"critbonus";s:1:"7";s:11:"sniperbonus";s:2:"10";s:5:"crash";s:1:"5";s:4:"cena";s:4:"2000";s:5:"massa";s:2:"10";}'),
(47, 'weapon', 0xd090d180d0bcd0b5d0b9d181d0bad0b8d0b920d0b0d0b2d182d0bed0bcd0b0d182, 0xd0a1d182d0b0d180d18bd0b920d0b0d180d0bcd0b5d0b9d181d0bad0b8d0b920d0b0d0b2d182d0bed0bcd0b0d18220d090d09a2d3134372c20d0bfd0b5d180d0b5d0b4d0b5d0bbd0b0d0bdd0bdd18bd0b920d0bfd0bed0b420d181d182d180d0b5d0bbd18cd0b1d18320d0bfd0b0d182d180d0bed0bdd0b0d0bcd0b820d0bad0b0d0bbd0b8d0b1d180d0b0203130d0bcd0bc2e20d0a1d0b4d0b5d0bbd0b0d0bdd0b020d0b4d0b0d0b2d0bdd0be2c20d0bdd0b0d0b4d0b5d0b6d0bdd0be20d0b820d0bdd0b020d0b2d0b5d0bad0b021, 'a:14:{s:9:"req_level";s:2:"15";s:6:"calibr";s:4:"10mm";s:10:"maxpatrons";s:2:"30";s:9:"arrayfire";s:1:"5";s:9:"type_weap";s:4:"fire";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:2:"15";s:6:"maxdmg";s:2:"20";s:7:"odbonus";s:0:"";s:9:"critbonus";s:1:"9";s:11:"sniperbonus";s:2:"12";s:5:"crash";s:1:"2";s:4:"cena";s:4:"2700";s:5:"massa";s:2:"12";}'),
(48, 'weapon', 0xd09ed181d0bad0bed0bbd0bed187d0bdd0b0d18f20d0b3d180d0b0d0bdd0b0d182d0b0, 0xd09dd0b5d0b1d0bed0bbd18cd188d0bed0b520d0b2d0b7d180d18bd0b2d0b0d18ed189d0b5d0b5d181d18f20d183d181d182d180d0bed0b9d181d182d0b2d0be2c20d0bad0bed182d0bed180d0bed0b520d0bcd0b5d182d0b0d18ed18220d0b4d0bbd18f20d0bfd0bed0b4d180d18bd0b2d0b020d0b2d0b1d0bbd0b8d0b7d0b820d186d0b5d0bbd0b82e20d0add182d0b820d180d0b0d0b7d180d18bd0b2d0bdd18bd0b520d0b3d180d0b0d0bdd0b0d182d18b20d180d0b0d0b7d180d0b0d0b1d0bed182d0b0d0bdd18b20d182d0b0d0ba2c20d187d182d0bed0b1d18b20d0bfd180d0b820d0b2d0b7d180d18bd0b2d0b520d0bad0bed180d0bfd183d18120d0bbd0b5d0b3d0bad0be20d180d0b0d181d0bfd0b0d0bbd181d18f20d0bdd0b020d0bcd0bdd0bed0b6d0b5d181d182d0b2d0be20d0bcd0b5d0bbd0bad0b8d18520d0bcd0b5d182d0b0d0bbd0bbd0b8d187d0b5d181d0bad0b8d18520d0bed181d0bad0bed0bbd0bad0bed0b22c20d0bad0bed182d0bed180d18bd0b520d0b820d0bdd0b0d0bdd0bed181d18fd18220d0bfd0bed0b2d180d0b5d0b6d0b4d0b5d0bdd0b8d0b52e, 'a:14:{s:9:"req_level";s:1:"2";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"throw";s:8:"type_dmg";s:4:"boom";s:6:"mindmg";s:2:"10";s:6:"maxdmg";s:2:"15";s:7:"odbonus";s:2:"-1";s:9:"critbonus";s:2:"15";s:11:"sniperbonus";s:2:"-5";s:5:"crash";s:0:"";s:4:"cena";s:3:"120";s:5:"massa";s:1:"2";}'),
(49, 'weapon', 0xd09dd0bed0b6, 0xd09ed0b1d18bd187d0bdd18bd0b920d0bdd0bed0b620d0b4d0bbd18f20d180d0b5d0b7d0bad0b820d0bfd180d0b5d0b4d0bcd0b5d182d0bed0b22e20d098d0bbd0b820d0b6d0b8d0b2d0bed182d0bdd18bd1852e20d098d0bbd0b820d0bbd18ed0b4d0b5d0b92e0d0ad09220d0bed0b1d189d0b5d0bc2c20d0b2d0b0d0bc20d180d0b5d188d0b0d182d18c21, 'a:14:{s:9:"req_level";s:1:"2";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"3";s:6:"maxdmg";s:1:"6";s:7:"odbonus";s:2:"-1";s:9:"critbonus";s:0:"";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:3:"350";s:5:"massa";s:1:"5";}'),
(50, 'weapon', 0xd0a2d0b5d181d0b0d0ba20, 0xd0add182d0bed18220d0bad183d185d0bed0bdd0bdd18bd0b920d0bfd180d0b8d0b1d0bed18020d181d0bfd0b5d186d0b8d0b0d0bbd18cd0bdd0be20d181d0bfd180d0bed0b5d0bad182d0b8d180d0bed0b2d0b0d0bd20d182d0b0d0ba2c20d187d182d0bed0b1d18b20d0bed0b1d0bbd0b5d0b3d187d0b8d182d18c20d0bfd180d0bed186d0b5d181d18120d180d0b0d0b7d180d183d0b1d0b0d0bdd0b8d18f20d0bcd18fd181d0b020d0b6d0b8d0b2d18bd18520d0b8d0bbd0b820d0bcd0b5d180d182d0b2d18bd18520d181d183d189d0b5d181d182d0b22e20d095d0b3d0be20d0bbd0b5d0b7d0b2d0b8d0b520d0b8d0b720d0bdd0b5d180d0b6d0b0d0b2d0b5d18ed189d0b5d0b920d181d182d0b0d0bbd0b820d0bed181d182d0b0d191d182d181d18f20d0bed181d182d180d18bd0bc20d0bdd0b0d0b4d0bed0bbd0b3d0be20d0b820d180d0b5d0b6d0b5d18220d0bbd183d187d188d0b52c20d187d0b5d0bc20d0bed0b1d18bd187d0bdd18bd0b920d0bdd0bed0b62e, 'a:14:{s:9:"req_level";s:1:"1";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"5";s:6:"maxdmg";s:1:"8";s:7:"odbonus";s:0:"";s:9:"critbonus";s:0:"";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:3:"300";s:5:"massa";s:1:"7";}'),
(51, 'weapon', 0xd091d0bed0b5d0b2d0bed0b920d0bdd0bed0b6, 0xd09dd0bed0b62c20d0b0d180d0bcd0b5d0b9d181d0bad0bed0b3d0be20d0bed0b1d180d0b0d0b7d186d0b02c20d0bfd180d0b5d0b4d0bdd0b0d0b7d0bdd0b0d187d0b5d0bd20d0b4d0bbd18f20d0b1d0bed18f20d18120d0bfd180d0b8d0bcd0b5d0bdd0b5d0bdd0b8d0b5d0bc20d185d0bed0bbd0bed0b4d0bdd0bed0b3d0be20d0bed180d183d0b6d0b8d18f2e20d097d0b0d0b7d183d0b1d180d0b5d0bdd0bdd0bed0b520d0bbd0b5d0b7d0b2d0b8d0b520d181d0bad0bed180d0b5d0b520d180d0b2d191d1822c20d187d0b5d0bc20d180d0b5d0b6d0b5d1822c20d187d182d0be20d0b4d0b5d0bbd0b0d0b5d18220d180d0b0d0bdd0b5d0bdd0b8d18f20d0b3d0bed180d0b0d0b7d0b4d0be20d181d0b5d180d18cd0b5d0b7d0bdd0b5d0b52e200d0ad098d0b7d0b3d0bed182d0bed0b2d0bbd0b5d0bd20d0b8d0b720d0bad0b0d180d0b1d0bed0bdd0bed0b2d18bd18520d181d0bfd0bbd0b0d0b2d0bed0b22c20d187d182d0be20d183d0b2d0b5d0bbd0b8d187d0b8d0b2d0b0d0b5d18220d0bfd180d0bed187d0bdd0bed181d182d18c2c20d0b4d0bed0bbd0b3d0bed0b2d0b5d187d0bdd0bed181d182d18c20d0b820d183d0bcd0b5d0bdd18cd188d0b0d0b5d18220d0b2d0b5d1812e0d0a, 'a:14:{s:9:"req_level";s:1:"6";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"6";s:6:"maxdmg";s:1:"9";s:7:"odbonus";s:2:"-1";s:9:"critbonus";s:0:"";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:3:"750";s:5:"massa";s:1:"3";}'),
(52, 'weapon', 0xd09ad0bed0bad182d0b5d0b9d0bbd18c20d09cd0bed0bbd0bed182d0bed0b2d0b0, 0xd0a1d0b0d0bcd0b0d18f20d0bfd180d0bed181d182d0b0d18f20d0b3d180d0b0d0bdd0b0d182d0b02c20c2abd09ad0bed0bad182d0b5d0b9d0bbd18c20d09cd0bed0bbd0bed182d0bed0b2d0b0c2bb20e2809320d18dd182d0be20d0b1d183d182d18bd0bbd0bad0b020d18120d0b7d0b0d0b6d0b8d0b3d0b0d182d0b5d0bbd18cd0bdd0bed0b920d181d0bcd0b5d181d18cd18e20d0b820d0bfd180d0bed0bfd0b8d182d0b0d0bdd0bdd0bed0b920d0b1d0b5d0bdd0b7d0b8d0bdd0bed0bc20d182d180d18fd0bfd0bad0bed0b920d0b220d0bad0b0d187d0b5d181d182d0b2d0b520d0b7d0b0d0bfd0b0d0bbd0b02e0d0ad09bd0b5d0b3d0bad0be20d0bfd180d0b8d0b3d0bed182d0bed0b2d0b8d182d18c20d0bfd180d0b0d0bad182d0b8d187d0b5d181d0bad0b820d0b220d0bbd18ed0b1d18bd18520d183d181d0bbd0bed0b2d0b8d18fd1852c20d0bed180d183d0b6d0b8d0b520d180d0b5d0b2d0bed0bbd18ed186d0b8d0bed0bdd0b5d180d0bed0b22c20d180d0b5d186d0b8d0b4d0b8d0b2d0b8d181d182d0bed0b220d0b820d0bfd180d0bed187d0b8d18520d0bdd0b5d0b1d0bbd0b0d0b3d0bed0b6d0b5d0bbd0b0d182d0b5d0bbd18cd0bdd18bd18520d187d0bbd0b5d0bdd0bed0b220d0bed0b1d189d0b5d181d182d0b2d0b0, 'a:14:{s:9:"req_level";s:1:"1";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"throw";s:8:"type_dmg";s:4:"boom";s:6:"mindmg";s:1:"5";s:6:"maxdmg";s:2:"12";s:7:"odbonus";s:0:"";s:9:"critbonus";s:2:"15";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:2:"35";s:5:"massa";s:1:"4";}'),
(53, 'weapon', 0xd091d0b8d182d0b0, 0xd0add182d0b020d0b1d0b5d0b9d181d0b1d0bed0bbd18cd0bdd0b0d18f20d0b1d0b8d182d0b020d0b8d0b720d0bfd180d0bed187d0bdd0bed0b3d0be20d0b4d0b5d180d0b5d0b2d0b020d0bed182d0bed0b1d18cd191d18220d0bfd0bed0b4d0b0d0bbd18cd188d0b520d0bed18220d0b2d0b0d18120d0b2d181d19120d187d182d0be20d183d0b3d0bed0b4d0bdd0be2e20d09dd0b0d181d182d0bed18fd189d0b0d18f20d0bad0bbd0b0d181d181d0b8d0bad0b02e20, 'a:14:{s:9:"req_level";s:1:"1";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"4";s:6:"maxdmg";s:2:"10";s:7:"odbonus";s:1:"1";s:9:"critbonus";s:2:"10";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:3:"325";s:5:"massa";s:2:"15";}'),
(54, 'weapon', 0xd0a0d0b0d0b7d0b2d0bed0b4d0bdd0bed0b920d0bad0bbd18ed187, 0xd09fd0bed0b6d0b0d0bbd183d0b92c20d18dd182d0b020d188d182d183d0bad0b020d0b3d0bed180d0b0d0b7d0b4d0be20d0bfd0bed0bbd0b5d0b7d0bdd0b5d0b520d0bfd180d0b820d180d0b5d0bcd0bed0bdd182d0b520d187d0b5d0b3d0be2dd0bdd0b8d0b1d183d0b4d18c2c20d0b5d181d0bbd0b82c20d0bad0bed0bdd0b5d187d0bdd0be2c20d0b2d0b0d18120d0bdd0b520d0b7d0bed0b2d183d18220d0bfd0bed0bbd0bad0bed0b2d0bdd0b8d0ba20d0a32e20d091d0bbd18ed0b4d0bed187d0bdd18bd0b920d0b820d0b2d18b20d0bdd0b520d181d182d0bed0b8d182d0b520d0bfd0bed181d180d0b5d0b4d0b820d181d0bed0bbd0b4d0b0d182d181d0bad0bed0b920d181d182d0bed0bbd0bed0b2d0bed0b92e20d0a0d0b0d0b7d0b2d0bed0b4d0bdd18bd0b520d0bad0bbd18ed187d0b820d181d0b4d0b5d0bbd0b0d0bdd18b20d0b8d0b720d186d0b5d0bbd18cd0bdd0bed0b3d0be20d0bcd0b5d182d0b0d0bbd0bbd0b02c20d0b820d0b8d18520d187d0b0d181d182d0be20d0b8d181d0bfd0bed0bbd18cd0b7d183d18ed18220d0bad0b0d0ba20d0b4d183d0b1d0b8d0bdd0bad0b82e0d0a, 'a:14:{s:9:"req_level";s:1:"4";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"3";s:6:"maxdmg";s:1:"8";s:7:"odbonus";s:0:"";s:9:"critbonus";s:0:"";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:3:"125";s:5:"massa";s:2:"12";}'),
(55, 'weapon', 0xd09cd0bed0bdd182d0b8d180d0bed0b2d0bad0b0, 0xd092d0b5d181d18cd0bcd0b020d0b2d0bdd183d188d0b8d182d0b5d0bbd18cd0bdd18bd0b920d0bad183d181d0bed0ba20d0bcd0b5d182d0b0d0bbd0bbd0b02c20d0bfd180d0b5d0b4d0bdd0b0d0b7d0bdd0b0d187d0b5d0bdd0bdd18bd0b920d181d0bfd0b5d186d0b8d0b0d0bbd18cd0bdd0be20d0b4d0bbd18f20d180d0b0d0b1d0bed18220d18120d182d18fd0b6d191d0bbd18bd0bcd0b82c20d0bfd180d0bed187d0bdd18bd0bcd0b820d0bed0b1d18ad0b5d0bad182d0b0d0bcd0b8e280a620d0b8d0bbd0b820d0bfd180d0bed0bbd0b0d0bcd18bd0b2d0b0d0bdd0b8d18f20d0b3d0bed0bbd0bed0b22e20d09cd0bed0bdd182d0b8d180d0bed0b2d0bad0b020d0b7d0b0d0b3d0bdd183d182d0b020d0bdd0b020d0bad0bed0bdd186d0b52c20d187d182d0bed0b1d18b20d0b5d19120d0bcd0bed0b6d0bdd0be20d0b1d18bd0bbd0be20d0b8d181d0bfd0bed0bbd18cd0b7d0bed0b2d0b0d182d18c20d0bad0b0d0ba20d180d18bd187d0b0d0b32e20d09ed0b1d18bd187d0bdd0be20d0bed0bad0bed0bbd0be20333520d181d0bc20d0b220d0b4d0bbd0b8d0bdd1832e0d0a, 'a:14:{s:9:"req_level";s:1:"5";s:6:"calibr";s:0:"";s:10:"maxpatrons";s:0:"";s:9:"arrayfire";s:0:"";s:9:"type_weap";s:5:"melee";s:8:"type_dmg";s:6:"normal";s:6:"mindmg";s:1:"3";s:6:"maxdmg";s:1:"7";s:7:"odbonus";s:0:"";s:9:"critbonus";s:0:"";s:11:"sniperbonus";s:0:"";s:5:"crash";s:0:"";s:4:"cena";s:3:"375";s:5:"massa";s:2:"12";}'),
(56, 'misc', 0xd0a8d0bad183d180d0b020d18fd189d0b5d180d0b0, 0xd09ad180d0b5d0bfd0bad0b0d18f20d0bad0bed0b6d0b02c20d181d0bed0b4d180d0b0d0bdd0bdd0b0d18f20d181d0be20d181d0b2d0b5d0b6d0b5d0b920d182d183d188d0bad0b820d18fd189d0b5d180d0b0, 'a:3:{s:6:"on_use";s:0:"";s:4:"cena";s:3:"150";s:5:"massa";s:1:"5";}');
//=====================================//
CREATE TABLE IF NOT EXISTS `conclave_locations` (
  `loc_id` varchar(20) NOT NULL DEFAULT '',
  `zone` varchar(20) NOT NULL,
  `loc_option` text NOT NULL,
  `monstr_list` mediumblob,
  `door_list` blob NOT NULL,
  `obj_list` mediumblob,
  PRIMARY KEY (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.main', 'bartertown', 'a:6:{s:4:"name";s:29:"Главная площадь";s:4:"info";s:163:"Главная площадь станции Бартертаун. Здесь находятся торговцы, бары и прочие забегаловки.";s:5:"fight";s:2:"no";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 0x4e3b, 0x613a353a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d092d0b2d0b5d180d18520d0bfd0be20d182d183d0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657430223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a363a22d091d090d0a0223b733a363a22746172676574223b733a31343a22626172746572746f776e2e626172223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a383a22d091d090d09dd09a223b733a363a22746172676574223b733a383a2262616e6b6d61696e223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a32363a22d092d0bdd0b8d0b720d0bfd0be20d182d183d0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657431223b7d693a343b613a323a7b733a373a2263617074696f6e223b733a31383a22d0add181d0bad0b0d0bbd0b0d182d0bed180223b733a363a22746172676574223b733a31343a22626172746572746f776e2e65736b223b7d7d, 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),
('test', 'bartertown', 'a:6:{s:4:"name";s:31:"тестовая локация";s:4:"info";s:21:"Для теста!!!!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"25";s:5:"loc_y";s:3:"100";s:5:"light";s:4:"temp";}', 0x613a313a7b693a303b613a32373a7b733a323a226964223b733a333a22726174223b733a31343a22706572696f645f7265737061776e223b733a323a223330223b733a373a227265737061776e223b693a313233323938303039343b733a343a226e616d65223b733a31303a22d0bad180d18bd181d0b0223b733a343a22696e666f223b733a34303a22d097d0bbd0bed0b520d0b2d0bed0bdd18ed187d0b5d0b520d0b6d0b8d0b2d0bed182d0bdd0bed0b5223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223230223b733a353a226d61786870223b733a323a223230223b733a323a226f64223b733a313a2233223b733a353a226d61786f64223b733a313a2233223b733a31313a22637269745f6368616e6365223b733a313a2230223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2234223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2230223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2230223b733a393a22726573706c617a6d61223b733a313a2230223b733a373a22726573626f6f6d223b733a313a2230223b733a373a22726573766f6c74223b733a313a2230223b733a383a22696e5f6669676874223b733a303a22223b733a393a22656e7465725f6c6f63223b733a303a22223b733a363a226f6e5f646965223b733a33343a226c6f6f742824706c617965725b6c6f635f69645d2c382c312c38302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b733a313a2278223b693a31323b733a313a2279223b693a31393b7d7d, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d183d0bbd0b8d186d183223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657431223b7d7d, 0x613a343a7b693a303b613a383a7b733a343a226e616d65223b733a333a22626f78223b733a343a22696e666f223b733a303a22223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a35303a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28312c312c246f626a5f6c6973745b24695d2c35293b223b733a333a22626167223b613a313a7b693a303b613a31313a7b693a303b733a313a2231223b733a323a226964223b733a313a2231223b693a313b733a373a22626f647961726d223b733a343a2274797065223b733a373a22626f647961726d223b693a323b733a31323a22d0a0d0b2d0b0d0bdd18cd191223b733a343a226e616d65223b733a31323a22d0a0d0b2d0b0d0bdd18cd191223b693a333b733a38383a22d0a0d0b2d0b0d0bdd18bd0b520d0bed0b1d0bdd0bed181d0bad0b82c20d18fd0b2d0bdd0be20d0bdd0b0d0b9d0b4d0b5d0bdd0bdd18bd0b520d0b3d0b4d0b520d182d0be20d0bdd0b020d0bfd0bed0bcd0bed0b9d0bad0b5223b733a343a22696e666f223b733a38383a22d0a0d0b2d0b0d0bdd18bd0b520d0bed0b1d0bdd0bed181d0bad0b82c20d18fd0b2d0bdd0be20d0bdd0b0d0b9d0b4d0b5d0bdd0bdd18bd0b520d0b3d0b4d0b520d182d0be20d0bdd0b020d0bfd0bed0bcd0bed0b9d0bad0b5223b693a343b733a3230373a22613a393a7b733a393a227265715f6c6576656c223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2230223b733a373a22726573626f6f6d223b733a313a2230223b733a373a22726573766f6c74223b733a313a2230223b733a393a22726573706f69736f6e223b733a313a2230223b733a363a22726573726164223b733a313a2230223b733a343a2263656e61223b733a313a2233223b733a353a226d61737361223b733a323a223130223b7d223b733a31303a2261626f75745f6974656d223b613a393a7b733a393a227265715f6c6576656c223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2230223b733a373a22726573626f6f6d223b733a313a2230223b733a373a22726573766f6c74223b733a313a2230223b733a393a22726573706f69736f6e223b733a313a2230223b733a363a22726573726164223b733a313a2230223b733a343a2263656e61223b733a313a2233223b733a353a226d61737361223b733a323a223130223b7d733a353a22636f6c766f223b693a313b7d7d733a31303a2275706461746574696d65223b693a313233323938333132393b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a34373a226966202874696d6528293e3132333239383036393029207b64657374726f795f676172626167652874657374293b7d223b733a333a22626167223b613a323a7b693a303b613a313a7b733a353a22636f6c766f223b693a313b7d693a313b613a31313a7b693a303b733a313a2238223b733a323a226964223b733a313a2238223b693a313b733a343a226d697363223b733a343a2274797065223b733a343a226d697363223b693a323b733a32373a22d09ad180d18bd181d0b8d0bdd18bd0b920d185d0b2d0bed181d182223b733a343a226e616d65223b733a32373a22d09ad180d18bd181d0b8d0bdd18bd0b920d185d0b2d0bed181d182223b693a333b733a3232373a22d0a5d0b2d0bed181d18220d0bad180d18bd181d18b2e20d093d0bed0b2d0bed180d18fd18220d187d182d0be20d0bfd0b5d180d0b5d0b420d181d0bcd0b5d180d182d18cd18e20d0bad180d18bd181d0b820d181d0b1d180d0b0d181d18bd0b2d0b0d18ed18220d181d0b2d0bed0b820d185d0b2d0bed181d182d18b2c20d182d0be20d0bbd0b820d0bed18220d0b8d181d0bfd183d0b3d0b02c20d182d0be20d0bbd0b820d0b5d189d0b520d0bed18220d187d0b5d0b3d0be2e20d0add182d0bed0b3d0be20d0bdd0b8d0bad182d0be20d0bdd0b520d0b7d0bdd0b0d0b5d1822e2e2e223b733a343a22696e666f223b733a3232373a22d0a5d0b2d0bed181d18220d0bad180d18bd181d18b2e20d093d0bed0b2d0bed180d18fd18220d187d182d0be20d0bfd0b5d180d0b5d0b420d181d0bcd0b5d180d182d18cd18e20d0bad180d18bd181d0b820d181d0b1d180d0b0d181d18bd0b2d0b0d18ed18220d181d0b2d0bed0b820d185d0b2d0bed181d182d18b2c20d182d0be20d0bbd0b820d0bed18220d0b8d181d0bfd183d0b3d0b02c20d182d0be20d0bbd0b820d0b5d189d0b520d0bed18220d187d0b5d0b3d0be2e20d0add182d0bed0b3d0be20d0bdd0b8d0bad182d0be20d0bdd0b520d0b7d0bdd0b0d0b5d1822e2e2e223b693a343b733a34363a22613a323a7b733a343a2263656e61223b733a323a223135223b733a353a226d61737361223b733a313a2232223b7d223b733a31303a2261626f75745f6974656d223b613a323a7b733a343a2263656e61223b733a323a223135223b733a353a226d61737361223b733a313a2232223b7d733a353a22636f6c766f223b693a313b7d7d7d693a323b613a353a7b733a343a226e616d65223b733a31303a22d0a5d0b8d0bcd0b8d0ba223b733a343a22696e666f223b733a303a22223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a363a226368696d696b223b7d733a383a226f6e5f656e746572223b733a303a22223b7d693a333b613a383a7b733a343a226e616d65223b733a383a22d0a1d0b5d0b9d184223b733a343a22696e666f223b733a303a22223b733a343a2274797065223b733a343a2273616665223b733a363a22737461747573223b613a333a7b733a343a2268617264223b733a313a2232223b733a373a2269735f6f70656e223b733a353a22636c6f7365223b733a383a226c6173746861636b223b693a313233323938333131313b7d733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a3137393a226966202828246f626a5f6c6973745b24695d5b7374617475735d5b6c6173746861636b5d2b352a3630293c74696d65282929207b246f626a5f6c6973745b24695d5b7374617475735d5b6c6173746861636b5d3d74696d6528293b246f626a5f6c6973745b24695d5b7374617475735d5b69735f6f70656e5d3d636c6f73653b246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28312c312c246f626a5f6c6973745b24695d2c35293b7d223b733a333a22626167223b613a313a7b693a303b613a31313a7b693a303b733a313a2231223b733a323a226964223b733a313a2231223b693a313b733a373a22626f647961726d223b733a343a2274797065223b733a373a22626f647961726d223b693a323b733a31323a22d0a0d0b2d0b0d0bdd18cd191223b733a343a226e616d65223b733a31323a22d0a0d0b2d0b0d0bdd18cd191223b693a333b733a38383a22d0a0d0b2d0b0d0bdd18bd0b520d0bed0b1d0bdd0bed181d0bad0b82c20d18fd0b2d0bdd0be20d0bdd0b0d0b9d0b4d0b5d0bdd0bdd18bd0b520d0b3d0b4d0b520d182d0be20d0bdd0b020d0bfd0bed0bcd0bed0b9d0bad0b5223b733a343a22696e666f223b733a38383a22d0a0d0b2d0b0d0bdd18bd0b520d0bed0b1d0bdd0bed181d0bad0b82c20d18fd0b2d0bdd0be20d0bdd0b0d0b9d0b4d0b5d0bdd0bdd18bd0b520d0b3d0b4d0b520d182d0be20d0bdd0b020d0bfd0bed0bcd0bed0b9d0bad0b5223b693a343b733a3230373a22613a393a7b733a393a227265715f6c6576656c223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2230223b733a373a22726573626f6f6d223b733a313a2230223b733a373a22726573766f6c74223b733a313a2230223b733a393a22726573706f69736f6e223b733a313a2230223b733a363a22726573726164223b733a313a2230223b733a343a2263656e61223b733a313a2233223b733a353a226d61737361223b733a323a223130223b7d223b733a31303a2261626f75745f6974656d223b613a393a7b733a393a227265715f6c6576656c223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2230223b733a373a22726573626f6f6d223b733a313a2230223b733a373a22726573766f6c74223b733a313a2230223b733a393a22726573706f69736f6e223b733a313a2230223b733a363a22726573726164223b733a313a2230223b733a343a2263656e61223b733a313a2233223b733a353a226d61737361223b733a323a223130223b7d733a353a22636f6c766f223b693a313b7d7d733a31303a2275706461746574696d65223b693a313233323938333131363b7d7d),
('bartertown.street1', 'bartertown', 'a:6:{s:4:"name";s:25:"Главная улица";s:4:"info";s:110:"Это главный тонель Бартертауна. На потолке ярко горят лампы.";s:5:"fight";s:2:"no";s:5:"loc_x";s:3:"250";s:5:"loc_y";s:2:"25";s:5:"light";s:7:"forever";}', '', 0x613a343a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d092d0b2d0b5d180d18520d0bfd0be20d182d183d0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6d61696e223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32323a22d09bd0b0d0b1d0bed180d0b0d182d0bed180d0b8d18f223b733a363a22746172676574223b733a373a226c61626d61696e223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a31383a22d093d0bed181d0bfd0b8d182d0b0d0bbd18c223b733a363a22746172676574223b733a31323a22686f73706974616c6d61696e223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a32363a22d092d0bdd0b8d0b720d0bfd0be20d182d183d0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657432223b7d7d, 0x613a323a7b693a303b613a353a7b733a343a226e616d65223b733a31303a22d09dd0b8d189d0b8d0b9223b733a343a22696e666f223b733a35353a22d09ad0b0d0bad0bed0b920d182d0be20d0b7d0b0d0bcd18bd0b7d0b3d0b0d0bdd18bd0b920d0bed0b1d0bed180d0b2d0b0d0bdd0b5d186223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a373a22636974697a656e223b7d733a383a226f6e5f656e746572223b733a303a22223b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333338313833353729207b64657374726f795f6761726261676528626172746572746f776e2e73747265657431293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.bar', 'bartertown', 'a:6:{s:4:"name";s:6:"Бар";s:4:"info";s:120:"Место отдыха горожан, путе??ественников и всех тех, кто сюда попал.";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', NULL, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31323a22d09dd0b0d180d183d0b6d183223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6d61696e223b7d7d, 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),
('labmain', 'bartertown', 'a:6:{s:4:"name";s:22:"Лаборатория";s:4:"info";s:193:"В воздухе витает запах каких-то химических препаратов. За столом трудится какой-то человек в белом халате";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"30";s:5:"loc_y";s:2:"30";s:5:"light";s:7:"forever";}', NULL, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31323a22d09dd0b0d180d183d0b6d183223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657431223b7d7d, 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),
('bartertown.street2', 'bartertown', 'a:6:{s:4:"name";s:27:"Главный тунель";s:4:"info";s:167:"В стене сияет дыра. Да, обыкновенная дыра. Кто-то очень грубо проделал искусственный проход.";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', 0x623a303b, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d092d0b2d0b5d180d18520d0bfd0be20d182d183d0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657431223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31373a22626172746572746f776e2e746f6e656c31223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0bfd0b5d180d180d0bed0bd223b733a363a22746172676574223b733a31353a22626172746572746f776e2e70657231223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a31363a22d0a1d182d180d0b0d0b6d0bdd0b8d0ba223b733a343a22696e666f223b733a34383a22d0a1d0bad183d187d0b0d18ed189d0b8d0b920d0bcd0bed0bbd0bed0b4d0bed0b920d187d0b5d0bbd0bed0b2d0b5d0ba223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a31303a2267756172647472617368223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('hospitalmain', 'bartertown', 'a:6:{s:4:"name";s:18:"Госпиталь";s:4:"info";s:96:"Бинты, ??прицы и медицинский спирт! Это явно больница!";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31323a22d09dd0b0d180d183d0b6d183223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657431223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a31383a22d09ad0bed181d182d0bed0bfd180d0b0d0b2223b733a343a22696e666f223b733a3137313a22d092d180d0b0d18720d0b220d0b1d0b5d0bbd0bed0bc20d185d0b0d0bbd0b0d182d0b52c20d0bfd0b5d180d0b5d0bfd0b0d187d0bad0b0d0bdd0bdd0bed0bc20d0bad180d0bed0b2d18cd18e2e20d097d0bbd0bed0b2d0b5d189d0b0d18f20d183d0bbd18bd0b1d0bad0b020d0bdd0b020d0bbd0b8d186d0b520d0bfd180d0b5d0b4d0b2d0b5d189d0b0d0b5d18220d0bdd0b5d187d182d0be20d0bdd0b5d0b4d0bed0b1d180d0bed0b521223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a393a226d6564696b6d61696e223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('bartertown.tonel1', 'bartertown', 'a:6:{s:4:"name";s:25:"Начало тунеля";s:4:"info";s:328:"Прорытый в земле тунель. Опорные балки выглядят надежно. К ним прикреплены самоделные светильники. Можно было бы сказать, довольно уютно, если не смрад тянущийся из глубины тунеля";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b3d0bed180d0bed0b4d183223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657432223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31373a22626172746572746f776e2e746f6e656c32223b7d7d, NULL),
('bartertown.tonel2', 'bartertown', 'a:6:{s:4:"name";s:29:"Середина тунеля";s:4:"info";s:59:"Смрад со свалки довольно ощутим.";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', '', 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b3d0bed180d0bed0b4d183223b733a363a22746172676574223b733a31373a22626172746572746f776e2e746f6e656c31223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31373a22626172746572746f776e2e746f6e656c33223b7d7d, ''),
('bartertown.tonel3', 'bartertown', 'a:6:{s:4:"name";s:23:"Конец тонеля";s:4:"info";s:39:"Едкая вонь бьет в нос.";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', '', 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b3d0bed180d0bed0b4d183223b733a363a22746172676574223b733a31373a22626172746572746f776e2e746f6e656c32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d181d0b2d0b0d0bbd0bad183223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736831223b7d7d, ''),
('bartertown.trash1', 'bartertown', 'a:6:{s:4:"name";s:12:"Свалка";s:4:"info";s:393:"Вы находитесь на свалке. Боль??ая полость, даже пещера вырытая в земле. ?? практически польностью заполненная мусором. Между настоящих гор мусора проложены тропинки. ??з темноты доносится странный писк и ??уо??ание";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', 0x4e3b, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09220d182d0bed0bdd0b5d0bbd18c223b733a363a22746172676574223b733a31373a22626172746572746f776e2e746f6e656c33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33323a22d09fd0be20d0bed0b4d0bdd0bed0b920d182d180d0bed0bfd0b8d0bdd0bad0b5223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736832223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a33343a22d09fd0be20d0b4d180d183d0b3d0bed0b920d182d180d0bed0bfd0b8d0bdd0bad0b5223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683261223b7d7d, '');
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.trash2', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 1";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736831223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736833223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333739333731393229207b64657374726f795f6761726261676528626172746572746f776e2e747261736832293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash3', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 2";s:4:"info";s:136:"Небольщая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736832223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736834223b7d7d, 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),
('bartertown.trash4', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 3";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736833223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736835223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333831343134383729207b64657374726f795f6761726261676528626172746572746f776e2e747261736834293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash5', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 4";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736834223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736836223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32383a22d09220d181d182d0bed180d0bed0bdd18320d181d0b2d0b5d182d0b0223b733a363a22746172676574223b733a32303a22626172746572746f776e2e747261736863616d70223b7d7d, 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),
('bartertown.trash6', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 5";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736835223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736837223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333831333332323129207b64657374726f795f6761726261676528626172746572746f776e2e747261736836293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash7', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 6";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736836223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736838223b7d7d, 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);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.trash8', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 7";s:4:"info";s:138:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736837223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736839223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333532343132393329207b64657374726f795f6761726261676528626172746572746f776e2e747261736838293b7d223b733a333a22626167223b4e3b7d7d),
('mainnora.part2', 'bartertown', 'a:6:{s:4:"name";s:41:"Основной ход, развилка";s:4:"info";s:173:"Какая-то нора. Должно быть ее прорыло ОЧЕНЬ крупное животное. Как бы не попасться к нему на обед";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727431223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d0bfd0bed0b1d0bed187d0bdd18bd0b920d185d0bed0b4223b733a363a22746172676574223b733a393a22646f702e7061727432223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32303a22d09220d0bcd0b0d0bbd18bd0b920d185d0bed0b4223b733a363a22746172676574223b733a31303a22646f702e706172743261223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35373a226966202874696d6528293e3132333736313232343729207b64657374726f795f67617262616765286d61696e6e6f72612e7061727432293b7d223b733a333a22626167223b4e3b7d7d),
('mainnora.part3', 'bartertown', 'a:6:{s:4:"name";s:36:"Основной ход часть 2";s:4:"info";s:173:"Какая-то нора. Должно быть ее прорыло ОЧЕНЬ крупное животное. Как бы не попасться к нему на обед";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 0x613a343a7b693a303b613a34343a7b733a323a226964223b733a333a22726174223b733a31343a22706572696f645f7265737061776e223b733a323a223838223b733a373a227265737061776e223b693a313233333538393332383b733a343a226e616d65223b733a31303a22d0bad180d18bd181d0b0223b733a343a22696e666f223b733a34303a22d097d0bbd0bed0b520d0b2d0bed0bdd18ed187d0b5d0b520d0b6d0b8d0b2d0bed182d0bdd0bed0b5223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223230223b733a353a226d61786870223b733a323a223230223b733a323a226f64223b733a313a2233223b733a353a226d61786f64223b733a313a2233223b733a31313a22637269745f6368616e6365223b733a313a2230223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2234223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2230223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2230223b733a393a22726573706c617a6d61223b733a313a2230223b733a373a22726573626f6f6d223b733a313a2230223b733a373a22726573766f6c74223b733a313a2230223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c312c38302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c352b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a333a22726174223b693a313b733a31303a22d0bad180d18bd181d0b0223b693a323b733a34303a22d097d0bbd0bed0b520d0b2d0bed0bdd18ed187d0b5d0b520d0b6d0b8d0b2d0bed182d0bdd0bed0b5223b693a333b733a323a223230223b693a343b733a313a2230223b693a353b733a313a2233223b693a363b733a313a2230223b693a373b733a363a226e6f726d616c223b693a383b733a313a2234223b693a393b733a313a2230223b693a31303b733a313a2230223b693a31313b733a313a2230223b693a31323b733a313a2230223b693a31333b733a313a2230223b693a31343b733a313a2230223b693a31353b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c312c38302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c352b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a39323b733a313a2279223b693a33353b7d693a313b613a34343a7b733a323a226964223b733a363a22426967726174223b733a31343a22706572696f645f7265737061776e223b733a323a223838223b733a373a227265737061776e223b693a313233343837343137313b733a343a226e616d65223b733a34313a22d09ad180d0bed0b2d0bed0b6d0b0d0b4d0bdd18bd0b920d09ad180d0bed182d0bed0bad180d18bd181223b733a343a22696e666f223b733a3231393a22d0a1d182d180d0b0d188d0bdd0b0d18f20d188d183d182d0bad0b020d18dd0b2d0bed0bbd18ed186d0b8d0b82e20d09fd0bed0bcd0b5d181d18c20d0bad180d18bd181d18b20d0b820d0bad180d0bed182d0b02c20d0bfd0bed0b4d0b2d0b5d180d0b3d188d0b0d18fd181d18f20d0bcd183d182d0b0d186d0b8d0b820d0bed18220d180d0b0d0b4d0b8d0b0d186d0b8d0b820d0bfd180d0b8d0bdd0bed181d0b8d18220d181d0bcd0b5d180d182d18c20d0bdd0b5d0bed181d182d0bed180d0bed0b6d0bdd18bd0bc20d0bfd183d182d0bdd0b8d0bad0b0d0bc2e223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223330223b733a353a226d61786870223b733a323a223330223b733a323a226f64223b733a313a2236223b733a353a226d61786f64223b733a313a2236223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b643a393b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a323a223130223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a37303a226c6f6f742824706c617965725b6c6f635f69645d2c32322c312c36302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32342c312c36302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a363a22426967726174223b693a313b733a31383a22d09ad180d0bed182d0bed0bad180d18bd181223b693a323b733a3231393a22d0a1d182d180d0b0d188d0bdd0b0d18f20d188d183d182d0bad0b020d18dd0b2d0bed0bbd18ed186d0b8d0b82e20d09fd0bed0bcd0b5d181d18c20d0bad180d18bd181d18b20d0b820d0bad180d0bed182d0b02c20d0bfd0bed0b4d0b2d0b5d180d0b3d188d0b0d18fd181d18f20d0bcd183d182d0b0d186d0b8d0b820d0bed18220d180d0b0d0b4d0b8d0b0d186d0b8d0b820d0bfd180d0b8d0bdd0bed181d0b8d18220d181d0bcd0b5d180d182d18c20d0bdd0b5d0bed181d182d0bed180d0bed0b6d0bdd18bd0bc20d0bfd183d182d0bdd0b8d0bad0b0d0bc2e223b693a333b733a323a223330223b693a343b733a313a2230223b693a353b733a313a2236223b693a363b733a313a2235223b693a373b733a363a226e6f726d616c223b693a383b733a313a2237223b693a393b733a313a2230223b693a31303b733a323a223130223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a37303a226c6f6f742824706c617965725b6c6f635f69645d2c32322c312c36302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32342c312c36302b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a39373b733a313a2279223b693a31373b7d693a323b613a34343a7b733a323a226964223b733a393a22646f75626c65726174223b733a31343a22706572696f645f7265737061776e223b733a323a223939223b733a373a227265737061776e223b693a313233343031333735353b733a343a226e616d65223b733a32333a22d09ad180d18bd181d0b02dd0bcd183d182d0b0d0bdd182223b733a343a22696e666f223b733a35343a22d0a1d182d180d0b0d0bdd0bdd0b0d18f20d0bad180d18bd181d0b020d1812032d0bcd18f20d185d0b2d0bed181d182d0b0d0bcd0b821223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223232223b733a353a226d61786870223b733a323a223232223b733a323a226f64223b733a313a2233223b733a353a226d61786f64223b733a313a2233223b733a31313a22637269745f6368616e6365223b733a313a2233223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2235223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2235223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2232223b733a393a22726573706c617a6d61223b733a313a2232223b733a373a22726573626f6f6d223b733a313a2232223b733a373a22726573766f6c74223b733a313a2232223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c322c34302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c372b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a393a22646f75626c65726174223b693a313b733a32333a22d09ad180d18bd181d0b02dd0bcd183d182d0b0d0bdd182223b693a323b733a35343a22d0a1d182d180d0b0d0bdd0bdd0b0d18f20d0bad180d18bd181d0b020d1812032d0bcd18f20d185d0b2d0bed181d182d0b0d0bcd0b821223b693a333b733a323a223232223b693a343b733a313a2230223b693a353b733a313a2233223b693a363b733a313a2233223b693a373b733a363a226e6f726d616c223b693a383b733a313a2235223b693a393b733a313a2230223b693a31303b733a313a2235223b693a31313b733a313a2232223b693a31323b733a313a2232223b693a31333b733a313a2232223b693a31343b733a313a2232223b693a31353b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c322c34302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c372b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a34303b733a313a2279223b693a31373b7d693a333b613a34343a7b733a323a226964223b733a363a22426967726174223b733a31343a22706572696f645f7265737061776e223b733a323a223939223b733a373a227265737061776e223b693a313233343136333339313b733a343a226e616d65223b733a31383a22d09ad180d0bed182d0bed0bad180d18bd181223b733a343a22696e666f223b733a3231393a22d0a1d182d180d0b0d188d0bdd0b0d18f20d188d183d182d0bad0b020d18dd0b2d0bed0bbd18ed186d0b8d0b82e20d09fd0bed0bcd0b5d181d18c20d0bad180d18bd181d18b20d0b820d0bad180d0bed182d0b02c20d0bfd0bed0b4d0b2d0b5d180d0b3d188d0b0d18fd181d18f20d0bcd183d182d0b0d186d0b8d0b820d0bed18220d180d0b0d0b4d0b8d0b0d186d0b8d0b820d0bfd180d0b8d0bdd0bed181d0b8d18220d181d0bcd0b5d180d182d18c20d0bdd0b5d0bed181d182d0bed180d0bed0b6d0bdd18bd0bc20d0bfd183d182d0bdd0b8d0bad0b0d0bc2e223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223330223b733a353a226d61786870223b733a323a223330223b733a323a226f64223b733a313a2236223b733a353a226d61786f64223b733a313a2236223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2237223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a323a223130223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a37303a226c6f6f742824706c617965725b6c6f635f69645d2c32322c312c36302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32342c312c36302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a363a22426967726174223b693a313b733a31383a22d09ad180d0bed182d0bed0bad180d18bd181223b693a323b733a3231393a22d0a1d182d180d0b0d188d0bdd0b0d18f20d188d183d182d0bad0b020d18dd0b2d0bed0bbd18ed186d0b8d0b82e20d09fd0bed0bcd0b5d181d18c20d0bad180d18bd181d18b20d0b820d0bad180d0bed182d0b02c20d0bfd0bed0b4d0b2d0b5d180d0b3d188d0b0d18fd181d18f20d0bcd183d182d0b0d186d0b8d0b820d0bed18220d180d0b0d0b4d0b8d0b0d186d0b8d0b820d0bfd180d0b8d0bdd0bed181d0b8d18220d181d0bcd0b5d180d182d18c20d0bdd0b5d0bed181d182d0bed180d0bed0b6d0bdd18bd0bc20d0bfd183d182d0bdd0b8d0bad0b0d0bc2e223b693a333b733a323a223330223b693a343b733a313a2230223b693a353b733a313a2236223b693a363b733a313a2235223b693a373b733a363a226e6f726d616c223b693a383b733a313a2237223b693a393b733a313a2230223b693a31303b733a323a223130223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a37303a226c6f6f742824706c617965725b6c6f635f69645d2c32322c312c36302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32342c312c36302b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a36323b733a313a2279223b693a39303b7d7d, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d0ba20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727432223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727434223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35373a226966202874696d6528293e3132333437393235383529207b64657374726f795f67617262616765286d61696e6e6f72612e7061727433293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash9', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 8";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736838223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683130223b7d7d, 0x613a323a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333532333439323529207b64657374726f795f6761726261676528626172746572746f776e2e747261736839293b7d223b733a333a22626167223b613a313a7b693a303b613a313a7b733a353a22636f6c766f223b4e3b7d7d7d693a313b613a373a7b733a343a226e616d65223b733a33323a22d09fd0bed0b8d181d0bad0b0d182d18c20d0b220d0bcd183d181d0bed180d0b5223b733a343a22696e666f223b733a36363a22d09fd0bed0b8d181d0ba20d0b220d0bcd183d181d0bed180d0bdd0bed0b920d0bad183d187d0b520d18120d186d0b5d0bbd18cd18e20d0bdd0b0d0b6d0b8d0b2d18b223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a383a226f6e5f656e746572223b733a35343a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2832302c312c246f626a5f6c6973745b24695d2c31303030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233383036323632373b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.trash10', 'bartertown', 'a:6:{s:4:"name";s:20:"Вход в нору";s:4:"info";s:213:"Неболь??ая вычищенная от мусора площадка. В центре на земле прорыта дыра. Очень похоже на нору. Тут что, кроты водятся?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d0bed0b4d0bdd18320d181d182d0bed180d0bed0bdd183223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736839223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31313a22d09220d0bdd0bed180d183223b733a363a22746172676574223b733a343a226e6f7261223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d0b4d180d183d0b3d183d18e20d181d182d0bed180d0bed0bdd183223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683961223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333635373939323529207b64657374726f795f6761726261676528626172746572746f776e2e74726173683130293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash9a', 'bartertown', 'a:6:{s:4:"name";s:30:"Тропинка  часть 8";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 0x613a333a7b693a303b613a34343a7b733a323a226964223b733a393a22646f75626c65726174223b733a31343a22706572696f645f7265737061776e223b733a333a22313737223b733a373a227265737061776e223b693a313233363531353138333b733a343a226e616d65223b733a34363a22d09ad180d0bed0b2d0bed0b6d0b0d0b4d0bdd18bd0b920d09ad180d18bd181d0b02dd0bcd183d182d0b0d0bdd182223b733a343a22696e666f223b733a35343a22d0a1d182d180d0b0d0bdd0bdd0b0d18f20d0bad180d18bd181d0b020d1812032d0bcd18f20d185d0b2d0bed181d182d0b0d0bcd0b821223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223232223b733a353a226d61786870223b733a323a223232223b733a323a226f64223b733a313a2233223b733a353a226d61786f64223b733a313a2233223b733a31313a22637269745f6368616e6365223b733a313a2233223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b643a363b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2235223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2232223b733a393a22726573706c617a6d61223b733a313a2232223b733a373a22726573626f6f6d223b733a313a2232223b733a373a22726573766f6c74223b733a313a2232223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c322c34302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c372b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a393a22646f75626c65726174223b693a313b733a32333a22d09ad180d18bd181d0b02dd0bcd183d182d0b0d0bdd182223b693a323b733a35343a22d0a1d182d180d0b0d0bdd0bdd0b0d18f20d0bad180d18bd181d0b020d1812032d0bcd18f20d185d0b2d0bed181d182d0b0d0bcd0b821223b693a333b733a323a223232223b693a343b733a313a2230223b693a353b733a313a2233223b693a363b733a313a2233223b693a373b733a363a226e6f726d616c223b693a383b733a313a2235223b693a393b733a313a2230223b693a31303b733a313a2235223b693a31313b733a313a2232223b693a31323b733a313a2232223b693a31333b733a313a2232223b693a31343b733a313a2232223b693a31353b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c322c34302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c372b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a39393b733a313a2279223b693a31333b7d693a313b613a34343a7b733a323a226964223b733a393a22646f75626c65726174223b733a31343a22706572696f645f7265737061776e223b733a333a22313737223b733a373a227265737061776e223b693a313233363537393433343b733a343a226e616d65223b733a34363a22d09ad180d0bed0b2d0bed0b6d0b0d0b4d0bdd18bd0b920d09ad180d18bd181d0b02dd0bcd183d182d0b0d0bdd182223b733a343a22696e666f223b733a35343a22d0a1d182d180d0b0d0bdd0bdd0b0d18f20d0bad180d18bd181d0b020d1812032d0bcd18f20d185d0b2d0bed181d182d0b0d0bcd0b821223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223232223b733a353a226d61786870223b733a323a223232223b733a323a226f64223b733a313a2233223b733a353a226d61786f64223b733a313a2233223b733a31313a22637269745f6368616e6365223b733a313a2233223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b643a363b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2235223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2232223b733a393a22726573706c617a6d61223b733a313a2232223b733a373a22726573626f6f6d223b733a313a2232223b733a373a22726573766f6c74223b733a313a2232223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c322c34302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c372b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a393a22646f75626c65726174223b693a313b733a32333a22d09ad180d18bd181d0b02dd0bcd183d182d0b0d0bdd182223b693a323b733a35343a22d0a1d182d180d0b0d0bdd0bdd0b0d18f20d0bad180d18bd181d0b020d1812032d0bcd18f20d185d0b2d0bed181d182d0b0d0bcd0b821223b693a333b733a323a223232223b693a343b733a313a2230223b693a353b733a313a2233223b693a363b733a313a2233223b693a373b733a363a226e6f726d616c223b693a383b733a313a2235223b693a393b733a313a2230223b693a31303b733a313a2235223b693a31313b733a313a2232223b693a31323b733a313a2232223b693a31333b733a313a2232223b693a31343b733a313a2232223b693a31353b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c322c34302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c372b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a33323b733a313a2279223b693a31303b7d693a323b613a34343a7b733a323a226964223b733a333a22726174223b733a31343a22706572696f645f7265737061776e223b733a333a22313737223b733a373a227265737061776e223b693a313233363531353138333b733a343a226e616d65223b733a32353a22d09ad180d0b5d0bfd0bad0b8d0b920d0bad180d18bd181d0b0223b733a343a22696e666f223b733a34303a22d097d0bbd0bed0b520d0b2d0bed0bdd18ed187d0b5d0b520d0b6d0b8d0b2d0bed182d0bdd0bed0b5223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223230223b733a353a226d61786870223b733a323a223230223b733a323a226f64223b733a313a2233223b733a353a226d61786f64223b733a313a2233223b733a31313a22637269745f6368616e6365223b733a313a2230223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2234223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2230223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b643a303b733a393a22726573706c617a6d61223b643a303b733a373a22726573626f6f6d223b643a303b733a373a22726573766f6c74223b643a303b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c312c38302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c352b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a333a22726174223b693a313b733a31303a22d0bad180d18bd181d0b0223b693a323b733a34303a22d097d0bbd0bed0b520d0b2d0bed0bdd18ed187d0b5d0b520d0b6d0b8d0b2d0bed182d0bdd0bed0b5223b693a333b733a323a223230223b693a343b733a313a2230223b693a353b733a313a2233223b693a363b733a313a2230223b693a373b733a363a226e6f726d616c223b693a383b733a313a2234223b693a393b733a313a2230223b693a31303b733a313a2230223b693a31313b733a313a2230223b693a31323b733a313a2230223b693a31333b733a313a2230223b693a31343b733a313a2230223b693a31353b733a36383a226c6f6f742824706c617965725b6c6f635f69645d2c382c312c38302b24706572293b6c6f6f742824706c617965725b6c6f635f69645d2c32322c312c352b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a39373b733a313a2279223b693a383b7d7d, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683861223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683130223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333635373937313029207b64657374726f795f6761726261676528626172746572746f776e2e74726173683961293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash3a', 'bartertown', 'a:6:{s:4:"name";s:30:"Тропинка  часть 2";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683261223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683461223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333532313734373029207b64657374726f795f6761726261676528626172746572746f776e2e74726173683361293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash4a', 'bartertown', 'a:6:{s:4:"name";s:30:"Тропинка  часть 3";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683361223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683561223b7d7d, 0x613a323a7b693a303b613a383a7b733a343a226e616d65223b733a33323a22d09fd0bed180d18bd182d18cd181d18f20d0b220d0bcd183d181d0bed180d0b5223b733a343a22696e666f223b733a3130303a22d098d0bdd0bed0b3d0b4d0b020d0b2d18bd0bad0b8d0b4d18bd0b2d0b0d18ed18220d0bfd0bed0bbd0b5d0b7d0bdd18bd0b520d0b2d0b5d189d0b82e20d0a5d0bed182d0b8d182d0b520d0bbd0b820d0b2d18b20d0b8d18520d0bdd0b0d0b9d182d0b83f223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a35333a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28322c312c246f626a5f6c6973745b24695d2c31363030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373631333334363b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333532333638373629207b64657374726f795f6761726261676528626172746572746f776e2e74726173683461293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('sera.third5', 'seratown', 'a:6:{s:4:"name";s:27:"Третий ??трек 5/7";s:4:"info";s:103:"Третий дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d09a20d0bdd0b0d187d0b0d0bbd18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726434223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09a20d0bad0bed0bdd186d18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726436223b7d7d, ''),
('sera.third6', 'seratown', 'a:6:{s:4:"name";s:27:"Третий ??трек 6/7";s:4:"info";s:103:"Третий дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d09a20d0bdd0b0d187d0b0d0bbd18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726435223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09a20d0bad0bed0bdd186d18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726437223b7d7d, ''),
('sera.third7', 'seratown', 'a:6:{s:4:"name";s:27:"Третий ??трек 7/7";s:4:"info";s:103:"Третий дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d09a20d0bdd0b0d187d0b0d0bbd18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726436223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('bartertown.trash5a', 'bartertown', 'a:6:{s:4:"name";s:30:"Тропинка  часть 4";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683461223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683661223b7d7d, 0x613a323a7b693a303b613a373a7b733a343a226e616d65223b733a32383a22d0a0d18bd182d18cd181d18f20d0b220d0bcd183d181d0bed180d0b5223b733a343a22696e666f223b733a34313a22d09020d0b2d0b4d180d183d0b320d187d182d0be2dd182d0be20d0bdd0b0d0b9d0b4d0b5d13fd18c3f223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a383a226f6e5f656e746572223b733a35333a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28322c312c246f626a5f6c6973745b24695d2c31303030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373631323733373b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333532333636343629207b64657374726f795f6761726261676528626172746572746f776e2e74726173683561293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.trash6a', 'bartertown', 'a:6:{s:4:"name";s:30:"Тропинка  часть 5";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683561223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683761223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333532313333383929207b64657374726f795f6761726261676528626172746572746f776e2e74726173683661293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash7a', 'bartertown', 'a:6:{s:4:"name";s:30:"Тропинка  часть 6";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683661223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683861223b7d7d, 0x613a323a7b693a303b613a373a7b733a343a226e616d65223b733a32383a22d0a0d18bd182d18cd181d18f20d0b220d0bcd183d181d0bed180d0b5223b733a343a22696e666f223b733a34353a22d09fd0bed0b8d181d0ba20d186d0b5d0bdd0bdd0bed181d182d0b5d0b920d0b220d0bcd183d181d0bed180d0b5223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a383a226f6e5f656e746572223b733a35343a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2832302c312c246f626a5f6c6973745b24695d2c31303030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373631323732343b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333532333634343929207b64657374726f795f6761726261676528626172746572746f776e2e74726173683761293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash8a', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 7";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683761223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683961223b7d7d, 0x613a323a7b693a303b613a383a7b733a343a226e616d65223b733a32383a22d0a0d18bd182d18cd181d18f20d0b220d0bcd183d181d0bed180d0b5223b733a343a22696e666f223b733a37393a22d095d181d0bbd0b820d0bfd0bed0b2d0b5d0b7d0b5d1822c20d0bcd0bed0b6d0bdd0be20d0bdd0b0d0b9d182d0b820d187d182d0be2dd0bbd0b8d0b1d0be20d0bfd0bed0bbd0b5d0b7d0bdd0bed0b5223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a35343a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2831342c332c246f626a5f6c6973745b24695d2c31323030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373631323931303b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333532313736383329207b64657374726f795f6761726261676528626172746572746f776e2e74726173683861293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part2', 'bartertown', 'a:6:{s:4:"name";s:41:"Побочный ход, развилка";s:4:"info";s:33:"Ход разветвляется";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a393a22646f702e7061727431223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32383a22d09dd0b020d0bed181d0bdd0bed0b2d0bdd0bed0b920d185d0bed0b4223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727432223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a393a22646f702e7061727433223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35323a226966202874696d6528293e3132333531363230363229207b64657374726f795f6761726261676528646f702e7061727432293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part3', 'bartertown', 'a:6:{s:4:"name";s:36:"Побочный ход часть 2";s:4:"info";s:173:"Какая-то нора. Должно быть ее прорыло ОЧЕНЬ крупное животное. Как бы не попасться к нему на обед";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a393a22646f702e7061727432223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a393a22646f702e7061727434223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35323a226966202874696d6528293e3132333531363232393629207b64657374726f795f6761726261676528646f702e7061727433293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.trash2a', 'bartertown', 'a:6:{s:4:"name";s:29:"Тропинка часть 1";s:4:"info";s:136:"Неболь??ая тропинка между огромными кучами мусора. Темно, хоть глаз выколи!";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09220d181d182d0bed180d0bed0bdd18320d0b3d0bed180d0bed0b4d0b0223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736831223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d181d0b2d0b0d0bbd0bad0b8223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683361223b7d7d, 0x613a323a7b693a303b613a383a7b733a343a226e616d65223b733a32383a22d098d181d0bad0b0d182d18c20d0b220d0bcd183d181d0bed180d0b5223b733a343a22696e666f223b733a34333a22d09020d0b2d0b4d180d183d0b320d187d182d0be2dd182d0be20d0bdd0b0d0b9d0b4d0b5d182d0b53f3f3f223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a35343a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2831342c362c246f626a5f6c6973745b24695d2c31343030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373936333034393b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333533313537353129207b64657374726f795f6761726261676528626172746572746f776e2e74726173683261293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.trashcamp', 'bartertown', 'a:6:{s:4:"name";s:12:"Костер";s:4:"info";s:69:"Вокруг костра собрались какие-то люди";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"20";s:5:"loc_y";s:2:"20";s:5:"light";s:7:"forever";}', NULL, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32313a22d09fd0be20d182d180d0bed0bfd0b8d0bdd0bad0b5223b733a363a22746172676574223b733a31373a22626172746572746f776e2e747261736835223b7d7d, 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),
('dop.part1', 'bartertown', 'a:6:{s:4:"name";s:36:"Побочный ход часть 1";s:4:"info";s:82:"Вспомогательный ход, параллельный основному";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a343a226e6f7261223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a393a22646f702e7061727432223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35323a226966202874696d6528293e3132333735333330373129207b64657374726f795f6761726261676528646f702e7061727431293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part4', 'bartertown', 'a:6:{s:4:"name";s:36:"Побочный ход часть 3";s:4:"info";s:173:"Какая-то нора. Должно быть ее прорыло ОЧЕНЬ крупное животное. Как бы не попасться к нему на обед";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a393a22646f702e7061727433223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727434223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35323a226966202874696d6528293e3132333532313738303629207b64657374726f795f6761726261676528646f702e7061727434293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part1a', 'bartertown', 'a:6:{s:4:"name";s:30:"Малый ход часть 1";s:4:"info";s:92:"Это ход помень??е. Видимо его прорыл зверь помень??е";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a343a226e6f7261223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a31303a22646f702e706172743261223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333434343730353829207b64657374726f795f6761726261676528646f702e706172743161293b7d223b733a333a22626167223b4e3b7d7d),
('mainnora.part4', 'bartertown', 'a:6:{s:4:"name";s:36:"Основной ход часть 3";s:4:"info";s:173:"Какая-то нора. Должно быть ее прорыло ОЧЕНЬ крупное животное. Как бы не попасться к нему на обед";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a343a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727433223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d0bfd0bed0b1d0bed187d0bdd18bd0b920d185d0bed0b4223b733a363a22746172676574223b733a393a22646f702e7061727434223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32303a22d09220d0bcd0b0d0bbd18bd0b920d185d0bed0b4223b733a363a22746172676574223b733a31303a22646f702e706172743461223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a31353a22d09220d0bbd0bed0b3d0bed0b2d0be223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727435223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35373a226966202874696d6528293e3132333736313236393729207b64657374726f795f67617262616765286d61696e6e6f72612e7061727434293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('mainnora.part5', 'bartertown', 'a:6:{s:4:"name";s:12:"Логово";s:4:"info";s:130:"Совсем недавно здесь был зверь, вырыв??ий эту нору. Куда же он подевался?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31373a22d098d0b720d0bbd0bed0b3d0bed0b2d0b0223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727434223b7d7d, 0x613a323a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35373a226966202874696d6528293e3132333531323033353729207b64657374726f795f67617262616765286d61696e6e6f72612e7061727435293b7d223b733a333a22626167223b4e3b7d693a313b613a373a7b733a343a226e616d65223b733a383a22d0a2d0b5d0bbd0be223b733a343a22696e666f223b733a3131383a22d0a0d0b0d181d0bfd0bed182d180d0bed188d0b5d0bdd0bdd18bd0b520d0bad180d0bed0b2d0b0d0b2d0b520d0bed181d182d0b0d0bdd0bad0b820d0b1d0bed0bcd0b6d0b02e20d09dd0b0d0b4d0be20d0b1d18bd0bbd0be20d0b4d183d0bcd0b0d182d18c2c20d0bad183d0b4d0b020d0bbd0b5d0b7223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a383a226f6e5f656e746572223b733a35343a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2832372c312c246f626a5f6c6973745b24695d2c31303030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373631323539303b7d7d),
('nora', 'bartertown', 'a:6:{s:4:"name";s:8:"Нора";s:4:"info";s:173:"Какая-то нора. Должно быть ее прорыло ОЧЕНЬ крупное животное. Как бы не попасться к нему на обед";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a343a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d181d0b2d0b0d0bbd0bad183223b733a363a22746172676574223b733a31383a22626172746572746f776e2e74726173683130223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d0bfd0bed0b1d0bed187d0bdd18bd0b920d185d0bed0b4223b733a363a22746172676574223b733a393a22646f702e7061727431223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d0bed181d0bdd0bed0b2d0bdd0bed0b920d185d0bed0b4223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727431223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a32303a22d09220d0bcd0b0d0bbd18bd0b920d185d0bed0b4223b733a363a22746172676574223b733a31303a22646f702e706172743161223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a34373a226966202874696d6528293e3132333439353336373529207b64657374726f795f67617262616765286e6f7261293b7d223b733a333a22626167223b4e3b7d7d),
('mainnora.part1', 'bartertown', 'a:6:{s:4:"name";s:36:"Основной ход часть 1";s:4:"info";s:173:"Какая-то нора. Должно быть ее прорыло ОЧЕНЬ крупное животное. Как бы не попасться к нему на обед";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a343a226e6f7261223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727432223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35373a226966202874696d6528293e3132333531363138353529207b64657374726f795f67617262616765286d61696e6e6f72612e7061727431293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part2a', 'bartertown', 'a:6:{s:4:"name";s:35:"Малый ход, развилка";s:4:"info";s:44:"Здесь ход разветвляется";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31303a22646f702e706172743161223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32383a22d09dd0b020d0bed181d0bdd0bed0b2d0bdd0bed0b920d185d0bed0b4223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727432223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a31303a22646f702e706172743361223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333635313630343129207b64657374726f795f6761726261676528646f702e706172743261293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('dop.part3a', 'bartertown', 'a:6:{s:4:"name";s:30:"Малый ход часть 2";s:4:"info";s:92:"Это ход помень??е. Видимо его прорыл зверь помень??е";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31303a22646f702e706172743261223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a31303a22646f702e706172743461223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333438363739373629207b64657374726f795f6761726261676528646f702e706172743361293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part4a', 'bartertown', 'a:6:{s:4:"name";s:30:"Малый ход часть 3";s:4:"info";s:92:"Это ход помень??е. Видимо его прорыл зверь помень??е";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d181d0b2d0b0d0bbd0bad0b5223b733a363a22746172676574223b733a31303a22646f702e706172743361223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32323a22d09a20d0bad0bed0bdd186d18320d185d0bed0b4d0b0223b733a363a22746172676574223b733a31303a22646f702e706172743561223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32383a22d09dd0b020d0bed181d0bdd0bed0b2d0bdd0bed0b920d185d0bed0b4223b733a363a22746172676574223b733a31343a226d61696e6e6f72612e7061727434223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333735343037323829207b64657374726f795f6761726261676528646f702e706172743461293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.pole1', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 1-1";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d181d0b5d0b2d0b5d180223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653231223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0b2d0bed181d182d0bed0ba223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653132223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d184d0b5d180d0bcd183223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6665726d223b7d7d, NULL),
('bartertown.pole12', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 1-2";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d181d0b5d0b2d0b5d180223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653232223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0b2d0bed181d182d0bed0ba223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653133223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d0b7d0b0d0bfd0b0d0b4223b733a363a22746172676574223b733a31363a22626172746572746f776e2e706f6c6531223b7d7d, 0x613a313a7b693a303b613a383a7b733a343a226e616d65223b733a33353a22d09ed181d0bcd0bed182d180d0b5d182d18cd181d18f20d0b2d0bed0bad180d183d0b3223b733a343a22696e666f223b733a34373a22d09020d0bdd0b5d18220d0bbd0b820d0bdd0b8d187d0b5d0b3d0be20d0bfd0bed0bbd0b5d0b7d0bdd0bed0b3d0be3f223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a35333a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2833302c312c246f626a5f6c6973745b24695d2c363030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373536333434363b7d7d),
('bartertown.pole33', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 3-3";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0b2d0bed181d182d0bed0ba223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653332223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a393a22d09dd0b020d18ed0b3223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653233223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a31313a22d09220d0bdd0bed180d183223b733a363a22746172676574223b733a31303a22646f702e706172743761223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333531343730383129207b64657374726f795f6761726261676528626172746572746f776e2e706f6c653333293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.pole22', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 2-2";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a343a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d181d0b5d0b2d0b5d180223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653332223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0b2d0bed181d182d0bed0ba223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653233223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d0b7d0b0d0bfd0b0d0b4223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653231223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a393a22d09dd0b020d18ed0b3223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653132223b7d7d, 0x613a323a7b693a303b613a383a7b733a343a226e616d65223b733a33353a22d09ed181d0bcd0bed182d180d0b5d182d18cd181d18f20d0b2d0bed0bad180d183d0b3223b733a343a22696e666f223b733a35383a22d09020d0bdd0b5d18220d0bbd0b820d0bdd0b8d187d0b5d0b3d0be2c20d187d182d0be20d0bfd0bbd0bed185d0be20d0bbd0b5d0b6d0b8d1823f223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a3130343a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2833302c332c246f626a5f6c6973745b24695d2c30293b246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2831342c332c246f626a5f6c6973745b24695d2c353030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373536333433313b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333434323336353229207b64657374726f795f6761726261676528626172746572746f776e2e706f6c653232293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.ferm', 'bartertown', 'a:6:{s:4:"name";s:10:"Ферма";s:4:"info";s:355:"Это ферма, здесь стоит какой-то покореженный домик и довольно вну??ительное поле с кукурузой. К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света";s:5:"fight";s:2:"no";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', NULL, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32373a22d093d0bbd0b0d0b2d0bdd18bd0b920d182d0bed0bdd0b5d0bbd18c223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657430223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a383a22d09fd0bed0bbd0b5223b733a363a22746172676574223b733a31363a22626172746572746f776e2e706f6c6531223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a31303a22d097d0b0d0b3d0bed0bd223b733a363a22746172676574223b733a32303a22626172746572746f776e2e6b6f726f766e696b31223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a31323a22d0a4d0b5d180d0bcd0b5d180223b733a343a22696e666f223b733a3131373a22d09fd0bed0b6d0b8d0bbd0bed0b920d0bcd183d0b6d0b8d0ba20d0b220d181d182d0b0d180d0bed0b920d0bfd0bed182d180d0b5d0bfd0b0d0bdd0bdd0bed0b920d0bad0b5d0bfd0bad0b52e20d095d181d18220d182d183d188d0b5d0bdd0bdd183d18e20d0bad183d0bad183d180d183d0b7d183223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a31363a22626172746572746f776e6665726d6572223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('bartertown.pole31', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 3-1";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0b2d0bed181d182d0bed0ba223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653332223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a393a22d09dd0b020d18ed0b3223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653231223b7d7d, 0x613a313a7b693a303b613a373a7b733a343a226e616d65223b733a33353a22d09ed181d0bcd0bed182d180d0b5d182d18cd181d18f20d0b2d0bed0bad180d183d0b3223b733a343a22696e666f223b733a35313a22d09dd0b5d18220d0bbd0b820d187d0b5d0b3d0be2c20d187d182d0be20d0bfd0bbd0bed185d0be20d0bbd0b5d0b6d0b8d1823f223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a383a226f6e5f656e746572223b733a3130333a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28322c312c246f626a5f6c6973745b24695d2c30293b246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2833302c312c246f626a5f6c6973745b24695d2c353030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373536303935393b7d7d),
('bartertown.pole32', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 3-2";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0b2d0bed181d182d0bed0ba223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653333223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d0b7d0b0d0bfd0b0d0b4223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653331223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a393a22d09dd0b020d18ed0b3223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653232223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333438353839353829207b64657374726f795f6761726261676528626172746572746f776e2e706f6c653332293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.pole23', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 2-3";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d181d0b5d0b2d0b5d180223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653333223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d0b7d0b0d0bfd0b0d0b4223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653232223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a393a22d09dd0b020d18ed0b3223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653133223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36303a226966202874696d6528293e3132333438313133313129207b64657374726f795f6761726261676528626172746572746f776e2e706f6c653233293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.pole13', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 1-3";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d181d0b5d0b2d0b5d180223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653233223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d0b7d0b0d0bfd0b0d0b4223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653132223b7d7d, 0x613a313a7b693a303b613a373a7b733a343a226e616d65223b733a33353a22d09ed181d0bcd0bed182d180d0b5d182d18cd181d18f20d0b2d0bed0bad180d183d0b3223b733a343a22696e666f223b733a35353a22d09dd0b5d18220d0bbd0b820d0bdd0b8d187d0b5d0b3d0be2c20d187d182d0be20d0bfd0bbd0bed185d0be20d0bbd0b5d0b6d0b8d1823f223b733a343a2274797065223b733a333a22626167223b733a363a22737461747573223b733a303a22223b733a383a226f6e5f656e746572223b733a35333a22246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a2833302c322c246f626a5f6c6973745b24695d2c353030293b223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233373534373131313b7d7d),
('bartertown.pole21', 'bartertown', 'a:6:{s:4:"name";s:12:"Поле 2-1";s:4:"info";s:186:"К потолку полости приделанна какая-то специальная лампа. Наверное чтобы урожай не загнулся без света.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"200";s:5:"light";s:7:"forever";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d181d0b5d0b2d0b5d180223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653331223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31373a22d09dd0b020d0b2d0bed181d182d0bed0ba223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653232223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a393a22d09dd0b020d18ed0b3223b733a363a22746172676574223b733a31363a22626172746572746f776e2e706f6c6531223b7d7d, ''),
('bartertown.street0', 'bartertown', 'a:6:{s:4:"name";s:27:"Главный тунель";s:4:"info";s:167:"Главный тунель Бартертауна. Ниже находятся Главная площадь, Лаборатория, Госпиталь, Свалка";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32363a22d092d0bdd0b8d0b720d0bfd0be20d182d183d0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6d61696e223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31303a22d0a4d0b5d180d0bcd0b0223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6665726d223b7d7d, NULL),
('bartertown.esk', 'bartertown', 'a:6:{s:4:"name";s:18:"Эскалатор";s:4:"info";s:71:"Длинный эскалатор. Ведет далеко наверх";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33323a22d09fd0bed0b4d0bdd18fd182d18cd181d18f20d0bfd0be20d0bdd0b5d0bcd183223b733a363a22746172676574223b733a31353a22626172746572746f776e2e65736b32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31333a22d09220d0b3d0bed180d0bed0b4223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6d61696e223b7d7d, NULL),
('bartertown.esk2', 'bartertown', 'a:6:{s:4:"name";s:18:"Эскалатор";s:4:"info";s:366:"Длинный эскалатор. Ведет далеко вниз. Вы надеялись подняться на поверхность, однако выход крепко заколочен. Табличка гласит: Выход закрыт администрацией Бартертауна в целях безопасности его граждан.";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32393a22d0a1d0bfd183d181d182d0b8d182d18cd181d18f20d0b2d0bdd0b8d0b7223b733a363a22746172676574223b733a31343a22626172746572746f776e2e65736b223b7d7d, NULL),
('bartertown.korovnik1', 'bartertown', 'a:6:{s:4:"name";s:41:"Загон для скота начало";s:4:"info";s:57:"Здесь фермеры держут свой скот.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"50";s:5:"loc_y";s:2:"50";s:5:"light";s:7:"forever";}', 0x613a323a7b693a303b613a34343a7b733a323a226964223b733a363a226272616d696e223b733a31343a22706572696f645f7265737061776e223b733a323a223333223b733a373a227265737061776e223b693a313233383134313837333b733a343a226e616d65223b733a32373a22d09ad180d183d0bfd0bdd18bd0b920d091d180d0b0d0bcd0b8d0bd223b733a343a22696e666f223b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223335223b733a353a226d61786870223b643a34303b733a323a226f64223b733a313a2234223b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2235223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2230223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a363a226272616d696e223b693a313b733a31323a22d091d180d0b0d0bcd0b8d0bd223b693a323b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b693a333b733a323a223335223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a363a226e6f726d616c223b693a383b733a313a2235223b693a393b733a313a2230223b693a31303b733a313a2230223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a32303b733a313a2279223b693a31313b7d693a313b613a34343a7b733a323a226964223b733a373a2273746f726f7a68223b733a31343a22706572696f645f7265737061776e223b733a333a22363030223b733a373a227265737061776e223b693a313233373536303435303b733a343a226e616d65223b733a31323a22d0a1d182d0bed180d0bed0b6223b733a343a22696e666f223b733a32383a22d0a7d182d0be2dd182d0be20d0bed185d180d0b0d0bdd18fd0b5d182223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b643a33383b733a353a226d61786870223b733a323a223630223b733a323a226f64223b693a353b733a353a226d61786f64223b733a313a2235223b733a31313a22637269745f6368616e6365223b733a323a223135223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2238223b733a373a22706174726f6e73223b693a383b733a31303a226d6178706174726f6e73223b733a323a223130223b733a383a22626f6e7573646578223b733a323a223230223b733a353a226d65646963223b733a313a2233223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a33363a226c6f6f742824706c617965725b6c6f635f69645d2c33332c31302c36302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a373a2273746f726f7a68223b693a313b733a31323a22d0a1d182d0bed180d0bed0b6223b693a323b733a32383a22d0a7d182d0be2dd182d0be20d0bed185d180d0b0d0bdd18fd0b5d182223b693a333b733a323a223630223b693a343b733a313a2233223b693a353b733a313a2235223b693a363b733a323a223135223b693a373b733a363a226e6f726d616c223b693a383b733a313a2238223b693a393b733a323a223130223b693a31303b733a323a223230223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a33363a226c6f6f742824706c617965725b6c6f635f69645d2c33332c31302c36302b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a31303b733a313a2279223b693a33313b7d7d, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09dd0b020d184d0b5d180d0bcd183223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6665726d223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33313a22d092d0b3d0bbd183d0b1d18c20d0bad0bed180d0bed0b2d0bdd0b8d0bad0b0223b733a363a22746172676574223b733a32303a22626172746572746f776e2e6b6f726f766e696b32223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36333a226966202874696d6528293e3132333736313938343529207b64657374726f795f6761726261676528626172746572746f776e2e6b6f726f766e696b31293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('bartertown.korovnik2', 'bartertown', 'a:6:{s:4:"name";s:47:"Загон для скота - середина";s:4:"info";s:57:"Здесь фермеры держут свой скот.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"50";s:5:"loc_y";s:2:"50";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a32303a22626172746572746f776e2e6b6f726f766e696b31223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33313a22d092d0b3d0bbd183d0b1d18c20d0bad0bed180d0bed0b2d0bdd0b8d0bad0b0223b733a363a22746172676574223b733a32303a22626172746572746f776e2e6b6f726f766e696b33223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36333a226966202874696d6528293e3133313132363132343929207b64657374726f795f6761726261676528626172746572746f776e2e6b6f726f766e696b32293b7d223b733a333a22626167223b613a313a7b693a303b613a31313a7b693a303b733a323a223334223b733a323a226964223b733a323a223334223b693a313b733a343a226d697363223b733a343a2274797065223b733a343a226d697363223b693a323b733a31303a22d09dd0b0d0b2d0bed0b7223b733a343a226e616d65223b733a31303a22d09dd0b0d0b2d0bed0b7223b693a333b733a3133333a22d09ad0b0d0bb20d0b6d0b8d0b2d0bed182d0bdd18bd1852e20d09fd0b0d187d0bad0b0d0b5d182d181d18f20d0b820d0bfd0bbd0bed185d0be20d0bfd0b0d185d0bdd0b5d1822e20d097d0b0d187d0b5d0bc20d0b5d0b3d0be20d0b1d180d0b0d182d18c20d0b820d182d0b0d181d0bad0b0d182d18c20d18120d181d0bed0b1d0bed0b93f223b733a343a22696e666f223b733a3133333a22d09ad0b0d0bb20d0b6d0b8d0b2d0bed182d0bdd18bd1852e20d09fd0b0d187d0bad0b0d0b5d182d181d18f20d0b820d0bfd0bbd0bed185d0be20d0bfd0b0d185d0bdd0b5d1822e20d097d0b0d187d0b5d0bc20d0b5d0b3d0be20d0b1d180d0b0d182d18c20d0b820d182d0b0d181d0bad0b0d182d18c20d18120d181d0bed0b1d0bed0b93f223b693a343b733a36353a22613a333a7b733a363a226f6e5f757365223b733a303a22223b733a343a2263656e61223b733a313a2231223b733a353a226d61737361223b733a313a2231223b7d223b733a31303a2261626f75745f6974656d223b613a333a7b733a363a226f6e5f757365223b733a303a22223b733a343a2263656e61223b733a313a2231223b733a353a226d61737361223b733a313a2231223b7d733a353a22636f6c766f223b693a323b7d7d7d7d),
('bartertown.korovnik3', 'bartertown', 'a:6:{s:4:"name";s:41:"Загон для скота - конец";s:4:"info";s:57:"Здесь фермеры держут свой скот.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"50";s:5:"loc_y";s:2:"50";s:5:"light";s:7:"forever";}', 0x613a333a7b693a303b613a34343a7b733a323a226964223b733a363a226272616d696e223b733a31343a22706572696f645f7265737061776e223b733a323a223630223b733a373a227265737061776e223b693a313331313236303630373b733a343a226e616d65223b733a32373a22d09ad180d183d0bfd0bdd18bd0b920d091d180d0b0d0bcd0b8d0bd223b733a343a22696e666f223b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b733a363a22737461747573223b733a343a2264656164223b733a31303a226869745f706f696e7473223b643a303b733a353a226d61786870223b643a34313b733a323a226f64223b693a363b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2235223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2230223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a363a226272616d696e223b693a313b733a31323a22d091d180d0b0d0bcd0b8d0bd223b693a323b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b693a333b733a323a223335223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a363a226e6f726d616c223b693a383b733a313a2235223b693a393b733a313a2230223b693a31303b733a313a2230223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a2d313b733a313a2279223b693a373b7d693a313b613a34343a7b733a323a226964223b733a363a226272616d696e223b733a31343a22706572696f645f7265737061776e223b733a323a223630223b733a373a227265737061776e223b693a313331313236303631363b733a343a226e616d65223b733a32353a22d0a1d0bbd0b0d0b1d18bd0b920d091d180d0b0d0bcd0b8d0bd223b733a343a22696e666f223b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223335223b733a353a226d61786870223b733a323a223335223b733a323a226f64223b733a313a2234223b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b643a333b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2230223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a363a226272616d696e223b693a313b733a31323a22d091d180d0b0d0bcd0b8d0bd223b693a323b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b693a333b733a323a223335223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a363a226e6f726d616c223b693a383b733a313a2235223b693a393b733a313a2230223b693a31303b733a313a2230223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a313b733a313a2279223b693a313b7d693a323b613a34343a7b733a323a226964223b733a363a226272616d696e223b733a31343a22706572696f645f7265737061776e223b733a323a223630223b733a373a227265737061776e223b693a313331313236303131383b733a343a226e616d65223b733a32373a22d09ad180d0b5d0bfd0bad0b8d0b920d091d180d0b0d0bcd0b8d0bd223b733a343a22696e666f223b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223335223b733a353a226d61786870223b733a323a223335223b733a323a226f64223b733a313a2234223b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a363a226e6f726d616c223b733a363a2264616d616765223b733a313a2235223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2230223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b643a363b733a393a22726573706c617a6d61223b643a363b733a373a22726573626f6f6d223b643a363b733a373a22726573766f6c74223b643a363b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a363a226272616d696e223b693a313b733a31323a22d091d180d0b0d0bcd0b8d0bd223b693a323b733a3131303a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d0b4d0b2d183d18520d0b3d0bed0bbd0bed0b2d18bd0b920d0b1d18bd0ba2e20d09fd0bed0b4d0bfd183d181d0bad0b0d0b5d18220d0ba20d181d0b5d0b1d0b520d182d0bed0bbd18cd0bad0be20d185d0bed0b7d18fd0b8d0bdd0b02e223b693a333b733a323a223335223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a363a226e6f726d616c223b693a383b733a313a2235223b693a393b733a313a2230223b693a31303b733a313a2230223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a33353a226c6f6f742824706c617965725b6c6f635f69645d2c33342c322c37302b24706572293b223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a313b733a313a2279223b693a313b7d7d, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31343a22d09ed0b1d180d0b0d182d0bdd0be223b733a363a22746172676574223b733a32303a22626172746572746f776e2e6b6f726f766e696b32223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36333a226966202874696d6528293e3133313132363037313329207b64657374726f795f6761726261676528626172746572746f776e2e6b6f726f766e696b33293b7d223b733a333a22626167223b613a313a7b693a303b613a31313a7b693a303b733a323a223334223b733a323a226964223b733a323a223334223b693a313b733a343a226d697363223b733a343a2274797065223b733a343a226d697363223b693a323b733a31303a22d09dd0b0d0b2d0bed0b7223b733a343a226e616d65223b733a31303a22d09dd0b0d0b2d0bed0b7223b693a333b733a3133333a22d09ad0b0d0bb20d0b6d0b8d0b2d0bed182d0bdd18bd1852e20d09fd0b0d187d0bad0b0d0b5d182d181d18f20d0b820d0bfd0bbd0bed185d0be20d0bfd0b0d185d0bdd0b5d1822e20d097d0b0d187d0b5d0bc20d0b5d0b3d0be20d0b1d180d0b0d182d18c20d0b820d182d0b0d181d0bad0b0d182d18c20d18120d181d0bed0b1d0bed0b93f223b733a343a22696e666f223b733a3133333a22d09ad0b0d0bb20d0b6d0b8d0b2d0bed182d0bdd18bd1852e20d09fd0b0d187d0bad0b0d0b5d182d181d18f20d0b820d0bfd0bbd0bed185d0be20d0bfd0b0d185d0bdd0b5d1822e20d097d0b0d187d0b5d0bc20d0b5d0b3d0be20d0b1d180d0b0d182d18c20d0b820d182d0b0d181d0bad0b0d182d18c20d18120d181d0bed0b1d0bed0b93f223b693a343b733a36353a22613a333a7b733a363a226f6e5f757365223b733a303a22223b733a343a2263656e61223b733a313a2231223b733a353a226d61737361223b733a313a2231223b7d223b733a31303a2261626f75745f6974656d223b613a333a7b733a363a226f6e5f757365223b733a303a22223b733a343a2263656e61223b733a313a2231223b733a353a226d61737361223b733a313a2231223b7d733a353a22636f6c766f223b693a363b7d7d7d7d),
('dop.part6a', 'bartertown', 'a:6:{s:4:"name";s:30:"Малый ход часть 5";s:4:"info";s:44:"Узкая нора. Кто ее вырыл?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32323a22d09a20d0bad0bed0bdd186d18320d185d0bed0b4d0b0223b733a363a22746172676574223b733a31303a22646f702e706172743761223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32343a22d09a20d0bdd0b0d187d0b0d0bbd18320d185d0bed0b4d0b0223b733a363a22746172676574223b733a31303a22646f702e706172743561223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333439353433333229207b64657374726f795f6761726261676528646f702e706172743661293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part5a', 'bartertown', 'a:6:{s:4:"name";s:30:"Малый ход часть 4";s:4:"info";s:36:"Кто прорыл эту нору?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32323a22d09a20d0bad0bed0bdd186d18320d185d0bed0b4d0b0223b733a363a22746172676574223b733a31303a22646f702e706172743661223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32343a22d09a20d0bdd0b0d187d0b0d0bbd18320d185d0bed0b4d0b0223b733a363a22746172676574223b733a31303a22646f702e706172743461223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333736313231363229207b64657374726f795f6761726261676528646f702e706172743561293b7d223b733a333a22626167223b4e3b7d7d),
('dop.part7a', 'bartertown', 'a:6:{s:4:"name";s:30:"Малый ход часть 6";s:4:"info";s:59:"Нора, прорытая каким-то животным";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31333a22d098d0b720d0bdd0bed180d18b223b733a363a22746172676574223b733a31373a22626172746572746f776e2e706f6c653333223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d092d0b3d0bbd183d0b1d18c20d0bdd0bed180d18b223b733a363a22746172676574223b733a31303a22646f702e706172743661223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333532313831323229207b64657374726f795f6761726261676528646f702e706172743761293b7d223b733a333a22626167223b4e3b7d7d),
('bankmain', 'bartertown', 'a:6:{s:4:"name";s:8:"Банк";s:4:"info";s:58:"Муниципальный банк Бартертауна";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31323a22d09dd0b0d180d183d0b6d183223b733a363a22746172676574223b733a31353a22626172746572746f776e2e6d61696e223b7d7d, 0x613a323a7b693a303b613a353a7b733a343a226e616d65223b733a31323a22d091d0b0d0bdd0bad0b8d180223b733a343a22696e666f223b733a3231313a22d09fd180d0b8d0bbd0b8d0b7d0b0d0bdd0bdd18bd0b92c20d185d0bed180d0bed188d0be20d0bed0b4d0b5d182d18bd0b920d0bcd0bed0bbd0bed0b4d0bed0b920d187d0b5d0bbd0bed0b2d0b5d0ba2e20d09ed0b1d18bd187d0bdd0be20d182d0b0d0bad0bed0b3d0be20d185d0bed187d0b5d182d181d18f20d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bbd18cd0bad0be20d0b8d0b72dd0b7d0b020d182d0bed0b3d0be2c20d187d182d0be20d0bed0bd20d0bed0b4d0b5d18220d0bbd183d187d188d0b520d0b2d181d0b5d1852e223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a31373a22626172746572746f776e2e62616e6b6972223b7d733a383a226f6e5f656e746572223b733a303a22223b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35313a226966202874696d6528293e3132333335373233373229207b64657374726f795f676172626167652862616e6b6d61696e293b7d223b733a333a22626167223b4e3b7d7d),
('seratown.main', 'seratown', 'a:6:{s:4:"name";s:27:"Серная станция";s:4:"info";s:102:"По названию понятно - в этой части метро производят серу";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32333a22d0a1d0b5d180d0bdd0b0d18f20d188d0b0d185d182d0b0223b733a363a22746172676574223b733a393a22736572612e6d696e65223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a34313a22d09220d182d0bed0bdd0b5d0bbd18c20d0ba20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31313a22746f73657261746f776e37223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a34313a22d09220d182d0bed0bdd0bdd0b5d0bbd18c20d0ba20d09cd0bed0b3d0b8d0bbd18cd0bdd0b8d0bad183223b733a363a22746172676574223b733a383a22746f677261766531223b7d7d, 0x613a323a7b693a303b613a353a7b733a343a226e616d65223b733a31363a22d09ed185d180d0b0d0bdd0bdd0b8d0ba223b733a343a22696e666f223b733a36353a22d0a1d182d180d0b0d0bdd0bdd18bd0b920d182d0b8d0bf2c20d181d182d0bed0b8d1822c20d0bdd0b020d0b2d181d0b5d18520d181d0bcd0bed182d180d0b8d182223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a31303a22736572612e6775617264223b7d733a383a226f6e5f656e746572223b733a303a22223b7d693a313b613a383a7b733a343a226e616d65223b733a32373a22d0a2d0bed180d0b3d0bed0b2d0b5d18620d181d0b5d180d0bed0b9223b733a343a22696e666f223b733a37303a22d09dd0b0d0b2d0b5d180d0bdd0bed0b52c20d182d0bed180d0b3d0bed0b2d186d18b20d0b7d0b4d0b5d181d18c20d0bfd180d0bed0b4d0b0d18ed18220d181d0b5d180d1833f223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a323a7b733a363a2274616c6b6964223b733a31303a2262617274657274657374223b733a383a227570646d6f6e6579223b693a313233373536323237373b7d733a353a226d6f6e6579223b693a313030303b733a383a226f6e5f656e746572223b733a35353a22246f626a5f6c6973745b24695d3d7570646174655f6d6f6e65795f6f626a28246f626a5f6c6973745b24695d2c313030302c353030293b223b733a333a22626167223b733a303a22223b733a31303a2275706461746574696d65223b693a313233373536353434303b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('sera.firsrtshtrek1', 'seratown', 'a:6:{s:4:"name";s:27:"Первый ??трек 1/5";s:4:"info";s:103:"Первый дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09dd0b020d0b3d0bbd0b0d0b2d0bdd18bd0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b32223b7d7d, NULL),
('sera.firsrtshtrek2', 'seratown', 'a:6:{s:4:"name";s:27:"Первый ??трек 2/5";s:4:"info";s:103:"Первый дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b31223b7d7d, ''),
('sera.firsrtshtrek5', 'seratown', 'a:6:{s:4:"name";s:35:"Первый ??трек, конец";s:4:"info";s:103:"Первый дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d182d180d0b5d182d0b8d0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31313a22736572612e746869726432223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33323a22d09a20d0b3d0bbd0b0d0b2d0bdd0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b34223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.secondshtrek1', 'seratown', 'a:6:{s:4:"name";s:27:"Второй ??трек 1/7";s:4:"info";s:103:"Второй дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09dd0b020d0b3d0bbd0b0d0b2d0bdd18bd0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e32223b7d7d, ''),
('sera.secondshtrek2', 'seratown', 'a:6:{s:4:"name";s:27:"Второй ??трек 2/7";s:4:"info";s:103:"Второй дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b31223b7d7d, ''),
('sera.secondshtrek3', 'seratown', 'a:6:{s:4:"name";s:27:"Второй ??трек 3/7";s:4:"info";s:103:"Второй дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:7:"forever";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b34223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b32223b7d7d, ''),
('sera.firsrtshtrek3', 'seratown', 'a:6:{s:4:"name";s:41:"Первый ??трек, развилка";s:4:"info";s:103:"Первый дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:7:"forever";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b34223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b32223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a33373a22d09fd180d0bed0bcd0b5d0b6d183d182d0bed187d0bdd18bd0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31323a22736572612e73687472656b31223b7d7d, ''),
('sera.mine', 'seratown', 'a:6:{s:4:"name";s:23:"Серная ??ахта";s:4:"info";s:43:"Это вход в серную ??ахту.";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31393a22d09dd0b020d181d182d0b0d0bdd186d0b8d18e223b733a363a22746172676574223b733a31333a2273657261746f776e2e6d61696e223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31333a22d09220d188d0b0d185d182d183223b733a363a22746172676574223b733a31343a22736572612e7374766f6c6d61696e223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a31363a22d09ed185d180d0b0d0bdd0bdd0b8d0ba223b733a343a22696e666f223b733a3130373a22d0a1d0b8d0b4d0b8d18220d0bdd0b020d181d0bad0b0d0bcd0b5d0b9d0bad0b520d18320d0b2d185d0bed0b4d0b020d0bdd0b020d188d0b0d185d182d18320d0b820d0bfd0b5d180d0b5d181d187d0b8d182d18bd0b2d0b0d0b5d18220d0b2d18bd180d183d187d0bad183223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a31333a227365726167756172646d696e65223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.minemain4', 'seratown', 'a:6:{s:4:"name";s:37:"Главный ??трек, конец";s:4:"info";s:96:"Главный ??трек серной ??ахты. Здесь безопасно и светло";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', '', 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31303a22d09dd0b0d0b7d0b0d0b4223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e33223b7d7d, 0x613a323a7b693a303b613a353a7b733a343a226e616d65223b733a31363a22d09ed185d180d0b0d0bdd0bdd0b8d0ba223b733a343a22696e666f223b733a37303a22d092d0bdd183d188d0b8d182d0b5d0bbd18cd0bdd18bd0b920d0bcd183d0b6d0b8d0ba20d18120d180d183d0b6d18cd0b5d0bc20d0bdd0b0d0bfd0b5d180d0b5d0b2d0b5d181223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a31333a22736572616d696e656775617264223b7d733a383a226f6e5f656e746572223b733a303a22223b7d693a313b613a363a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a303a22223b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('sera.firsrtshtrek4', 'seratown', 'a:6:{s:4:"name";s:27:"Первый ??трек 4/5";s:4:"info";s:103:"Первый дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b35223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b33223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.minemain1', 'seratown', 'a:6:{s:4:"name";s:39:"Главный ??трек, начало";s:4:"info";s:96:"Главный ??трек серной ??ахты. Здесь безопасно и светло";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33313a22d09fd0bed0b4d0bdd18fd182d18cd181d18f20d0bdd0b0d0b2d0b5d180d185223b733a363a22746172676574223b733a31343a22736572612e7374766f6c6d61696e223b7d7d, 0x613a313a7b693a303b613a363a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a323a7b733a363a2274616c6b6964223b733a31313a22706179736572616d696e65223b733a343a2268617264223b733a323a223339223b7d733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.minemain3', 'seratown', 'a:6:{s:4:"name";s:43:"Главный ??трек, середина";s:4:"info";s:96:"Главный ??трек серной ??ахты. Здесь безопасно и светло";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', '', 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e34223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e32223b7d7d, 0x613a313a7b693a303b613a363a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b733a303a22223b733a353a226d6f6e6579223b733a323a223339223b733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.stvolmain', 'seratown', 'a:6:{s:4:"name";s:49:"Главный ствол серной ??ахты";s:4:"info";s:61:"Ведет вниз - в ??треки серной ??ахты";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"50";s:5:"loc_y";s:2:"50";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33383a22d0a1d0bfd183d181d182d0b8d182d18cd181d18f20d0ba20d188d182d180d0b5d0bad0b0d0bc223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e31223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d098d0b720d188d0b0d185d182d18b223b733a363a22746172676574223b733a393a22736572612e6d696e65223b7d7d, NULL),
('sera.minemain2', 'seratown', 'a:6:{s:4:"name";s:43:"Главный ??трек, развилка";s:4:"info";s:96:"Главный ??трек серной ??ахты. Здесь безопасно и светло";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', '', 0x613a343a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33313a22d09a20d0b2d18bd185d0bed0b4d18320d0b8d0b720d188d0b0d185d182d18b223b733a363a22746172676574223b733a31343a22736572612e6d696e656d61696e31223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d0bfd0b5d180d0b2d18bd0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b31223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a32383a22d092d0be20d0b2d182d0bed180d0bed0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b31223b7d7d, 0x613a313a7b693a303b613a363a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.third3', 'seratown', 'a:6:{s:4:"name";s:27:"Третий ??трек 3/7";s:4:"info";s:103:"Третий дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d09a20d0bdd0b0d187d0b0d0bbd18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726432223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09a20d0bad0bed0bdd186d18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726434223b7d7d, ''),
('sera.third2', 'seratown', 'a:6:{s:4:"name";s:27:"Третий ??трек 2/7";s:4:"info";s:103:"Третий дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d09a20d0bdd0b0d187d0b0d0bbd18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726431223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09220d0bfd0b5d180d0b2d18bd0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b35223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32363a22d09a20d0bad0bed0bdd186d18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726433223b7d7d, ''),
('sera.secondshtrek4', 'seratown', 'a:6:{s:4:"name";s:41:"Второй ??трек, развилка";s:4:"info";s:103:"Первый дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b35223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b33223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a33373a22d09fd180d0bed0bcd0b5d0b6d183d182d0bed187d0bdd18bd0b920d188d182d180d0b5d0ba223b733a363a22746172676574223b733a31323a22736572612e73687472656b34223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a34343a22d098d0b720d0bdd0b5d0b520d0bcd0bed0b6d0bdd0be20d0b4d0bed0b1d18bd182d18c20d181d0b5d180d183223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.secondshtrek5', 'seratown', 'a:6:{s:4:"name";s:27:"Второй ??трек 5/7";s:4:"info";s:103:"Первый дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b36223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b34223b7d7d, ''),
('sera.secondshtrek6', 'seratown', 'a:6:{s:4:"name";s:27:"Второй ??трек 6/7";s:4:"info";s:103:"Второй дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', '', 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d092d0b3d0bbd183d0b1d18c20d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b37223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a31353a22d09a20d0b2d18bd185d0bed0b4d183223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b35223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a34313a22d098d0b720d0bdd0b5d0b520d0b4d0bed0b1d18bd0b2d0b0d0b5d182d181d18f20d181d0b5d180d0b0223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('sera.secondshtrek7', 'seratown', 'a:6:{s:4:"name";s:27:"Второй ??трек 7/7";s:4:"info";s:103:"Второй дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, '', 0x613a323a7b693a303b613a353a7b733a343a226e616d65223b733a32333a22d0a1d0b5d180d0bdd0b0d18f20d188d0b0d185d182d0b0223b733a343a22696e666f223b733a39333a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b2e20d091d183d0b4d18cd182d0b520d0bed181d182d0bed180d0bed0b6d0bdd18b2c20d0b7d0b4d0b5d181d18c20d0bdd0b5d0b1d0b5d0b7d0bed0bfd0b0d181d0bdd0be223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a36313a226966202874696d6528293e3132333430333735393729207b64657374726f795f6761726261676528736572612e7365636f6e6473687472656b37293b7d223b733a333a22626167223b4e3b7d7d),
('sera.shtrek1', 'seratown', 'a:6:{s:4:"name";s:41:"Промежуточный ??трек 1/4";s:4:"info";s:88:"Промежуточный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33323a22d09ad0be20d0bfd0b5d180d0b2d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31383a22736572612e66697273727473687472656b33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33323a22d09ad0be20d0b2d182d0bed180d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31323a22736572612e73687472656b32223b7d7d, ''),
('sera.shtrek2', 'seratown', 'a:6:{s:4:"name";s:41:"Промежуточный ??трек 2/4";s:4:"info";s:88:"Промежуточный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0bfd0b5d180d0b2d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31323a22736572612e73687472656b31223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33323a22d09ad0be20d0b2d182d0bed180d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31323a22736572612e73687472656b33223b7d7d, ''),
('sera.shtrek3', 'seratown', 'a:6:{s:4:"name";s:41:"Промежуточный ??трек 3/4";s:4:"info";s:88:"Промежуточный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0bfd0b5d180d0b2d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31323a22736572612e73687472656b32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33323a22d09ad0be20d0b2d182d0bed180d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31323a22736572612e73687472656b34223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32333a22d0a1d0b5d180d0bdd0b0d18f20d188d0b0d185d182d0b0223b733a343a22696e666f223b733a32353a22d098d181d182d0bed187d0bdd0b8d0ba20d181d0b5d180d18b223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('sera.shtrek4', 'seratown', 'a:6:{s:4:"name";s:41:"Промежуточный ??трек 4/4";s:4:"info";s:88:"Промежуточный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0bfd0b5d180d0b2d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31323a22736572612e73687472656b33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33323a22d09ad0be20d0b2d182d0bed180d0bed0bcd18320d188d182d180d0b5d0bad183223b733a363a22746172676574223b733a31383a22736572612e7365636f6e6473687472656b34223b7d7d, ''),
('sera.third1', 'seratown', 'a:6:{s:4:"name";s:27:"Третий ??трек 1/7";s:4:"info";s:103:"Третий дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a313a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32363a22d09a20d0bad0bed0bdd186d18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726432223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d0a1d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a34313a22d098d0b720d0bdd0b5d0b520d0b4d0bed0b1d18bd0b2d0b0d0b5d182d181d18f20d181d0b5d180d0b0223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('sera.third4', 'seratown', 'a:6:{s:4:"name";s:27:"Третий ??трек 4/7";s:4:"info";s:103:"Третий дополнительный ??трек. Здесь водятся серные крысы";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d09a20d0bdd0b0d187d0b0d0bbd18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726433223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32363a22d09a20d0bad0bed0bdd186d18320d188d182d180d0b5d0bad0b0223b733a363a22746172676574223b733a31313a22736572612e746869726435223b7d7d, 0x613a313a7b693a303b613a363a7b733a343a226e616d65223b733a32313a22d181d0b5d180d0bdd0b0d18f20d0b6d0b8d0bbd0b0223b733a343a22696e666f223b733a34313a22d098d0b720d0bdd0b5d0b520d0b4d0bed0b1d18bd0b2d0b0d0b5d182d181d18f20d181d0b5d180d0b0223b733a343a2274797065223b733a343a226d696e65223b733a363a22737461747573223b613a313a7b733a343a2268617264223b733a323a223339223b7d733a353a226d6f6e6579223b733a303a22223b733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('toseratown7', 'seratown', 'a:6:{s:4:"name";s:16:"Тонель 7/7";s:4:"info";s:242:"Тонель между Бартертауном и серной станцией. На земле проходят рельсы, кажется под напряжением. Неужели кто-то еще пользуется метро?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31313a22746f73657261746f776e36223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31333a2273657261746f776e2e6d61696e223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333533383130343829207b64657374726f795f6761726261676528746f73657261746f776e37293b7d223b733a333a22626167223b4e3b7d7d),
('bartertown.per1', 'bartertown', 'a:6:{s:4:"name";s:12:"Перрон";s:4:"info";s:84:"Когда-то давно здесь останавливались поезда...";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', NULL, 0x613a333a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33383a22d09a20d186d0b5d0bdd182d180d18320d091d0b0d180d182d0b5d180d182d0b0d183d0bdd0b0223b733a363a22746172676574223b733a31383a22626172746572746f776e2e73747265657432223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a34363a22d09220d182d0bed0bdd0b5d0bbd18c20d0ba20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22746f73657261746f776e31223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a35323a22d09220d182d0bed0bdd0b5d0bbd18c20d0ba20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31303a2277656170746f6e656c31223b7d7d, 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);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('toseratown1', 'seratown', 'a:6:{s:4:"name";s:16:"Тонель 1/7";s:4:"info";s:242:"Тонель между Бартертауном и серной станцией. На земле проходят рельсы, кажется под напряжением. Неужели кто-то еще пользуется метро?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d0b1d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31353a22626172746572746f776e2e70657231223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22746f73657261746f776e32223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333536363931373729207b64657374726f795f6761726261676528746f73657261746f776e31293b7d223b733a333a22626167223b4e3b7d7d),
('toseratown2', 'seratown', 'a:6:{s:4:"name";s:16:"Тонель 2/7";s:4:"info";s:242:"Тонель между Бартертауном и серной станцией. На земле проходят рельсы, кажется под напряжением. Неужели кто-то еще пользуется метро?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31313a22746f73657261746f776e31223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22746f73657261746f776e33223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333734383239343429207b64657374726f795f6761726261676528746f73657261746f776e32293b7d223b733a333a22626167223b4e3b7d7d),
('toseratown3', 'seratown', 'a:6:{s:4:"name";s:16:"Тонель 3/7";s:4:"info";s:242:"Тонель между Бартертауном и серной станцией. На земле проходят рельсы, кажется под напряжением. Неужели кто-то еще пользуется метро?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31313a22746f73657261746f776e32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22746f73657261746f776e34223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333436373536373329207b64657374726f795f6761726261676528746f73657261746f776e33293b7d223b733a333a22626167223b4e3b7d7d),
('toseratown4', 'seratown', 'a:6:{s:4:"name";s:16:"Тонель 4/7";s:4:"info";s:242:"Тонель между Бартертауном и серной станцией. На земле проходят рельсы, кажется под напряжением. Неужели кто-то еще пользуется метро?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31313a22746f73657261746f776e33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22746f73657261746f776e35223b7d7d, ''),
('toseratown5', 'seratown', 'a:6:{s:4:"name";s:16:"Тонель 5/7";s:4:"info";s:242:"Тонель между Бартертауном и серной станцией. На земле проходят рельсы, кажется под напряжением. Неужели кто-то еще пользуется метро?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31313a22746f73657261746f776e34223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22746f73657261746f776e36223b7d7d, '');
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('toseratown6', 'seratown', 'a:6:{s:4:"name";s:16:"Тонель 6/7";s:4:"info";s:242:"Тонель между Бартертауном и серной станцией. На земле проходят рельсы, кажется под напряжением. Неужели кто-то еще пользуется метро?";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31313a22746f73657261746f776e35223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22746f73657261746f776e37223b7d7d, ''),
('weap.main', 'weapstation', 'a:6:{s:4:"name";s:33:"Станция Оружейная";s:4:"info";s:177:"На этой станции находится завод по производству оружия - в эти опасные времена вещь очень нужная!";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"10";s:5:"loc_y";s:2:"10";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a34313a22d09220d182d0bed0bdd0b5d0bbd18c20d0bdd0b020d091d0b0d180d182d0b5d180d182d0b0d183d0bd223b733a363a22746172676574223b733a31303a2277656170746f6e656c35223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a35363a22d09220d182d0bed0bdd0b5d0bbd18c20d0ba20d0b7d0b0d0b1d180d0bed188d0b5d0bdd0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31303a22646573312e746f6e656c223b7d7d, 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),
('weaptonel1', 'weapstation', 'a:6:{s:4:"name";s:16:"Тунель 1/5";s:4:"info";s:87:"Тунель между оружейной станцией и бартертауном";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31353a22626172746572746f776e2e70657231223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b9223b733a363a22746172676574223b733a31303a2277656170746f6e656c32223b7d7d, NULL);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('weaptonel2', 'weapstation', 'a:6:{s:4:"name";s:16:"Тунель 2/5";s:4:"info";s:87:"Тунель между оружейной станцией и бартертауном";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31303a2277656170746f6e656c31223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b9223b733a363a22746172676574223b733a31303a2277656170746f6e656c33223b7d7d, ''),
('weaptonel3', 'weapstation', 'a:6:{s:4:"name";s:16:"Тунель 3/5";s:4:"info";s:87:"Тунель между оружейной станцией и бартертауном";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31303a2277656170746f6e656c32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b9223b733a363a22746172676574223b733a31303a2277656170746f6e656c34223b7d7d, ''),
('weaptonel4', 'weapstation', 'a:6:{s:4:"name";s:16:"Тунель 4/5";s:4:"info";s:87:"Тунель между оружейной станцией и бартертауном";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 0x613a343a7b693a303b613a34343a7b733a323a226964223b733a373a22766f6c74726174223b733a31343a22706572696f645f7265737061776e223b733a333a22313131223b733a373a227265737061776e223b693a313233353134383935393b733a343a226e616d65223b733a33393a22d09ad180d0b5d0bfd0bad0b8d0b920d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b733a343a22696e666f223b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223330223b733a353a226d61786870223b733a323a223330223b733a323a226f64223b733a313a2234223b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a343a22766f6c74223b733a363a2264616d616765223b733a313a2238223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2235223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b643a363b733a393a22726573706c617a6d61223b643a363b733a373a22726573626f6f6d223b643a363b733a373a22726573766f6c74223b643a363b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a303a22223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a373a22766f6c74726174223b693a313b733a32343a22d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b693a323b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b693a333b733a323a223330223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a343a22766f6c74223b693a383b733a313a2238223b693a393b733a313a2230223b693a31303b733a313a2235223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a303a22223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a35313b733a313a2279223b693a33343b7d693a313b613a34343a7b733a323a226964223b733a373a22766f6c74726174223b733a31343a22706572696f645f7265737061776e223b733a333a22313131223b733a373a227265737061776e223b693a313233353138383630343b733a343a226e616d65223b733a32343a22d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b733a343a22696e666f223b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223330223b733a353a226d61786870223b733a323a223330223b733a323a226f64223b733a313a2234223b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a343a22766f6c74223b733a363a2264616d616765223b733a313a2238223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2235223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a303a22223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a373a22766f6c74726174223b693a313b733a32343a22d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b693a323b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b693a333b733a323a223330223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a343a22766f6c74223b693a383b733a313a2238223b693a393b733a313a2230223b693a31303b733a313a2235223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a303a22223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a38313b733a313a2279223b693a33393b7d693a323b613a34343a7b733a323a226964223b733a373a22766f6c74726174223b733a31343a22706572696f645f7265737061776e223b733a333a22313131223b733a373a227265737061776e223b693a313233343937333837323b733a343a226e616d65223b733a33393a22d09ad180d0b5d0bfd0bad0b8d0b920d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b733a343a22696e666f223b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b643a323b733a353a226d61786870223b733a323a223330223b733a323a226f64223b693a363b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a343a22766f6c74223b733a363a2264616d616765223b733a313a2238223b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2235223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b643a363b733a393a22726573706c617a6d61223b643a363b733a373a22726573626f6f6d223b643a363b733a373a22726573766f6c74223b643a363b733a383a22696e5f6669676874223b733a31323a22333730706c61796572313230223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a303a22223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a373a22766f6c74726174223b693a313b733a32343a22d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b693a323b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b693a333b733a323a223330223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a343a22766f6c74223b693a383b733a313a2238223b693a393b733a313a2230223b693a31303b733a313a2235223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a303a22223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a31373b733a313a2279223b693a33313b7d693a333b613a34343a7b733a323a226964223b733a373a22766f6c74726174223b733a31343a22706572696f645f7265737061776e223b733a333a22313131223b733a373a227265737061776e223b693a313233343937333837323b733a343a226e616d65223b733a33373a22d0a1d0bbd0b0d0b1d18bd0b920d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b733a343a22696e666f223b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b733a363a22737461747573223b733a343a226c696665223b733a31303a226869745f706f696e7473223b733a323a223330223b733a353a226d61786870223b733a323a223330223b733a323a226f64223b733a313a2234223b733a353a226d61786f64223b733a313a2234223b733a31313a22637269745f6368616e6365223b733a313a2235223b733a383a22747970655f646d67223b733a343a22766f6c74223b733a363a2264616d616765223b643a363b733a373a22706174726f6e73223b733a313a2230223b733a31303a226d6178706174726f6e73223b733a313a2230223b733a383a22626f6e7573646578223b733a313a2235223b733a353a226d65646963223b733a313a2230223b733a393a227265736e6f726d616c223b733a313a2235223b733a393a22726573706c617a6d61223b733a313a2235223b733a373a22726573626f6f6d223b733a313a2235223b733a373a22726573766f6c74223b733a313a2235223b733a383a22696e5f6669676874223b733a303a22223b733a373a2274696d656d6f64223b733a373a22666f7265766572223b733a363a226f6e5f646965223b733a303a22223b733a373a22636f6d616e6461223b733a383a226d6f6e7374657273223b693a303b733a373a22766f6c74726174223b693a313b733a32343a22d0add0bbd0b5d0bad182d180d0bed0bad180d18bd181d0b0223b693a323b733a3230393a22d090d0bad0bad0b0d0bcd183d0bbd18fd182d0bed18020d18120d185d0b2d0bed181d182d0b8d0bad0bed0bc2120d09fd0bed0b420d0b4d0b5d0b9d181d182d0b2d0b8d0b5d0bc20d0b2d18bd181d0bed0bad0bed0b3d0be20d0bdd0b0d0bfd180d18fd0b6d0b5d0bdd0b8d18f20d0bad180d18bd181d0b020d0bdd0b0d18dd0bbd0b5d0bad182d180d0bed0b7d0bed0b2d0b0d0bbd0b0d181d18c20d0b820d181d0b5d0b9d187d0b0d18120d0bcd0bed0b6d0b5d18220d183d0b4d0b0d180d0b8d182d18c20d182d0bed0bad0bed0bc21223b693a333b733a323a223330223b693a343b733a313a2230223b693a353b733a313a2234223b693a363b733a313a2235223b693a373b733a343a22766f6c74223b693a383b733a313a2238223b693a393b733a313a2230223b693a31303b733a313a2235223b693a31313b733a313a2235223b693a31323b733a313a2235223b693a31333b733a313a2235223b693a31343b733a313a2235223b693a31353b733a303a22223b693a31363b733a373a22666f7265766572223b733a313a2278223b693a39393b733a313a2279223b693a32363b7d7d, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d0b1d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31303a2277656170746f6e656c33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b9223b733a363a22746172676574223b733a31303a2277656170746f6e656c35223b7d7d, ''),
('weaptonel5', 'weapstation', 'a:6:{s:4:"name";s:16:"Тунель 5/5";s:4:"info";s:87:"Тунель между оружейной станцией и бартертауном";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"100";s:5:"loc_y";s:3:"100";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32353a22d09a20d091d0b0d180d182d0b5d180d182d0b0d183d0bdd183223b733a363a22746172676574223b733a31303a2277656170746f6e656c34223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32313a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b9223b733a363a22746172676574223b733a393a22776561702e6d61696e223b7d7d, ''),
('des1.main', 'des1station', 'a:6:{s:4:"name";s:37:"Забро??енная станция";s:4:"info";s:195:"Тут давно никто не живет, местные обитатели не люди, а тоннельная живность - в основном крысы и дикие собаки";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"150";s:5:"loc_y";s:3:"150";s:5:"light";s:5:"never";}', 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, 0x613a353a7b693a303b613a323a7b733a373a2263617074696f6e223b733a33363a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c35223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a32333a22d0a5d0b8d0b6d0b8d0bdd0b020d181d0bbd0b5d0b2d0b0223b733a363a22746172676574223b733a31313a22646573312e686f75736531223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a33333a22d0a5d0b8d0b6d0b8d0bdd0b020d0bfd0bed181d0b5d180d0b5d0b4d0b8d0bdd0b5223b733a363a22746172676574223b733a31313a22646573312e686f75736532223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a32353a22d0a5d0b8d0b6d0b8d0bdd0b020d181d0bfd180d0b0d0b2d0b0223b733a363a22746172676574223b733a31313a22646573312e686f75736533223b7d693a343b613a323a7b733a373a2263617074696f6e223b733a33303a22d092d0b2d0b5d180d18520d0bfd0be20d182d0bed0bdd0bdd0b5d0bbd18e223b733a363a22746172676574223b733a393a22646573312e68616c6c223b7d7d, 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);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('grave.main', 'gravestation', 'a:6:{s:4:"name";s:18:"Могильник";s:4:"info";s:122:"Ужасный трупный запах распространяется вокруг. Похоже на кладбище";s:5:"fight";s:2:"no";s:5:"loc_x";s:3:"123";s:5:"loc_y";s:3:"123";s:5:"light";s:5:"never";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a31383a22d09cd0bed0b3d0b8d0bbd18cd0bdd0b8d0ba223b733a363a22746172676574223b733a373a2267726176653131223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d09a20d0a1d0b5d180d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a383a22746f677261766535223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32373a22d093d183d0bbd18c2dd0bcd0bed0b3d0b8d0bbd18cd189d0b8d0ba223b733a343a22696e666f223b733a3233373a22d0a1d182d180d0b0d0bdd0bdd0bed0b520d181d183d189d0b5d181d182d0b2d0be2c20d0bfd0bed185d0bed0b6d0b520d0bdd0b020d187d0b5d0bbd0bed0b2d0b5d0bad0be2c20d0bed0b4d0bdd0b0d0bad0be20d182d0b0d0bad0bed0b520d185d183d0b4d0bed0b52c20d0b4d0b020d0b5d189d0b520d0bad0bed0b6d0b020d0bcd0b5d181d182d0b0d0bcd0b820d181d0bbd0b0d0b7d0b8d1822e2e2e20d091d0bed0bbd18cd188d0b520d0bfd0bed185d0bed0b620d0bdd0b020d182d0b8d0bfd0b8d187d0bdd0bed0b3d0be20d0b7d0bed0bcd0b1d0b820d0b8d0b720d184d0b8d0bbd18cd0bcd0bed0b2223b733a343a2274797065223b733a333a226e7063223b733a363a22737461747573223b613a313a7b733a363a2274616c6b6964223b733a393a226772617665676f756c223b7d733a383a226f6e5f656e746572223b733a303a22223b7d7d),
('des1.hall2', 'des1station', 'a:6:{s:4:"name";s:18:"Тоннель 3/4";s:4:"info";s:75:"Продолжение тоннеля забро??енной станции";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"300";s:5:"loc_y";s:2:"30";s:5:"light";s:5:"never";}', 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, 0x613a343a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d092d0bdd0b8d0b720d0bfd0be20d182d0bed0bdd0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31303a22646573312e68616c6c31223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d092d0b2d0b5d180d18520d0bfd0be20d182d0bed0bdd0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31303a22646573312e68616c6c33223b7d693a323b613a323a7b733a373a2263617074696f6e223b733a32333a22d0a5d0b8d0b6d0b8d0bdd0b020d181d0bbd0b5d0b2d0b0223b733a363a22746172676574223b733a31323a22646573312e686f7573653231223b7d693a333b613a323a7b733a373a2263617074696f6e223b733a32353a22d0a5d0b8d0b6d0b8d0bdd0b020d181d0bfd180d0b0d0b2d0b0223b733a363a22746172676574223b733a31323a22646573312e686f7573653232223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35333a226966202874696d6528293e3132333532323133323429207b64657374726f795f6761726261676528646573312e68616c6c32293b7d223b733a333a22626167223b4e3b7d7d),
('des1.hall', 'des1station', 'a:6:{s:4:"name";s:16:"Тонель 1/4";s:4:"info";s:189:"Когда-то это был главный тоннель этой станции, и здесь повсюду сновали люди. Когда-то давно, но не сейчас";s:5:"fight";s:3:"yes";s:5:"loc_x";s:3:"200";s:5:"loc_y";s:3:"150";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a32383a22d092d0bdd0b8d0b720d0bfd0be20d182d0bed0bdd0bdd0b5d0bbd18e223b733a363a22746172676574223b733a393a22646573312e6d61696e223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33303a22d092d0b2d0b5d180d18520d0bfd0be20d182d0bed0bdd0bdd0b5d0bbd18e223b733a363a22746172676574223b733a31303a22646573312e68616c6c31223b7d7d, 0x613a323a7b693a303b613a373a7b733a343a226e616d65223b733a383a22d0afd189d0b8d0ba223b733a343a22696e666f223b733a3134333a22d097d0b0d0bfd0b5d180d182d18bd0b920d18fd189d0b8d0ba2e20d092d0b8d0b4d0b8d0bcd0be20d0b5d0b3d0be20d0b2d0bbd0b0d0b4d0b5d0bbd0b5d18620d185d0bed182d0b5d0bb20d181d18ed0b4d0b020d0b2d0b5d180d0bdd183d182d18cd181d18f20d0bfd0bed0b7d0b6d0b520d0b820d0b7d0b0d0b1d180d0b0d182d18c20d0b4d0bed0b1d180d0be2e223b733a343a2274797065223b733a343a2273616665223b733a363a22737461747573223b613a333a7b733a343a2268617264223b733a323a223235223b733a373a2269735f6f70656e223b733a343a226c6f636b223b733a383a226c6173746861636b223b693a313233343839303431333b7d733a383a226f6e5f656e746572223b733a3238333a226966202828246f626a5f6c6973745b24695d5b7374617475735d5b6c6173746861636b5d2b32352a3630293e74696d65282929207b246f626a5f6c6973745b24695d5b7374617475735d5b6c6173746861636b5d3d74696d6528293b246f626a5f6c6973745b24695d5b7374617475735d5b69735f6f70656e5d3d636c6f73653b246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28342c36302c246f626a5f6c6973745b24695d2c30293b246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28392c332c246f626a5f6c6973745b24695d2c30293b246f626a5f6c6973745b24695d3d7570646174655f696e765f6f626a28372c312c246f626a5f6c6973745b24695d2c383030293b7d223b733a333a22626167223b4e3b733a31303a2275706461746574696d65223b693a313233343839303539323b7d693a313b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35323a226966202874696d6528293e3132333532303033383629207b64657374726f795f6761726261676528646573312e68616c6c293b7d223b733a333a22626167223b4e3b7d7d),
('des1.tonel', 'des1station', 'a:6:{s:4:"name";s:16:"Тонель 1/5";s:4:"info";s:120:"Старый тонель, ведущий к забро??енной станции. Тут редко кто ходит.";s:5:"fight";s:2:"no";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:7:"forever";}', NULL, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a34303a22d09a20d0b7d0b0d0b1d180d0bed188d0b5d0bdd0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c32223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33363a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a393a22776561702e6d61696e223b7d7d, NULL),
('des1.tonel2', 'des1station', 'a:6:{s:4:"name";s:16:"Тонель 2/5";s:4:"info";s:120:"Старый тонель, ведущий к забро??енной станции. Тут редко кто ходит.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a34303a22d09a20d0b7d0b0d0b1d180d0bed188d0b5d0bdd0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c33223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33363a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31303a22646573312e746f6e656c223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333439373833383629207b64657374726f795f6761726261676528646573312e746f6e656c32293b7d223b733a333a22626167223b4e3b7d7d);
//=====================================//
INSERT INTO `conclave_locations` (`loc_id`, `zone`, `loc_option`, `monstr_list`, `door_list`, `obj_list`) VALUES
('des1.tonel3', 'des1station', 'a:6:{s:4:"name";s:16:"Тонель 3/5";s:4:"info";s:120:"Старый тонель, ведущий к забро??енной станции. Тут редко кто ходит.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:3:"150";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a34303a22d09a20d0b7d0b0d0b1d180d0bed188d0b5d0bdd0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c34223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33363a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c32223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333439363531333829207b64657374726f795f6761726261676528646573312e746f6e656c33293b7d223b733a333a22626167223b4e3b7d7d),
('des1.tonel4', 'des1station', 'a:6:{s:4:"name";s:16:"Тонель 4/5";s:4:"info";s:120:"Старый тонель, ведущий к забро??енной станции. Тут редко кто ходит.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:2:"15";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a34303a22d09a20d0b7d0b0d0b1d180d0bed188d0b5d0bdd0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c35223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33363a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c33223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333439393438363129207b64657374726f795f6761726261676528646573312e746f6e656c34293b7d223b733a333a22626167223b4e3b7d7d),
('des1.tonel5', 'des1station', 'a:6:{s:4:"name";s:16:"Тонель 5/5";s:4:"info";s:120:"Старый тонель, ведущий к забро??енной станции. Тут редко кто ходит.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"15";s:5:"loc_y";s:3:"150";s:5:"light";s:5:"never";}', 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, 0x613a323a7b693a303b613a323a7b733a373a2263617074696f6e223b733a34303a22d09a20d0b7d0b0d0b1d180d0bed188d0b5d0bdd0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a393a22646573312e6d61696e223b7d693a313b613a323a7b733a373a2263617074696f6e223b733a33363a22d09a20d09ed180d183d0b6d0b5d0b9d0bdd0bed0b920d181d182d0b0d0bdd186d0b8d0b8223b733a363a22746172676574223b733a31313a22646573312e746f6e656c34223b7d7d, 0x613a313a7b693a303b613a353a7b733a343a226e616d65223b733a32313a22d092d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a22696e666f223b733a35383a22d09fd0bed0b420d0bdd0bed0b3d0b0d0bcd0b820d0b2d0b0d0bbd18fd0b5d182d181d18f20d0b2d181d18fd0bad0b8d0b920d185d0bbd0b0d0bc223b733a343a2274797065223b733a373a2267617262616765223b733a383a226f6e5f656e746572223b733a35343a226966202874696d6528293e3132333531393234383029207b64657374726f795f6761726261676528646573312e746f6e656c35293b7d223b733a333a22626167223b4e3b7d7d),
('des1.house1', 'des1station', 'a:6:{s:4:"name";s:12:"Хижина";s:4:"info";s:92:"Старая, покинутая хижина. Когда-то здесь жили люди.";s:5:"fight";s:3:"yes";s:5:"loc_x";s:2:"30";s:5:"loc_y";s:2:"40";s:5:"light";s:5:"never";}', 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