<?php
/*
//////////////////////////////////////////////////////////////////////////////////
//+----------------------------------------------------------------------------+//
//|                ...:::Класс обработки BBCODE ТЭГОВ:::...                    |//
//+----------------------------------------------------------------------------+//
//| Автор: Саид aka SunRise,                                                   |//
//| Контакты: http://www.XSCLUB.ru/, ICQ - 9109495.                            |//
//+----------------------------------------------------------------------------+//                                                                   |
//| При использовании и модификации класса, наличие данного инфо блока         |//
//| обязательно!!!                                                             |//
//|                                                                            |//
//| Методы класса:                                                             |//
//| 	ADD('TEXT') - Обработка тэгов в тексте;                                |//
//| 	DEL('TEXT') - Удаление тэгов из текста;                                |//
//| 	IMG_TEST('TEXT') - Метод теста валидности изображения. Данным          |//
//|                        методом стоит обрабатывать текст поступающий на     |//
//|                        запись в БАЗУ ДАННЫХ.                               |//
//|                                                                            |//
//| Свойства класса:                                                           |//
//|		user - информация о пользователе для тэга HIDE (Статическое свойство)  |//
//+----------------------------------------------------------------------------+//
//| Пример использования класса:                                               |//
//|   +------------------------------------------------------------------+     |//
//|   | <?php                                                            |     |//
//|	  |	//Подключение класса                                             |     |//
//|   |    	require_once "BBCODE.php";                                   |     |//
//|   |    	BBCODE::$user = $user_id ? true : false;                     |     |//
//|   |     	                                                         |     |//
//|   | //Вариант 1                                                      |     |//
//|   | 	$object = new BBCODE($some_text);                            |     |//
//|   | 	echo $object; // Вывод обработанного текста                  |     |//
//|   |                                                                  |     |//
//|   | //Вариант 2                                                      |     |//
//|   | 	$object = new BBCODE;                                        |     |//
//|   | 	echo $object->ADD($some_text); // Вывод обработанного текста |     |//
//|   |                                                                  |     |//
//|   | //Вариант 3                                                      |     |//
//|   | 	echo BBCODE::ADD($some_text); // Вывод обработанного текста  |     |//
//|   | ?>                                                               |     |//
//|   +------------------------------------------------------------------+     |//
//|                                                                            |//
//+----------------------------------------------------------------------------+//
//| ТЭГИ:                                                                      |//
//| [color=...]...[/color] - цвет текста                                       |//
//| [sub]...[/sub] - подстрочный текст                                         |//
//| [sup]...[/sup] - надстрочный текст                                         |//
//| [left]...[/left] - выравнивание текста по левому краю                      |//
//| [right]...[/right] - выравнивание текста по правому краю                   |//
//| [center]...[/center] - выравнивание текста по центру                       |//
//| [justify]...[/justify] - равносторонее выравнивание текста                 |//
//| [*]...[/*] - аналог тэгов <li>...</li>                                     |//
//| [fieldset=...]...[/fieldset] - текстовое поле с заголовком аналог          |//
//| 							   тэга <fieldset>...</fieldset>               |//
//| [b]...[/b] - жирный текст                                                  |//
//| [s]...[/s] - зачеркнутый                                                   |//
//| [q]...[/q] - цитата                                                        |//
//| [u]...[/u] - подчеркнутый                                                  |//
//| [i]...[/i] - наклонный                                                     |//
//| [hr] - разделительная черта                                                |//
//| [url=...]...[/url] - именованная ссылка                                    |//
//| [img=...x...]...[/img] - изображение с заданием размера                    |//
//| [flash=...x...][/flash] - флеш-анимация с заданием размера				   |//
//| [hide]...[/hide] - скрытый текст              							   |//
//+----------------------------------------------------------------------------+//
//////////////////////////////////////////////////////////////////////////////////
*/
class BBCODE {
	/**
	 * Класс обработки BBCODE тэгов
	 */
    public static $user = false;
	private static $text;
	public function __construct($text = "")
	{
    	self::$text = $this->ADD($text);
	}
	public function __destruct()
	{
		/**
		 * ...... Destructor ......
		 */
	}
	private function __toString()
	{
		return self::$text;
	}
	public function __get($var)
	{
		echo "Обращение к несуществующему свойству \"$var\"!!!";
	}
	public function __set($var, $val)
	{
		echo "Попытка установить к несуществующему свойству \"$var\" значения \"$val\"!!!";
	}
	public function __call($func, $args)
	{
		echo "Обращение к несуществующему методу \"$func\"!!!";
	}
	final public function ADD($text = "")
	{
		/**
     	 * Обработка BBCODE
     	 */
   		$color = 'Maroon|DarkRed|FireBrick|Red|Salmon|Tomato|Coral|'
		. 'OrangeRed|Chocolate|SandyBrown|DarkOrange|Orange|DarkGoldenrod|Goldenrod|Gold|Olive|Yellow|YellowGreen|'
		. 'GreenYellow|Chartreuse|LawnGreen|Green|Lime|LimeGreen|SpringGreen|MediumSpringGreen|Turquoise|LightSeaGreen|'
		. 'MediumTurquoise|Teal|DarkCyan|Aqua|Cyan|DarkTurquoise|DeepSkyBlue|DodgerBlue|RoyalBlue|Navy|DarkBlue|'
		. 'MediumBlue|Blue|BlueViolet|DarkOrchid|DarkViolet|Purple|DarkMagenta|Fuchsia|Magenta|MediumVioletRed|DeepPink|'
		. 'HotPink|Crimson|Brown|IndianRed|RosyBrown|LightCoral|Snow|MistyRose|DarkSalmon|LightSalmon|Sienna|'
		. 'SeaShell|SaddleBrown|Peachpuff|Peru|Linen|Bisque|Burlywood|Tan|AntiqueWhite|NavajoWhite|BlanchedAlmond|'
		. 'PapayaWhip|Moccasin|Wheat|Oldlace|FloralWhite|Cornsilk|Khaki|LemonChiffon|PaleGoldenrod|DarkKhaki|Beige|'
		. 'LightGoldenrodYellow|LightYellow|Ivory|OliveDrab|DarkOliveGreen|DarkSeaGreen|DarkGreen|ForestGreen|LightGreen|'
		. 'PaleGreen|Honeydew|SeaGreen|MediumSeaGreen|Mintcream|MediumAquamarine|Aquamarine|DarkSlateGray|PaleTurquoise|'
		. 'LightCyan|Azure|CadetBlue|PowderBlue|LightBlue|SkyBlue|LightskyBlue|SteelBlue|AliceBlue|SlateGray|'
		. 'LightSlateGray|LightsteelBlue|CornflowerBlue|Lavender|GhostWhite|MidnightBlue|SlateBlue|DarkSlateBlue|'
		. 'MediumSlateBlue|MediumPurple|Indigo|MediumOrchid|Plum|Violet|Thistle|Orchid|LavenderBlush|PaleVioletRed|Pink|'
		. 'LightPink|Black|DimGray|Gray|DarkGray|Silver|LightGrey|Gainsboro|WhiteSmoke|White';
    	$text = preg_replace('#\[color=(\#(?:[a-fA-F0-9]{3}|[a-fA-F0-9]{6})|' . $color . ')\](.*?)\[/color\]#si', '<span style="color:\1">\2</span>', $text);
    	$text = preg_replace('#\[left\](.*?)\[/left\]#si', '<div style="text-align:left">\1</div>', $text);
    	$text = preg_replace('#\[right\](.*?)\[/right\]#si', '<div style="text-align:right">\1</div>', $text);
    	$text = preg_replace('#\[justify\](.*?)\[/justify\]#si', '<div style="text-align:justify">\1</div>', $text);
    	$text = preg_replace('#\[center\](.*?)\[/center\]#si', '<div style="text-align:center">\1</div>', $text);
 		$text = preg_replace_callback('#\[size=([0-9]{1,2})\](.*?)\[/size\]#si',
					create_function(
									'$data',
        	           				'if(intval($data[1])>48) {
        	        					$data[1] = 48;
        	                    	} elseif (intval($data[1])<3) {
        	                    		$data[1] = 3;
        	                    	}
        	          				return "<span style=\"font-size:{$data[1]}px\">{$data[2]}</span>";'
        	        ), $text);
    	$text = str_replace(array('[*]', '[/*]', '[li]'), array('<li>', '</li>', '<li/>'), $text);
    	$text = preg_replace_callback('#\[fieldset(?(?=\=)\=(.*?)|)\](.*?)\[/fieldset\]#si',
    	 			create_function(
    	 							'$m',
    	 							'if(!empty($m[1]))
    	 							{
    	 								return "<fieldset><legend>$m[1]</legend>$m[2]</fieldset>";
    	 							}
    	 							else
    	 							{
    	 								return "<fieldset>$m[2]</fieldset>";
    	 							}'
    	 			), $text);
    	$text = preg_replace('#\[hr\]#si', '<hr style="margin:2px;border:0;border-bottom:1px dashed #aaa"/>', $text);
    	$text = preg_replace('#\[b\](.*?)\[/b\]#si', '<span style="font-weight:bold">\1</span>', $text);
    	$text = preg_replace('#\[i\](.*?)\[/i\]#si', '<span style="font-style:italic">\1</span>', $text);
    	$text = preg_replace('#\[u\](.*?)\[/u\]#si', '<span style="text-decoration:underline">\1</span>', $text);
    	$text = preg_replace('#\[s\](.*?)\[/s\]#si', '<span style="text-decoration:line-through">\1</span>', $text);
    	$text = preg_replace('#\[q\](.*?)\[/q\]#si', '<div style="border:1px dashed #ccc;margin:0;padding:2px;color:#ccc;background:#fff"><div style="font-weight:bold;border-bottom:1px dashed #ccc">Цитата:</div>\1</div>', $text);
    	$text = preg_replace('#\[red\](.*?)\[/red\]#si', '<span style="color:red">\1</span>', $text);
    	$text = preg_replace('#\[green\](.*?)\[/green\]#si', '<span style="color:green">\1</span>', $text);
    	$text = preg_replace('#\[blue\](.*?)\[/blue\]#si', '<span style="color:blue">\1</span>', $text);
    	if(preg_match('#\[hide\](.*?)\[/hide\]#si', $text))
    	{
    		if(self::$user)
    		{
            	$text = preg_replace('#\[hide\](.*?)\[/hide\]#si', '<div style="background:#EAF1F4;border:1px solid #84BEE6;color:#2383A3;margin:2px;padding:2px">\1</div>', $text);
    		}
    		else
    		{
                $text = preg_replace('#\[hide\](.*?)\[/hide\]#si', '<div style="background:#EAF1F4;border:1px solid #84BEE6;color:#2383A3;margin:2px;padding:2px">Скрытый текст могут прочесть только зарегистрированные пользователи.</div>', $text);
    		}
    	}
    	$text = preg_replace_callback('`\\[url=((?:http|ftp)s?://.+?)\\](.+?)\\[/url\\]|((?<!\])(?:http|ftp)s?://(www.)?[0-9a-z\.-]+\.[0-9a-z]{1,7}[0-9a-zA-Z\/\?\.\~\&\;\_\=\%\-\+\:\#]*)|\[img(?(?=\=)\=([0-9]+x[0-9]+)|)\]((?:http|ftp)s?://[a-zA-Z0-9\-\_\+\.\%\~\/]+?\.(?:jpeg|jpe|jpg|gif|png|tga|tif|tiff|bmp))\[/img\]`',
     				create_function(
    					'$m',
    					'if(isset($m[6]))
    					{
							$x = preg_replace(\'#^([0-9]+)x(?:.*?)$#si\', \'\1\', $m[5]);
							$y = preg_replace(\'#^(?:.*?)x([0-9]+)$#si\', \'\1\', $m[5]);
							$matches = array(\'%3C\',\'%3E\',\'%26\',\'%26\',\'%22\',\'%3A\',\'%28\',\'%29\');
							$m[6] = str_replace($matches, \'\', $m[6]);
							if(!empty($m[5]))
							{
								return \'<img src="\'.$m[6].\'" width="\'.$x.\'" height="\'.$y.\'" alt="\'.$m[6].\'" style="border:0" />\';
							}
							else
							{
								return \'<img src="\'.$m[6].\'" alt="\'.$m[6].\'" style="border:0;width:auto;height:auto" />\';
							}
    					}
    					else
    					{
    						if (!isset($m[3]))
    						{
        						return \'<a href="\' . $m[1] . \'">\' . $m[2] . \'</a>\';
        					}
    						else
    						{
    							$lText = \'\';
    							if(mb_strlen($m[3])>70) $lText = mb_substr($m[3],0,70) . \'...\'; else $lText = $m[3];
        						return \'<a href="\' . $m[3] . \'">\' . $lText . \'</a>\';
        					}
    					}'
    				), $text);
    	$text = preg_replace_callback('`\[flash(?(?=\=)\=([0-9]+)x([0-9]+)|)\]((?:http|ftp)s?://[0-9a-z\.-]+\.[0-9a-z]{1,7}[0-9a-zA-Z\/\?\.\~\&\;\_\=\%\-\+\:\#]*)\[/flash\]`si',
    				create_function(
    								'$m',
    								'if(!empty($m[1]) && !empty($m[1]))
    								{
    									return	\'<object width="\' . $m[1] .\'" height="\' . $m[2] .\'"><param name="movie" value="\3"></param><param name="allowFullScreen" value="true"></param><param name="allowScriptAccess" value="sameDomain"></param><embed src="\3" type="application/x-shockwave-flash" allowfullscreen="true" allowScriptAccess="sameDomain" width="\' . $m[1] .\'" height="\' . $m[2] .\'"></embed></object>\';
    								}
    								else
    								{
    									return	\'<object><param name="movie" value="\3"></param><param name="allowFullScreen" value="true"></param><param name="allowScriptAccess" value="sameDomain"></param><embed src="\3" type="application/x-shockwave-flash" allowfullscreen="true" allowScriptAccess="sameDomain"></embed></object>\';
    								}'
    				), $text);
		return $text;
    }
	final public function DEL($text = "")
	{
    	/**
    	 * Вырезание BBCODE ТЭГОВ из текта
    	 */
    	$text = strtr($text,
    	 			array('[green]' => '', '[/green]' => '', '[red]' => '',
    	 				  '[/red]' => '', '[blue]' => '', '[/blue]' => '',
    	 				  '[b]' => '', '[/b]' => '', '[i]' => '', '[/i]' => '',
    	 				  '[u]' => '', '[/u]' => '', '[s]' => '', '[/s]' => '',
    	 				  '[c]' => '', '[/c]' => '', '[*]' => '', '[hr]' => '',
    	 				  '[center]' => '', '[/center]' => '', '[left]' => '',
    	 				  '[/left]' => '', '[right]' => '', '[/right]' => '',
    	 				  '[justify]' => '', '[/justify]' => '', '[/*]' => '',
    	 				  '[q]' => '', '[/q]' => ''));
    	$text = preg_replace('{\[color=(?:.+?)\](.*?)\[/color\]}si', '\1', $text);
    	$text = preg_replace('{\[img\](.*?)\[/img\]}si', '', $text);
    	$text = preg_replace('{\[hide\](.*?)\[/hide\]}si', '', $text);
    	$text = preg_replace('{\[size=(.*?)\](.*?)\[/size\]}si', '\2', $text);
    	$text = preg_replace('{\[url=(.*?)\](.*?)\[/url\]}si', '\2 - \1', $text);
    	$text = preg_replace('{\[fieldset(?(?=\=)\=(.*?)|)\](.*?)\[/fieldset\]}si', '\1<br/>\2', $text);
    	return $text;
	}
	final public function IMG_TEST($text = "")
	{
		/**
    	 * Проверка подлинности изображения в ТЭГе IMG
    	 */
		if(preg_match('#\[img\](.*?)\[\/img\]#si', $text))
		{
    		if(preg_match('#\[img\]((?:http|ftp)+s?://[a-zA-Z0-9\-\_\+\.\%\~\/]+?\.(?:jpeg|jpe|jpg|gif|png|tga|tif|tiff|bmp))\[\/img\]#i', $text))
    		{
    			return preg_replace_callback('#\[img\]((?:http|ftp)+s?://[a-zA-Z0-9\-\_\+\.\%\~\/]+?\.(?:jpeg|jpe|jpg|gif|png|tga|tif|tiff|bmp))\[\/img\]#si',
    									 create_function(
    								 					'$data',
    								 					'$img = @getimagesize($data[1]);
														if(!empty($img) && is_array($img) && in_array($img[\'mime\'], array(\'image/gif\', \'image/jpeg\', \'image/png\', \'image/tga\', \'image/bmp\', \'image/tiff\')) && $img[0] > 10 && $img[1] > 10)
														{
															return \'[img]\' . $data[1] . \'[/img]\';
														}
														else
														{
															return \'\';
														}'
									 	 ), $text);
			}
			else
			{
            	return preg_replace('#\[img\](.*?)\[\/img\]#si', '', $text);
			}
    	}
	}
}
//////////////////////////////////////////////////////////////////////////////////
?>