[h1 align=center]xBB v. 0.24 - PHP-библиотека для работы с BBCode[/h1]

[table border=0 align=center][tr][td][list=1]
[*][url="#inf"]Общие сведения[/url]
[*][url="#tags"]Список тегов[/url]
[*][url="#start"]Быстрый старт[/url]
[*][url="#api"]API[/url]
[list]
[*][url="#properties"]Свойства класса bbcode[/url]
[*][url="#methods"]Методы класса bbcode[/url]
[*][url="#add_tag"]Как создать тег[/url]
[/list]
[*][url="#css"]Применение CSS[/url]
[*][url="#use"]Условия использования и инсталляция[/url]
[/list][/td][/tr][/table]

[h2 align=center][anchor=inf /]Общие сведения[/h2]

[b]xBB[/b] - написанная на PHP библиотека для работы с BBCode, которая является развитием библиотеки, описанной [url=http://www.pc.uz/documents/text/732.html title="Парсер BBCode на PHP"]здесь[/url].

xBB может быть использован в гостевых книгах, форумах, на досках объявлений и т.п. На этом сайте (http://www.pc.uz) поддержка BBCode в пользовательских комментариях реализована с помощью xBB. Данная документация целиком сверстана в BBCode и конвертирована в HTML с помощью xBB.

Парсер реализован несколько отлично от аналогов. Обычно такие парсеры реализуются с помощью регулярных выражений. Этот же использует метод конечных автоматов. Имеет следующий плюс: [u]как бы ни была богата и продвинута коллекция тегов, поддерживаемая в данной реализации, скорость обработки текстов будет постоянной[/u], так как осуществляется за фиксированное число проходов. Коллекцию тегов можно увеличивать до бесконечности, а скрипт будет выполняться одинаково быстро. Скорость его работы зависит только от величины текста и от числа тегов, используемых в конкретном тексте, но не от числа всех возможных тегов и вариантов их написания. Скрипт не парсит текст многократно для каждого тега или варианта написания тега.

В умолчальной поставке xBB поддерживает 41 тег, "автоматические ссылки", смайлы. Коллекция тегов и смайлов легко расширяема.

Теги имеют следующие особенности:

[list=a]
[*]Названия тегов и атрибутов не зависят от регистра. Например, [bbcode]@l;font=Arial size=+1@r;, @l;FONT=Arial SIZE=+1@r; и @l;FoNt=Arial SiZe=+1@r;[/bbcode] - равнозначно.

[*]Значения атрибутов могут быть закавычены "так" и 'так', либо никак не закавычены. Следующие конструкции равнозначны: [bbcode]@l;google="BBCode"@r;, @l;google='BBCode'@r;, @l;google=BBCode@r;.[/bbcode]. Следующие конструкции НЕ равнозначны: [bbcode]@l;google="Поддержка BBCode"@r;, @l;google=Поддержка BBCode@r;[/bbcode]. Последний вариант будет интерпретирован скриптом как [bbcode]@l;google="Поддержка" BBCode=""@r;[/bbcode].

[*]Теги могут быть вложенными. Но те из них, которые создают элементы блочного типа (такие как [bbcode]@l;h1@r; или @l;table@r;[/bbcode]), не могут быть вложены в строчные теги (такие как [bbcode]@l;i@r; или @l;color@r;[/bbcode]). Строчные элементы закрываются, если начинается блочный. Эти ограничения обусловлены требованиями W3C.

[*]Теги должны быть правильно вложены. Неправильный код "[bbcode]@l;b@r;@l;i@r;текст@l;/b@r;@l;/i@r;[/bbcode]" будет интерпретирован скриптом как "[bbcode]@l;b@r;@l;i@r;текст@l;/i@r;@l;/b@r;[/bbcode][tt]@l;/i@r;[/tt]". Это ограничение также обусловлено требованием W3C.

[*]В данной реализации BBCode поддерживаются закрывающие теги вида [bbcode]@l;/@r;[/bbcode]. Такой тег закрывает последний незакрытый тег. Например, [bbcode]@l;b@r;текст@l;/b@r;[/bbcode] равнозначно [bbcode]@l;b@r;текст@l;/@r;[/bbcode]. Тем не менее рекомендую пользоваться именно первой формой написания. :vip: Тогда, в случае нагромождения вложенных тегов, вам будет легче ориентроваться в коде. Кроме того, первая форма написания позволяет скрипту более корректно обрабатывать пользовательские ошибки.

[*]Поддерживается закрытие тега способом [tt][b]@l;тег /@r;[/b][/tt]. Например, конструкции [bbcode]@l;url name=top@r;@l;/url@r;[/bbcode] и [bbcode]@l;url name=top /@r;[/bbcode] равнозначны.

[*]В некоторых случаях можно не писать закрывающий тег. Например, тег [bbcode]@l;tr@r;[/bbcode] (строка таблицы), будет автоматически закрыт, как только встретится очередной [bbcode]@l;tr@r;[/bbcode] или закрывающий тег [bbcode]@l;/table@r;[/bbcode]. Тег [bbcode]@l;hr@r;[/bbcode] вообще не имеет закрывающего, интерпретируется скриптом как [bbcode]@l;hr/@r;[/bbcode]. О поведении конкретных тегов смотрите их описания.

[*]При конвертации ББКода в HTML сохраняется форматирование пробелами. Т.е. все двойные пробелы переводятся в [tt]'&nbsp;&nbsp;'[/tt], все переводы строк заменяются на [b][tt]'<br />'[/tt][/b]. Однако вокруг некоторых элементов (таких как [bbcode]@l;h1@r;[/bbcode]) игнорируются 1-2 перевода строк, так как эти элементы сами по себе создают дополнительные отступы. Это сделано для того, чтобы по возможности приблизить визуальное представление HTML к исходному ББкоду.
[/list]

xBB поддерживает мнемонизацию специальных символов. Например, чтобы вывести на печать [b]@l;b@r;[/b] без преобразования в HTML, можно ввести [bbcode]@at;l;b@at;r;[/bbcode]. Поддерживаются мнемоники следующих спецсимволов:

[list=a]
[*]Открывающая квадратная скобка '[b]@l;[/b]' может быть мнемонизирована как [bbcode]'@at;l;'[/bbcode].

[*]Закрывающая квадратная скобка '[b]@r;[/b]' может быть мнемонизирована как [bbcode]'@at;r;'[/bbcode].

[*]Двойная кавычка '[b]"[/b]' может быть мнемонизирована как [bbcode]'@at;q;'[/bbcode].

[*]Одинарная кавычка "[b]'[/b]" (апостроф) может быть мнемонизирована как [bbcode]'@at;a;'[/bbcode].

[*]Знак собачки '[b]@[/b]' может быть мнемонизирован как [bbcode]'@at;at;'[/bbcode].
[/list]

Поддержка "автоматических ссылок" означает, что строки вида [nobb]"http://какойто_uri", "https://какойто_uri", "ftp://какойто_uri", "www.какойто_uri" и "ящик@домен"[/nobb] автоматически конвертируются в соответствующие гиперссылки. Этого не происходит для содержимого таких тегов как [bbcode]@l;code@r;, @l;nobb@r;[/bbcode] и аналогичных. Автоматические ссылки могут быть отключены. Как это делается - смотрите главу об [url="#api"]API[/url].

О задании наборов смайликов - смотрите главы [url="#start"]"Быстрый старт"[/url] и [url="#api"]"API"[/url].

Далее подробно описываются теги, поддержка которых реализована в xBB по умолчанию.

[h2 align=center][anchor=tags /]Список тегов[/h2]

[list=1]
[*][bbcode]@l;*@r;[/bbcode] - элемент списка. Аналог HTML-ного [b][tt]<li>[/tt][/b]. Может содержаться только в теге [bbcode]@l;list@r;[/bbcode]. Автоматически закрывается, если начинается очередной [bbcode]@l;*@r;[/bbcode] или если закрывается [bbcode]@l;list@r;[/bbcode]. При конвертации переводится в [b][tt]<li class="bb">[/tt][/b]. Может использоваться в форме [bbcode]@l;*=целое_число@r;[/bbcode], что эквивалентно [b][tt]<li class="bb" value="целое_число">[/tt][/b]. Целое число здесь - номер (возможно, переведенный в букву) текущего элемента списка. Смотрите примеры в описании [bbcode]@l;list@r;[/bbcode].

[*][bbcode]@l;a@r;[/bbcode] - ссылка. Аналог HTML-ного [b][tt]<a>[/tt][/b]. Поддерживаются атрибуты [b][tt]title[/tt][/b], [b][tt]id[/tt][/b] (для создания якорей), [b][tt]name[/tt][/b] (фактически - синоним для [b][tt]id[/tt][/b]), [b][tt]href[/tt][/b] и [b][tt]target[/tt][/b], аналогичные HTML-ным. Кроме того, поддерживаются атрибуты [b][tt]url[/tt][/b] (синоним для [b][tt]href[/tt][/b]) и [b][tt]anchor[/tt][/b] (синоним для [b][tt]id[/tt][/b]). Тег [bbcode]@l;a@r;[/bbcode] может быть использован в следующих формах:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr]
[th]Код
[th]Пример
[th]Результат
[tr]
[td][bbcode]@l;a@r;адрес_ссылки@l;/a@r;[/bbcode]
[td][bbcode]@l;a target=_blank@r;www.pc.uz@l;/a@r;[/bbcode]
[td][a target=_blank]www.pc.uz[/a]
[tr]
[td][bbcode]@l;a=адрес_ссылки@r;текст ссылки@l;/a@r;[/bbcode]
[td][bbcode]@l;a=forum.pc.uz title="Хороший форум"@r;Форум PC.UZ@l;/a@r;[/bbcode]
[td][a=forum.pc.uz title="Хороший форум"]Форум PC.UZ[/a]
[tr]
[td][bbcode]@l;a href=адрес_ссылки@r;текст ссылки@l;/a@r;[/bbcode]
[td][bbcode]@l;a href=service.pc.uz@r;Сервис-центр@l;/a@r;[/bbcode]
[td][a href=service.pc.uz]Сервис-центр[/a]
[tr]
[td][bbcode]@l;a url=адрес_ссылки@r;текст ссылки@l;/a@r;[/bbcode]
[td][bbcode]@l;a url=restoran.uz@r;Рестораны Ташкента@l;/a@r;[/bbcode]
[td][a url=restoran.uz]Рестораны Ташкента[/a]
[/table]

Если адрес ссылки не начинается с одной из следующих строк - '[b][tt]http://[/tt][/b]', '[b][tt]https://[/tt][/b]', '[b][tt]ftp://[/tt][/b]', '[b][tt]file://[/tt][/b]', '[b][tt]#[/tt][/b]', '[b][tt]/[/tt][/b]', '[b][tt]?[/tt][/b]', '[b][tt]./[/tt][/b]', '[b][tt]../[/tt][/b]' или '[b][tt]mailto:[/tt][/b]', то слева к нему автоматом допишется '[b][tt]http://[/tt][/b]'.

Код [bbcode]@l;a id=this /@r;[/bbcode], [bbcode]@l;a name=this /@r;[/bbcode] или [bbcode]@l;a anchor=this /@r;[/bbcode] создаст якорь в документе. Если имя якоря не начинается с латинской буквы (как того требует W3C), к нему в начало будет дописано '[b][tt]bb[/tt][/b]'.

[*][bbcode]@l;abbr@r;[/bbcode] - аббревиатура. Эквивалент HTML-ного [b][tt]<abbr class="bb">[/tt][/b]. Может использоваться в форме [bbcode]@l;abbr="расшифровка аббревиатуры"@r;[/bbcode], что эквивалентно [b][tt]<abbr class="bb" title="расшифровка аббревиатуры">[/tt][/b].

Пример: [bbcode]@l;abbr="PHP: Hypertext Preprocessor"@r;PHP@l;/abbr@r;[/bbcode]. Результат: [abbr="PHP: Hypertext Preprocessor"]PHP[/abbr].

[*][bbcode]@l;acronym@r;[/bbcode] - акроним. Эквивалент HTML-ного [b][tt]<acronym class="bb">[/tt][/b]. Может использоваться в форме [bbcode]@l;acronym="расшифровка акронима"@r;[/bbcode], что эквивалентно [b][tt]<acronym class="bb" title="расшифровка акронима">[/tt][/b].

Пример: [bbcode]@l;acronym="Хранимая процедура"@r;хранимка@l;/acronym@r;[/bbcode]. Результат: [acronym="Хранимая процедура"]хранимка[/acronym].

[*][bbcode]@l;address@r;[/bbcode] - контактная информация. Эквивалент HTML-ного [b][tt]<address class="bb">[/tt][/b].

Пример: [bbcode]@l;address@r;Узбекистан, г. Ташкент@l;/address@r;[/bbcode]. Результат:

[address]Узбекистан, г. Ташкент[/address]

[*][bbcode]@l;align@r;[/bbcode] - выравниване текста по левому ([bbcode]@l;align=left@r;[/bbcode]), правому ([bbcode]@l;align=right@r;[/bbcode]) краю, по центру ([bbcode]@l;align=center@r;[/bbcode]) или по ширине ([bbcode]@l;align=justify@r;[/bbcode]). При конвертации переводится в [b][tt]<div class="bb" align="...">[/tt][/b].

Пример: [bbcode]@l;align=right@r;Текст, выровненный по правому краю.@l;/align@r;[/bbcode]. Результат:

[align=right]Текст, выровненный по правому краю.[/align]

[*][bbcode]@l;anchor@r;[/bbcode] - якорь в документе. Может использоваться в следующих формах:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr]
[th]Код
[th]Эквивалент в HTML
[tr]
[td][bbcode]@l;anchor@r;имя@l;/anchor@r;[/bbcode]
[td][b][tt]<a id="имя"></a>[/tt][/b]
[tr]
[td][bbcode]@l;anchor=имя /@r;[/bbcode]
[td][b][tt]<a id="имя"></a>[/tt][/b]
[tr]
[td][bbcode]@l;anchor=имя@r;текст@l;/anchor@r;[/bbcode]
[td][b][tt]<a id="имя">текст</a>[/tt][/b]
[/table]

Если имя якоря не начинается с латинской буквы (как того требует W3C), к нему в начало будет дописано '[b][tt]bb[/tt][/b]'.

[*][bbcode]@l;b@r;[/bbcode] - жирный шрифт. Эквивалент HTML-ного [b][tt]<strong>[/tt][/b].

Пример: "[bbcode]@l;b@r;текст@l;/b@r;[/bbcode]". Результат: "[b]текст[/b]".

[*][bbcode]@l;bbcode@r;[/bbcode] - тег для подсветки ББКода. Внутри [bbcode]@l;bbcode@r;[/bbcode] теги BBCode, смайлики, и "автоматические ссылки" не транслируются в HTML, а посвечиваются. Пример:

[bbcode]@l;bbcode@r;[/bbcode]
В содержимом тега @l;bbcode@r; можно использовать мнемонизацию спецсимволов, чтобы исключить неоднозначную трактовку вложенности тегов. Например, неоднозначность "@l;bbcode@r; @l;/bbcode@r; @l;/bbcode@r;" можно исключить, написав "@l;bbcode@r; @at;l;/bbcode@at;r; @l;/bbcode@r;". Если же вам надо вывести собственно мнемонику какого-то спецсимвола, то она сама должна быть мнемонизирована. То есть, чтобы вывести '@at;l;', нужно набрать '@at;at;l;'.
[bbcode]@l;/bbcode@r;[/bbcode]

Результат:

[bbcode]В содержимом тега @l;bbcode@r; можно использовать мнемонизацию спецсимволов, чтобы исключить неоднозначную трактовку вложенности тегов. Например, неоднозначность "@l;bbcode@r; @l;/bbcode@r; @l;/bbcode@r;" можно исключить, написав "@l;bbcode@r; @at;l;/bbcode@at;r; @l;/bbcode@r;". Если же вам надо вывести собственно мнемонику какого-то спецсимвола, то она сама должна быть мнемонизирована. То есть, чтобы вывести '@at;l;', нужно набрать '@at;at;l;'.[/bbcode]

[*][bbcode]@l;caption@r;[/bbcode] - заголовок таблицы. Эквивалент HTML-ного [b][tt]<caption class="bb">[/tt][/b]. Может содержаться только в теге [bbcode]@l;table@r;[/bbcode]. Смотрите пример в описании [bbcode]@l;table@r;[/bbcode].

[*][bbcode]@l;center@r;[/bbcode] - сокращение для [bbcode]@l;align=center@r;[/bbcode].
Пример: [bbcode]@l;center@r;Текст, выровненный по центру@l;/center@r;[/bbcode].
Результат:
[center]Текст, выровненный по центру[/center]

[*][bbcode]@l;code@r;[/bbcode] - тег для программных кодов, кодов разметки и т.п. Эквивалент HTML-ного [b][tt]<code class="bb">[/tt][/b]. Внутри [bbcode]@l;code@r;[/bbcode] игнорируются ББ-теги и смайлики, не работают "автоматические ссылки". Пример:

[table border=0 align=center][tr][td][bbcode]@l;code@r;[/bbcode]
// Класс для тега @at;l;code@at;r;
class bb_code extends bbcode {
    var $ends = array();
    var $children = array();
    function get_html() {
        $str = '<code class="bb">';
        foreach ($this -> tree as $item) {
            if ('item' == $item['type']) { continue; }
            $str .= htmlspecialchars($item['str']);
        }
        $str .= '</code>';
        return str_replace('  ', '&nbsp;&nbsp;', nl2br($str));
    }
}
[bbcode]@l;/code@r;[/bbcode][/table]

Результат:
[table border=0 align=center][tr][td][code]
// Класс для тега @l;code@r;
class bb_code extends bbcode {
    var $ends = array();
    var $children = array();
    function get_html() {
        $str = '<code class="bb">';
        foreach ($this -> tree as $item) {
            if ('item' == $item['type']) { continue; }
            $str .= htmlspecialchars($item['str']);
        }
        $str .= '</code>';
        return str_replace('  ', '&nbsp;&nbsp;', nl2br($str));
    }
}[/code][/table]

[*][bbcode]@l;color@r;[/bbcode] - тег для цветового выделения текста. При конвертации переводится в [b][tt]<font color="...">[/tt][/b].

Пример: "[bbcode]@l;color=red@r;текст@l;/color@r;[/bbcode]". Результат: "[color=red]текст[/color]".

[*][bbcode]@l;email@r;[/bbcode] - тег для создания гиперссылки e-mail. При конвертации переводится в [tt]<a class="bb_email" href="mailto:...">...</a>[/tt]. Поддерживает также атрибуты [b][tt]title[/tt][/b], [b][tt]name[/tt][/b] и [b][tt]target[/tt][/b], аналогичные соответствующим в HTML. Примеры:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr]
[th]Код
[th]Результат
[tr]
[td][tt][bbcode]@l;email@r;dima@pc.uz@l;/email@r;[/bbcode]
[td][email]dima@pc.uz[/email]
[tr]
[td][bbcode]@l;email=dima@pc.uz title="Мой ящик"@r;Мой ящик@l;/email@r;[/bbcode]
[td][email=dima@pc.uz title="Мой ящик"]Мой ящик[/email]
[/table]

[*][bbcode]@l;font@r;[/bbcode] - указать шрифт. Аналог HTML-ного [b][tt]<font>[/tt][/b]. Поддерживает также атрибуты [b][tt]color[/tt][/b] и [b][tt]size[/tt][/b]. Примеры:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr]
[th]Код
[th]Результат
[tr]
[td][bbcode]@l;font=Arial@r;текст@l;/font@r;[/bbcode]
[td][font=Arial]текст[/font]
[tr]
[td][bbcode]@l;font=Verdana color=red size=+2@r;текст@l;/font@r;[/bbcode]
[td][font=Verdana color=red size=+2]текст[/font]
[/table]

[*][bbcode]@l;google@r;[/bbcode] - тег для создания ссылки на Google. При конвертации переводится в [b][tt][nobb]<a class="bb_google" href="http://www.google.com/search?q=Запрос">[/nobb][/tt][/b]. Поддерживает также атрибуты [b][tt]title[/tt][/b], [b][tt]name[/tt][/b] и [b][tt]target[/tt][/b].

Пример: "[bbcode]@l;google=BBCode target=_blank@r;Спроси Гугл про ББКод@l;/google@r;[/bbcode]". Результат: "[google=BBCode target=_blank]Спроси Гугл про ББКод[/google]".

[*][bbcode]@l;h1@r;[/bbcode] - аналог HTML-ного [b][tt]<h1>[/tt][/b]. При конвертации переводится в [b][tt]<h1 class="bb">[/tt][/b]. Поддерживает атрибут [b][tt]align[/tt][/b].
Пример: [bbcode]@l;h1 align=center@r;Заголовок 1@l;/h1@r;[/bbcode]. Результат:
[h1 align=center]Заголовок 1[/h1]

[*][bbcode]@l;h2@r;[/bbcode] - аналог HTML-ного [b][tt]<h2>[/tt][/b]. При конвертации переводится в [b][tt]<h2 class="bb">[/tt][/b]. Поддерживает атрибут [b][tt]align[/tt][/b].
Пример: [bbcode]@l;h2 align=center@r;Заголовок 2@l;/h2@r;[/bbcode]. Результат:
[h2 align=center]Заголовок 2[/h2]

[*][bbcode]@l;h3@r;[/bbcode] - аналог HTML-ного [b][tt]<h3>[/tt][/b]. При конвертации переводится в [b][tt]<h3 class="bb">[/tt][/b]. Поддерживает атрибут [b][tt]align[/tt][/b].
Пример: [bbcode]@l;h3 align=center@r;Заголовок 3@l;/h3@r;[/bbcode]. Результат:
[h3 align=center]Заголовок 3[/h3]

[*][bbcode]@l;hr@r;[/bbcode] - аналог HTML-ного [b][tt]<hr>[/tt][/b]. При конвертации переводится в [b][tt]<hr class="bb" />[/tt][/b]. Пример: [bbcode]@l;hr@r;[/bbcode]. Результат:

[hr]

[*][bbcode]@l;i@r;[/bbcode] - аналог HTML-ного [b][tt]<i>[/tt][/b]. Пример: "[bbcode]@l;i@r;текст@l;/i@r;[/bbcode]". Результат: "[i]текст[/i]".

[*][bbcode]@l;img@r;[/bbcode] - аналог HTML-ного [b][tt]<img>[/tt][/b]. Поддерживает атрибуты [b][tt]width[/tt][/b], [b][tt]height[/tt][/b] и [b][tt]border[/tt][/b]. Примеры:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr]
[th]Код
[th]Результат
[tr]
[td][bbcode]@l;img@r;http://www.pc.uz/files/images/pcuz_1.gif@l;/img@r;[/bbcode]
[td][img]http://www.pc.uz/files/images/pcuz_1.gif[/img]
[tr]
[td][bbcode]@l;img width=116 height=22@r;http://www.pc.uz/files/images/pcuz_1.gif@l;/img@r;[/bbcode]
[td][img width=116 height=22]http://www.pc.uz/files/images/pcuz_1.gif[/img]
[/table]

[*][bbcode]@l;justify@r;[/bbcode] - сокращение для [bbcode]@l;align=justify@r;[/bbcode].

Пример:
[bbcode]@l;justify@r;Выровнять текст по ширине (как в этом абзаце) можно с помощью тега @at;l;align=justify@at;r; или с помощью тега @at;l;justify@at;r;. Этот тег эквивалентен @l;b@r;<div class="bb" align="justify">@l;/b@r; в HTML. Помимо выравнивания по ширине возможно также выравнивание по левому краю (тег @at;l;left@at;r; или @at;l;align=left@at;r;), по правому краю (тег @at;l;right@at;r; или @at;l;align=right@at;r;) и по центру (тег @at;l;center@at;r; или @at;l;align=center@at;r;).@l;/justify@r;[/bbcode].

Результат:
[justify]Выровнять текст по ширине (как в этом абзаце) можно с помощью тега [bbcode]@l;align=justify@r;[/bbcode] или с помощью тега [bbcode]@l;justify@r;[/bbcode]. Этот тег эквивалентен [b]<div class="bb" align="justify">[/b] в HTML. Помимо выравнивания по ширине возможно также выравнивание по левому краю (тег [bbcode]@l;left@r;[/bbcode] или [bbcode]@l;align=left@r;[/bbcode]), по правому краю (тег [bbcode]@l;right@r;[/bbcode] или [bbcode]@l;align=right@r;[/bbcode]) и по центру (тег [bbcode]@l;center@r;[/bbcode] или [bbcode]@l;align=center@r;[/bbcode]).[/justify]

[*][bbcode]@l;left@r;[/bbcode] - сокращение для [bbcode]@l;align=left@r;[/bbcode]. Пример: [bbcode]@l;left@r;Текст, выровненный по левому краю.@l;/left@r;[/bbcode].

Результат:
[left]Текст, выровненный по левому краю.[/left]

[*][bbcode]@l;list@r;[/bbcode] - тег для создания списка. Аналог HTML-ных [b][tt]<ul>[/tt][/b] и [b][tt]<ol>[/tt][/b]. При конвертации переводится в [b][tt]<ul class="bb">[/tt][/b] или в [b][tt]<ol class="bb" type="...">[/tt][/b]. Единственный вложенный тег - [bbcode]@l;*@r;[/bbcode], который в свою очередь может иметь вложенные теги. Примеры:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr]
[th]Код
[th]Результат
[th]Код
[th]Результат
[th]Код
[th]Результат
[tr]
[td][bbcode]@l;list@r;
@l;*@r;Раз
@l;*@r;Два
@l;*@r;Три
@l;/list@r;[/bbcode]
[td][list]
[*]Раз
[*]Два
[*]Три
[/list]
[td][bbcode]@l;list=1@r;
@l;*@r;Раз
@l;*=3@r;Два
@l;*@r;Три
@l;/list@r;[/bbcode]
[td][list=1]
[*]Раз
[*=3]Два
[*]Три
[/list]
[td][bbcode]@l;list=a@r;
@l;*=5@r;Раз
@l;*@r;Два
@l;*@r;Три
@l;/list@r;[/bbcode]
[td][list=a]
[*=5]Раз
[*]Два
[*]Три
[/list]
[/table]

[*][bbcode]@l;nobb@r;[/bbcode] - тег, внутри которого не происходит конвертации ББКода в HTML, не работают "автоматические ссылки" и не вставляются смайлы.
Пример: "[bbcode]@l;nobb@r;@l;b@r;ББКод@l;/b@r; со смайлом :)@l;/nobb@r;[/bbcode]". Результат: "[nobb][b]ББКод[/b] со смайлом :)[/nobb]".

Должен предупредить, что неоднозначность во вложенности тегов может привести к неожидавшимся результатам.
Например, код
[center][bbcode]@l;nobb@r;[/bbcode][tt] текст1 @l;/nobb@r; текст2 [/tt][bbcode]@l;/nobb@r;[/bbcode][/center]
будет интерпретирован скриптом так:
[center][bbcode]@l;nobb@r; текст1 @l;/nobb@r;[/bbcode][tt] текст2 @l;/nobb@r;[/tt][/center]
Код
[center][bbcode]@l;b@r; текст1 @l;nobb@r;[/bbcode][tt] текст2 @l;/b@r; текст3 [/tt][bbcode]@l;/nobb@r; текст4 @l;/b@r;[/bbcode][/center]
будет интерпретирован скриптом так:
[center][bbcode]@l;b@r; текст1 @l;nobb@r; текст2 @l;/nobb@r;@l;/b@r;[/bbcode][tt] текст3 @l;/nobb@r; текст4 @l;/b@r;[/tt][/center]
Чтобы такого избежать, пользуйтесь мнемониками спецсимволов.

[*][bbcode]@l;php@r;[/bbcode] - тег, подсвечивающий код PHP. При конвертации посвеченный код вставляется в [b][tt]<div class="php">[/tt][/b].
Пример:
[table border=0 align=center]
[tr][td][bbcode]@l;php@r;<?php
// Класс для тега @at;l;php@at;r;
class bb_php extends bbcode {
    var $ends = array();
    var $children = array();
    function get_html() {
        $str = '';
        foreach ($this -> tree as $item) {
            if ('text' == $item['type']) { $str .= $item['str']; }
        }
        if (false !== strpos($str, '<?')) {
            $str = highlight_string($str, true);
        } else {
            $str = '<?php '.$str.' ?>';
            $str = highlight_string($str, true);
            $str = str_replace('&lt;?php ', '', $str);
            $str = str_replace('&lt;?php&nbsp;', '', $str);
            $str = str_replace('>?&gt;<', '><', $str);
        }
        $str = preg_replace("'<span [^>]*></span>'si", '', $str);
        return '<div class="php">'.$str.'</div>';
    }
}
?>@l;/php@r;[/bbcode][/table]
Результат:
[table border=0 align=center][tr][td][php]<?php
// Класс для тега @l;php@r;
class bb_php extends bbcode {
    var $ends = array();
    var $children = array();
    function get_html() {
        $str = '';
        foreach ($this -> tree as $item) {
            if ('text' == $item['type']) { $str .= $item['str']; }
        }
        if (false !== strpos($str, '<?')) {
            $str = highlight_string($str, true);
        } else {
            $str = '<?php '.$str.' ?>';
            $str = highlight_string($str, true);
            $str = str_replace('&lt;?php ', '', $str);
            $str = str_replace('&lt;?php&nbsp;', '', $str);
            $str = str_replace('>?&gt;<', '><', $str);
        }
        $str = preg_replace("'<span [^>]*></span>'si", '', $str);
        return '<div class="php">'.$str.'</div>';
    }
}
?>[/php][/table]

[*][bbcode]@l;quote@r;[/bbcode] - Цитата. При конвертации конструкция [bbcode]@l;quote=Автор@r;текст@l;/quote@r;[/bbcode] переводится в

[b][tt]<div class="bb_quote_author">Автор</div><div class="bb_quote">текст</div>[/tt][/b]

Вот так это выглядит:

[quote=Автор]текст[/quote]

Автора указывать необязательно.
Визуальное оформление цитат следует делать с помощью CSS. Вот пример такого оформления:
[table border=0 align=center][tr][td][code]
div.bb_quote_author {
    margin: 10px 5px 0px 5px;
    padding: 4px;
    border-width: 1px 1px 0px 1px;
    border-style: solid;
    border-color: #a9b8c2;
    color: #333333;
    background-color: #a9b8c2;
    font-size: 0.85em;
    font-weight: bold;
}
div.bb_quote_author:after {
    content: " писал(а):";
}
div.bb_quote {
    margin: 0px 5px 10px 5px;
    padding: 5px;
    border-color: #a9b8c2;
    border-width: 0px 1px 1px 1px;
    border-style: solid;
    font-family: "Lucida Grande", "Trebuchet MS", Helvetica, Arial, sans-serif;
    background-color: #fafafa;
    color: #4b5c77;
}[/code][/table]

[*][bbcode]@l;right@r;[/bbcode] - сокращение для [bbcode]@l;align=right@r;[/bbcode]. Пример: [bbcode]@l;right@r;Текст, выровненный по правому краю.@l;/right@r;[/bbcode].

Результат:
[right]Текст, выровненный по правому краю.[/right]

[*][bbcode]@l;s@r;[/bbcode] - зачеркнутый текст. Аналог HTML-ного [b][tt]<del>[/tt][/b]. Пример: "[bbcode]@l;s@r;текст@l;/s@r;[/bbcode]". Результат: "[s]текст[/s]".

[*][bbcode]@l;size@r;[/bbcode] - тег для изменения размера шрифта. При конвертации переводится в [b][tt]<font size="...">[/tt][/b]. Пример: "[bbcode]@l;size=6@r;текст@l;/size@r;[/bbcode]". Результат: "[size=6]текст[/size]".

[*][bbcode]@l;strike@r;[/bbcode] - синоним для [bbcode]@l;s@r;[/bbcode]. Пример: "[bbcode]@l;strike@r;текст@l;/strike@r;[/bbcode]". Результат: "[strike]текст[/strike]".

[*][bbcode]@l;sub@r;[/bbcode] - нижний индекс. Аналог HTML-ного [b][tt]<sub>[/tt][/b]. Пример: "[bbcode]@l;sub@r;текст@l;/sub@r;[/bbcode]". Результат: "[sub]текст[/sub]".

[*][bbcode]@l;sup@r;[/bbcode] - верхний индекс. Аналог HTML-ного [b][tt]<sup>[/tt][/b]. Пример: "[bbcode]@l;sup@r;текст@l;/sup@r;[/bbcode]". Результат: "[sup]текст[/sup]".

[*][bbcode]@l;table@r;[/bbcode] - таблица. Аналог HTML-ного [b][tt]<table>[/tt][/b]. При конвертации переводится в [b][tt]<table class="bb">[/tt][/b]. Поддерживаются атрибуты [b][tt]border[/tt][/b], [b][tt]width[/tt][/b], [b][tt]cellspacing[/tt][/b], [b][tt]cellpadding[/tt][/b] и [b][tt]align[/tt][/b], аналогичные HTML-ным. В [bbcode]@l;table@r;[/bbcode] могут быть вложены только теги [bbcode]@l;caption@r;[/bbcode] (заголовок) и [bbcode]@l;tr@r;[/bbcode] (строка). Пример:

[bbcode]@l;table border=1 align=center cellspacing=0 cellpadding=5@r;
@l;caption@r;Заголовок@l;/caption@r;
@l;tr@r;
@l;th@r;Столбец 1
@l;th@r;Столбец 2
@l;tr@r;
@l;td align=center colspan=2@r;Строка
@l;/table@r;[/bbcode]

Результат:
[table border=1 align=center cellspacing=0 cellpadding=5]
[caption]Заголовок[/caption]
[tr]
[th]Столбец 1
[th]Столбец 2
[tr]
[td align=center colspan=2]Строка
[/table]

[*][bbcode]@l;td@r;[/bbcode] - ячейка таблицы. Аналог HTML-ного [b][tt]<td>[/tt][/b]. Может быть вложен только в [bbcode]@l;tr@r;[/bbcode]. При конвертации переводится в [b][tt]<td class="bb">[/tt][/b]. Поддерживаются атрибуты [b][tt]width[/tt][/b], [b][tt]height[/tt][/b], [b][tt]align[/tt][/b], [b][tt]valign[/tt][/b], [b][tt]colspan[/tt][/b] и [b][tt]rowspan[/tt][/b], аналогичные HTML-ным. Пример использования смотрите выше.

[*][bbcode]@l;th@r;[/bbcode] - заголовок столбца таблицы. Аналог HTML-ного [b][tt]<th>[/tt][/b]. Может быть вложен только в [bbcode]@l;tr@r;[/bbcode]. При конвертации переводится в [b][tt]<th class="bb">[/tt][/b]. Поддерживаются атрибуты [b][tt]width[/tt][/b], [b][tt]height[/tt][/b], [b][tt]align[/tt][/b], [b][tt]valign[/tt][/b], [b][tt]colspan[/tt][/b] и [b][tt]rowspan[/tt][/b], аналогичные HTML-ным. Пример использования смотрите выше.

[*][bbcode]@l;tr@r;[/bbcode] - строка таблицы. Аналог HTML-ного [b][tt]<tr>[/tt][/b]. Может быть вложен только в [bbcode]@l;table@r;[/bbcode]. Может содержать только [bbcode]@l;th@r;[/bbcode] и [bbcode]@l;td@r;[/bbcode]. При конвертации переводится в [b][tt]<tr class="bb">[/tt][/b]. Пример использования смотрите выше.

[*][bbcode]@l;tt@r;[/bbcode] - стиль печатной машинки. Аналог HTML-ного [b][tt]<tt>[/tt][/b]. Пример: "[bbcode]@l;tt@r;текст@l;/tt@r;[/bbcode]". Результат: "[tt]текст[/tt]".

[*][bbcode]@l;u@r;[/bbcode] - подчеркнутый текст. Аналог HTML-ного [b][tt]<u>[/tt][/b]. Пример: "[bbcode]@l;u@r;текст@l;/u@r;[/bbcode]". Результат: "[u]текст[/u]".

[*][bbcode]@l;url@r;[/bbcode] - ссылка. Синоним для [bbcode]@l;a@r;[/bbcode].
[/list]

[h2 align=center][anchor=start /]Быстрый старт[/h2]

Класс, реализующий обработку ББКода, называется [b][tt]bbcode[/tt][/b]. Вот пример использования этого класса в PHP-коде:

[table border=0 align=center][tr][td][php]$text = '[b]Переменная с текстом BBCode: [i]Hello world![/i][/b]';
// Подключаем библиотеку с классом
require_once 'ваш/путь/bbcode.lib.php';
// Создаем объект и распарсиваем $text
$bb = new bbcode($text);
// Конвертируем BBCode в HTML и выводим его
echo $bb -> get_html();[/php][/table]

Все достаточно просто. При инициализации объекта ему передается текст, содержащий BBCode. Метод [b][tt]get_html[/tt][/b] возвращает текст HTML, конвертированный из BBCode. Следующий пример демонстрирует, как можно обработать последовательность текстов BBCode:

[table border=0 align=center][tr][td][php]$list = array(
        'Первый текст с @l;b@r;ББКодом@l;/b@r;',
        'Второй текст с @l;i@r;ББКодом@l;/i@r;'
    );
// Подключаем библиотеку с классом
require_once 'ваш/путь/bbcode.lib.php';
// Создаем объект
$bb = new bbcode;
// В цикле парсим ББКод и выводим HTML
foreach ($list as $val) {
    $bb -> parse($val);
    echo $bb -> get_html() . '<br />';
}[/php][/table]

В этом примере текст BBCode обрабатывается не при инициализации объекта, а путем вызова специального метода [b][tt]parse[/tt][/b].

Для работы со смайликами в классе [b][tt]bbcode[/tt][/b] предусмотрено свойство [b][tt]mnemonics[/tt][/b], которое является массивом и должно содержать пары

[center][tt]'мнемоника' => 'ее замена'[/tt][/center]

Например: [bbcode]':)' => '<img src="ulibka.gif" alt="Улыбка" />'[/bbcode]

Сформируйте массив замен и положите его в [b][tt]mnemonics[/tt][/b]. Тогда ваши смайлики будут обрабатываться. Смайлики не будут вставляться в содержимое тегов [bbcode]@l;bbcode@r;[/bbcode], [bbcode]@l;code@r;[/bbcode], [bbcode]@l;nobb@r;[/bbcode] и [bbcode]@l;php@r;[/bbcode].

Пример PHP-кода, устанавливающего набор смайликов:

[table border=0 align=center][tr][td][php]$text = 'Переменная [b]BBCode[/b] со смайликами: :) :D';
// Формируем список смайликов:
$smiles = array(
        ':)' => '<img src="smilies/2.gif" alt="Well" />',
        ':D' => '<img src="smilies/1.gif" alt="Very we!" />'
    );
// Подключаем библиотеку с классом
require_once 'ваш/путь/bbcode.lib.php';
// Создаем объект и распарсиваем $text
$bb = new bbcode($text);
// Задаем набор смайликов
$bb -> mnemonics = $smiles;
// Конвертируем BBCode в HTML и выводим его
echo $bb -> get_html();[/php][/table]

Более подробно о работе с библиотекой смотрите ниже, в разделе "API".

[h2 align=center][anchor=api /]API[/h2]

Объект класса [b]bbcode[/b] может быть инициализирован без параметров:

[table border=0 align=center][tr][td][php]$bb = new bbcode;[/php][/table]

Или с параметрами следующих типов:

[list=1]
[*]Строка с тегами BBCode:
[table border=0 align=center][tr][td][php]$text = 'Строка с тегами @l;b@r;@l;i@r;BBCode@l;/i@r;@l;/b@r;.';
$bb = new bbcode($text);[/php][/table]

[*]Массив с синтаксическим разбором BBCode. Описание этого массива смотрите в описании свойства [b]syntax[/b]. Инициализация аналогична:

[table border=0 align=center][tr][td][php]$text = 'Строка с тегами @l;b@r;@l;i@r;BBCode@l;/i@r;@l;/b@r;.';
$bb1 = new bbcode($text);
$bb2 = new bbcode($bb1 -> syntax);
if ($bb1 -> get_html() == $bb2 -> get_html()) {
    echo 'Один и тот же HTML';
}[/php][/table]

[*]Массив с деревом элементов BBCode. Описание этого массива смотрите в описании свойства [b]tree[/b]. Инициализация аналогична:

[table border=0 align=center][tr][td][php]$text = 'Строка с тегами @l;b@r;@l;i@r;BBCode@l;/i@r;@l;/b@r;.';
$bb1 = new bbcode($text);
$bb2 = new bbcode($bb1 -> tree);
if ($bb1 -> get_html() == $bb2 -> get_html()) {
    echo 'Один и тот же HTML';
}[/php][/table]
[/list]

Если конструктор класса получает массив, то считает его результатом синтаксического анализа какого-то ББКода и сохраняет в [b][tt]$this -> syntax[/tt][/b] или в [b][tt]$this -> tree[/tt][/b] в зависимости от структуры. Если получает непустую строку, то сохраняет ее в [b][tt]$this -> text[/tt][/b]. По полученному аргументу вычисляет все три свойства.

[h3 align=center][anchor=properties /]Свойства класса bbcode[/h3]

[list]
[*][b][tt]tag[/tt][/b] - имя тега, которому сопоставлен данный экземпляр класса. Или пустая строка, если объект не сопоставлен конкретному тегу. Это свойство может понадобиться вам, если захотите добавить свой тег, или переопределить какой-то из сущуествующих. Более подробные пояснения смотрите ниже.

[*][b][tt]attrib[/tt][/b] - массив пар
[center][tt][имя атрибута] => значение атрибута[/tt][/center]

для тега, которому сопоставлен экземпляр класса. Если объект не сопоставлен конкретному тегу, то этот массив пуст. Это свойство может понадобиться вам, если захотите добавить свой тег, или переопределить какой-то из сущуествующих. Более подробные пояснения смотрите ниже.

[*][b][tt]text[/tt][/b] - текст с обрабатываемым ББКодом. Этот текст ложится сюда при инициализации объекта, и меняется при каждом вызове конструктора класса или метода [b][tt]parse[/tt][/b].

Свойство [b][tt]text[/tt][/b] может оказаться полезным для оптимизации работы ваших скриптов. Из следующих примеров это станет более понятно:

[table align="center"][tr][td][php]/*
Получаем текст BBCode, парсим его, и результат парсинга сохраняем в файле
(это в примере. Лучше - в базе данных). Это позволит не парсить один и тот же
текст дважды.
*/
$text = isset($_POST['text']) ? $_POST['text'] : '';
require_once 'ваш/путь/bbcode.lib.php';
$bb = new bbcode($text);
$fp = fopen('./bb_syntax', 'wb');
fwrite($fp, serialize($bb -> syntax));
fclose($fp);[/php][/table]

Теперь, для восстановления исходного BBCode нам понадобится свойство [b][tt]text[/tt][/b]:

[table align="center"][tr][td][php]/*
Берем из файла (для примера) результат парсинга BBCode, восстанавливаем
исходный BBCode и выдаем его для редактирования
*/
$syntax = unserialize(file_get_contents('./bb_syntax'));
require_once 'ваш/путь/bbcode.lib.php';
$bb = new bbcode($syntax);
echo '<textarea cols="100" rows="30">';
echo htmlspecialchars($bb -> text);
echo '</textarea>';[/php][/table]

В следующем примере берем из файла результат парсинга BBCode, генерируем HTML и выводим его на печать:

[table align="center"][tr][td][php]$syntax = unserialize(file_get_contents('./bb_syntax'));
require_once 'ваш/путь/bbcode.lib.php';
$bb = new bbcode($syntax);
echo $bb -> get_html();[/php][/table]

[*][b][tt]syntax[/tt][/b] - массив, содержащий синтаксический разбор ББКода. Заполняется при вызове конструктора класса или при вызове метода [b][tt]parse[/tt][/b]. Имеет следующую структуру:

[table border=0 align=center][tr][td][code]Array
(
    ...
    @l;i@r; => Array  // @l;i@r; - целочисленный ключ начиная с 0
        (
            [type] => тип элемента: 'text', 'open', 'close' или 'open/close'
                      'text'  - элемент соответствует тексту между тегами
                      'open'  - элемент соответствует открывающему тегу
                      'close' - элемент соответствует закрывающему тегу
                      'open/close' - элемент соответствует закрытому тегу
                                     (например такому: @l;img="..." /@r;)
            [str]  => строковое представление элемента: текст между тегами
                      или тег (например: '@l;FONT color=red size=+1@r;')
            [name] => имя тега. Всегда в нижнем регистре. Например: 'color'.
                      Значение [name] отсутствует для элементов типа 'text'
                      и может быть пустой строкой для элементов типа
                      'close'. В последнем случае элемент будет
                      соответствовать тегу '@l;/@r;', который будет считаться
                      закрывающим для последнего незакрытого перед ним.
            [attrib] => Array         // Это значение существует только для
                (                     // элементов типов 'open' и
                    ...               // 'open/close'
                    ...
                    [имя атрибута] => значение атрибута. Например:
                    ...               @l;color@r; => red
                                      Имя атрибута всегда в нижнем регистре.
                                      Значение атрибута может быть пустой
                                      строкой. Имя тега тоже присутствует в
                                      списке атрибутов. Это для того, чтобы
                                      можно было работать, например, с
                                      такими тегами - @l;color="#555555"@r;
                )
            [layout] => Array                 // Это значение несуществует
                (                             // для элементов типа 'text'.
                    [0] => Array              // Массив содержит пары
                        (                     // ( тип строки , строка )
                            [0] => 0          // Типы могут быть следующие:
                            [1] => [          // 0 - скобка ('[' или ']')
                        )                     // 1 - слэш '/'
                    ...                       // 2 - имя тега
                    @l;i@r; => Array              //     (например - 'FONT')
                        (                     // 3 - знак '='
                            [0] => тип строки // 4 - строка из пробельных
                            [1] => строка     //     символов
                        )                     // 5 - кавычка или апостроф,
                    ...                       //     ограничивающая значение
                                              //     атрибута
                )                             // 6 - имя атрибута
        )                                     // 7 - значение атрибута
    ...
)[/code][/table]

Свойство [tt][b]syntax[/b][/tt] может помочь вам, во-первых, оптимизировать свои скрипты. Пример, как это сделать, смотрите выше. Во-вторых, это свойство будет вам полезно, если захотите реализовать какую-то нестандартную операцию над BBCode. Например, - вырезать все теги.

[*][b][tt]tree[/tt][/b] - массив, содержащий нормализованное дерево ББКода. Получается из [tt][b]syntax[/b][/tt] в результате его логического анализа:

[list=1]
[*][tt][b]syntax[/b][/tt] преобразовывается в правильную скобочную структуру
[*]Затем преобразовываются в текст все элементы, которым запрещено находиться в данном месте. (Например, теги, вложенные в [bbcode]@l;nobb@r;[/bbcode])
[*]Одномерный массив преобразуется в дерево.
[/list]

Вот структура массива [b][tt]tree[/tt][/b]:

[table border=0 align=center][tr][td][code]Array
(
    ...
    @l;i@r; => Array      i - целочисленный ключ начиная с 0
        (
            [type] => тип элемента. Может иметь только два значения: 'item'
                      и 'text'. В первом случае элемент соответствует
                      какому-то тегу. Во втором случае элемент является
                      строкой текста без тегов.

            [name] => имя тега в нижнем регистре. Например: 'h1'. [name]
                      определен только для элементов типа 'item' и
                      отсутствует для элементов типа 'text'.

            [attrib] => Array         Список значений атрибутов. Определен
                (                     только для элементов типа 'item' и
                    ...               отсутствует для элементов типа 'text'.
                    ...
                    [имя атрибута] => значение атрибута. Например:
                    ...               @l;align@r; => center
                    ...               Имя атрибута всегда в нижнем регистре.
                                      Значение атрибута может быть пустой
                                      строкой. Имя тега тоже присутствует в
                                      списке атрибутов. Это для того, чтобы
                                      можно было работать, например, с
                )                     такими тегами - @l;align=right@r;

            [val] => Array            Дерево подэлементов данного элемента.
                (                     Существует только для элементов типа
                    ...               'item' и отсутствует для элементов
                    @l;i@r; => Array      типа 'text'. Структура полностью
                    ...               идентична структуре свойства
                    ...               $this -> tree.
                )
            [str] => строка текста без тегов.
                     Напрмер: 'Хорошо живет на свете Виннипух'.
                     [str] существует только для элементов типа 'text' и не
                     существует для элементов типа 'item'.
        )
    ...
)[/code][/table]

Свойство [b][tt]tree[/tt][/b] содержит более полный разбор BBCode, чем свойство [tt][b]syntax[/b][/tt]. Но если из [tt][b]syntax[/b][/tt] возможно однозначно восстановить исходный текст BBCode, то из [b][tt]tree[/tt][/b] это, скорее всего, окажется невозможно.

Вам обязательно понадобится свойство [b][tt]tree[/tt][/b], если вы будете создавать свои теги.

[*][b][tt]tags[/tt][/b] - это свойство - ассоциированный массив пар

[center]'имя_тега' => имя класса, реализующего соответствующий тег[/center]

Все теги, разрешенные в ББКоде, должны быть представлены в этом массиве. Следующий пример показывает, как можно исключить из обработки какой-либо тег:

[table align="center"][tr][td][php]// Обрабатываем текст BBCode без тега @l;h1@r;
$text = '@l;h1@r;BBCode@l;/h1@r; Пишем про @l;b@r;ББКод@l;/b@r;';
require_once 'ваш/путь/bbcode.lib.php';
$bb = new bbcode;
unset($bb -> tags['h1']);
$bb -> parse($text);
echo $bb -> get_html();[/php][/table]

Процедура добавления тега несколько более сложна. Поэтому будет описана отдельно.

[*][b][tt]children[/tt][/b] - массив имен тегов, которым разрешено быть вложенными в данный. Если данный объект не сопоставлен какому-либо тегу, то это - массив имен тегов, которым разрешено находиться в корне дерева элементов.

[*][b][tt]mnemonics[/tt][/b] - массив мнемоник - смайлики и прочие условные обозначения, которые должны заменяться на что-то. Ключ - мнемоника, значение - на что заменяется. Например:

[center][tt]':-)' => '<img src="smile.gif" />'[/tt][/center]

[*][b][tt]autolinks[/tt][/b] - опция, включающая автоматические ссылки. По умолчанию установлена в [b][tt]true[/tt][/b] (автоматические ссылки включены). Для отключения ссылок должна быть установлена в [b][tt]false[/tt][/b]. Пример:

[table align="center"][tr][td][php]$text = 'Статья про @l;b@r;BBCode@l;/b@r; - http://www.pc.uz/documents/text/732.html';
require_once 'ваш/путь/bbcode.lib.php';
$bb = new bbcode($text);
// Отключаем автоматические ссылки:
$bb -> autolinks = false;
echo $bb -> get_html() . '<br />';
// Включаем автоматические ссылки:
$bb -> autolinks = true;
echo $bb -> get_html();[/php][/table]

[*][b][tt]is_close[/tt][/b] - свойство, устанавливающее значение по умолчанию для дочерних классов (тегов), для которых означает следующее:

[list]
[*][b]true[/b]  - данный тег всегда закрыт (например, - [bbcode]@l;hr@r;[/bbcode])
[*][b]false[/b] - данный тег может не быть закрытым
[/list]

Это свойство может понадобится вам при конструировании собственных тегов.

[*][b][tt]lbr[/tt][/b] - свойство, устанавливающее значение по умолчанию для дочерних классов (тегов), - число переводов строк, которые должны игнорироваться перед тегом. Это свойство может понадобится вам при конструировании собственных тегов. Например, тег [bbcode]@l;h1@r;[/bbcode] сам по себе создает разрыв перед собой, значит обработчик, должен проигнорировать перед ним один разрыв, поставленный пользователем в исходном коде. Этот факт указан в описании специального класса:

[table align="center"][tr][td][php]var $lbr = 1;[/php][/table]
По умолчанию значение этого свойства установлено в 0.

[*][b][tt]rbr[/tt][/b] - свойство, устанавливающее значение по умолчанию для дочерних классов (тегов), - число переводов строк, которые должны игнорироваться после тега. Это свойство может понадобится вам при конструировании собственных тегов. Например, тег [bbcode]@l;h1@r;[/bbcode] сам по себе создает разрыв после себя, равный примерно двум переводам строк, значит обработчик, должен проигнорировать после него два разрыва, поставленных пользователем в исходном коде. Этот факт указан в описании специального класса:

[table align="center"][tr][td][php]var $rbr = 2;[/php][/table]
По умолчанию значение этого свойства установлено в 0.
[/list]

[h3 align=center][anchor=methods /]Методы класса bbcode[/h3]

[list]
[*][b][tt]get_tokens()[/tt][/b] - Функция парсит текст BBCode (который берет из [b][tt]$this -> text[/tt][/b]) и возвращает масив пар "число (тип лексемы) - лексема", где типы лексем могут быть следующие:

[list=1]
[*=0] - открывющая квадратная скобка ("[b]@l;[/b]")
[*] - закрывающая квадратная cкобка ("[b]@r;[/b]")
[*] - двойная кавычка ('[b]"[/b]')
[*] - апостроф ("[b]'[/b]")
[*] - равенство ("[b]=[/b]")
[*] - прямой слэш ("[b]/[/b]")
[*] - последовательность пробельных символов (" ", "[b]\t[/b]", "[b]\n[/b]", "[b]\r[/b]", "[b]\0[/b]" или "[b]\x0B[/b]")
[*] - последовательность прочих символов, не являющаяся именем тега
[*] - имя тега
[/list]


[*][b][tt]parse([i]mixed[/i] code)[/tt][/b] - парсер BBCode. Совершает синтаксический разбор BBCode, инициализирует свойства [b][tt]syntax[/tt][/b] и [b][tt]tree[/tt][/b]. Необязательный аргумент [b][tt]code[/tt][/b] может быть строкой с текстом BBCode или массивом типа [b][tt]syntax[/tt][/b] или массивом типа [b][tt]tree[/tt][/b]. Если [b][tt]code[/tt][/b] не указан, то синтаксическому разбору подвергается [b][tt]$this -> text[/tt][/b]. Пример использования:

[table align=center][tr][td][php]$text = 'Строка с тегами @l;b@r;@l;i@r;BBCode@l;/i@r;@l;/b@r;.';
$bb = new bbcode;
// Парсим $text:
$bb -> parse($text);
// Выводим HTML:
echo $bb -> get_html();[/php][/table]

[*][b][tt]specialchars([i]string[/i] string)[/tt][/b] - конвертирует специальные символы в строке [b][tt]string[/tt][/b] в мнемоники BBCode. Вот таблица трансляции:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr][th]Спецсимвол[th]Мнемоника
[tr][td align=center]@l;[td align=center]@at;l;
[tr][td align=center]@r;[td align=center]@at;r;
[tr][td align=center]@q;[td align=center]@at;q;
[tr][td align=center]@a;[td align=center]@at;a;
[tr][td align=center]@at;[td align=center]@at;at;
[/table]

[*][b][tt]unspecialchars([i]string[/i] string)[/tt][/b] - конвертирует мнемоники BBCode в строке [b][tt]string[/tt][/b] в специальные символы. Это - обратная функция для [b][tt]specialchars[/tt][/b].

[*][b][tt]must_close_tag([i]string[/i] current, [i]string[/i] next)[/tt][/b] - логическая функция. Проверяет, должен ли тег с именем [b][tt]current[/tt][/b] закрыться перед началом тега с именем [b][tt]next[/tt][/b]. Возвращает [b][tt]true[/tt][/b], если должен закрыться и [b][tt]false[/tt][/b] в противном случае.

[*][b][tt]normalize_bracket([i]array[/i] syntax)[/tt][/b] - превращает массив со структурой как у свойства [b][tt]syntax[/tt][/b] в правильную скобочную структуру. У возвращаемого массива отсутствует элементы [b][tt]'layout'[/tt][/b], но присутствуют элементы [b][tt]'level'[/tt][/b], куда пишется уровень вложенности тега.

[*][b][tt]get_tree()[/tt][/b] - обрабатывает массив [b][tt]$this -> syntax[/tt][/b], перезаписывает свойство [b][tt]tree[/tt][/b] и возвращает дерево элементов.

[*][b][tt]get_syntax([i]array[/i] tree)[/tt][/b] - конвертит дерево элементов BBCode в массив со структурой свойства [b][tt]syntax[/tt][/b] и возвращает результат. Необязательный аргумент [b][tt]tree[/tt][/b] обязан иметь ту же структруру, что и свойство [b][tt]tree[/tt][/b]. Если аргумент не указан, то обрабатывается [b][tt]$this -> tree[/tt][/b].

[*][b][tt]insert_smiles([i]string[/i] text)[/tt][/b] - обрабатывает строку [b][tt]text[/tt][/b]: мнемонизирует HTML-код, заменяет разрывы строк на [b][tt]<br />[/tt][/b], вставляет смайлики (перечисленные в массиве [b][tt]mnemonics[/tt][/b]) и "автоматические ссылки" (если опция [b][tt]autolinks[/tt][/b] установлена в [b][tt]true[/tt][/b]).

[*][b][tt]highlight()[/tt][/b] - возвращает подсвеченный BBCode. Пример использования:

[table align=center][tr][td][php]$text = 'Строка с тегами @l;b@r;@l;i@r;BBCode@l;/i@r;@l;/b@r;.';
$bb = new bbcode($text);
// Выводим подсвеченный BBCode:
echo $bb -> highlight();[/php][/table]

[*][b][tt]get_html([i]array[/i] elems)[/tt][/b] - генерирует и возвращает HTML-код. Необязательный аргумент [b][tt]elems[/tt][/b] обязан иметь ту же структруру, что и свойство [b][tt]tree[/tt][/b]. Если аргумент не указан, то обрабатывается [b][tt]$this -> tree[/tt][/b]. Пример использования:

[table align=center][tr][td][php]$text = 'Строка с тегами @l;b@r;@l;i@r;BBCode@l;/i@r;@l;/b@r;.';
$bb = new bbcode($text);
// Выводим HTML:
echo $bb -> get_html();[/php][/table]
[/list]

[h3 align=center][anchor=add_tag /]Как создать тег[/h3]

Чтобы добавить еще один тег, нужно, во-первых, написать дочерний класс к классу [b][tt]bbcode[/tt][/b], реализующий специфику вашего тега, и, во-вторых, добавить имя вашего тега и соответствющего ему класса в массив [b][tt]tags[/tt][/b]. В следующем общем примере продемонстрировано практически все, что может вам понадобиться при описании нового тега(ов):

[table align=center][tr][td][php]/* Класс для тегов [mytag=Имя friends=Друзья]...[mytag] и
   [yourtag=Имя friends=Друзья]...[yourtag] */
class my_bbcode extends bbcode {
    /* Являются ли теги [mytag] и [yourtag] всегда закрытым
       (наподобие @l;hr@r;) */
    var $is_close = false;
    /* Число разрывов строк, которые должны быть игнорированы перед тегом
       [mytag] или [yourtag] */
    var $lbr = 1;
    /* Число разрывов строк, которые должны быть игнорированы после тега
       [mytag] или [yourtag] */
    var $rbr = 1;
    /* Перечисляем теги, открытие которых должно привести к автоматическому
       закрытию тега [mytag] или [yourtag] */
    var $ends = array('*','td','th','tr');
    /* Перечисляем теги, которые должны быть автоматически закрыты при открытии
       тега [mytag] или [yourtag] */
    var $stop = array('a','b','u','s');
    /* Перечисляем теги, которым разрешено быть вложенными непосредственно в тег
       [mytag] или [yourtag] */
    var $children = array('b','color','i','u','url');
    /* Перечисляем теги, непосредственно в которые разрешено вкладывать теги
       [mytag] и [yourtag] */
    var $parent = array('align','td');
    /* Разрешено ли использовать теги [mytag] и [yourtag] в корне дерева
       элементов BBCode.
       (Не всем разрешено. Например, тегу @l;td@r; запрещено) */
    var $top_level = true;
    /* Описываем конвертацию в HTML */
    function get_html() {
        $result = '<p>';
        /* $this -> tag - имя текущего тега. Всегда доступно.
           $this -> attrib - массив значений атрибутов. Всегда доступен.
           Имеет структуру: 'имя_атрибута' => значение атрибута */
        if ('mytag' == $this -> tag) {
            $result .= 'Меня зовут '.$this -> attrib['mytag'].'<br />';
        } else {
            $result .= 'Тебя зовут '.$this -> attrib['yourtag'].'<br />';
        }
        if (isset($this -> attrib['friends'])) {
            $result .= 'Друзья: '.$this -> attrib['friends'].'<br />';
        }
        /* parent::get_html($this -> tree) - Возвращает HTML, сгенерированный из
                                             содержимого тега. */
        $result .= parent::get_html($this -> tree).'</p>';
        return $result;
    }
}[/php][/table]

Написав этот класс, можно пользоваться тегами [mytag] и [yourtag]:

[table align=center][tr][td][php]$bb = new bbcode;
// Включаем новые теги в список поддерживаемых тегов:
$bb -> tags['mytag'] = 'my_bbcode';
$bb -> tags['yourtag'] = 'my_bbcode';
// Тестируем:
$text = 'Пробуем: [mytag=Вася friends="Петя и Коля"]Ура![/mytag]
Вторая проба: [yourtag=Лена]Красота - [b]великая[/b] сила![/yourtag]';
$bb -> parse($text);
echo $bb -> get_html();[/php][/table]

Еще несколько замечаний:

[list]
[*]Свойство [b][tt]is_close[/tt][/b] указывать необязательно. Оно по умолчанию установлено в [b][tt]false[/tt][/b].

[*]Свойство [b][tt]lbr[/tt][/b] указывать необязательно. Оно по умолчанию установлено в [b][tt]0[/tt][/b].

[*]Свойство [b][tt]rbr[/tt][/b] указывать необязательно. Оно по умолчанию установлено в [b][tt]0[/tt][/b].

[*]Свойство [b][tt]stop[/tt][/b] указывать необязательно.

[*]Свойство [b][tt]children[/tt][/b] указывать необязательно. Если оно не указано, то в данный тег можно будет вложить любой тег, который указан в свойстве [b][tt]children[/tt][/b] родительского класса.

[*]Свойство [b][tt]parent[/tt][/b] указывать необязательно.

[*]Свойство [b][tt]top_level[/tt][/b] указывать необязательно. Если оно неуказано, то вопрос, разрешать ли тегу быть вложенным в корень дерева элементов BBCode, будет зависеть от того, указан ли этот тег в свойстве [b][tt]children[/tt][/b] объекта родительского класса.

[*]Если новый тег включить в список поддерживаемых тегов после того, как был распарсен текст с BBCode, то этот тег не будет обрабатываться.

[*]Вы можете не только добавлять собственные теги, но и переопределять умолчальные. Например, если вы хотите переопределить тег [bbcode]@l;code@r;[/bbcode], то должны написать свой альтернативный класс для этого тега и заменить на него умолчальный:

[table align=center][tr][td][php]$bb = new bbcode;
// Назначаем тегу @l;code@r; свой альтернативный класс my_code:
$bb -> tags['code'] = 'my_code';[/php][/table]
[/list]

[h2 align=center][anchor=css /]Применение CSS[/h2]

Для изменения внешнего вида сообщений BBCode, конвертированных в HTML, следует использовать CSS. Для облегчения этой задачи многим из тегов HTML, соответствующим тегам BBCode, прописаны специальные имена классов. В следующей таблице описаны некоторые селекторы, которые могут быть использованы в таблицах стилей.

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr][th]Селектор[th]Описание
[tr][td][b]a.bb[/b][td]Ссылки, соответствующие тегам [bbcode]@l;a@r;[/bbcode], [bbcode]@l;anchor@r;[/bbcode] и [bbcode]@l;url@r;[/bbcode].
[tr][td][b]a.bb_email[/b][td]Ссылки e-mail, соответствующие тегу [bbcode]@l;email@r;[/bbcode].
[tr][td][b]a.bb_google[/b][td]Ссылки на результаты поиска в GOOGLE, соответствующие тегу [bbcode]@l;google@r;[/bbcode].
[tr][td][b]abbr.bb[/b][td]Аббревиатуры, соответствующие тегу [bbcode]@l;abbr@r;[/bbcode].
[tr][td][b]acronym.bb[/b][td]Акронимы, соответствующие тегу [bbcode]@l;acronym@r;[/bbcode].
[tr][td][b]address.bb[/b][td]Контактная информация, соответствующая тегу [bbcode]@l;address@r;[/bbcode].
[tr][td][b]caption.bb[/b][td]Заголовки таблиц, соответствующие тегу [bbcode]@l;caption@r;[/bbcode].
[tr][td][b]code.bb[/b][td]Компьютерные коды, соответствующие тегу [bbcode]@l;code@r;[/bbcode].
[tr][td][b]div.bb[/b][td]Блоки, соответствующие тегам [bbcode]@l;align@r;[/bbcode], [bbcode]@l;center@r;[/bbcode], [bbcode]@l;justify@r;[/bbcode], [bbcode]@l;left@r;[/bbcode] и [bbcode]@l;right@r;[/bbcode].
[tr][td][b]div.bb_quote[/b][td]Тексты цитат, соответствующие тегу [bbcode]@l;quote@r;[/bbcode].
[tr][td][b]div.bb_quote_author[/b][td]Указания на авторов цитат, соответствующие тегу [bbcode]@l;quote@r;[/bbcode].
[tr][td][b]div.php[/b][td]Код PHP, соответствующий тегу [bbcode]@l;php@r;[/bbcode].
[tr][td][b]h1.bb[/b][td]Заголовки верхнего уровня, соответствующие тегу [bbcode]@l;h1@r;[/bbcode].
[tr][td][b]h2.bb[/b][td]Заголовки второго уровня, соответствующие тегу [bbcode]@l;h2@r;[/bbcode].
[tr][td][b]h3.bb[/b][td]Заголовки третьего уровня, соответствующие тегу [bbcode]@l;h3@r;[/bbcode].
[tr][td][b]hr.bb[/b][td]Горизонтальные линии, соответствующие тегу [bbcode]@l;hr@r;[/bbcode].
[tr][td][b]li.bb[/b][td]Элементы списков, соответствующие тегу [bbcode]@l;*@r;[/bbcode].
[tr][td][b]ol.bb[/b][td]Списки, соответствующие тегам [bbcode]@l;list=1@r;[/bbcode] и [bbcode]@l;list=a@r;[/bbcode].
[tr][td][b]table.bb[/b][td]Таблицы, соответствующие тегу [bbcode]@l;table@r;[/bbcode].
[tr][td][b]td.bb[/b][td]Ячейки таблиц, соответствующие тегу [bbcode]@l;td@r;[/bbcode].
[tr][td][b]th.bb[/b][td]Заголовки столбцов таблиц, соответствующие тегу [bbcode]@l;th@r;[/bbcode].
[tr][td][b]tr.bb[/b][td]Строки таблиц, соответствующие тегу [bbcode]@l;tr@r;[/bbcode].
[tr][td][b]ul.bb[/b][td]Списки, соответствующие тегу [bbcode]@l;list@r;[/bbcode] без указания типа.
[/table]

Подсветка BBCode внутри тега [bbcode]@l;bbcode@r;[/bbcode] также определяется средствами CSS. В следующей таблице описаны селекторы, которые могут быть использованы в таблицах стилей для подсветки BBCode:

[table border=1 align=center cellspacing=0 cellpadding=5]
[tr][th]Селектор[th]Описание
[tr][td][b]code.bb_code[/b][td]Контейнер подсвеченного BBCode
[tr][td][b]span.bb_spec_char[/b][td]Мнемоники спецсимволов
[tr][td][b]span.bb_mnemonic[/b][td]Прочие мнемоники (смайлики)
[tr][td][b]span.bb_autolink[/b][td]Автоматические ссылки
[tr][td][b]span.bb_tag[/b][td]Теги BBCode
[tr][td][b]span.bb_bracket[/b][td]Квадратные скобки, ограничивающие теги
[tr][td][b]span.bb_slash[/b][td]Слэши '/', которые закрывают теги
[tr][td][b]span.bb_tagname[/b][td]Имена тегов
[tr][td][b]span.bb_attrib_name[/b][td]Имена атрибутов
[tr][td][b]span.bb_equal[/b][td]Знаки равенства перед значениями атрибутов
[tr][td][b]span.bb_quote[/b][td]Кавычки, ограничивающие значения атрибутов
[tr][td][b]span.bb_attrib_val[/b][td]Значения атрибутов
[/table]

[h2 align=center][anchor=use /]Условия использования и инсталляция[/h2]

Скрипт распространяется бесплатно по лицензии GNU GPL v 2. Согласно этой лицензии вы можете свободно использовать, распространять и менять этот скрипт при условии, что ваши собственные программные продукты, использующие этот скрипт, не будут распространяться, либо будут распространяться по той-же лицензии GNU GPL.

Если вас не устраивает эта публичная лицензия, обращайтесь ко мне (dima@pc.uz). Поскольку весь исходный код этой библиотеки является моей собственностью, то при достижении соответствующего соглашения я могу предоставить ее вам по более пригодной для вас лицензии.

Инсталляция проста:
[list]
[*]Скачайте zip-архив с библиотекой.
[*]Распакуйте его куда-либо на своем сайте, поддерживающим PHP.
[*]Наберите в адресной строке броузера: [bbcode]http://ваш.сайт/ваш/путь/bbcode/[/bbcode]. Это - демонстрационная фича. - Убедитесь, что скрипт работает.
[*]В ваш рабочий скрипт вставьте строчку

[table border=0 align=center][tr]
[td][center][php]require_once 'ваш/путь/bbcode/bbcode.lib.php';[/php][/center][/table]
Готово. Можете пользоваться библиотекой.
[/list]

Если у вас уже была установлена предыдущая версия этой библиотеки, то вам достаточно заменить файл [b][tt]bbcode.lib.php[/tt][/b] на более новый. Если вы не изменяли код старой библиотеки, то у вас не должно возникнуть проблем с переходом на новую версию.

Скачать zip-архив со скриптом, тестами и набором смайликов можно [url=http://www.pc.uz/files/illustrations/bbcode/xbb.zip]здесь[/url].

Успешной работы!

[table align=center width=95%][tr]
[td align=left][b]Дмитрий Скоробогатов[/b]
[td align=right]08.03.2007
[/table]
