<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>DWmail - System Tests</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link href="style.css" rel="stylesheet" type="text/css" />
</head>
<body>
<p align="center"><img src="dwmail.jpg" alt="DWmail" width="197" height="65" /></p>
<p align="left" class="TableHeader">&nbsp;<b>PHP Version Checker</b></p>
<?php

echo ("<p><b>PHP Version</b>: " . phpversion());

function version_check($vercheck) {
	$minver = explode(".", $vercheck);
	$curver = explode(".", phpversion());
	$versionfailure = 0;
	if ($curver[0] < $minver[0]) {
		$versionfailure = 1;
	}
	if ($curver[1] < $minver[1] && ($curver[0] <= $minver[0]) && $versionfailure == 0) {
		$versionfailure = 1;
	}
	if (substr($curver[2], 0, 1) < $minver[2] && ($curver[1] <= $minver[1]) && ($curver[0] <= $minver[0]) && $versionfailure == 0) {
		$versionfailure = 1;
	}
	if ($versionfailure == 1) {
		echo (" - <span class=\"Fail\">PHP 4.1.0 or greater is required</span></p>");
		$versioncheck = true;
	}
	else {
		echo (" - <span class=\"Success\">OK</span></p>");
		$versioncheck = false;
	}
	return $versioncheck;
}
function check_trans_sid() {
	ob_start();
	phpinfo(INFO_GENERAL);
	$val_phpinfo .= ob_get_contents();
	ob_end_clean();
	if (strstr($val_phpinfo, "--enable-trans-sid")) {
		$sid_enabled = true;
	}
	else {
		$sid_enabled = false;
	}
	return $sid_enabled;
}

$versioncheck = & version_check('4.1.0');
?>
<p align="left" class="TableHeader">&nbsp;<b>Minimum System Requirements</b></p>
<?php

$sid_enabled = true;
if ($versioncheck == true) {
	$sid_enabled = & check_trans_sid();
}

$phpext = get_loaded_extensions();

echo ("<p><b>IMAP Extensions</b>: ");

if (in_array ("imap", $phpext)){
	echo (" <span class=\"Success\">Installed</span>");
} 
else {
	echo (" <span class=\"Fail\">Not Installed</span> - IMAP support is a core requirement to run DWmail");
}

echo ("<p><b>Session support</b>: ");

if (in_array ("session", $phpext)){
	echo (" <span class=\"Success\">Installed </span>");
} 
else {
	echo (" <span class=\"Fail\">Not Installed</span> - Session support is a core requirement to run DWmail");
}

echo ("<p><b>Perl Compatible Regular Expression (pcre) support</b>: ");

if (in_array ("pcre", $phpext)){
	echo (" <span class=\"Success\">Installed </span>");
} 
else {
	echo (" <span class=\"Fail\">Not Installed</span>");
}
?>
<p align="left" class="TableHeader">&nbsp;<b>Database Support</b></p>
<?php
echo ("<p><b>MySQL</b>: ");

if (in_array ("mysql", $phpext)){
	echo (" <span class=\"Success\">Installed</span>");
} 
else {
	echo (" <span class=\"Warning\">Not Installed</span>");
}
echo ("<br />(for calendar, addressbook and enhanced preferences support - optional but recommended)</p>");

echo ("<p><b>MySQLi (for PHP5+ and MySQL 4.1+ only)</b>: ");

if (in_array ("mysqli", $phpext)){
	echo (" <span class=\"Success\">Installed</span>");
} 
else {
	echo (" <span class=\"Warning\">Not Installed</span>");
}
echo ("</p>");

echo ("<p><b>PostgreSQL</b>: ");

if (in_array ("pgsql", $phpext)){
	echo (" <span class=\"Success\">Installed</span>");
} 
else {
	echo (" <span class=\"Warning\">Not Installed</span>");
}
echo ("</p>");
?>
<p align="left" class="TableHeader">&nbsp;<b>Recommended System Requirements</b></p>
<?php
echo ("<p><b>PSpell (spell checker)</b>: ");

if (in_array ("pspell", $phpext)){
	echo (" <span class=\"Success\">Installed</span>");
} 
else {
	echo (" <span class=\"Warning\">Not Installed</span>");
}
echo ("</p>");



$transidenabled = ini_get('session.use_trans_sid');

echo ("<p><b>Session trans_sid setting</b>: ");
if (($transidenabled == 0) || ($sid_enabled == false)) {
	echo (" <span class=\"Warning\">Disabled</span> - DWmail does work with trans_sid disabled, however we advise that you enable it in your PHP settings if you can");
}
else {
	echo (" <span class=\"Success\">Enabled</span>");
} 

echo ("<p><b>File uploads (sending attachment support)</b>:</p><p>");
$fileuploadsupport = ini_get('file_uploads');
$filetempdir = ini_get('upload_tmp_dir');
$filemaxsize = ini_get('upload_max_filesize');
$postmaxsize = ini_get('post_max_size');
$fileopenbasedir = ini_get('open_basedir');

if ($fileuploadsupport == 1){
	echo ("Upload Support: <span class=\"Success\">Enabled</span><br />");
} 
else {
	echo ("Upload Support: <span class=\"Warning\">Disabled</span> - You may not be able to send file attachments with emails<br />");
}
echo ("Upload temporary directory: ");
if (isset($filetempdir)) {
	echo ("$filetempdir - Make sure that you have access to this directory, especially if open_basedir is set<br />");
}
else {
	echo ("<span class=\"Warning\">Not Set</span> - We advise that you check your PHP configurations so that file uploads work <a href=\"http://www.php.net/features.file-upload\" target=\"_blank\">http://www.php.net/features.file-upload</a><br />");
}
echo ("Upload maximum file size: ");
if (isset($filemaxsize)) {
	echo ("$filemaxsize - Attachments above this size will be rejected<br />");
}
else {
	echo ("No Value: OK<br />");
}
echo ("Maximum POST size: ");
if (isset($postmaxsize)) {
	echo ("$postmaxsize - The maximum size any one email compose can be.<br /><br />");
}
else {
	echo ("No Value: OK<br /><br />");
}

echo ("Open basedir: ");
if (isset($fileopenbasedir)) {
	echo ($fileopenbasedir);
}
else {
	echo ("Not Set");
}
echo (" - If this is set, make sure that your temporary upload directory is accessible from here</p>");

echo ("<p><b>Zlib</b>: ");

if (in_array ("zlib", $phpext)){
	echo (" <span class=\"Success\">Installed</span>");
} 
else {
	echo (" <span class=\"Warning\">Not Installed</span>");
}
echo (" - Utility to allow dynamic creation of Zip files when downloading attachments</p>");
?>
</body>
</html>