<?php
/*



# This file is to display the contents of the compose box for Mozilla
# V-editor users
*/

require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/html.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/compose.inc.php");

require ("./includes/options.inc.php");

$id = $_GET['id'];
$mode = $_GET['mode'];
$edit = $_GET['edit'];
$postedit = $_GET['postedit'];

if (($_SESSION['sess_u'] == "") && ($_SESSION['sess_p'] == "")) {
	echo ("<p>" . $lang['SErrors']['Session'] . "</p>");
	exit;
}

$IMAPConnection = new WM_IMAPConnection($_SESSION);

$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();
if ($securitycheck == 0) {
	echo ("<p>" . $lang['SErrors']['IP'] . "</p>");
	exit;
}

$mailbox = $IMAPConnection->WM_IMAPConnect();

if ($UseDatabase == 1) {
	$GetSignature = trim($MySQLConnection->DB_GetPrefs('signature'));
	if ($GetSignature == FALSE) {
		$GetSignature = "";
	}
	else {
		$GetSignature = stripslashes($GetSignature);
		$GetSignature = strip_tags($GetSignature);
		if ($edit <> "text") {
			$GetSignature = nl2br($GetSignature);
		}
		else {
			$GetSignature = $crlf . $GetSignature;
		}
		$GetSignature .= $nlhtml . $crlf . $nlhtml . $crlf;
	}
}
else {
	$GetSignature = "";
}

if ($id <> "") {
	$IMAPConnection->WM_IMAPGetHeader($id);
	$headerdetails = $IMAPConnection->WM_IMAPFullHeaders();
	$subj = $IMAPConnection->WM_IMAPGetSubject();

	if ($subj == "") {
		$subj2 = "(no subject)";
	}
	if ($mode == "" || $mode == "all") {
		$subj2 = "RE: " . $MainSettings->CheckSlashes($subj);
	}
	elseif ($mode == "fwd") {
		$subj2 = "FW: " . $MainSettings->CheckSlashes($subj);
	}
	$structure = $IMAPConnection->WM_IMAPGetStructure($id);

	if (sizeof($structure->parts) > 1) {
		$sections = parseBody($structure);
		$attachments = get_attachments($sections);
		$embeddedattachments = get_embeddedattachments($sections);
	}

	if (is_array($sections)) {
		for($x=0; $x<sizeof($sections); $x++) {
			if ($sections[$x]["type"] == "multipart/alternative" && $sections[$x]["disposition"] != "attachment") {
				$message["alternative"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
			}
			elseif ($sections[$x]["type"] == "text/html"  && $sections[$x]["disposition"] != "attachment") {
				$message["html"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
				$message["html"] = parseEncoding($message["html"], $sections[$x]["encoding"]);
				$origformat = "html";
			}
			elseif ($sections[$x]["type"] == "text/plain"  && $sections[$x]["disposition"] != "attachment") {
				$message["text"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
				$message["text"] = parseEncoding($message["text"], $sections[$x]["encoding"]);
				$message["text"] = htmlspecialchars(stripslashes(trim($message["text"])));
				$origformat = "text";
			}
		}
		if (isset($message["html"]) && ($HTMLemail == 1 || ($HTMLemail == 2 && !isset($message["text"])))) {
			$content = stripslashes(trim($message["html"]));
			$origformat = "html";
			$CleanUpHTML = new HTMLCleanup($content);
			$CleanUpHTML->ChangeTarget();
			$CleanUpHTML->RemoveScripting();
			$CleanUpHTML->RemoveMalicious();
			$content = $CleanUpHTML->_body;
		}
		else {
			$content = $message["text"];
			$origformat = "text";
		}
	}
	else {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = parseEncoding($content, $encoding[$structure->encoding]);
		$origformat = "text";
	}
	unset ($message);
	if ($edit <> "text") {
		$nlhtml .= "<br />";
		$fonthtml = "<font face=\"arial, helvetica\" size=\"2\" color=\"#000000\">";
	}
	else {
		$nlhtml .= "";
		$fonthtml = "";
	}

	$message = $fonthtml . $crlf . $GetSignature . $nlhtml . $crlf . $crlf;
	if ($IncOrig == "1") {
		$message .= "-----" . $lang['SCompose']['ComposeOriginal'] . "-----" .  $nlhtml . $crlf;
		if ($edit == "html" || $edit == "veditor") {
			$message .= "<strong>" . $lang['SCompose']['From'] . ":</strong> " . $headerdetails['fromaddress'] . $nlhtml . $crlf;
			$message .= "<strong>" . $lang['SCompose']['Sent'] . ":</strong> " . $headerdetails['date'] . $nlhtml . $crlf;
			$message .= "<strong>" . $lang['SCompose']['To'] . ":</strong> " . $headerdetails['toaddress'] . $nlhtml . $crlf;

			if ($headerdetails['ccaddress'] <> "") {
				$message .= "<strong>" . $lang['SCompose']['Cc'] . ":</strong> " . $headerdetails['ccaddress'] . $crlf;
			}
			$message .= "<strong>" . $lang['SCompose']['Subject'] . ":</strong> " . $subj . $nlhtml . $nlhtml . $crlf . $crlf;
		}
		else {
			$message .= $lang['SCompose']['From'] . ": " . $headerdetails['fromaddress'] . $nlhtml . $crlf;
			$message .= $lang['SCompose']['Sent'] . ": " . $headerdetails['date'] . $nlhtml . $crlf;
			$message .= $lang['SCompose']['To'] . ": " . $headerdetails['toaddress'] . $nlhtml . $crlf;


			if ($headerdetails['ccaddress'] <> "") {
				$message .= $lang['SCompose']['Cc'] . ": " . $headerdetails['ccaddress'] . $crlf;
			}
			$message .= $lang['SCompose']['Subject'] . ": " . $subj . $nlhtml . $nlhtml . $crlf . $crlf;
		}

		if ($edit <> "text") {
			$message .= "</font>";
			if ($origformat == "text") {
				$content = nl2br($content);
			}
			$message .= $content;
		}
		else {
			if ($origformat == "html") {
				$content = str_replace ("<BR>", "\n", $content);
				$content = str_replace ("<BR />", "\n", $content);
				$content = str_replace ("<br>", "\n", $content);
				$content = str_replace ("<br />", "\n", $content);
				$content = str_replace ("</p>", "\n\n", $content);
				$content = str_replace ("</P>", "\n\n", $content);
			}
			$message = $message . strip_tags($content);
		}
		// Find any embedded images and replace their ID in the body of the message so we can view them
		if (is_array($embeddedattachments)) {
			for($x=0; $x<sizeof($embeddedattachments); $x++) {
				// Note this calls the same file as attachment download but we must set submit=inline to allow display rather than download
				$message = str_replace("cid:" . $embeddedattachments[$x]["id"], "attachment.php?submit=inline&amp;id=$id&amp;pid=" . $embeddedattachments[$x]["pid"]  . "&amp;" . strip_tags(SID), $message);
			}
		}
	}
}

if ($edit == "text" || $edit == "html") {
	$message = $MainSettings->CheckSlashes($message);
	if ((($postmode == "html") || ($postmode == "veditor")) && ($edit == "text")) {
		$message = str_replace ("<BR>", "\n", $message);
		$message = str_replace ("<BR />", "\n", $message);
		$message = str_replace ("<br>", "\n", $message);
		$message = str_replace ("<br />", "\n", $message);
		$message = str_replace ("</p>", "\n\n", $message);
		$message = str_replace ("</P>", "\n\n", $message);
		$message = strip_tags ($message);
	}
	elseif (($postmode == "text") && (($edit == "html") || ($edit == "veditor"))) {
		$message = nl2br ($message);
	}
	if ($message == "" && $GetSignature <> "") {
		$message = $crlf . $GetSignature;
	}
}
else {
	$message = $MainSettings->CheckSlashes($message);
	if (($postmode == "text") && (($edit == "html") || ($edit == "veditor"))) {
		$message = nl2br ($message);
	}
	if (($message == "")  && ($id == "") && ($mode == "")) {
		if ($GetSignature <> "") {
			$GetSignature = "<br />" . $GetSignature;
		}
		if (!isset($ve['c_fontface'])) {
			$ve['c_fontface'] = "Arial, Helvetica, sans-serif";
		}
		if (!isset($ve['c_fontsize'])) {
			$ve['c_fontsize'] = "2";
		}
		if (!isset($ve['c_fontcolour'])) {
			$ve['c_fontcolour'] = "#000000";
		}
		$message = "<font face=\"" . stripslashes($ve['c_fontface']) . "\" size=\"" . stripslashes($ve['c_fontsize']) . "\" color=\"" . stripslashes($ve['c_fontcolour']) . "\"><p>&nbsp;$GetSignature</p></font>";
	}
	elseif (($message <> "")  && ($id <> "")) {
		if (!isset($ve['r_fontface'])) {
			$ve['r_fontface'] = "Arial, Helvetica, sans-serif";
		}
		if (!isset($ve['r_fontsize'])) {
			$ve['r_fontsize'] = "2";
		}
		if (!isset($ve['r_fontcolour'])) {
			$ve['r_fontcolour'] = "#0000CC";
		}
		$message = "<font face=\"" . stripslashes($ve['r_fontface']) . "\" size=\"" . stripslashes($ve['r_fontsize']) . "\" color=\"" . stripslashes($ve['r_fontcolour']) . "\"><p>&nbsp;</p></font>\n" . $message;
	}
}

header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
?>
<html lang="<?php echo $_SESSION['DefaultLang']; ?>">
<head>
  <style type="text/css">
    body {background-color:white; text-align:left;}
  </style>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $_SESSION['DefaultCharSet']; ?>" />
</head>

<body>

<?php echo $message; ?>
</body>
</html>

