<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

@setlocale(LC_TIME, $AvailLangs[$DefaultLang]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($DefaultLang))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($DefaultLang))) . "/login.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

if ($UseDatabase == 1 && $StatsLogging == 1) {
	switch ($DatabaseType) {
		case 'mysqli':
			$DBLib = 'mysqli';
			break;
		case 'postgresql':
			$DBLib = 'postgresql';
			break;
		default:
			$DBLib = 'mysql';
			break;
	}
	require_once ("./includes/db_" . $DBLib . ".inc.php");
	$MySQLConnection = new DB_Connection($MySQLServer, $MySQLUsername, $MySQLPassword, $MySQLDBName);
	$MySQLMakeConnection = $MySQLConnection->DB_MakeConnection();

	$loginstoday = $MySQLConnection->DB_LoginPeriod(0);
	$loginsmonth = $MySQLConnection->DB_LoginPeriod(30);
}

$advancedlogin = $_GET['advancedlogin'];
$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageMenu = $getFile->fileRead('blankmenu');

$DefaultCharSet = $AvailLangs[$DefaultLang]['charset'];

$CodeSearch = array (
	"[mainmenu]",
	"[copyright]",
	"[folders]",
	"[header_refresh]",
	"[charset]",
	"[lang]",
	"[pagetitle]"
);

$CodeReplace = array (
	$PageMenu,
	$PageCopyright,
	"",
	"",
	$DefaultCharSet,
	$DefaultLang,
	" - " . $lang['SLogin']['LoginTitle']
);

$PageHeader = str_replace ($CodeSearch, $CodeReplace, $PageHeader);
$PageFooter = str_replace ($CodeSearch, $CodeReplace, $PageFooter);

$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

if ($advancedlogin == 1) {
	$LoginForm = $getFile->fileRead('advancedlogin');
}
else {
	$LoginForm = $getFile->fileRead('standardlogin');
}

header ("Content-Type: text/html; charset=" . $DefaultCharSet);
echo $PageHeader;

if ($DefaultType == "pop3") {
	$whichservertype = "<input type=\"radio\" name=\"t\" value=\"imap\" id=\"imap\" /> <label for=\"imap\"><acronym title=\"Internet Message Access Protocol 4\">IMAP4</acronym></label> <input type=\"radio\" name=\"t\" value=\"pop3\" checked=\"checked\" id=\"pop3\" /> <label for=\"pop3\"><acronym title=\"Post Office Protocol 3\">POP3</acronym></label>";
}
else {
	$whichservertype = "<input type=\"radio\" name=\"t\" value=\"imap\" checked=\"checked\" id=\"imap\" /> <label for=\"imap\"><acronym title=\"Internet Message Access Protocol 4\">IMAP4</acronym></label> <input type=\"radio\" name=\"t\" value=\"pop3\" id=\"pop3\" /> <label for=\"pop3\"><acronym title=\"Post Office Protocol 3\">POP3</acronym></label>";
}
if ($AllowSSLConnections == 1) {
	$whichservertype .= "<input type=\"radio\" name=\"t\" value=\"imapssl\" id=\"imapssl\" /> <label for=\"imapssl\"><acronym title=\"Internet Message Access Protocol 4 over Secure Sockets Layer\">IMAP4 (SSL)</acronym></label> <input type=\"radio\" name=\"t\" value=\"pop3ssl\" id=\"pop3ssl\" /> <label for=\"pop3ssl\"><acronym title=\"Post Office Protocol 3 over Secure Sockets Layer\">POP3 (SSL)</acronym></label>";
}

if (is_array($AvailLangs)) {
	$LangList = "<select name=\"l\">\n";
	while(list($key, $value) = each($AvailLangs)) {
		$LangList .= "<option value=\"" . $key . "\"";
		if ($key == $DefaultLang) {
			$LangList .= " selected=\"selected\"";
		}
		$LangList .= ">" . $AvailLangs[$key]['desc'] . " - " . $AvailLangs[$key]['charset'] . "</option>\n";
	}
	$LangList .= "</select>\n";
}
else {
	$LangList = "";
}

if (is_array($AllowedDomains)) {
	$DomainList = "<select name=\"d\">\n";
	for ($i=0; $i<count($AllowedDomains); $i++) {
		$DomainList .= "<option value=\"" . $AllowedDomains[$i] . "\"";
		if ($AllowedDomains[$i] == $DefaultDomain) {
			$DomainList .= " selected=\"selected\"";
		}
		$DomainList .= ">" . $AllowedDomains[$i] . "</option>\n";
	}
	$DomainList .= "</select>\n";
}
else {
	$DomainList = "";
}

$CodeSearch = array (
	"[fullemail]",
	"[username]",
	"[password]",
	"[mailserver]",
	"[servertype]",
	"[portnumber]",
	"[hiddenfields]",
	"[formaction]",
	"[domainlist]",
	"[language]"
);

$CodeReplace = array (
	"<input type=\"text\" name=\"e\" size=\"35\" />",
	"<input type=\"text\" name=\"u\" size=\"35\" />",
	"<input type=\"password\" name=\"p\" size=\"35\" />",
	"<input type=\"text\" name=\"s\" size=\"35\" />",
	$whichservertype,
	"<input type=\"text\" name=\"port\" size=\"35\" />",
	"<input type=\"hidden\" name=\"a\" value=\"1\" />",
	"dologin.php",
	$DomainList,
	$LangList
);

$LoginForm = str_replace ($CodeSearch, $CodeReplace, $LoginForm);
$LoginForm = LangReplace('SLogin', $LoginForm, $lang);

if (isset($loginstoday) && isset($loginsmonth)) {
	$LoginForm = str_replace("[ifstatslogging]", "", $LoginForm);
	$LoginForm = str_replace("[/ifstatslogging]", "", $LoginForm);
	$LoginForm = str_replace("[loginstoday]", $loginstoday, $LoginForm);
	$LoginForm = str_replace("[loginsmonth]", $loginsmonth, $LoginForm);
}
else {
	$LoginForm = preg_replace("/(\[)(ifstatslogging)(])(\r\n)*(.*)(\[\/ifstatslogging\])/siU", "", $LoginForm);
}

if ($FullLogin == 1) {
	$LoginForm = str_replace("[iffulllogin]", "", $LoginForm);
	$LoginForm = str_replace("[/iffulllogin]", "", $LoginForm);
	$LoginForm = preg_replace("/(\[)(ifshortlogin)(])(\r\n)*(.*)(\[\/ifshortlogin\])/siU", "", $LoginForm);
}
else {
	$LoginForm = str_replace("[ifshortlogin]", "", $LoginForm);
	$LoginForm = str_replace("[/ifshortlogin]", "", $LoginForm);
	$LoginForm = preg_replace("/(\[)(iffulllogin)(])(\r\n)*(.*)(\[\/iffulllogin\])/siU", "", $LoginForm);
}

echo $LoginForm;

echo $PageFooter;
?>


