<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/html.inc.php");
require ("./includes/config.inc.php");
require ("./includes/browser.inc.php");
require_once("./includes/mime.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/compose.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/utils.inc.php");

// It has been reported and replicated in a very few circumstances that
// $_SESSION['ca'] simply disappears from being set at the bottom
// of this page to being missing when reloaded right at this location.
// $_SESSION['ca'] is the array used for sending attachments
// If anyone can replicate this issue or find out why please let us know!

require ("./includes/options.inc.php");

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

if (isset($_GET['w']) && $_GET['w'] == 'popup') {
	$prependheader = "popup_";
}
else {
	$prependheader = "";
}

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageCompose = $getFile->fileRead('composemessage');
if ($AppendSignature == 1) {
	$PageSignature = $getFile->fileRead('signature');
}
else {
	$PageSignature = "";
}

$id = $_GET['id'];
if ($id == "") {
	$id = $_POST['id'];
}

if ($id == "") {
	$PageComposeMenu = "";
}
else {
	$PageComposeMenu = $getFile->fileRead('composemenu');
}

$isdraft = 0;

$draftmode = $_GET['w'];
if ($draftmode == 'draft') {
	$isdraft = 1;
}

$postmode = $_POST['edit'];

$mode = $_GET['mode'];
if ($mode == "") {
	$mode = $_POST['mode'];
}

// Compose Mode has been changed
if ($_POST['text']) {
	$edit = "text";
}
if ($_POST['html']) {
	$edit = "html";
}
if ($_POST['wysiwyg']) {
	$edit = "wysiwyg";
}

if (($DefaultComposeMode) && ($edit == "")) {
	$edit = $DefaultComposeMode;
}

$enablespellcheck = 0;
// Check that the pspell library is installed and that the $AvailLanguages array tells us that
// aspell support for the current language is enabled
if (function_exists('pspell_new') && $AvailLangs[trim($_SESSION['DefaultLang'])]['spell']['enable'] == 1) {
	$enablespellcheck = 1;
}

$MIMEChecker = new MIME();

$myoptions['DefaultComposeMode'] = $edit;

// Clear out old attachments from the session if we have a NEW email
if (!$_POST['submit'] && !$_POST['attachfile'] && !$_POST['text'] && !$_POST['html'] && !$_POST['wysiwyg'] && !$_POST['updateattachments']) {
	unset($_SESSION['ca']);
}
if ($UseDatabase == 1) {
	$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
}
else {
	if ($AllowCookies == 1) {
		$expiretime = 3600 * 8760;
		setcookie ("dwmailoptions", serialize($myoptions), time()+$expiretime);
	}
}

// Display text for the current Compose Mode
if ($edit == "text") {
	$currentmode = $lang['SCompose']['ComposePlain'];
}
elseif ($edit == "html") {
	$currentmode = $lang['SCompose']['ComposeHTML'];
}
else {
	$currentmode = $lang['SCompose']['ComposeWYSIWYG'];
}

$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

if ($_GET['id'] && $_GET['mode'] == 'fwd' && $isdraft <> 1) {
	$pagetitle = " - " . $lang['SCompose']['Forward'];
}
elseif ($_GET['id'] && $_GET['mode'] <> 'fwd' && $isdraft <> 1) {
	$pagetitle = " - " . $lang['SCompose']['Reply'];
}
else {
	$pagetitle = " - " . $lang['SCompose']['Title'];
}

$CodeSearch = array (
	"[view_id]",
	"[view_folder]",
	"[session_append]",
	"[session]",
);

$CodeReplace = array (
	$id,
	urlencode($_SESSION['folder']),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 0),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 1)
);

$PageComposeMenu = str_replace ($CodeSearch, $CodeReplace, $PageComposeMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", $pagetitle, $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);

$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();
$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$crlf = $MainSettings->GetCRLF();
$IMAPConnection->_crlf = $crlf;
$IMAPConnection->_charset = $_SESSION['DefaultCharSet'];

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

// Check to see if form has been submitted first and if so process a send email request
if (isset($_POST['submit']) || isset($_POST['savedraft'])) {
	// Page has been submitted as either a draft or as a send
	$replyto = $MainSettings->CheckSlashes(trim($_POST['replyto']));
	$replyto = str_replace("&quot;", '"', $replyto);
	$to = $MainSettings->CheckSlashes(trim($_POST['to']));
	$to = str_replace("&quot;", '"', $to);
	$to = str_replace(";", ",", $to);
	$cc = $MainSettings->CheckSlashes(trim($_POST['cc']));
	$cc = str_replace("&quot;", '"', $cc);
	$cc = str_replace(";", ",", $cc);
	$bcc = $MainSettings->CheckSlashes(trim($_POST['bcc']));
	$bcc = str_replace("&quot;", '"', $bcc);
	$bcc = str_replace(";", ",", $bcc);
	$alias = $MainSettings->CheckSlashes(trim(urldecode($_POST['alias'])));
	$alias = str_replace("&quot;", '"', $alias);
	$subject = $MainSettings->CheckSlashes(htmlspecialchars(trim($_POST['subject'])));
	$subject = str_replace("&quot;", '"', $subject);
	$body2 = $MainSettings->CheckSlashes(trim($_POST['body']));
	$priority = $_POST['priority'];
	$receipt = $_POST['receipt'];
	$attacharry = $_POST['attach'];

	$allowemail = 0;

	if (!isset($_SESSION['lastemail'])) {
		$_SESSION['lastemail'] = time();
		$allowemail = 1;
	}
	else {
		if ((time() - $_SESSION['lastemail']) >= $floodfilter) {
			$_SESSION['lastemail'] = time();
			$allowemail = 1;
		}
	}

	$to_array  = imap_rfc822_parse_adrlist($to, $DefaultDomain);
	$cc_array  = imap_rfc822_parse_adrlist($cc, $DefaultDomain);
	$bcc_array  = imap_rfc822_parse_adrlist($bcc, $DefaultDomain);

	if ($alias <> '') {
		$alias_array  = imap_rfc822_parse_adrlist($alias, $DefaultDomain);

		unset ($alias);
		if (is_array($alias_array)) {
			if ($alias_array[0]->personal <> "") {
				$checkordname = $MIMEChecker->check8bit($alias_array[0]->personal);
				if ($checkordname == TRUE) {
					$alias .= $MIMEChecker->RFCEncode($alias_array[0]->personal, $_SESSION['DefaultCharSet']) . " ";
				}
				else {
					$alias .= "\"" . $alias_array[0]->personal . "\" ";
				}
				unset ($checkordname);
			}
			$alias .= "<" . $alias_array[0]->mailbox . "@" . $alias_array[0]->host . ">";
		}
	}

	$recipientarray = array_merge ($to_array, $cc_array, $bcc_array);
	$recipientcount = count ($recipientarray);

	// Flood check handler
	if ($allowemail == 0 && !isset($_POST['savedraft'])) {
		$error_floodfilter = $lang['SCompose']['FloodFilter'];
		$error_floodfilter = str_replace("[floodfilter]", $floodfilter, $error_floodfilter);
		$errormessage = $error_floodfilter;
	}

	// Maximum recipient handler
	elseif ($recipientcount > $recipientmaximum && !isset($_POST['savedraft'])) {
		$errormessage = $lang['SCompose']['RecipientMaximum'];
		$errormessage = str_replace("[recipientmaximum]", $recipientmaximum, $errormessage);
	}

	// No recipients to email
	elseif ($recipientcount == 0 && !isset($_POST['savedraft'])) {
		$errormessage = $lang['SCompose']['NoRecipients'];
	}

	else {

		// Rebuild Email Addresses to RFC822 and RFC 2047 standards
		// Note if the personal name contains an @ and is not enclosed in quotes DWmail will generate an unexpected data error
		// We assume any email addresses taken from the database using GROUPS are already in RFC standards and so we won't re-parse through imap_rfc822_parse_adrlist()
		unset ($to);
		if (is_array($to_array)) {
			for($key=0; $key<sizeof($to_array); $key++) {
				if (($to_array[$key]->mailbox <> "" && substr($to_array[$key]->mailbox, 0, 6) <> "group:" && $to_array[$key]->host <> "") && ($to_array[$key]->mailbox <> "INVALID_ADDRESS" && $to_array[$key]->host <> ".SYNTAX-ERROR")) {
					if ($key <> 0) {
						$to .= ", ";
					}
					if ($to_array[$key]->personal <> "") {
						$checkordname = $MIMEChecker->check8bit($to_array[$key]->personal);
						if ($checkordname == TRUE) {
							$to .= $MIMEChecker->RFCEncode($to_array[$key]->personal, $_SESSION['DefaultCharSet']) . " ";
						}
						else {
							$to .= "\"" . $to_array[$key]->personal . "\" ";
						}
						unset ($checkordname);
					}
					$to .= "<" . $to_array[$key]->mailbox . "@" . $to_array[$key]->host . ">";
				}
				elseif (substr($to_array[$key]->mailbox, 0, 6) == "group:") {
					// We have found a group
					// At the moment, unfortunately we assume that details parsed from the database are in valid RFC format
					$groupname = substr($to_array[$key]->mailbox, 6);
					$grouplisting = $MySQLConnection->DB_FindGroup($groupname);
					if ($grouplisting) {
						while(list($key, $value) = each($grouplisting)) {
							if (isset($to) && $to <> '') {
								$to .= ", ";
							}
							$checkordname = $MIMEChecker->check8bit($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname']);
							if ($checkordname == TRUE) {
								$to .= $MIMEChecker->RFCEncode($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname'], $_SESSION['DefaultCharSet']) . " ";
							}
							else {
								$to .= "\"" . $grouplisting[$key]['firstname'] . " " . $grouplisting[$key]['lastname'] . "\" ";
							}
							$to .= "<" . $grouplisting[$key]['email'] . ">";
						}
					}
					else {
						// Group does not exist
						$errormessage = str_replace("[groupname]", $groupname, $lang['SContacts']['GroupSendError']);
					}
				}
			}
		}
		// Reset to array for SMTP sending
		unset ($to_array);
		$to_array  = imap_rfc822_parse_adrlist($to, $DefaultDomain);
		unset ($cc);
		if (is_array($cc_array)) {
			for($key=0; $key<sizeof($cc_array); $key++) {
				if (($cc_array[$key]->mailbox <> "" && substr($cc_array[$key]->mailbox, 0, 6) <> "group:" && $cc_array[$key]->host <> "") && ($cc_array[$key]->mailbox <> "INVALID_ADDRESS" && $cc_array[$key]->host <> ".SYNTAX-ERROR")) {
					if ($key <> 0) {
						$cc .= ", ";
					}
					if ($cc_array[$key]->personal <> "") {
						$checkordname = $MIMEChecker->check8bit($cc_array[$key]->personal);
						if ($checkordname == TRUE) {
							$cc .= $MIMEChecker->RFCEncode($cc_array[$key]->personal, $_SESSION['DefaultCharSet']) . " ";
						}
						else {
							$cc .= "\"" . $cc_array[$key]->personal . "\" ";
						}
						unset ($checkordname);
					}
					$cc .= "<" . $cc_array[$key]->mailbox . "@" . $cc_array[$key]->host . ">";
				}
				elseif (substr($cc_array[$key]->mailbox, 0, 6) == "group:") {
					// We have found a group
					// At the moment, unfortunately we assume that details parsed from the database are in valid RFC format
					$groupname = substr($cc_array[$key]->mailbox, 6);
					$grouplisting = $MySQLConnection->DB_FindGroup($groupname);
					if ($grouplisting) {
						while(list($key, $value) = each($grouplisting)) {
							if (isset($cc) && $cc <> '') {
								$cc .= ", ";
							}
							$checkordname = $MIMEChecker->check8bit($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname']);
							if ($checkordname == TRUE) {
								$cc .= $MIMEChecker->RFCEncode($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname'], $_SESSION['DefaultCharSet']) . " ";
							}
							else {
								$cc .= "\"" . $grouplisting[$key]['firstname'] . " " . $grouplisting[$key]['lastname'] . "\" ";
							}
							$cc .= "<" . $grouplisting[$key]['email'] . ">";
						}
					}
					else {
						// Group does not exist
						$errormessage = str_replace("[groupname]", $groupname, $lang['SContacts']['GroupSendError']);
					}
				}
			}
		}
		// Reset to array for SMTP sending
		unset ($cc_array);
		$cc_array  = imap_rfc822_parse_adrlist($cc, $DefaultDomain);
		unset ($bcc);
		if (is_array($bcc_array)) {
			for($key=0; $key<sizeof($bcc_array); $key++) {
				if (($bcc_array[$key]->mailbox <> "" && substr($bcc_array[$key]->mailbox, 0, 6) <> "group:" && $bcc_array[$key]->host <> "") && ($bcc_array[$key]->mailbox <> "INVALID_ADDRESS" && $bcc_array[$key]->host <> ".SYNTAX-ERROR")) {
					if ($key <> 0) {
						$bcc .= ", ";
					}
					if ($bcc_array[$key]->personal <> "") {
						$checkordname = $MIMEChecker->check8bit($bcc_array[$key]->personal);
						if ($checkordname == TRUE) {
							$bcc .= $MIMEChecker->RFCEncode($bcc_array[$key]->personal, $_SESSION['DefaultCharSet']) . " ";
						}
						else {
							$bcc .= "\"" . $bcc_array[$key]->personal . "\" ";
						}
						unset ($checkordname);
					}
					$bcc .= "<" . $bcc_array[$key]->mailbox . "@" . $bcc_array[$key]->host . ">";
				}
				elseif (substr($bcc_array[$key]->mailbox, 0, 6) == "group:") {
					// We have found a group
					// At the moment, unfortunately we assume that details parsed from the database are in valid RFC format
					$groupname = substr($bcc_array[$key]->mailbox, 6);
					$grouplisting = $MySQLConnection->DB_FindGroup($groupname);
					if ($grouplisting) {
						while(list($key, $value) = each($grouplisting)) {
							if (isset($bcc) && $bcc <> '') {
								$bcc .= ", ";
							}
							$checkordname = $MIMEChecker->check8bit($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname']);
							if ($checkordname == TRUE) {
								$bcc .= $MIMEChecker->RFCEncode($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname'], $_SESSION['DefaultCharSet']) . " ";
							}
							else {
								$bcc .= "\"" . $grouplisting[$key]['firstname'] . " " . $grouplisting[$key]['lastname'] . "\" ";
							}
							$bcc .= "<" . $grouplisting[$key]['email'] . ">";
						}
					}
					else {
						// Group does not exist
						$errormessage = str_replace("[groupname]", $groupname, $lang['SContacts']['GroupSendError']);
					}
				}
			}
		}
		// Reset to array for SMTP sending
		unset ($bcc_array);
		$bcc_array  = imap_rfc822_parse_adrlist($bcc, $DefaultDomain);

		$recipientarray = array_merge ($to_array, $cc_array, $bcc_array);
		$recipientcount = count ($recipientarray);

		// Maximum recipient handler
		if ($recipientcount > $recipientmaximum && !isset($_POST['savedraft'])) {
			$errormessage = $lang['SCompose']['RecipientMaximum'];
			$errormessage = str_replace("[recipientmaximum]", $recipientmaximum, $errormessage);
		}

		// Append an administrator signature if necessary
		if ($AppendSignature == 1 && !isset($_POST['savedraft'])) {
			$PageSignature = $crlf . $crlf . $PageSignature;
		}
		if ($crlf == "\n") {
			$body2 = str_replace("\r", "", $body2);
			$PageSignature = str_replace("\r", "", $PageSignature);
		}

		if ($_POST['edit'] <> "text") {
			$PageSignature = nl2br($PageSignature);
			$PageSignature = parseLinks($PageSignature, 0);
			if (isset($_POST['savedraft'])) {
				// Don't set <html> or <body> in a draft message
				$body2= $body2 . $PageSignature;
			}
			else {
				$body2 = "<html><title>" . $subject . "</title><body>" . $body2 . $PageSignature . "</body></html>";
			}
		}
		else {
			$body2 = $body2 . $PageSignature;
		}

		// Handle forwarded attachments
		if (is_array($attacharry)) {
			$structure = $IMAPConnection->WM_IMAPGetStructure($_POST['msgid']);
			$sections = parseBody($structure);

			for ($x=0; $x<sizeof($attacharry); $x++) {
				$whichsection = $attacharry[$x];
				settype($whichsection, "integer"); 

				for($i=0; $i<sizeof($sections); $i++) {
					if($sections[$i]["pid"] == $whichsection) {
						$type = $sections[$i]["type"];
						$encoding = $sections[$i]["encoding"];
						$filename = $sections[$i]["name"];
						$size = $sections[$i]["size"];
						$description = $sections[$i]["description"];
						$disposition = $sections[$i]["disposition"];
						$cid = $sections[$i]["id"];
					}
				}

				$attachment = $IMAPConnection->WM_IMAPGetBody($_POST['msgid'], $whichsection, -1);
				$finalfile = parseEncoding($attachment, $encoding);

				$decodedsize = strlen($finalfile);
				$preattachedfiles[$x]['size'] = $decodedsize;
				$preattachedfiles[$x]['name'] = $filename;
				$preattachedfiles[$x]['type'] = $type;
				$preattachedfiles[$x]['contents'] = $finalfile;
				$preattachedfiles[$x]['cid'] = $cid;
				$preattachedfiles[$x]['disposition'] = $disposition;
				$preattachedfiles[$x]['description'] = $description;
			}

			// Convert back inline images back to CID's so that they work in the final message again
			$embeddedattachments = get_embeddedattachments($sections);
			if (is_array($embeddedattachments)) {
				for($x=0; $x<sizeof($embeddedattachments); $x++) {
					// Note this calls the same file as attachment download but we must set submit=inline to allow display rather than download
					$body2 = str_replace("attachment.php?submit=inline&amp;id=" . $_POST['msgid'] . "&amp;pid=" . $embeddedattachments[$x]["pid"]  . "&amp;f=" . $_POST['f'] . "&amp;" . strip_tags(SID), "cid:" . $embeddedattachments[$x]["id"], $body2);
					$body2 = str_replace("attachment.php?submit=inline&id=" . $_POST['msgid'] . "&pid=" . $embeddedattachments[$x]["pid"]  . "&f=" . $_POST['f'] . "&" . strip_tags(SID), "cid:" . $embeddedattachments[$x]["id"], $body2);
				}
				$body2 = str_replace("attachment.php?submit=inline", "", $body2);
				$body2 = str_replace(strip_tags(SID), "", $body2);
			}
		}
		else {
			$preattachedfiles = "";
		}

		// Now deal with embedded attachments
		// Only scan jpeg and gif types to lower resources
		// This handles user added embedded images and NOT forwarded embedded images
		if ($_SESSION['ca']) {
			for($i=0; $i<sizeof($_SESSION['ca']); $i++) {
				if ($_SESSION['ca'][$i]['type'] == "image/jpeg" || $_SESSION['ca'][$i]['type'] == "image/pjpeg" || $_SESSION['ca'][$i]['type'] == "image/gif") {
					if ($_SERVER['HTTPS'] == "on") {
						$httpstatus = "https://";
					}
					else {
						$httpstatus = "http://";
					}
					$pathtorender = str_replace ("compose.php", "renderimage.php", $_SERVER["REQUEST_URI"]);
					$findneedle = $httpstatus . $_SERVER["HTTP_HOST"] . $pathtorender . "?embedid=" . $i . "&amp;" . strip_tags(SID);
					if (strstr($body2, $findneedle)) {
						// Found an embedded image so first generate a content id
						// Then replace the renderimage URL with the CID
						for($j=1; $j<=8; $j++) {
							$temprnd1 .= rand(0, 9);
						}
						for($j=1; $j<=4; $j++) {
							$temprnd2 .= rand(0, 9);
						}
						$newcid = $i . $temprnd1 . '@' . date("dmY") . '-' . $temprnd2;
						$_SESSION['ca'][$i]['cid'] = $newcid;
						$body2 = str_replace($findneedle, 'cid:' . $newcid, $body2);
						unset ($newcid);
						unset ($temprnd1);
						unset ($temprnd2);
					}
				}
			}
		}

		if (empty($errormessage)) {

		if (!isset($_POST['submit']) && isset($_POST['savedraft'])) {
			// This if/else routine is for saving drafts
			$buildemail = $IMAPConnection->WM_IMAPBuildEmail($to, $cc, $bcc, $replyto, $subject, $body2, $_SESSION['ca'], $preattachedfiles, $AttachmentNumber, $_POST['edit'], $priority, $receipt, $_SESSION['currentemailaddress'], 0, $pname, $alias, '', $_POST['mid']);

			$saveemail = $IMAPConnection->WM_IMAPSaveSent($CyrusIMAP, $UseSMTP, $IMAPDrafts, $IMAPSubscriptions);

			header ('Location: ./mailbox.php?f=' . urlencode($IMAPDrafts) . '&' . strip_tags(SID));
			exit;
		}

		if (isset($_POST['submit']) && !isset($_POST['savedraft'])) {
			// This if/else routine is for sending emails

			// DWmail is in Local mode and is going to send using SMTP
			if (($DWmailMode == 1) && ($UseSMTP == 1)) {
				require ("./includes/smtp.inc.php");
				$SMTPConnection = new WM_SMTPConnection($_SESSION);
				$SMTPConnection->_helodomain = $HELOServerName;
				$smtpconnect = $SMTPConnection->WM_SMTPConnect($DefaultSMTP);
				if (!$smtpconnect) {
					$smtperror[] = "Failed to connect to SMTP server: $DefaultSMTP";
				}
				$smtphelo = $SMTPConnection->WM_HELO();
				if (!$smtphelo) {
					$smtperror[] = "HELO to SMTP server failed";
				}
				if ($UseSMTPAuth == 1) {
					$smtpauth = $SMTPConnection->WM_SMTPAuth();
					if (!$smtpauth) {
						$smtperror[] = "Authentication to SMTP server failed";
					}
				}
				$smtpfrom = $SMTPConnection->WM_EnvelopeFROM($_SESSION['currentemailaddress']);
				if (!$smtpfrom) {
					$smtperror[] = "Could not set From address";
				}
				if (is_array($to_array)) {
				for($key=0; $key<sizeof($to_array); $key++) {
					if (($to_array[$key]->mailbox <> "" && $to_array[$key]->host <> "") && ($to_array[$key]->mailbox <> "INVALID_ADDRESS" && $to_array[$key]->host <> ".SYNTAX-ERROR")) {
						$smtpto = $SMTPConnection->WM_EnvelopeTO($to_array[$key]->mailbox . "@" . $to_array[$key]->host);
						if (!$smtpto) {
							$smtperror[] = "Could not set To address";
						}
					}
				}
				}
				if (is_array($cc_array)) {
				for($key=0; $key<sizeof($cc_array); $key++) {
					if (($cc_array[$key]->mailbox <> "" && $cc_array[$key]->host <> "") && ($cc_array[$key]->mailbox <> "INVALID_ADDRESS" && $cc_array[$key]->host <> ".SYNTAX-ERROR")) {
						$smtpcc = $SMTPConnection->WM_EnvelopeTO($cc_array[$key]->mailbox . "@" . $cc_array[$key]->host);
						if (!$smtpcc) {
							$smtperror[] = "Could not set Cc address";
						}
					}
				}
				}
				if (is_array($bcc_array)) {
				for($key=0; $key<sizeof($bcc_array); $key++) {
					if (($bcc_array[$key]->mailbox <> "" && $bcc_array[$key]->host <> "") && ($bcc_array[$key]->mailbox <> "INVALID_ADDRESS" && $bcc_array[$key]->host <> ".SYNTAX-ERROR")) {
						$smtpbcc = $SMTPConnection->WM_EnvelopeTO($bcc_array[$key]->mailbox . "@" . $bcc_array[$key]->host);
						if (!$smtpbcc) {
							$smtperror[] = "Could not set Bcc address";
						}
					}
				}
				}

				// Build the email first
				$sendemail = $IMAPConnection->WM_IMAPBuildEmail($to, $cc, $bcc, $replyto, $subject, $body2, $_SESSION['ca'], $preattachedfiles, $AttachmentNumber, $_POST['edit'], $priority, $receipt, $_SESSION['currentemailaddress'], 1, $pname, $alias, '', $_POST['mid']);

				// Make sure all new lines are \n and then force all \n to \r\n
				// to strip and bare line feeds (as SMTP will not allow this)
				$sendemail['header'] = str_replace ("\r\n", "\n", $sendemail['header']);
				$sendemail['header'] = str_replace ("\n", "\r\n", $sendemail['header']);

				$sendemail['message'] = str_replace ("\r\n", "\n", $sendemail['message']);
				$sendemail['message'] = str_replace ("\n", "\r\n", $sendemail['message']);

				$emailsent = $SMTPConnection->WM_Data($sendemail['header'] . "\r\n" . $sendemail['message']);
				if (!$emailsent) {
					$smtperror[] = "Could not send header and body of message";
					$emailsent = $smtperror;
				}

				$smtpclose = $SMTPConnection->WM_SMTPClose();

				// If you wish to see the SMTP communication logs then you can uncomment the next line (useful for debugging)
				// echo ($SMTPConnection->_smtplog);

			}
			else {
				// This section uses the imap_mail() command and not SMTP

				// Build the email first
				$sendemail = $IMAPConnection->WM_IMAPBuildEmail($to, $cc, $bcc, $replyto, $subject, $body2, $_SESSION['ca'], $preattachedfiles, $AttachmentNumber, $_POST['edit'], $priority, $receipt, $_SESSION['currentemailaddress'], 0, $pname, $alias, '', $_POST['mid']);

				// This bit actually calls the sendmail routine
				$emailsent = $IMAPConnection->WM_IMAPSendMail($sendemail);
			}

			$PageGenericMessage = $getFile->fileRead('generic_message');
			$PageGenericMessage = str_replace("[pagetitle]", $lang['SCompose']['Title'], $PageGenericMessage);

			// Check for errors and save if required
			if ($emailsent == TRUE && !is_array($emailsent)) {

				// Delete from draft folder
				if ($_SESSION['folder'] == $IMAPDrafts && !empty($id)) {
					$IMAPConnection->WM_IMAPDelete($id);
					$IMAPConnection->WM_IMAPExpungeMailbox();
				}

				// Save email to sent mail folder
				$returnmessage = $lang['SCompose']['Success'] . "<br /><br /><a href=\"mailbox.php?f=" . urlencode($_SESSION['folder']) . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['Back'] . "</a>";
				if ($AllowSentMail == 1 && ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") && $_POST['savesent'] == 1) {
					$saveemail = $IMAPConnection->WM_IMAPSaveSent($CyrusIMAP, $UseSMTP, $IMAPSentMail, $IMAPSubscriptions);
				}

				// Set the message headers to answered
				if ($_POST['msgid']) {
					$SetAnswered = $IMAPConnection->WM_IMAPSetFlag("\\Answered", $_POST['msgid']);
				}

				// Remove attachments from the session as the message was sent
				unset($_SESSION['ca']);

				// Check whether to save recipients to addressbook
				if ($_POST['saverecipients'] == 1 && $UseDatabase == 1) {
					// loop through $recipientarray
					if (is_array($recipientarray)) {
						for($key=0; $key<sizeof($recipientarray); $key++) {
							if (($recipientarray[$key]->mailbox <> "" && $recipientarray[$key]->host <> "") && ($recipientarray[$key]->mailbox <> "INVALID_ADDRESS" && $recipientarray[$key]->host <> ".SYNTAX-ERROR")) {
								if ($recipientarray[$key]->personal <> "") {
									$submitteddetails['lastname'] = $recipientarray[$key]->personal;
								}
								else {
									$submitteddetails['lastname'] = $recipientarray[$key]->mailbox . "@" . $recipientarray[$key]->host;
								}
								$submitteddetails['email'] = $recipientarray[$key]->mailbox . "@" . $recipientarray[$key]->host;
								if ($MySQLMakeConnection) {
									// Check if email is already in addressbook
									$ab_check = $MySQLConnection->DB_EntryExist($submitteddetails['email']);
									if (!$ab_check) {
										$ab_addentry = $MySQLConnection->DB_NewEntry($submitteddetails);
									}
								}
							}
						}
					}
				
				}
			}
			else {
				if (is_array($emailsent)) {
					$imapreturn = $lang['SErrors']['IMAPError'] . "'" . implode("<br />\n", $emailsent) . "'";
				}
				$errormessage = $lang['SErrors']['IMAPError'] . " $imapreturn<br /><br /><a href=\"mailbox.php?f=" . urlencode($_SESSION['folder']) . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['Back'] . "</a>";
			}
		}
		}

	}
}

// Now we have handled any outgoing email we can display either the compose form, error or success pages
include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

if ($returnmessage) {
	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;
	$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
	echo $PageGenericMessage;
}
else {

	// Get a user defined signature
	if ($UseDatabase == 1) {
		$GetSignature = trim($MySQLConnection->DB_GetPrefs('signature'));
		if ($GetSignature == FALSE) {
			$GetSignature = "";
		}
		else {
			$GetSignature = stripslashes($GetSignature);
			$GetSignature = strip_tags($GetSignature);
			if ($edit <> "text") {
				$GetSignature = nl2br($GetSignature);
			}
			else {
				$GetSignature = $crlf . $GetSignature;
			}
			$GetSignature .= $nlhtml . $crlf . $nlhtml . $crlf;
		}
	}
	else {
		$GetSignature = "";
	}

	// Have we got a message id.  Means we have a reply or forward so get message details.
	if ($id <> '') {

		if ($_GET['f']) {
			$_SESSION['folder'] = strip_tags(trim($_GET['f']));
		}
		$IMAPConnection->WM_IMAPGetHeader($id);
		$headerdetails = $IMAPConnection->WM_IMAPFullHeaders();
		$subj = $IMAPConnection->WM_IMAPGetSubject();

		if ($subj == "") {
			$subj2 = "(no subject)";
		}
		if ($isdraft == 1) {
			$subj2 = $MainSettings->CheckSlashes($subj);
		}
		elseif (($mode == "" || $mode == "all") && (substr(strtoupper($subj), 0, 3) <> "RE:")) {
			$subj2 = "RE: " . $MainSettings->CheckSlashes($subj);
		}
		elseif (($mode == "fwd") && (substr(strtoupper($subj), 0, 3) <> "FW:")) {
			$subj2 = "FW: " . $MainSettings->CheckSlashes($subj);
		}
		else {
			$subj2 = $MainSettings->CheckSlashes($subj);
		}
		$structure = $IMAPConnection->WM_IMAPGetStructure($id);

		if (sizeof($structure->parts) > 1) {
			$sections = parseBody($structure);
			$attachments = get_attachments($sections);
			$embeddedattachments = get_embeddedattachments($sections);

			if (is_array($attachments) && is_array($embeddedattachments)) {
				$allattachments = array_merge($attachments, $embeddedattachments);
			}
			elseif (is_array($embeddedattachments)) {
				$allattachments = $embeddedattachments;
			}
			else {
				$allattachments = $attachments;
			}
		}

		if (is_array($sections)) {
			for($x=0; $x<sizeof($sections); $x++) {
				if ($sections[$x]["type"] == "multipart/alternative" && $sections[$x]["disposition"] != "attachment") {
					$message["alternative"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
				}
				elseif ($sections[$x]["type"] == "text/html"  && $sections[$x]["disposition"] != "attachment") {
					$message["html"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
					$message["html"] = parseEncoding($message["html"], $sections[$x]["encoding"]);
					$origformat = "html";
				}
				elseif ($sections[$x]["type"] == "text/plain"  && $sections[$x]["disposition"] != "attachment") {
					$message["text"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
					$message["text"] = parseEncoding($message["text"], $sections[$x]["encoding"]);
					$message["text"] = htmlspecialchars(stripslashes(trim($message["text"])));
					$origformat = "text";
				}
			}
			if (isset($message["html"]) && ($HTMLemail == 1 || ($HTMLemail == 2 && !isset($message["text"])))) {
				$content = stripslashes(trim($message["html"]));
				$origformat = "html";
				$CleanUpHTML = new HTMLCleanup($content);
				$CleanUpHTML->ChangeTarget();
				$CleanUpHTML->RemoveScripting();
				$CleanUpHTML->RemoveMalicious();
				$content = $CleanUpHTML->_body;
			}
			else {
				$content = $message["text"];
				$origformat = "text";
			}
		}
		else {
			$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
			$content = parseEncoding($content, $encoding[$structure->encoding]);
			$origformat = "text";
		}
		unset ($message);

		if ($isdraft <> 1) {
			if ($edit <> "text") {
				$nlhtml .= "<br />";
				if (!isset($ve['c_fontface'])) {
					$ve['c_fontface'] = "Arial, Helvetica, sans-serif";
				}
				if (!isset($ve['c_fontsize'])) {
					$ve['c_fontsize'] = "2";
				}
				if (!isset($ve['c_fontcolour'])) {
					$ve['c_fontcolour'] = "#000000";
				}
				$fonthtml = "<font face=\"" . stripslashes($ve['c_fontface']) . "\"  size=\"" . stripslashes($ve['c_fontsize']) . "\" color=\"" . stripslashes($ve['c_fontcolour']) . "\">";
			}
			else {
				$nlhtml .= "";
				$fonthtml = "";
			}

			$message = $fonthtml . $crlf . $GetSignature . $nlhtml . $crlf . $crlf;
			if (($IncOrig == "1") || (!isset($IncOrig))) {
				$localtime_date = DateToLocal($tz, $headerdetails['date'], $DateFormattingFull);

				$message .= "-----" . $lang['SCompose']['ComposeOriginal'] . "-----" .  $nlhtml . $crlf;
				if ($edit == "html" || $edit == "wysiwyg") {
					$message .= "<strong>" . $lang['SCompose']['From'] . ":</strong> " . $headerdetails['fromaddress'] . $nlhtml . $crlf;
					$message .= "<strong>" . $lang['SCompose']['Sent'] . ":</strong> " . $localtime_date . $nlhtml . $crlf;
					$message .= "<strong>" . $lang['SCompose']['To'] . ":</strong> " . $headerdetails['toaddress'] . $nlhtml . $crlf;
					if ($headerdetails['ccaddress'] <> "") {
						$message .= "<strong>" . $lang['SCompose']['Cc'] . ":</strong> " . $headerdetails['ccaddress'] . $crlf;
					}
					$message .= "<strong>" . $lang['SCompose']['Subject'] . ":</strong> " . $subj . $nlhtml . $nlhtml . $crlf . $crlf;
				}
				else {
					$message .= $lang['SCompose']['From'] . ": " . $headerdetails['fromaddress'] . $nlhtml . $crlf;
					$message .= $lang['SCompose']['Sent'] . ": " . $localtime_date . $nlhtml . $crlf;
					$message .= $lang['SCompose']['To'] . ": " . $headerdetails['toaddress'] . $nlhtml . $crlf;

					if ($headerdetails['ccaddress'] <> "") {
						$message .= $lang['SCompose']['Cc'] . ": " . $headerdetails['ccaddress'] . $crlf;
					}
					$message .= $lang['SCompose']['Subject'] . ": " . $subj . $nlhtml . $nlhtml . $crlf . $crlf;
				}

				if ($edit <> "text") {
					if ($origformat == "text") {
						$content = nl2br($content);
					}
					$message .= $content;
					$message .= "</font>";
				}
				else {
					if ($origformat == "html") {
						$content = str_replace ("\n", "", $content);
						$content = str_replace ("\r", "", $content);
						$content = str_replace ("<BR>", "\n", $content);
						$content = str_replace ("<BR />", "\n", $content);
						$content = str_replace ("<br>", "\n", $content);
						$content = str_replace ("<br />", "\n", $content);
						$content = str_replace ("</p>", "\n\n", $content);
						$content = str_replace ("</P>", "\n\n", $content);
					}
					$message = $message . strip_tags($content);
				}
			}
		}
		else {
			// This is draft content
			$message = $content;
			if ($origformat == 'html' && $allowbrowser == 0) {
				$edit == 'html';
			}
			elseif ($origformat == 'html' && $allowbrowser == 1) {
				$edit == 'wysiwyg';
			}
			else {
				$edit == 'text';
			}
		}

		if ($mode == "" && $id <> "" && $isdraft == 0) {
			if (htmlspecialchars($headerdetails['reply_toaddress'] == "")) {
				$sendto = $headerdetails['fromaddress'];
			}
			else {
				$sendto = $headerdetails['reply_toaddress'];
			}
		}
		elseif ($mode == "all" && $isdraft == 0) {
			if (htmlspecialchars($headerdetails['reply_toaddress'] == "")) {
				$sendto = $headerdetails['fromaddress'];
			}
			else {
				$sendto = $headerdetails['reply_toaddress'];
			}
			$sendto .= ", " . $headerdetails['toaddress'];
			$sendcc = $headerdetails['ccaddress'];
		}
		elseif ($isdraft == 1) {
			$sendto = str_replace('"', '&quot;', $headerdetails['toaddress']);
			$sendcc = str_replace('"', '&quot;', $headerdetails['ccaddress']);
			$sendbcc = str_replace('"', '&quot;', $headerdetails['bccaddress']);
		}

	}

	// Set value of 'to' field if parsed from view.php
	if ($_GET['newto']) {
		$sendto = htmlspecialchars($_GET['newto']);
	}

	// Set values if a mode change has occurred.
	if ($_POST['replyto']) {
		$ReplyTo = $_POST['replyto'];
	}
	else {
		if (!isset($ReplyTo) || $ReplyTo == "") {
			$ReplyTo = stripslashes($_SESSION['currentemailaddress']);
		}		
	}
	if ($_POST['to']) {
		$sendto = $_POST['to'];
	}
	if ($_POST['cc']) {
		$sendcc = $_POST['cc'];
	}
	if ($_POST['bcc']) {
		$sendbcc = $_POST['bcc'];
	}
	if ($_POST['subject']) {
		$subj2 = $_POST['subject'];
	}
	if ($_POST['body']) {
		$message = $_POST['body'];
	}

	if ($_POST['correctspelling']) {
		// Now we have a submission to correct spelling.
		// Look in enter own first, if blank then use suggestions
		if (is_array($_POST['spell'])) {
			for ($i=0; $i<sizeof($_POST['spell']); $i++) {
				if (trim($_POST['othersuggest'][$i]) <> '') {
					$message = str_replace($_POST['spell'][$i], $_POST['othersuggest'][$i], $message);
				}
				else {
					$message = str_replace($_POST['spell'][$i], $_POST['suggest'][$i], $message);
				}
			}
		}
	}

	$session_formdetails = $MainSettings->SessAppend_form($TransIDEnabled);

	if ($AllowAttachments == 1) {
		// This is the compose form with attachments enabled (note that the <form> must have an enctype)
		if ($edit == "text" || $edit == "html") {
			$message = $MainSettings->CheckSlashes($message);
			if ((($postmode == "html") || ($postmode == "wysiwyg")) && ($edit == "text")) {
				$message = str_replace ("<BR>", "\n", $message);
				$message = str_replace ("<BR />", "\n", $message);
				$message = str_replace ("<br>", "\n", $message);
				$message = str_replace ("<br />", "\n", $message);
				$message = str_replace ("</p>", "\n\n", $message);
				$message = str_replace ("</P>", "\n\n", $message);
				$message = strip_tags ($message);
			}
			elseif (($postmode == "text") && (($edit == "html") || ($edit == "wysiwyg"))) {
				$message = nl2br ($message);
			}
			if ($message == "" && $GetSignature <> "") {
				$message = $crlf . $GetSignature;
			}
			$compose_form = "<form action=\"compose.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"composeform\">$session_formdetails";
			// Find any embedded images and replace their ID in the body of the message so we can view them
			if (is_array($embeddedattachments)) {
				for($x=0; $x<sizeof($embeddedattachments); $x++) {
					// Note this calls the same file as attachment download but we must set submit=inline to allow display rather than download
					$message = str_replace("cid:" . $embeddedattachments[$x]["id"], "attachment.php?submit=inline&amp;id=$id&amp;pid=" . $embeddedattachments[$x]["pid"]  . "&amp;f=" . $_GET['f'] . "&amp;" . strip_tags(SID), $message);
				}
			}
			$messagebox = "<textarea name=\"body\" cols=\"65\" rows=\"15\" class=\"compose\">" . $message . "</textarea>";
		}
		else {
			$message = $MainSettings->CheckSlashes($message);
			if (($postmode == "text") && (($edit == "html") || ($edit == "wysiwyg"))) {
				$message = nl2br ($message);
			}
			if ($allowbrowser == 1 && $bd['browser'] == "Mozilla") {
				$compose_form = "<form action=\"compose.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"composeform\" onSubmit=\"ReFormat(this);\">$session_formdetails";
				$PageHeader = str_replace("<body", "<body onload=\"InitializeEditor();\"", $PageHeader);
				$PageHeader = str_replace("<BODY", "<body onload=\"InitializeEditor();\"", $PageHeader);
			}
			else {
				$compose_form = "<form action=\"compose.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"composeform\" onSubmit=\"ReFormat(this);\">$session_formdetails";
				$PageHeader = str_replace("<body", "<body onload=\"InitializeEditor();\"", $PageHeader);
				$PageHeader = str_replace("<BODY", "<body onload=\"InitializeEditor();\"", $PageHeader);
			}
			if ($allowbrowser == 1 && $bd['browser'] == "Mozilla") {
				$messagebox = $getFile->fileRead('editor_mozilla');
				$messagebox = LangReplace('SWYSIWYG', $messagebox, $lang);
				$messagebox = str_replace("[parseelements]", "?id=$id&amp;f=" . urlencode($folder) . "&amp;edit=$edit&amp;mode=$mode&amp;postedit=$postmode&amp;" . strip_tags(SID), $messagebox);
			}
			elseif ($allowbrowser == 1 && $bd['browser'] <> "Mozilla") {
				$messagebox = $getFile->fileRead('editor_ie55');
				$messagebox = LangReplace('SWYSIWYG', $messagebox, $lang);
				$messagebox = str_replace("[session_force]", strip_tags(SID), $messagebox);
			}
			else {
				$messagebox = $lang['SErrors']['WYSIWYGError'];
			}

			if (($message == "")  && ($id == "") && ($mode == "")) {
				if ($GetSignature <> "") {
					$GetSignature = "<br />" . $GetSignature;
				}
				if (!isset($ve['c_fontface'])) {
					$ve['c_fontface'] = "Arial, Helvetica, sans-serif";
					$fontface = "Arial, Helvetica, sans-serif";
				}
				else {
					$fontface = $ve['c_fontface'];
				}
				if (!isset($ve['c_fontsize'])) {
					$ve['c_fontsize'] = "2";
					$fontsize = "2";
				}
				else {
					$fontsize = $ve['c_fontsize'];
				}
				if (!isset($ve['c_fontcolour'])) {
					$ve['c_fontcolour'] = "#000000";
					$forecolour = "#000000";
				}
				else {
					$forecolour = $ve['c_fontcolour'];
				}
				$message = "<font face=\"" . stripslashes($ve['c_fontface']) . "\" size=\"" . stripslashes($ve['c_fontsize']) . "\" color=\"" . stripslashes($ve['c_fontcolour']) . "\"><p>$GetSignature</p></font>";
			}
			elseif (($message <> "")  && ($id <> "")) {
				if (!isset($ve['r_fontface'])) {
					$ve['r_fontface'] = "Arial, Helvetica, sans-serif";
					$fontface = "Arial, Helvetica, sans-serif";
				}
				else {
					$fontface = $ve['r_fontface'];
				}
				if (!isset($ve['r_fontsize'])) {
					$ve['r_fontsize'] = "2";
					$fontsize = "2";
				}
				else {
					$fontsize = $ve['r_fontsize'];
				}
				if (!isset($ve['r_fontcolour'])) {
					$ve['r_fontcolour'] = "#0000CC";
					$forecolour = "#0000CC";
				}
				else {
					$forecolour = $ve['r_fontcolour'];
				}
				$message = "<font face=\"" . stripslashes($ve['r_fontface']) . "\" size=\"" . stripslashes($ve['r_fontsize']) . "\" color=\"" . stripslashes($ve['r_fontcolour']) . "\"><p>&nbsp;</p></font>\n" . $message;
			}
			// Find any embedded images and replace their ID in the body of the message so we can view them
			if (is_array($embeddedattachments)) {
				for($x=0; $x<sizeof($embeddedattachments); $x++) {
					// Note this calls the same file as attachment download but we must set submit=inline to allow display rather than download
					$message = str_replace("cid:" . $embeddedattachments[$x]["id"], "attachment.php?submit=inline&amp;id=$id&amp;pid=" . $embeddedattachments[$x]["pid"]  . "&amp;f=" . $_GET['f'] . "&amp;" . strip_tags(SID), $message);
				}
			}
			$messagebox = str_replace ("[compose_message]", $message, $messagebox);
		}

		// Add new attachment to the session
		if (isset($_FILES['newattachment'])) {
			if ($_FILES['newattachment']['name'] <> "") {
				$fp = fopen($_FILES['newattachment']['tmp_name'], "r");
				$filecontents = fread($fp, $_FILES['newattachment']['size']);
				fclose($fp);
				$currattachsize = sizeof($_SESSION['ca']);
				$_SESSION['ca'][$currattachsize]['id'] = $currattachsize;
				$_SESSION['ca'][$currattachsize]['name'] = $_FILES['newattachment']['name'];
				$_SESSION['ca'][$currattachsize]['size'] = $_FILES['newattachment']['size'];
				$_SESSION['ca'][$currattachsize]['type'] = $_FILES['newattachment']['type'];
				$_SESSION['ca'][$currattachsize]['cid'] = '';
				$_SESSION['ca'][$currattachsize]['contents'] = $filecontents;
			}
		}

		// Remove unselected attachments
		$resetarray = 0;
		if (is_array($_POST['updateattach']) && ($_POST['updateattachments'])) {
			for($i=0; $i<sizeof($_SESSION['ca']); $i++) {
				if (!isset($_POST['updateattach'][$i])) {
					unset ($_SESSION['ca'][$i]);
					$resetarray = 1;
				}
			}
		}
		if ($resetarray == 1) {
			sort($_SESSION['ca']);
			reset($_SESSION['ca']);
		}

		// If we don't have a file upload AND we don't have any files left checked remove all uploaded attachments
		if (!$_POST['updateattach'] && $_FILES['newattachment']['name'] == "") {
			unset ($_SESSION['ca']);
		}

		$preattachments = 0;

		// Display attachments from a forwarded message
		if ($mode == "fwd" && sizeof($allattachments) >= 1) {
			$preattachments = 1;
			for ($x=0; $x<sizeof($allattachments); $x++) {
				$compose_preattachments_box .= "<img alt=\"" . $lang['SCompose']['Attachment'] . "\" width=\"10\" height=\"13\" src=\"templates/" . $DefaultTemplate . "/images/mailbox/attach.gif\" /> <input type=\"checkbox\" name=\"attach[]\" value=\"" . $allattachments[$x]["pid"] . "\" checked=\"checked\" /> ";
				if (isset($allattachments[$x]["name"])) {
					$compose_preattachments_box .= $allattachments[$x]["name"];
				}
				else {
					if (isset($allattachments[$x]["description"])) {
						$compose_preattachments_box .= $allattachments[$x]["description"];
					}
					else {
						$compose_preattachments_box .= $lang['SCompose']['NoAttachmentName'];
					}
				}
				$compose_preattachments_box .= "<br />";
			}			
		}
		elseif ($id <> "") {
			// Else display embedded attachments in a reply
			if (sizeof($allattachments) >= 1) {
				$preattachments = 1;
				for ($x=0; $x<sizeof($embeddedattachments); $x++) {
					$compose_preattachments_box .= "<img alt=\"" . $lang['SCompose']['Attachment'] . "\" width=\"10\" height=\"13\" src=\"templates/" . $DefaultTemplate . "/images/mailbox/attach.gif\" /> <input type=\"checkbox\" name=\"attach[]\" value=\"" . $embeddedattachments[$x]["pid"] . "\" checked=\"checked\" /> ";
					if (isset($embeddedattachments[$x]["name"])) {
						$compose_preattachments_box .= $embeddedattachments[$x]["name"];
					}
					else {
						if (isset($embeddedattachments[$x]["description"])) {
							$compose_preattachments_box .= $embeddedattachments[$x]["description"];
						}
						else {
							$compose_preattachments_box .= $lang['SCompose']['NoAttachmentName'];
						}
					}
					$compose_preattachments_box .= "<br />";
				}
			}

		}

		// Display attachments added from this compose session
		if ($_SESSION['ca']) {
			for($i=0; $i<sizeof($_SESSION['ca']); $i++) {
					$compose_attachments_box .= "<img alt=\"" . $lang['SCompose']['Attachment'] . "\" width=\"10\" height=\"13\" src=\"templates/" . $DefaultTemplate . "/images/mailbox/attach.gif\" /> <input type=\"checkbox\" name=\"updateattach[" . $_SESSION['ca'][$i]['id'] . "]\" value=\"1\" checked=\"checked\" /> " .  $_SESSION['ca'][$i]['name'] . "<br />";
			}
			$compose_attachments_box .= "<input type=\"submit\" name=\"updateattachments\" value=\"" . $lang['SCompose']['UpdateAttachments'] . "\" class=\"button\" /><br />";
		}

		if (!$_SESSION['ca']) {
			$compose_attachments_box .= "<input type=\"file\" name=\"newattachment\" size=\"40\" /> <input type=\"submit\" value=\"" . $lang['SCompose']['AttachFile'] . "\" class=\"button\" name=\"attachfile\" /><br />";
		}
		elseif (sizeof($_SESSION['ca']) < $AttachmentNumber) {
			$compose_attachments_box .= "<input type=\"file\" name=\"newattachment\" size=\"40\" /> <input type=\"submit\" value=\"" . $lang['SCompose']['AttachFile'] . "\" class=\"button\" name=\"attachfile\" /><br />";
		}
		$PageCompose = str_replace("[attachments]", $compose_attachments_box, $PageCompose);

		if ($preattachments == 1) {
			$PageCompose = str_replace("[ifpreattached]", "", $PageCompose);
			$PageCompose = str_replace("[/ifpreattached]", "", $PageCompose);
			$PageCompose = str_replace("[preattachments]", $compose_preattachments_box, $PageCompose);
		}
		else {
			$PageCompose = preg_replace("/(\[)(ifpreattached)(])(\r\n)*(.*)(\[\/ifpreattached\])/siU", "", $PageCompose);
		}

		$PageCompose = str_replace("[ifattachments]", "", $PageCompose);
		$PageCompose = str_replace("[/ifattachments]", "", $PageCompose);

	}
	else {
		// This is the compose form if sending attachments is disabled
		if ($edit == "text" || $edit == "html") {
			$message = $MainSettings->CheckSlashes($message);
			if ((($postmode == "html") || ($postmode == "wysiwyg")) && ($edit == "text")) {
				$message = str_replace ("<BR>", "\n", $message);
				$message = str_replace ("<BR />", "\n", $message);
				$message = str_replace ("<br>", "\n", $message);
				$message = str_replace ("<br />", "\n", $message);
				$message = str_replace ("</p>", "\n\n", $message);
				$message = str_replace ("</P>", "\n\n", $message);
				$message = strip_tags ($message);
			}
			elseif (($postmode == "text") && (($edit == "html") || ($edit == "wysiwyg"))) {
				$message = nl2br ($message);
			}
			if ($message == "" && $GetSignature <> "") {
				$message = $crlf . $GetSignature;
			}
			$compose_form = "<form action=\"compose.php\" method=\"post\" name=\"composeform\">$session_formdetails";
			$messagebox = "<textarea name=\"body\" cols=\"65\" rows=\"15\" class=\"compose\">" . $message . "</textarea>";
		}
		else {
			$message = $MainSettings->CheckSlashes($message);
			if (($postmode == "text") && (($edit == "html") || ($edit == "wysiwyg"))) {
				$message = nl2br ($message);
			}
			if ($allowbrowser == 1 && $bd['browser'] == "Mozilla") {
				$compose_form = "<form action=\"compose.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"composeform\" onSubmit=\"ReFormat(this);\">$session_formdetails";
				$PageHeader = str_replace("<body", "<body onload=\"InitializeEditor();\"", $PageHeader);
				$PageHeader = str_replace("<BODY", "<body onload=\"InitializeEditor();\"", $PageHeader);
			}
			else {
				$compose_form = "<form action=\"compose.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"composeform\" onSubmit=\"ReFormat(this);\">$session_formdetails";
				$PageHeader = str_replace("<body", "<body onload=\"InitializeEditor();\"", $PageHeader);
				$PageHeader = str_replace("<BODY", "<body onload=\"InitializeEditor();\"", $PageHeader);
			}
			if ($allowbrowser == 1 && $bd['browser'] == "Mozilla") {
				$messagebox = $getFile->fileRead('editor_mozilla');
				$messagebox = LangReplace('SWYSIWYG', $messagebox, $lang);
				$messagebox = str_replace("[parseelements]", "?id=$id&amp;f=" . urlencode($folder) . "&amp;edit=$edit&amp;mode=$mode&amp;postedit=$postmode&amp;" . strip_tags(SID), $messagebox);
			}
			elseif ($allowbrowser == 1 && $bd['browser'] <> "Mozilla") {
				$messagebox = $getFile->fileRead('editor_ie55');
				$messagebox = LangReplace('SWYSIWYG', $messagebox, $lang);
				$messagebox = str_replace("[session_force]", strip_tags(SID), $messagebox);
			}
			else {
				$messagebox = $lang['SErrors']['WYSIWYGError'];
			}

			if (($message == "")  && ($id == "") && ($mode == "")) {
				if ($GetSignature <> "") {
					$GetSignature = "<br />" . $GetSignature;
				}
				$message = "<p><font face=\"arial, helvetica\" size=\"2\" color=\"#000000\">$GetSignature</font></p>";
			}
			elseif (($message <> "")  && ($id <> "")) {
				$message = "<p><font face=\"arial, helvetica\" size=\"2\" color=\"#0000CC\">&nbsp;</font></p>\n" . $message;
			}
			$messagebox = str_replace ("[compose_message]", $message, $messagebox);
		}
		$compose_attachments = "";
		$PageCompose = preg_replace("/(\[)(ifattachments)(])(\r\n)*(.*)(\[\/ifattachments\])/siU", "", $PageCompose);
	}

	$nosuggestions = 1;
	if ($_POST['spellcheck']) {
		require ('./includes/spellcheck.inc.php');
		$CheckSpelling = new SpellChecker($DefaultLang, $AvailLangs[$DefaultLang]['spell']['charset']);
		$openspelling = $CheckSpelling->OpenDictionary();

		// Split by non word characer.  We can grab the offset here to do a replace once rather than replace all
		// However for HTML we first have to remove tags so that they won't get spell checked
		// This means the offset will be wrong
		//  PREG_SPLIT_OFFSET_CAPTURE
		$tmpmessage = str_replace ("<BR>", "\n", $message);
		$tmpmessage = str_replace ("<BR />", "\n", $tmpmessage);
		$tmpmessage = str_replace ("<br>", "\n", $tmpmessage);
		$tmpmessage = str_replace ("<br />", "\n", $tmpmessage);
		$tmpmessage = str_replace ("</p>", "\n", $tmpmessage);
		$tmpmessage = str_replace ("</P>", "\n", $tmpmessage);
		$tmpmessage = strip_tags(stripslashes($tmpmessage));
		$tmpmessage = unhtmlentities($tmpmessage);
		$checkwords = preg_split('/[\W\s]+?/', $tmpmessage, -1);
		$misspelled = array();
		$suggestions = array();
		$wordoffset = array();
		// As we can't use replace once then we will have to make the array unique to prevent duplicates
		$uniquecheckwords = array_unique($checkwords);
		sort($uniquecheckwords);
		unset ($checkwords);
		if (is_array($uniquecheckwords)) {
			for ($i=0; $i<sizeof($uniquecheckwords); $i++) {
				$misspelled[$i] = $CheckSpelling->check($uniquecheckwords[$i]);
				// $wordoffset[$i] = $uniquecheckwords[$i][1];
				if ($misspelled[$i] == FALSE) {
					$nosuggestions = 0;
					$suggestions[$i] = $CheckSpelling->suggest($uniquecheckwords[$i]);
				}
				else {
					$suggestions[$i] = '';
				}
			}
		}
		$CheckSpelling->close();

		if ($nosuggesions == 0) {
			// We have found misspelt words, now display suggestions
			$PageSpellSuggestions = $getFile->fileRead('spellsuggestions');
			for ($i=0; $i<sizeof($misspelled); $i++) {
				if ($misspelled[$i] == FALSE) {
					// This has been flagged as misspelt
					$currentwordtmp = $PageSpellSuggestions;
					$currentwordtmp = str_replace("[spelling_misspeltword]", $uniquecheckwords[$i] . "<input type=\"hidden\" name=\"spell[]\" value=\"" . htmlspecialchars($uniquecheckwords[$i]) . "\" />", $currentwordtmp);
					$spellsuggest = "<select name=\"suggest[]\"><option value=\"" . htmlspecialchars($uniquecheckwords[$i]) . "\" selected=\"selected\">" . $lang['SCompose']['SpellKeepAs'] . htmlspecialchars($uniquecheckwords[$i]) . "</option>";
					if (is_array($suggestions[$i])) {
						for ($j=0; $j<sizeof($suggestions[$i]); $j++) {
							$spellsuggest .= "<option value=\"" . htmlspecialchars($suggestions[$i][$j]) . "\">" . $lang['SCompose']['SpellReplaceWith'] . $suggestions[$i][$j] . "</option>";
						}
					}
					$spellsuggest .= "</select>";
					$currentwordtmp = str_replace("[spelling_suggestions]", $spellsuggest, $currentwordtmp);
					$currentwordtmp = str_replace("[spelling_replacewith]", "<input type=\"text\" name=\"othersuggest[]\" />", $currentwordtmp);
					$suggestionoutput .= $currentwordtmp;
					unset ($currentwordtmp);
					unset ($spellsuggest);
				}
			}			
		}
	}

	// Conditional template variable setup
	if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
		$PageCompose = str_replace("[ifimap]", "", $PageCompose);
		$PageCompose = str_replace("[/ifimap]", "", $PageCompose);
	}
	else {
		$PageCompose = preg_replace("/(\[)(ifimap)(])(\r\n)*(.*)(\[\/ifimap\])/siU", "", $PageCompose);
	}

	if ($UseDatabase == 1) {
		$PageCompose = str_replace("[ifdatabase]", "", $PageCompose);
		$PageCompose = str_replace("[/ifdatabase]", "", $PageCompose);
	}
	else {
		$PageCompose = preg_replace("/(\[)(ifdatabase)(])(\r\n)*(.*)(\[\/ifdatabase\])/siU", "", $PageCompose);
	}

	if ($EnableContacts == 1 && $UseDatabase == 1) {
		$PageCompose = str_replace("[ifcontacts]", "", $PageCompose);
		$PageCompose = str_replace("[/ifcontacts]", "", $PageCompose);
	}
	else {
		$PageCompose = preg_replace("/(\[)(ifcontacts)(])(\r\n)*(.*)(\[\/ifcontacts\])/siU", "", $PageCompose);
	}

	if ($_POST['savesent'] == 1) {
		$imap_savemessage = "<input type=\"checkbox\" name=\"savesent\" value=\"1\" checked=\"checked\" id=\"savesent\" />";
	}
	elseif (($AllowSentMail == 1) && ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl")) {
		$imap_savemessage = "<input type=\"checkbox\" name=\"savesent\" value=\"1\" checked=\"checked\" id=\"savesent\" />";
	}
	elseif (($AllowSentMail <> 1) && ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl")) {
		$imap_savemessage = "<input type=\"checkbox\" name=\"savesent\" value=\"1\" id=\"savesent\" />";
	}

	if ($_POST['saverecipients'] == 1) {
		$imap_saverecipients = "<input type=\"checkbox\" name=\"saverecipients\" value=\"1\" checked=\"checked\" id=\"saverecipients\" />";
	}
	elseif (($SaveRecipients == 1) && ($UseDatabase == 1)) {
		$imap_saverecipients = "<input type=\"checkbox\" name=\"saverecipients\" value=\"1\" checked=\"checked\" id=\"saverecipients\" />";
	}
	elseif (($SaveRecipients <> 1) && ($UseDatabase == 1)) {
		$imap_saverecipients = "<input type=\"checkbox\" name=\"saverecipients\" value=\"1\" id=\"saverecipients\" />";
	}

	if ($_POST['receipt'] == 1) {
		$bt_read_receipt = "<input type=\"checkbox\" name=\"receipt\" value=\"1\" id=\"receipt\" checked=\"checked\" />";
	}
	else {
		$bt_read_receipt = "<input type=\"checkbox\" name=\"receipt\" value=\"1\" id=\"receipt\" />";
	}

	$bt_priorities .= "<input type=\"radio\" name=\"priority\" value=\"1\" id=\"pri-high\"";
	if ($_POST['priority'] == 1) {
		$bt_priorities .= " checked=\"checked\"";
	}
	$bt_priorities .= " /> <label for=\"pri-high\">" . $lang['SCompose']['Priority'][1] . "</label> <input type=\"radio\" name=\"priority\" value=\"2\"";
	if ($_POST['priority'] == 2 || !$_POST['priority']) {
		$bt_priorities .= " checked=\"checked\"";
	}
	$bt_priorities .= " id=\"pri-normal\" /> <label for=\"pri-normal\">" . $lang['SCompose']['Priority'][2] . "</label> <input type=\"radio\" name=\"priority\" value=\"3\" id=\"pri-low\"";
	if ($_POST['priority'] == 3) {
		$bt_priorities .= " checked=\"checked\"";
	}
	$bt_priorities .= " /> <label for=\"pri-low\">" . $lang['SCompose']['Priority'][3] . "</label>";

	if ($allowbrowser == 1) {
		// Leave veditorbutton variable in for older template compatibility
		$veditorbutton = '<input type="submit" name="wysiwyg" value="' . $lang['SCompose']['ComposeWYSIWYG'] . '" class="button" />';
		$PageCompose = str_replace("[ifwysiwyg]", "", $PageCompose);
		$PageCompose = str_replace("[/ifwysiwyg]", "", $PageCompose);

	}
	else {
		$veditorbutton = '';
		$PageCompose = preg_replace("/(\[)(ifwysiwyg)(])(\r\n)*(.*)(\[\/ifwysiwyg\])/siU", "", $PageCompose);
	}

	if ($enablespellcheck == 1) {
		$PageCompose = str_replace("[ifspellcheck]", "", $PageCompose);
		$PageCompose = str_replace("[/ifspellcheck]", "", $PageCompose);

	}
	else {
		$PageCompose = preg_replace("/(\[)(ifspellcheck)(])(\r\n)*(.*)(\[\/ifspellcheck\])/siU", "", $PageCompose);
	}
	if ($_POST['spellcheck']) {
		$PageCompose = str_replace("[ifspellsuggest]", "", $PageCompose);
		$PageCompose = str_replace("[/ifspellsuggest]", "", $PageCompose);

		if ($nosuggestions == 0) {
			$PageCompose = str_replace("[spellcheck_suggestions]", $suggestionoutput, $PageCompose);
		}
		else {
			$PageCompose = str_replace("[spellcheck_suggestions]", $lang['SCompose']['SpellNoErrors'], $PageCompose);
		}

	}
	else {
		$PageCompose = preg_replace("/(\[)(ifspellsuggest)(])(\r\n)*(.*)(\[\/ifspellsuggest\])/siU", "", $PageCompose);
	}


	if ($UseDatabase == 1) {
		$AliasList = $MySQLConnection->DB_GetAliasList();
		if (is_array($AliasList)) {
			$PageCompose = str_replace("[ifalias]", "", $PageCompose);
			$PageCompose = str_replace("[/ifalias]", "", $PageCompose);
			$PageCompose = preg_replace("/(\[)(ifnoalias)(])(\r\n)*(.*)(\[\/ifnoalias\])/siU", "", $PageCompose);

			while(list($key, $value) = each($AliasList)) {
				$aliaslistdisplay .= "<option value=\"" . urlencode('"' . $AliasList[$key]['name'] . '" <' . $AliasList[$key]['email'] . '>') . "\">&quot;" . $AliasList[$key]['name'] . "&quot; &lt;" . $AliasList[$key]['email'] . "&gt;</option>";
			}
		}
		else {
			$PageCompose = str_replace("[ifnoalias]", "", $PageCompose);
			$PageCompose = str_replace("[/ifnoalias]", "", $PageCompose);
			$PageCompose = preg_replace("/(\[)(ifalias)(])(\r\n)*(.*)(\[\/ifalias\])/siU", "", $PageCompose);
			$aliaslistdisplay = '';
		}
	}
	else {
		$PageCompose = str_replace("[ifnoalias]", "", $PageCompose);
		$PageCompose = str_replace("[/ifnoalias]", "", $PageCompose);
		$PageCompose = preg_replace("/(\[)(ifalias)(])(\r\n)*(.*)(\[\/ifalias\])/siU", "", $PageCompose);
		$aliaslistdisplay = '';
	}

	if (!isset($addressbook_to)) {
		$addressbook_to = "";
	}
	if (!isset($addressbook_cc)) {
		$addressbook_cc = "";
	}
	if (!isset($addressbook_bcc)) {
		$addressbook_bcc = "";
	}

	if (isset($pname) && ($pname <> "")) {
		$listemailcurrent = '"' . $pname . '" &lt;' . $_SESSION['currentemailaddress'] . '&gt;';
	}
	else {
		$listemailcurrent = $_SESSION['currentemailaddress'];
	}

	if (isset($DisplayBcc) && ($DisplayBcc <> 1)) {
		$PageCompose = preg_replace("/(\[)(ifbcc)(])(\r\n)*(.*)(\[\/ifbcc\])/siU", "", $PageCompose);
	}
	else {
		$PageCompose = str_replace("[ifbcc]", "", $PageCompose);
		$PageCompose = str_replace("[/ifbcc]", "", $PageCompose);
	}
	if (isset($DisplayRT) && ($DisplayRT <> 1)) {
		if ($DefaultReplyTo) {
			$hiddenrt = '<input type="hidden" id="reply_to" name="replyto" value="' . str_replace('"', "&quot;", $DefaultReplyTo) . '" />';
		}
		else {
			$hiddenrt = '<input type="hidden" id="reply_to" name="replyto" value="' . str_replace('"', "&quot;", $_SESSION['currentemailaddress']) . '" />';
		}
		$PageCompose = preg_replace("/(\[)(ifreplyto)(])(\r\n)*(.*)(\[\/ifreplyto\])/esiU", '\$hiddenrt', $PageCompose);
	}
	else {
		$PageCompose = str_replace("[ifreplyto]", "", $PageCompose);
		$PageCompose = str_replace("[/ifreplyto]", "", $PageCompose);
	}

	if (empty($errormessage)) {
		$PageCompose = preg_replace("/(\[)(iferror)(])(\r\n)*(.*)(\[\/iferror\])/siU", "", $PageCompose);
	}
	else {
		$PageCompose = str_replace("[iferror]", "", $PageCompose);
		$PageCompose = str_replace("[/iferror]", "", $PageCompose);
	}

	if (is_array($headerdetails) && $headerdetails['messageid'] <> '') {
		$replyid = "<input type=\"hidden\" name=\"mid\" value=\"" . $headerdetails['messageid'] . "\" />";
	}

	// Compose Form variable definitions and replacements
	$CodeSearch = array (
		"[compose_form]",
		"[compose_fromencode]",
		"[compose_attachments]",
		"[compose_replyto]",
		"[compose_to]",
		"[compose_cc]",
		"[compose_bcc]",
		"[compose_subject]",
		"[compose_body]",
		"[session_force]",
		"[session_force2]",
		"[session_js]",
		"[compose_from]",
		"[compose_menu]",
		"[compose_hidden]",
		"[compose_mode]",
		"[compose_priority]",
		"[compose_readreceipt]",
		"[imap_savemessage]",
		"[v-editor_button]",
		"[addressbook_to]",
		"[addressbook_cc]",
		"[addressbook_bcc]",
		"[error_message]",
		"[imap_saverecipients]",
		"[wysiwyg_forecolor]",
		"[wysiwyg_fontface]",
		"[wysiwyg_fontsize]",
		"[AliasList]"
	);

	$CodeReplace = array (
		$compose_form,
		urlencode(unhtmlentities($listemailcurrent)),
		$compose_attachments,
		"<input type=\"text\" name=\"replyto\" id=\"reply_to\" size=\"40\" value=\"" . str_replace('"', "&quot;", $ReplyTo) . "\" />",
		"<input type=\"text\" name=\"to\" size=\"40\" id=\"to_input\" value=\"" . str_replace('"', "&quot;", stripslashes($sendto)) . "\" />",
		"<input type=\"text\" name=\"cc\" size=\"40\" id=\"cc_input\" value=\"" . str_replace('"', "&quot;", stripslashes($sendcc)) . "\" />",
		"<input type=\"text\" name=\"bcc\" size=\"40\" id=\"bcc_input\" value=\"" . str_replace('"', "&quot;", stripslashes($sendbcc)) . "\" />",
		"<input type=\"text\" name=\"subject\" size=\"40\" value=\"" . str_replace('"', "&quot;", stripslashes($subj2)) . "\" />",
		stripslashes($messagebox),
		"?" . strip_tags(SID),
		"&amp;" . strip_tags(SID),
		strip_tags(SID),
		$listemailcurrent,
		$PageComposeMenu,
		$replyid . "<input type=\"hidden\" name=\"edit\" value=\"$edit\" /><input type=\"hidden\" name=\"mode\" value=\"$mode\" /><input type=\"hidden\" name=\"msgid\" value=\"$id\" /><input type=\"hidden\" name=\"id\" value=\"$id\" /><input type=\"hidden\" name=\"f\" value=\"" . $_SESSION['folder'] . "\" />",
		$currentmode,
		$bt_priorities,
		$bt_read_receipt,
		$imap_savemessage,
		$veditorbutton,
		$addressbook_to,
		$addressbook_cc,
		$addressbook_bcc,
		$errormessage,
		$imap_saverecipients,
		$forecolour,
		$fontface,
		$fontsize,
		$aliaslistdisplay
	);

	$PageCompose = str_replace ($CodeSearch, $CodeReplace, $PageCompose);
	$PageCompose = LangReplace('SCompose', $PageCompose, $lang);

	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;
	echo $PageCompose;
}

// Close our IMAP connection
$IMAPConnection->WM_IMAPClose();

if ($UseDatabase == 1) {
	// Close MySQL connection
	$MySQLCloseConnection = $MySQLConnection->DB_CloseConnection();
}

echo $PageFooter;
?>