<?php
 

class directadmin
{

    var $s;

    function directadmin( $host, $auser, $apass )
    {
        $this->s = new httpsocket( );
        $this->s->connect( $host, 2222 );
        $this->s->set_login( $auser, $apass );
        return $this->check_auth( $auser, $apass );
    }

    function check_auth( $user, $pass )
    {
        $this->s->query( "/CMD_API_VERIFY_PASSWORD", array( "user" => $user, "pass" => $pass ) );
        $ret = $this->s->fetch_parsed_body( );
        if ( !isset( $ret['error'] ) )
        {
            return 0;
        }
        else
        {
            return $ret['details'];
        }
    }

    function add_user( $name, $email, $passwd, $domain, $package, $ip )
    {
        $this->s->query( "/CMD_API_ACCOUNT_USER", array( "action" => "create", "add" => "Submit", "username" => "{$name}", "email" => "{$email}", "passwd" => "{$passwd}", "passwd2" => "{$passwd}", "domain" => "{$domain}", "package" => "{$package}", "ip" => "{$ip}", "notify" => "yes" ) );
        $ret = $this->s->fetch_parsed_body( );
        if ( !isset( $ret['error'] ) )
        {
            return 0;
        }
        else
        {
            return $ret['error']."".$ret['details'];
        }
    }

    function get_user_info( $name )
    {
        $this->s->query( "/CMD_API_SHOW_USER_CONFIG", array( "user" => $name ) );
        $ret = $this->s->fetch_parsed_body( );
        if ( !isset( $ret['error'] ) )
        {
            return $ret;
        }
        else
        {
            return false;
        }
    }

    function is_suspended_user( $name )
    {
        $info = $this->get_user_info( $name );
        return $info['suspended'] == "no" ? 0 : 1;
    }

    function is_active_user( $name )
    {
        return !$this->is_suspended_user( $name );
    }

    function suspend_user( $name )
    {
        if ( $this->is_suspended_user( $name ) )
        {
            return 0;
        }
        $this->s->query( "/CMD_SELECT_USERS", array( "location" => "/CMD_USER_SHOW", "suspend" => "Suspend", "select0" => $name ) );
        return $this->s->fetch_body( );
    }

    function activate_user( $name )
    {
        if ( $this->is_active_user( $name ) )
        {
            return 0;
        }
        $this->s->query( "/CMD_SELECT_USERS", array( "location" => "/CMD_USER_SHOW", "suspend" => "Unsuspend", "select0" => $name ) );
        return $this->s->fetch_body( );
    }

    function set_package_user( $name, $package )
    {
        $this->s->query( "/CMD_API_MODIFY_USER", array( "action" => "package", "user" => $name, "package" => $package ) );
        $ret = $this->s->fetch_parsed_body( );
        if ( !$ret['error'] )
        {
            return 0;
        }
        else
        {
            return $ret['error']." ".$ret['details'];
        }
    }

    function get_users( )
    {
        $this->s->query( "/CMD_API_SHOW_USERS" );
        $ret = $this->s->fetch_parsed_body( );
        return $ret['list'];
    }

    function get_packages( )
    {
        $this->s->query( "/CMD_API_PACKAGES_USER" );
        $r = $this->s->fetch_parsed_body( );
        return $r['list'];
    }

    function delete_user( $name )
    {
        $this->s->set_method( "post" );
        $this->s->query( "/CMD_SELECT_USERS", array( "confirmed" => "Confirm", "delete" => "yes", "select0" => "{$name}" ) );
        return $this->s->fetch_body( );
    }

}

class httpsocket
{

    var $version = "2.6";
    var $method = "GET";
    var $remote_host;
    var $remote_port;
    var $remote_uname;
    var $remote_passwd;
    var $result;
    var $result_header;
    var $result_body;
    var $result_status_code;
    var $lastTransferSpeed;
    var $bind_host;
    var $error = array( );
    var $warn = array( );
    var $query_cache = array( );
    var $doFollowLocationHeader = TRUE;
    var $redirectURL;
    var $extra_headers = array( );

    function connect( $host, $port = "" )
    {
        if ( !is_numeric( $port ) )
        {
            $port = 80;
        }
        $this->remote_host = $host;
        $this->remote_port = $port;
    }

    function bind( $ip = "" )
    {
        if ( $ip == "" )
        {
            $ip = $_SERVER['SERVER_ADDR'];
        }
        $this->bind_host = $ip;
    }

    function set_method( $method = "GET" )
    {
        $this->method = strtoupper( $method );
    }

    function set_login( $uname = "", $passwd = "" )
    {
        if ( 0 < strlen( $uname ) )
        {
            $this->remote_uname = $uname;
        }
        if ( 0 < strlen( $passwd ) )
        {
            $this->remote_passwd = $passwd;
        }
    }

    function query( $request, $content = "", $doSpeedCheck = 0 )
    {
        $this->error = $this->warn = array( );
        $this->result_status_code = NULL;
        if ( preg_match( "!^http://!i", $request ) )
        {
            $location = parse_url( $request );
            $this->connect( $location['host'], $location['port'] );
            $this->set_login( $location['user'], $location['pass'] );
            $request = $location['path'];
            $content = $location['query'];
            if ( strlen( $request ) < 1 )
            {
                $request = "/";
            }
        }
        $array_headers = array( "User-Agent" => "HTTPSocket/{$this->version}", "Host" => $this->remote_port == 80 ? $this->remote_host : "{$this->remote_host}:{$this->remote_port}", "Referer" => "/", "Accept" => "*/*", "Connection" => "Close" );
        foreach ( $this->extra_headers as $key => $value )
        {
            $array_headers[$key] = $value;
        }
        $this->result = $this->result_header = $this->result_body = "";
        if ( is_array( $content ) )
        {
            $pairs = array( );
            foreach ( $content as $key => $value )
            {
                $pairs[] = "{$key}=".urlencode( $value );
            }
            $content = join( "&", $pairs );
            unset( $pairs );
        }
        $OK = TRUE;
        if ( $this->bind_host )
        {
            $socket = socket_create( AF_INET, SOCK_STREAM, SOL_TCP );
            socket_bind( $socket, $this->bind_host );
            if ( @!socket_connect( @$socket, @$this->remote_host, @$this->remote_port ) )
            {
                $OK = FALSE;
            }
        }
        else
        {
            $socket = @fsockopen( @$this->remote_host, @$this->remote_port, @$sock_errno, @$sock_errstr, 10 );
        }
        if ( !$socket || !$OK )
        {
            $this->error[] = "Can't create socket connection to {$this->remote_host}:{$this->remote_port}.";
            return 0;
        }
        if ( ( !$socket || !$OK ) && isset( $this->remote_uname, $this->remote_passwd ) )
        {
            $array_headers['Authorization'] = "Basic ".base64_encode( "{$this->remote_uname}:{$this->remote_passwd}" );
        }
        if ( isset( $this->remote_uname ) && $this->remote_passwd == NULL )
        {
            $array_headers['Cookie'] = "session={$_SERVER['SESSION_ID']}; key={$_SERVER['SESSION_KEY']}";
        }
        if ( $this->method == "POST" )
        {
            $array_headers['Content-type'] = "application/x-www-form-urlencoded";
            $array_headers['Content-length'] = strlen( $content );
        }
        else if ( $content )
        {
            $request .= "?{$content}";
        }
        $query = "{$this->method} {$request} HTTP/1.0\r\n";
        foreach ( $array_headers as $key => $value )
        {
            $query .= "{$key}: {$value}\r\n";
        }
        $query .= "\r\n";
        if ( $this->method == "POST" && $content )
        {
            $query .= "{$content}\r\n\r\n";
        }
        if ( $this->bind_host )
        {
            socket_write( $socket, $query );
            while ( $out = socket_read( $socket, 2048 ) )
            {
                $this->result .= $out;
            }
        }
        else
        {
            fwrite( $socket, $query, strlen( $query ) );
            $this->lastTransferSpeed = 0;
            $status = socket_get_status( $socket );
            $startTime = time( );
            $length = 0;
            $prevSecond = 0;
            while ( !feof( $socket ) && !$status['timed_out'] )
            {
                $chunk = fgets( $socket, 1024 );
                $length += strlen( $chunk );
                $this->result .= $chunk;
                $elapsedTime = time( ) - $startTime;
                if ( 0 < $elapsedTime )
                {
                    $this->lastTransferSpeed = $length / 1024 / $elapsedTime;
                }
            }
            if ( $this->lastTransferSpeed == 0 )
            {
                $this->lastTransferSpeed = $length / 1024;
            }
        }
        $this->result_body = split( "\r\n\r\n", $this->result, 2 )[1];
        $this->result_header = split( "\r\n\r\n", $this->result, 2 )[0];
        if ( $this->bind_host )
        {
            socket_close( $socket );
        }
        else
        {
            fclose( $socket );
        }
        $headers = $this->fetch_header( );
        if ( !$this->result_status_code )
        {
            preg_match( "#HTTP/1\\.. (\\d+)#", $headers[0], $matches );
            $this->result_status_code = $matches[1];
        }
        if ( !empty( $headers['content-length'] ) && $headers['content-length'] != strlen( $this->result_body ) )
        {
            $this->result_status_code = 206;
        }
        if ( $this->doFollowLocationHeader && $headers['location'] )
        {
            $this->redirectURL = $headers['location'];
            $this->query( $headers['location'] );
        }
    }

    function gettransferspeed( )
    {
        return $this->lastTransferSpeed;
    }

    function get( $location, $asArray = FALSE )
    {
        $this->query( $location );
        if ( $this->get_status_code( ) == 200 )
        {
            if ( $asArray )
            {
                return split( "\n", $this->fetch_body( ) );
            }
            return $this->fetch_body( );
        }
        return FALSE;
    }

    function get_status_code( )
    {
        return $this->result_status_code;
    }

    function add_header( $key, $value )
    {
        $this->extra_headers[$key] = $value;
    }

    function clear_headers( )
    {
        $this->extra_headers = array( );
    }

    function fetch_result( )
    {
        return $this->result;
    }

    function fetch_header( $header = "" )
    {
        $array_headers = split( "\r\n", $this->result_header );
        $array_return = array( 0 => $array_headers[0] );
        unset( $array_headers[0] );
        foreach ( $array_headers as $pair )
        {
            $value = split( ": ", $pair, 2 )[1];
            $key = split( ": ", $pair, 2 )[0];
            $array_return[strtolower( $key )] = $value;
        }
        if ( $header != "" )
        {
            return $array_return[strtolower( $header )];
        }
        return $array_return;
    }

    function fetch_body( )
    {
        return $this->result_body;
    }

    function fetch_parsed_body( )
    {
        parse_str( $this->result_body, $x );
        return $x;
    }

}

?>
