<?php

/*
////////////////////////////////////////////////////////////////////////////////
// JohnCMS                             Content Management System              //
// Official the project site:      http://johncms.com                     //
// Additional support site:      http://gazenwagen.com                  //
// Additional translation script site:      http://wapmod.net                  //
////////////////////////////////////////////////////////////////////////////////
// JohnCMS core team:                                                         //
// Author john77          john77@gazenwagen.com                  //
// And support by AlkatraZ          alkatraz@gazenwagen.com                //
// Translation english by RYN          admin@wapmod.net                //
//                                                                            //
// Version information see the file version.txt              //
////////////////////////////////////////////////////////////////////////////////
*/

define('_IN_JOHNCMS', 1);

$textl = 'Avatar';

require_once ('../incfiles/core.php');
require_once ('../incfiles/head.php');

if (!$user_id) {
    display_error('Access page only registered users');
    require_once ('../incfiles/end.php');
    exit;
}

switch ($act) {
    case 'choice' :
        if ($_GET['ava'] && intval($_GET['cat'])) {
            $ava = intval($_GET['ava']);
            $cat = intval($_GET['cat']);
            $av = '../avatars/' . $cat . '/' . $ava . '.png';
            copy($av, '../files/avatar/' . $user_id . '.png');
        }
        echo '<p>Avatar changed!<br /><a href="my_data.php?id=' . $user_id . '">Continue</a><br/><a href="avatar.php">Back</a></p>';
        break;

    case 'cat' :
        if (!is_dir($rootpath . 'avatars/' . $id)) {
            echo $id;
            echo '<p>Error!<br/><a href="avatar.php">Back</a></p>';
            require_once ('../incfiles/end.php');
            exit;
        }
        echo '<div class="phdr">Avatar: <b>' . htmlentities(file_get_contents($rootpath . 'avatars/' . $id . '/name.dat'), ENT_QUOTES, 'utf-8') . '</b></div>';
        $array = glob($rootpath . 'avatars/' . $id . '/*.png');
        $total = count($array);
        $end = $start + $kmess;
        if ($end > $total)
            $end = $total;
        if ($total > 0) {
            for ($i = $start; $i < $end; $i++) {
                $ava = preg_replace('#^' . $rootpath . 'avatars/' . $id . '/(.*?).png$#isU', '$1', $array [$i], 1);
                echo is_integer($i / 2) ? '<div class="list1">' : '<div class="list2">';
                echo '<img src="' . $array [$i] . '" alt="" /> - <a href="avatar.php?act=choice&amp;cat=' . $id . '&amp;ava=' . $ava . '">Select</a></div>';
            }
        }
        else {
            echo 'No avatar in this category!<br/>';
        }
        echo '<div class="phdr">Total: ' . $total . '</div>';
        if ($total > $kmess) {
            echo '<p>' . pagenav('avatar.php?act=cat&amp;id=' . $id . '&amp;', $start, $total, $kmess) . '</p>';
            echo '<p><form action="avatar.php" method="get"><input type="hidden" value="cat" name="act" /><input type="hidden" value="' . $id .
            '" name="id" /><input type="text" name="page" size="2"/><input type="submit" value="Go to page &gt;&gt;"/></form></p>';
        }
        echo '<p><a href="avatar.php">Back to category</a></p>';
        break;

    default :
        if (empty ($_SESSION['refsm'])) {
            $_SESSION['refsm'] = htmlspecialchars($_SERVER['HTTP_REFERER']);
        }
        echo '<div class="phdr"><b>Category avatar</b></div>';
        $dir = glob($rootpath . 'avatars/*', GLOB_ONLYDIR);
        $total_dir = count($dir);
        for ($i = 0; $i < $total_dir; $i++) {
            echo is_integer($i / 2) ? '<div class="list1">' : '<div class="list2">';
            echo '<a href="avatar.php?act=cat&amp;id=' . preg_replace('#^' . $rootpath . 'avatars/#isU', '', $dir[$i], 1) . '">' . htmlentities(file_get_contents($dir[$i] . '/name.dat'), ENT_QUOTES, 'utf-8') . '</a> (' . (int) count(glob($dir
            [$i] . '/*.png')) . ')</div>';
        }
        echo '<div class="phdr"><a href="' . $_SESSION['refsm'] . '">Back</a></div>';
        break;
}

require_once ('../incfiles/end.php');

?>