<?php

require 'config.php';

list($msec,$sec) = explode(' ',microtime());
$ms = $sec+$msec;

if($auth){
auth($_SERVER['PHP_AUTH_USER'],$_SERVER['PHP_AUTH_PW']);
}

function auth($user,$pass){
global $user_name, $user_pass;
if(!$user || !$pass){
header('WWW-Authenticate: Basic realm="Authentification"');
header('HTTP/1.0 401 Unauthorized');
header('Content-type: text/html; charset=utf-8');
print '<html><head><title>Error</title></head><body><p style="color:red;font-size:24pt;text-align:center">Unauthorized</p></body></html>';
exit;
}
else{
if($user!=$user_name || $pass!=$user_pass){
header('WWW-Authenticate: Basic realm="Authentification"');
header('HTTP/1.0 401 Unauthorized');
header("Content-type: text/html; charset=utf-8");
print '<html><head><title>Error</title></head><body><p style="color:red;font-size:24pt;text-align:center">Unauthorized</p></body></html>';
exit;
}
}
return;
}

function send_header($u){
/*
if(substr_count($u, 'MSIE'))
{header('Content-type: text/html; charset=UTF-8');}
else
{header('Content-type: application/xhtml+xml; charset=UTF-8');}
*/
header('Content-type: text/html; charset=UTF-8');
header('Cache-control: no-cache');
return;
}

function c($query,$c)
{
if(!$query){
return '.';
}
else{
if($c){
$current = str_replace('\\','/',trim(rawurldecode($c)));

if(is_dir($current)){
if($current[iconv_strlen($current)-1] != '/'){
$current = $current.'/';
}
}
return $current;
}
else{
$query = str_replace('\\','/',trim(rawurldecode($query)));
if(is_dir($query)){
if($query[iconv_strlen($query)-1] != '/'){
$query = $query.'/';
}
}
return $query;
}
}
}

function this($current){
global $lng, $_POST;
$realpath = realpath($current);
$realpath = $realpath?$realpath:$current;

$chmod = look_chmod($current);
$chmod = $chmod?$chmod:htmlspecialchars($_POST['chmod']);

$d = dirname(str_replace('\\','/',$realpath));

$type = strtoupper(strrchr($current,'.'));

if(is_dir($current))
{
if($current == '.')
{return '<div class="border">'.$lng['dir'].' <strong><a href="index.php">'.getcwd().'</a></strong> ('.look_chmod(getcwd()).')<br/></div>';}
else
{
return '<div class="border">'.$lng['back'].' <a href="index.php?'.$d.'">'.$d.'</a> ('.look_chmod($d).')<br/></div>
<div class="border">'.$lng['dir'].' <strong><a href="index.php?'.$current.'">'.str_replace('\\','/',$realpath).'</a></strong> ('.$chmod.')<br/></div>';
}
}
elseif(is_file($current) && ($type=='.ZIP' || $type=='.JAR' || $type=='.GZ' || $type=='.TAR' || $type=='.TGZ' || $type=='.BZ' || $type=='.BZ2'))
{
$up = dirname($d);
return '<div class="border">'.$lng['back'].' <a href="index.php?'.$up.'">'.$up.'</a> ('.look_chmod($up).')<br/></div>
<div class="border">'.$lng['dir'].' <strong><a href="index.php?'.$d.'">'.$d.'</a></strong> ('.look_chmod($d).')<br/></div>
<div class="border">'.$lng['file'].' <strong><a href="index.php?'.$current.'">'.str_replace('\\','/',$realpath).'</a></strong> ('.$chmod.')<br/></div>';
}
else
{
$up = dirname($d);
return '<div class="border">'.$lng['back'].' <a href="index.php?'.$up.'">'.$up.'</a> ('.look_chmod($up).')<br/></div>
<div class="border">'.$lng['dir'].' <strong><a href="index.php?'.$d.'">'.$d.'</a></strong> ('.look_chmod($d).')<br/></div>
<div class="border">'.$lng['file'].' <strong><a href="edit.php?'.$current.'">'.str_replace('\\','/',$realpath).'</a></strong> ('.$chmod.')<br/></div>';
}
}

function static_name($current,$dest)
{
$len = iconv_strlen($current);
if(iconv_substr($dest,0,$len) == $current)
{
$static = iconv_substr($dest,$len);

if(iconv_strpos($static,'/'))
{$static = strtok($static,'/');}
}
else
{return;}
return $static;
}

function look($current)
{
global $lng,$dir_size,$date_format,$edit_format,$realname,$target,$add_archive,$limit,$_GET,$_SERVER;
if($target)
{$target = ' target="_blank"';}
else
{$target = '';}

if($add_archive)
{$add = '&amp;go=1&amp;add_archive='.$add_archive;}
else
{$add = '';}

$page1 = $page2 = array();

$dir = opendir($current);
$i = 1;

while($file = readdir($dir))
{
if($file=='.' || $file=='..')
{continue;}

if($current != '.')
{$file = $current.$file;}

if($realname==1)
{$name = str_replace('\\','/',realpath($file));}
elseif($realname==2)
{$name = basename($file);}
else
{$name = $file;}

$type = strtoupper(strrchr($name,'.'));
$time = filemtime($file);
$name = str_link($name);
$i++;

if(isset($_GET['time']))
{$key = $time;}
else
{$key = strtolower($name);}

if(is_dir($file)){
$page1[$key] = '<td><input name="check[]" type="checkbox" value="'.$file.'"/></td><td><a href="index.php?c='.$file.'/'.$add.'">'.$name.'/</a></td><td></td><td>DIR</td><td>';
if($dir_size){
$page1[$key].= dir_size($file);
}
else{
$page1[$key].= $lng['unknown'];
}
$page1[$key].= '</td><td><a href="change.php?'.$file.'/">'.$lng['ch'].'</a></td><td><a href="change.php?go=del&amp;c='.$file.'/">'.$lng['dl'].'</a></td><td><a href="change.php?go=chmod&amp;c='.$file.'">'.look_chmod($file).'</a></td><td>'.strftime($date_format, $time).'</td>';
}
else{
if(preg_match('/^('.$edit_format.')+$/i', $type)){
$page2[$key] = '<td><input name="check[]" type="checkbox" value="'.$file.'"/></td><td><a href="edit.php?'.$file.'"'.$target.'>'.$name.'</a></td><td><a href="change.php?get='.$file.'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.file_size($file).'</td><td><a href="change.php?'.$file.'">'.$lng['ch'].'</a></td><td><a href="change.php?go=del&amp;c='.$file.'">'.$lng['dl'].'</a></td><td><a href="change.php?go=chmod&amp;c='.$file.'">'.look_chmod($file).'</a></td><td>'.strftime($date_format, $time).'</td>';
}
elseif($type=='.ZIP' || $type=='.JAR' || $type=='.GZ' || $type=='.TAR' || $type=='.TGZ' || $type=='.BZ' || $type=='.BZ2'){
$page2[$key] = '<td><input name="check[]" type="checkbox" value="'.$file.'"/></td><td><a href="index.php?'.$file.'">'.$name.'</a><br/><a class="submit" href="change.php?go=1&amp;c='.$file.'&amp;mega_full_extract=1">'.$lng['extract_archive'].'</a></td><td><a href="change.php?get='.$file.'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.file_size($file).'</td><td><a href="change.php?'.$file.'">'.$lng['ch'].'</a></td><td><a href="change.php?go=del&amp;c='.$file.'">'.$lng['dl'].'</a></td><td><a href="change.php?go=chmod&amp;c='.$file.'">'.look_chmod($file).'</a></td><td>'.strftime($date_format, $time).'</td>';
}
else{
$page2[$key] = '<td><input name="check[]" type="checkbox" value="'.$file.'"/></td><td><a href="'.str_replace($_SERVER['DOCUMENT_ROOT'],'',$file).'">'.$name.'</a></td><td><a href="change.php?get='.$file.'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.file_size($file).'</td><td><a href="change.php?'.$file.'">'.$lng['ch'].'</a></td><td><a href="change.php?go=del&amp;c='.$file.'">'.$lng['dl'].'</a></td><td><a href="change.php?go=chmod&amp;c='.$file.'">'.look_chmod($file).'</a></td><td>'.strftime($date_format, $time).'</td>';
}

if($type=='.SQL'){
$page2[$key] = str_replace('</a></td><td>'.$type.'</td><td>','</a><br/><a class="submit" href="change.php?go=tables&amp;c='.$file.'">'.$lng['tables'].'</a><br/><a class="submit" href="change.php?go=installer&amp;c='.$file.'">'.$lng['create_sql_installer'].'</a></td><td>'.$type.'</td><td>',$page2[$key]);
}

}

}
closedir($dir);

if(isset($_GET['time']))
{
krsort($page1,SORT_NUMERIC);
krsort($page2,SORT_NUMERIC);
}
else
{
ksort($page1,SORT_REGULAR);
ksort($page2,SORT_REGULAR);
}

$page = array_merge($page1,$page2);
$all = ceil(sizeof($page)/$limit);
$pg = intval($_GET['pg']);
if($pg < 1){
$pg = 1;
}
$page = array_slice($page, ($pg*$limit)-$limit, $limit);


if($page)
{
$i = 1;
foreach($page as $var)
{print '<tr class="border">'.$var.'<td>'.$i++.'</td></tr>';}

if(isset($_GET['time']))
{$time = '&amp;time';}
else
{$time = '';}

}
else
{print '<tr class="border"><th colspan="9">'.$lng['dir_empty'].'</th></tr>';}

echo go($pg, $all, '&amp;c='.$current.$time.$add);
return;
}

function copy_d($dest)
{
$ex = explode('/',$dest);
foreach($ex as $var)
{
$tmp.= $var.'/';
mkdir($tmp,0777);
chmod($tmp,0777);
}
return;
}

function copy_files($d,$dest,$static,$chmod)
{
global $lng;
$f = opendir($d);
while($file = readdir($f))
{
if($file=='.' || $file=='..' || $file==$static){continue;}
if($d == $dest){break;}
if(is_dir($d.'/'.$file))
{
mkdir($dest.'/'.$file,0777);
chmod($dest,0777);
copy_files($d.'/'.$file,$dest.'/'.$file,$static,$chmod);
}
else
{copy($d.'/'.$file,$dest.'/'.$file);}
}
closedir($f);
if($chmod){rechmod($dest,$chmod);}
return '<div class="red">'.str_replace('%dir%',$dest,$lng['copy_files_true']).'<br/></div>';
}

function move_files($d,$dest,$static,$chmod)
{
global $lng;
$f = opendir($d);
while($file = readdir($f))
{
if($file=='.' || $file=='..' || $file==$static){continue;}
if($d == $dest){break;}
if(is_dir($d.'/'.$file))
{
mkdir($dest.'/'.$file,0777);
chmod($dest.'/'.$file,0777);
move_files($d.'/'.$file,$dest.'/'.$file,$static,$chmod);
rmdir($d.'/'.$file);
}
else
{
if(copy($d.'/'.$file,$dest.'/'.$file))
{unlink($d.'/'.$file);}
}
}
closedir($f);
chmod($d,0777);
rmdir($d);
if($chmod){rechmod($dest,$chmod);}
return '<div class="red">'.str_replace('%dir%',$dest,$lng['move_files_true']).'<br/></div>';
}

function copy_file($source,$dest,$chmod)
{
global $lng;
copy_d(dirname($dest));
if(copy($source,$dest))
{
if($chmod){rechmod($dest,$chmod);}
return '<div class="red">'.str_replace('%file%',$source,$lng['copy_file_true']).'<br/></div>';
}
else
{return '<div class="red">'.str_replace('%file%',$source,$lng['copy_file_false']).'<br/></div>';}
}

function move_file($source,$dest,$chmod)
{
global $lng;
copy_d(dirname($dest));
if(copy($source,$dest))
{
del_file($source);
if($chmod){rechmod($dest,$chmod);}
return '<div class="red">'.str_replace('%file%',$source,$lng['move_file_true']).'<br/></div>';
}
else{
return '<div class="red">'.str_replace('%file%',$source,$lng['move_file_false']).'<br/></div>';
}
}

function del_file($f)
{
global $lng;
chmod($f,0777);
if(unlink($f))
{return '<div class="red">'.$lng['del_file_true'].'<br/></div>';}
else
{return '<div class="red">'.$lng['del_file_false'].'<br/></div>';}
}

function del_dir($d)
{
global $lng;
chmod($d,0777);
$dir = opendir($d);
while($f = readdir($dir))
{
if($f=='.' ||  $f=='..')
{continue;}
$f = str_replace('\\','/',realpath($d.'/'.$f));
chmod($f,0777);
if(is_file($f))
{if(!unlink($f)){$err.=$f.'<br/>';}}
elseif(is_dir($f))
{
rmdir($f);
del_dir($f.'/');
}
}
closedir($dir);
if(!rmdir($d)){$err.=str_replace('\\','/',realpath($d)).'<br/>';}
if($err){return '<div class="red">'.$lng['del_dir_false'].'<br/>'.$err.'</div>';}
return '<div class="red">'.$lng['del_dir_true'].'<br/></div>';
}

function dir_size($file)
{
if(!is_dir($file) || !is_readable($file))
{return;}
$ds[] = $file;
$sz = 0;
do
{
$d = array_shift($ds);
$h = opendir($d);
while($file = readdir($h))
{
if($file!='.' && $file!='..' && is_readable($d.'/'.$file))
{
if(is_dir($d.'/'.$file))
{$ds[] = $d.'/'.$file;}
$sz += sprintf('%u', filesize($d.'/'.$file));
}
}
closedir($h);
}
while(sizeof($ds) > 0);

return file_size($sz);
}



function file_size($file){
if(is_file($file)){
$size = sprintf('%u', filesize($file));
}
else{
$size = $file;
}

if($size < 1024){
return $size.' Byte';
}
elseif($size < 1048576){
return round($size/1024,2).' Kb';
}

return round($size/1024/1024,2).' Mb';
}

function look_chmod($file)
{return iconv_substr(sprintf('%o', fileperms($file)), -4);}

function create_file($file,$mode,$chmod,$text)
{
global $lng;
if(!$mode){
$mode = 'w+b';
}

if($create = fopen($file, $mode))
{
$page.= '<div class="red">'.$lng['create_file_true'].'<br/></div>';
if($text)
{
if(fputs($create,trim($text)))
{$page.= '<div class="red">'.$lng['fputs_file_true'].'<br/></div>';}
else
{$page.= '<div class="red">'.$lng['fputs_file_false'].'<br/></div>';}
}
fclose($create);
$page.= rechmod($file,$chmod);
}
else
{return '<div class="red">'.$lng['create_file_false'].'<br/></div>';}
return $page;
}

function rechmod($current,$chmod)
{
global $lng;

if(iconv_strlen($chmod)<4){
$chmod = '0'.$chmod;
}

if(chmod(trim($current), octdec($chmod))){
return '<div class="red">'.$lng['chmod_true'].' ('.$current.')<br/></div>';
}
else{
$error = error_get_last();
$error = explode(':',$error['message']);
return '<div class="red">'.$lng['chmod_false'].' ('.$current.') - '.$error[1].'<br/></div>';
}
}

function create_dir($dir,$chmod)
{
global $lng;
if(mkdir($dir, $chmod)){
rechmod($dir, $chmod);
return '<div class="red">'.$lng['create_dir_true'].'<br/></div>';
}
else{
return '<div class="red">'.$lng['create_dir_false'].'<br/></div>';
}
}

function frename($current,$name,$chmod,$del)
{
if(is_dir($current))
{
copy_d($name);

if($del)
{print move_files($current,$name,static_name($current,$name),$chmod);}
else
{print copy_files($current,$name,static_name($current,$name),$chmod);}
}
else
{
if($del)
{print move_file($current,$name,$chmod);}
else
{print copy_file($current,$name,$chmod);}
}
return;
}

function syntax($source,$charset)
{
global $lng,$php;
exec($php.' -c -f -l "'.$source.'"',$rt,$v);

if(!sizeof($rt) || !file_exists($source))
{return '<div class="red">'.$lng['syntax_not_check'].'<br/></div>';}

if(($v == 255) || (sizeof($rt) > 2))
{
$st = trim(strip_tags($rt[1]));
if($st!=null)
{
$erl = preg_replace("~.*\s(\d*)$~",'$1',$st,1);
$pg = $st;
}
else
{$pg = $lng['syntax_unknown'].'<br/>';}
}
elseif(($v == 0) || (sizeof($rt)>0))
{$pg = $lng['syntax_true'].'<br/>';}

$fl = trim(file_get_contents($source));
if($charset == 'windows-1251')
{$fl = iconv('UTF-8','windows-1251',$fl);}
elseif($charset == 'utf-8')
{$fl = iconv('windows-1251','UTF-8',$fl);}

if(substr_count($fl,"\r") > 2)
{$arr = split("\r",xhtml_highlight(str_replace("\n",null,$fl)));}
else
{$arr = split('<br />',xhtml_highlight($fl));}

$end = sizeof($arr);
for($i=0; $i<$end; $i++)
{
if($i == ($erl-1))
{$page.= '<span class="fail_code">&#160;'.($i+1).'&#160;</span> '.$arr[$i].'<br/>';}
else
{$page.= '<span class="true_code">'.($i+1).'</span> '.$arr[$i].'<br/>';}
}

return '<div class="red">'.$pg.'</div><div class="code">'.$page.'</div>';
}

function syntax2($current,$charset)
{
global $lng,$version;
$fp = fsockopen('wapinet.ru',80,$er1,$er2,15);
if(!$fp){return '<div class="red">'.$lng['syntax_not_check'].'<br/></div>';}

$f = rawurlencode(trim(file_get_contents($current)));

fputs($fp,'POST /syntax2/index.php HTTP/1.0'."\r\n".'Content-type: application/x-www-form-urlencoded; charset='.$charset."\r\n".'Content-length: '.(iconv_strlen($f)+2)."\r\n".'Host: wapinet.ru'."\r\n".'Connection: close'."\r\n".'User-Agent: GManager '.$version."\r\n\r\n".'f='.$f."\r\n\r\n");

while($r != "\r\n"){$r = fgets($fp);}
$r=null;

while(!feof($fp))
{$r.=fread($fp,1024);}
fclose($fp);
return trim($r);
}

function zip_syntax($current,$f,$charset,$syntax)
{
$content = edit_zip_file($current,$f);
$tmp = PCLZIP_TEMPORARY_DIR.'/tmp_gmanager.dat';
$fp = fopen($tmp,'w');
fputs($fp,$content['text']);
fclose($fp);

if(!$syntax)
{$pg = syntax($tmp,$charset);}
else
{$pg = syntax2($tmp,$charset);}
unlink($tmp);
return $pg;
}

function validator($current,$charset)
{
global $lng;
$data = fopen($current,'r');
if(!$data)
{return '<div class="red">'.$lng['validator_not_check'].'<br/></div>';}
$fl = file_get_contents($current);
if($charset == 'windows-1251')
{$fl = iconv('UTF-8','windows-1251',$fl);}
elseif($charset == 'utf-8')
{$fl = iconv('windows-1251','UTF-8',$fl);}
$xml_parser = xml_parser_create();
if(!xml_parse($xml_parser, $fl, feof($data)))
{
$err = xml_error_string(xml_get_error_code($xml_parser));
$line = xml_get_current_line_number($xml_parser);
$column = xml_get_current_column_number($xml_parser);
xml_parser_free($xml_parser);
fclose($data);
return '<div class="red">Error [Line '.$line.', Column '.$column.']: '.$err.'<br/></div>'.code($fl,$line);
}
else
{
xml_parser_free($xml_parser);
return '<div class="red">'.$lng['validator_true'].'<br/></div>'.code($fl,0);
}
}

function xhtml_highlight($fl)
{return preg_replace('#color="(.*?)"#', 'style="color: $1"', str_replace(array('<font ', '</font>'), array('<span ', '</span>'), highlight_string($fl,true)));}

function url_highlight($fl)
{return '<code>'.nl2br(preg_replace("~(&quot;|&#039;)[^<>]*(&quot;|&#039;)~iU",'<span style="color:#DD0000">$0</span>',preg_replace("~&lt;!--.*--&gt;~iU",'<span style="color:#FF8000">$0</span>',preg_replace("~(&lt;[^\s!]*\s)([^<>]*)([/?]?&gt;)~iU",'$1<span style="color:#007700">$2</span>$3',preg_replace("~&lt;[^<>]*&gt;~iU",'<span style="color:#0000BB">$0</span>',htmlspecialchars($fl,ENT_QUOTES)))))).'</code>';}

function code($fl,$line)
{
if(substr_count($fl,"\r") > 2)
{$arr = split("\r",url_highlight(str_replace("\n",null,$fl)));}
else
{$arr = split("\n",url_highlight($fl));}

$end = sizeof($arr);
for($i=0; $i<$end; $i++)
{
if($i == ($line-1))
{$page.= '<span class="fail_code">&#160;'.($i+1).'&#160;</span> '.$arr[$i];}
else
{$page.= '<span class="true_code">'.($i+1).'</span> '.$arr[$i];}
}
return '<div class="code">'.$page.'</div>';
}

function list_zip_archive($current)
{
global $lng,$pclzip,$date_format;
require_once $pclzip;

$zip = &new PclZip($current);

if(($list = $zip->listContent())==0)
{return '<div class="red">'.$lng['archive_error'].'<br/></div>';}
else
{
$s = sizeof($list);

for($i=0; $i<$s; $i++)
{
if($list[$i]['folder'])
{
$type = 'DIR';
$name = $list[$i]['filename'];
$size = ' ';
}
else
{
$type = strtoupper(strrchr($list[$i]['filename'],'.'));
$name = '<a href="?c='.$current.'&amp;f='.$list[$i]['filename'].'">'.str_link($list[$i]['filename']).'</a>';
$size = file_size($list[$i]['size']);
}
$link.= '<tr class="border"><td><input name="check[]" type="checkbox" value="'.$list[$i]['filename'].'"/></td><td>'.$name.'</td><td><a href="change.php?get='.$current.'&amp;f='.$list[$i]['filename'].'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.$size.'</td><td> </td><td><a href="change.php?go=del_zip_archive&amp;c='.$current.'&amp;f='.$list[$i]['filename'].'">'.$lng['dl'].'</a></td><td> </td><td>'.strftime($date_format,$list[$i]['mtime']).'</td><td>'.($i+1).'</td></tr>';
}

return $link;
}
}

function list_tar_archive($current)
{
global $lng,$tar,$date_format;
require_once $tar;

$tar = &new Archive_Tar($current);

if(($list = $tar->listContent())==0)
{return '<div class="red">'.$lng['archive_error'].'<br/></div>';}
else
{
$s = sizeof($list);

for($i=0; $i<$s; $i++)
{
if($list[$i]['typeflag'])
{
$type = 'DIR';
$name = $list[$i]['filename'];
$size = ' ';
}
else
{
$type = strtoupper(strrchr($list[$i]['filename'],'.'));
$name = '<a href="?c='.$current.'&amp;f='.$list[$i]['filename'].'">'.str_link($list[$i]['filename']).'</a>';
$size = file_size($list[$i]['size']);
}
$link.= '<tr class="border"><td><input name="check[]" type="checkbox" value="'.$list[$i]['filename'].'"/></td><td>'.$name.'</td><td><a href="change.php?get='.$current.'&amp;f='.$list[$i]['filename'].'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.$size.'</td><td> </td><td><a href="change.php?go=del_tar_archive&amp;c='.$current.'&amp;f='.$list[$i]['filename'].'">'.$lng['dl'].'</a></td><td> </td><td>'.strftime($date_format,$list[$i]['mtime']).'</td><td>'.($i+1).'</td></tr>';
}

return $link;
}
}

function edit_zip_file($current,$f)
{
global $pclzip;
require_once $pclzip;

$zip = &new PclZip($current);
$ext = $zip->extract(PCLZIP_OPT_BY_NAME, $f, PCLZIP_OPT_EXTRACT_AS_STRING);

if(!$ext){
return array(
'text'=>$lng['archive_error'],
'size'=>0,
'lines'=>0
);
}
else{
return array(
'text'=>trim($ext[0]['content']),
'size'=>file_size($ext[0]['size']),
'lines'=>sizeof(explode("\n",$ext[0]['content']))
);
}
}


function edit_zip_file_ok($current,$f,$text)
{
global $pclzip,$lng;
require_once $pclzip;

define('PCLZIP_TMP_NAME',$f);
$tmp = PCLZIP_TEMPORARY_DIR.'/tmp_gmanager.dat';

$fp = fopen($tmp,'w');
fputs($fp, $text);
fclose($fp);

$zip = &new PclZip($current);

$zip->delete(PCLZIP_OPT_BY_NAME, $f);

function cb($p_event, &$p_header){
$p_header['stored_filename'] = PCLZIP_TMP_NAME;
return 1;
}

$fl = $zip->add($tmp,PCLZIP_CB_PRE_ADD, 'cb');
unlink($tmp);

if($fl){
return '<div class="red">'.$lng['fputs_file_true'].'<br/></div>';
}
else{
return '<div class="red">'.$lng['fputs_file_false'].'<br/></div>';
}
}


function look_zip_file($current,$f)
{
global $lng,$pclzip,$date_format;
require_once $pclzip;

$zip = &new PclZip($current);
$ext = $zip->extract(PCLZIP_OPT_BY_NAME, $f, PCLZIP_OPT_EXTRACT_AS_STRING);

if(!$ext)
{return '<div class="red">'.$lng['archive_error'].'<br/></div>';}
else
{return '<div class="red">'.$lng['archive_size'].': '.file_size($ext[0]['compressed_size']).'<br/>'.$lng['real_size'].': '.file_size($ext[0]['size']).'<br/>'.$lng['archive_date'].': '.strftime($date_format,$ext[0]['mtime']).'<br/>&#187;<a href="edit.php?c='.$current.'&amp;f='.$f.'">'.$lng['edit'].'</a><br/></div>'.archive_fl(trim($ext[0]['content']));}
}

function look_tar_file($current,$f)
{
global $lng,$tar,$date_format;
require_once $tar;

$tar = &new Archive_Tar($current);
$ext = $tar->extractInString($f);

if(!$ext)
{return '<div class="red">'.$lng['archive_error'].'<br/></div>';}
else
{
$list = $tar->listContent();
$s = sizeof($list);

for($i=0; $i<$s; $i++)
{
if($list[$i]['filename'] != $f)
{continue;}
else
{return '<div class="red">'.$lng['real_size'].': '.file_size($list[$i]['size']).'<br/>'.$lng['archive_date'].': '.strftime($date_format,$list[$i]['mtime']).'<br/></div>'.archive_fl(trim($ext));}
}
}
}

function extract_zip_archive($current,$name,$chmod)
{
global $lng,$pclzip;
require_once $pclzip;

rechmod(dirname($name),0777);

$zip = &new PclZip($current);
$zip->extract(PCLZIP_OPT_PATH, $name);

if(is_dir($name))
{
if($chmod){rechmod($name,$chmod);}
return '<div class="red">'.$lng['extract_true'].'<br/></div>';
}
else
{return '<div class="red">'.$lng['extract_false'].'<br/></div>';}
}

function extract_tar_archive($current,$name,$chmod)
{
global $lng,$tar;
require_once $tar;

rechmod(dirname($name),0777);

$tar = &new Archive_Tar($current);
$tar->extract($name);

if(is_dir($name))
{
if($chmod){rechmod($name,$chmod);}
return '<div class="red">'.$lng['extract_true'].'<br/></div>';
}
else
{return '<div class="red">'.$lng['extract_false'].'<br/></div>';}
}

function extract_zip_file($current,$name,$chmod,$ext)
{
global $lng,$pclzip;
require_once $pclzip;

$zip = &new PclZip($current);
$zip->extract(PCLZIP_OPT_PATH, $name, PCLZIP_OPT_BY_NAME, $ext);

if(is_dir($name))
{
if($chmod){rechmod($name,$chmod);}
return '<div class="red">'.$lng['extract_file_true'].'<br/></div>';
}
else
{return '<div class="red">'.$lng['extract_file_false'].'<br/></div>';}
}

function extract_tar_file($current,$name,$chmod,$ext)
{
global $lng,$tar;
require_once $tar;

$tar = &new Archive_Tar($current);
mkdir($name,0777);
chmod($name,0777);

for($i=0; $i<=sizeof($ext); ++$i)
{
$folder = explode('/',$name.'/'.$ext[$i]);
$s2 = sizeof($folder)-1;
$folder2 = null;
for($i2=0; $i2<$s2; ++$i2)
{
$folder2.= $folder[$i2].'/';
mkdir($folder2,0777);
chmod($folder2,0777);
}

$fp = fopen($name.'/'.$ext[$i],'wb');
fputs($fp,$tar->extractInString($ext[$i]));
fclose($fp);
}

if(is_dir($name))
{
if($chmod){rechmod($name,$chmod);}
return '<div class="red">'.$lng['extract_file_true'].'<br/></div>';
}
else
{return '<div class="red">'.$lng['extract_file_false'].'<br/></div>';}
}

function del_zip_archive($current,$f)
{
global $lng,$pclzip;
require_once $pclzip;

$zip = &new PclZip($current);
$list = $zip->delete(PCLZIP_OPT_BY_NAME, $f);

if(!$list)
{return '<div class="red">'.$lng['del_file_false'].'<br/></div>';}
else
{return '<div class="red">'.$lng['del_file_true'].'<br/></div>';}
}

function del_tar_archive($current,$f)
{
global $lng,$tar;
require_once $tar;

$tar = &new Archive_Tar($current);

$list = $tar->listContent();

$new_tar = $new_tar_string = array();
$s = sizeof($list);
for($i=0; $i<$s; $i++)
{
if($list[$i]['filename'] == $f)
{continue;}
else
{
$new_tar_string[].= $tar->extractInString($list[$i]['filename']);
$new_tar[].= $list[$i]['filename'];
}
}

$fp = fopen($current,'wb');
fclose($fp);

$s2 = sizeof($new_tar);
for($i=0; $i<$s2; $i++)
{
if($new_tar[$i][iconv_strlen($new_tar[$i])-1] == '/')
{$tar->addModify('.',iconv_substr($new_tar[$i], 0, -1));}
else
{$tar->addString($new_tar[$i],$new_tar_string[$i]);}
}

if(in_array($f,$tar->listContent()))
{return '<div class="red">'.$lng['del_file_false'].'<br/></div>';}
else
{return '<div class="red">'.$lng['del_file_true'].'<br/></div>';}
}

function add_archive($c)
{
global $lng;
$current = dirname($c).'/';

print '<form action="change.php?c='.$current.'&amp;go=1" method="post">
<div class="telo">
<table>
<tr>
<th>'.$lng['ch_index'].'</th>
<th>'.$lng['name'].'</th>
<th>'.$lng['type'].'</th>
<th>'.$lng['size'].'</th>
<th>'.$lng['change'].'</th>
<th>'.$lng['del'].'</th>
<th>'.$lng['chmod'].'</th>
<th>'.$lng['date'].'</th>
<th>'.$lng['n'].'</th>
</tr>';

print look($current);

print '</table><div class="ch"><input type="submit" name="add_archive" value="'.$lng['add_archive'].'"/></div></div></form>
<div class="rb">'.$lng['create'].' <a href="change.php?go=create_file&amp;c='.$current.'">'.$lng['file'].'</a> / <a href="change.php?go=create_dir&amp;c='.$current.'">'.$lng['dir'].'</a><br/></div>
<div class="rb"><a href="change.php?go=upload&amp;c='.$current.'">'.$lng['upload'].'</a><br/></div>
<div class="rb"><a href="change.php?go=mod&amp;c='.$current.'">'.$lng['mod'].'</a><br/></div>';
return;
}

function add_zip_archive($add_archive,$ext,$dir)
{
global $lng,$pclzip;
require_once $pclzip;

$zip = &new PclZip($add_archive);
$add = $zip->add($ext,PCLZIP_OPT_ADD_PATH,$dir,PCLZIP_OPT_REMOVE_ALL_PATH);

if(!$add)
{return '<div class="red">'.$lng['add_archive_false'].'<br/></div>';}
else
{return '<div class="red">'.$lng['add_archive_true'].'<br/></div>';}
}

function add_tar_archive($add_archive,$ext,$dir)
{
global $lng,$tar;
require_once $tar;

$tar = &new Archive_Tar($add_archive);

foreach($ext as $v){
$path = pathinfo($v);
$add = $tar->addModify($v,$dir,$path['dirname']);
}

if(!$add)
{return '<div class="red">'.$lng['add_archive_false'].'<br/></div>';}
else
{return '<div class="red">'.$lng['add_archive_true'].'<br/></div>';}
}

function create_zip_archive($name,$chmod,$ext)
{
global $lng,$pclzip,$current;
require_once $pclzip;

define('CUR',str_replace('//','/','/'.strstr($current,'/')));

$zip = &new PclZip($name);
function cb($p_event, &$p_header){
$test = explode(CUR,$p_header['filename']);
$p_header['stored_filename'] = $test[1];
return 1;
}
$zip->create($ext, PCLZIP_CB_PRE_ADD, 'cb');

if(file_exists($name))
{
if($chmod){rechmod($name,$chmod);}
return '<div class="red">'.$lng['create_archive_true'].'<br/></div>';
}
else
{return '<div class="red">'.$lng['create_archive_false'].'<br/></div>';}
}

function gz($c)
{
global $lng,$date_format;

$ext = implode('',gzfile($c));
$gz = explode(chr(0),file_get_contents($c));

if(!$ext)
{return '<div class="red">'.$lng['archive_error'].'<br/></div>';}
else
{return '<div class="red">'.$lng['name'].': '.$gz[1].'<br/>'.$lng['archive_size'].': '.file_size($c).'<br/>'.$lng['real_size'].': '.file_size(strlen($ext)).'<br/>'.$lng['archive_date'].': '.strftime($date_format,filemtime($c)).'<br/></div>'.archive_fl(trim($ext));}
}

function gz_extract($c,$name,$chmod)
{
global $lng;

mkdir($name, 0777);
chmod($name, 0777);

$gz = explode(chr(0),file_get_contents($c));

$f = fopen($name.'/'.$gz[1],'wb');
$z = gzopen($c,'r');
fputs($f,gzread($z, sprintf('%u', filesize($c))*5));
gzclose($z);
fclose($f);

if(is_file($name.'/'.$gz[1]))
{
if($chmod){rechmod($name,$chmod);}
return '<div class="red">'.$lng['extract_file_true'].'<br/></div>';
}
else
{return '<div class="red">'.$lng['extract_file_false'].'<br/></div>';}
}

function archive_fl($fl)
{
if(substr_count($fl,"\r") > 2)
{$arr = split("\r",xhtml_highlight(str_replace("\n",NULL,$fl)));}
else
{$arr = split('<br />',xhtml_highlight($fl));}

foreach($arr as $i => $val)
{$page.= '<span class="true_code">'.($i+1).'</span> '.$val.'<br/>';}

return '<div class="code">'.$page.'</div>';
}


function get_archive_file($archive, $f){
global $pclzip, $tar;

switch(strtolower(strrchr($archive,'.'))){
case '.zip':
case '.jar':
require_once $pclzip;
$zip = &new PclZip($archive);
$ext = $zip->extract(PCLZIP_OPT_BY_NAME, $f, PCLZIP_OPT_EXTRACT_AS_STRING);
return $ext[0]['content'];
break;

case '.tgz':
case '.tar':
case '.bz':
case '.bz2':
require_once $tar;
$tar = &new Archive_Tar($archive);
return $tar->extractInString($f);
break;
}
return;
}


function upload_files($tmp,$name,$dir,$chmod)
{
global $lng;

if(iconv_substr($dir,-1) != '/')
{
$name = basename($dir);
$dir = dirname($dir).'/';
}

if(move_uploaded_file($tmp,$dir.$name))
{
if($chmod){rechmod($dir.$name,$chmod);}
return '<div class="red">'.$lng['upload_true'].'</div>';
}
else
{return '<div class="red">'.$lng['upload_false'].'</div>';}
}

function upload_url($url,$name,$chmod,$headers)
{
global $lng;
$tmp = array();
$url = trim($url);

if(substr_count($url,"\n")){
	$explode = explode("\n",$url);
		foreach($explode as $v){
			$v = trim($v);
			$tmp[] = array($v,$name.basename($v));
		}
	}
else{
	if(iconv_substr($name,-1) != '/'){
		$name = dirname($name).'/'.basename($name);
	}
	else{
		$name = $name.basename($url);
	}
$tmp[] = array($url,$name);

}

ini_set('user_agent',str_replace('User-Agent: ', '', $headers));

$out = '<div class="red">';
foreach($tmp as $v){
if(copy($v[0], $v[1]) && rechmod($v[1], $chmod)){
$out.= $lng['upload_true'].' ('.$v[0].' &gt; '.$v[1].')<br/>';
}
else{
$out.= $lng['upload_false'].' ('.$v[0].' x '.$v[1].')<br/>';
}
}
$out.= '</div>';

return $out;
}

function send_mail($theme,$mess,$to,$from)
{
global $lng;
if(@mail($to, '=?utf-8?B?'.base64_encode($theme).'?=', $mess, "From: $from\r\nContent-type: text/plain; charset=utf-8;\r\nX-Mailer: Gmanager;\r\nX-Priority: 3"))
{return '<div class="red">'.$lng['send_mail_true'].'<br/></div>';}
else
{return '<div class="red">'.$lng['send_mail_false'].'<br/></div>';}
}

function show_eval($eval){
global $lng;
if(ob_start()){
eval($eval);
$ret = ob_get_contents();
ob_clean();

$rows = sizeof(explode("\n",$ret))+1;
if($rows < 3){$rows = 3;}
return $tmp.'<div class="input">'.$lng['result'].'<br/><textarea cols="48" rows="'.$rows.'">'.htmlspecialchars($ret).'</textarea></div>';
}
else{
print '<pre class="code"><code>';
eval($eval);
print '</code></pre>';
return;
}
}

function replace($current,$from,$to,$regexp)
{
global $lng;
if(!$from)
{return '<div class="red">'.$lng['replace_false_str'].'<br/></div>';}
$c = file_get_contents($current);

if($regexp)
{
preg_match_all('/'.str_replace('/','\/',$from).'/',$c,$all);
$all = sizeof($all[0]);
if(!$all)
{return '<div class="red">'.$lng['replace_false_str'].'<br/></div>';}
$str = preg_replace('/'.str_replace('/','\/',$from).'/',$to,$c);
if($str)
{
$f = fopen($current,'wb');
$str = fputs($f,$str);
fclose($f);
}
else
{return '<div class="red">'.$lng['regexp_error'].'<br/></div>';}
}
else
{
$all = substr_count($c,$from);
if(!$all)
{return '<div class="red">'.$lng['replace_false_str'].'<br/></div>';}
$f = fopen($current,'wb');
$str = fputs($f,str_replace($from,$to,$c));
fclose($f);
}

if($str)
{return '<div class="red">'.$lng['replace_true'].$all.'<br/></div>';}
else
{return '<div class="red">'.$lng['replace_false_file'].'<br/></div>';}
}

function zip_replace($current,$f,$from,$to,$regexp)
{
global $lng,$pclzip;
if(!$from)
{return '<div class="red">'.$lng['replace_false_str'].'<br/></div>';}

$c = edit_zip_file($current,$f);
$c = $c['text'];

if($regexp)
{
preg_match_all('/'.str_replace('/','\/',$from).'/',$c,$all);
$all = sizeof($all[0]);
if(!$all)
{return '<div class="red">'.$lng['replace_false_str'].'<br/></div>';}
$str = preg_replace('/'.str_replace('/','\/',$from).'/',$to,$c);
if($str){
return edit_zip_file_ok($current,$f,$str);
}
else{
return '<div class="red">'.$lng['regexp_error'].'<br/></div>';
}
}
else{
$all = substr_count($c,$from);
if(!$all){
return '<div class="red">'.$lng['replace_false_str'].'<br/></div>';
}

return edit_zip_file_ok($current,$f,str_replace($from,$to,$c));
}
}


function search($c, $s, $w, $r)
{
global $lng,$date_format,$edit_format,$target;

if($target)
{$target=' target="_blank"';}
else
{$target='';}

$c = str_replace('//','/',$c.'/');

$i = 0;
$in = null;
$page = array();
$dir = opendir($c);
while($f = readdir($dir))
{
if($f=='.' || $f=='..')
{continue;}
if(is_dir($c.$f))
{search($c.$f.'/',$s,$w,$r);}


$type = strtoupper(strrchr($f,'.'));

if($r){
$s = strtolower($s);
}

if(!$w){
if(iconv_strpos($f,$s)===false)
{continue;}
}
else{

if($type == '.GZ'){
$gz = gzopen($c.$f,'r');
$fl = gzread($gz,sprintf('%u', filesize($c.$f))*5);
gzclose($gz);
}
else{
$fl = file_get_contents($c.$f);
}

if($r){
$fl = strtolower($fl);
}

if(!$in = substr_count($fl,$s))
{continue;}
$in = ' ('.$in.')';
}


$i++;
$time = filemtime($c.$f);
$name = str_link($c.$f);

if(preg_match('/^('.$edit_format.')+$/i', $type)){
$page[$f].= '<tr class="ch"><td><input name="check[]" type="checkbox" value="'.$c.$f.'"/></td><td><a href="edit.php?'.$c.$f.'"'.$target.'>'.$name.'</a>'.$in.'</td><td><a href="change.php?get='.$c.$f.'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.file_size($c.$f).'</td><td><a href="change.php?'.$c.$f.'">'.$lng['ch'].'</a></td><td><a href="change.php?go=del&amp;c='.$c.$f.'">'.$lng['dl'].'</a></td><td><a href="change.php?go=chmod&amp;c='.$c.$f.'">'.look_chmod($c.$f).'</a></td><td>'.strftime($date_format, $time).'</td><td>'.$i.'</td></tr>';
}
elseif($type=='.ZIP' || $type=='.JAR' || $type=='.GZ' || $type=='.TAR' || $type=='.TGZ' || $type=='.BZ' || $type=='.BZ2'){
$page[$f].= '<tr class="ch"><td><input name="check[]" type="checkbox" value="'.$c.$f.'"/></td><td><a href="index.php?'.$c.$f.'">'.$name.'</a>'.$in.'</td><td><a href="change.php?get='.$c.$f.'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.file_size($c.$f).'</td><td><a href="change.php?'.$c.$f.'">'.$lng['ch'].'</a></td><td><a href="change.php?go=del&amp;c='.$c.$f.'">'.$lng['dl'].'</a></td><td><a href="change.php?go=chmod&amp;c='.$c.$f.'">'.look_chmod($c.$f).'</a></td><td>'.strftime($date_format, $time).'</td><td>'.$i.'</td></tr>';
}
else{
$page[$f].= '<tr class="ch"><td><input name="check[]" type="checkbox" value="'.$c.$f.'"/></td><td><a href="'.$c.$f.'">'.$name.'</a>'.$in.'</td><td><a href="change.php?get='.$c.$f.'">'.$lng['get'].'</a></td><td>'.$type.'</td><td>'.file_size($c.$f).'</td><td><a href="change.php?'.$c.$f.'">'.$lng['ch'].'</a></td><td><a href="change.php?go=del&amp;c='.$c.$f.'">'.$lng['dl'].'</a></td><td><a href="change.php?go=chmod&amp;c='.$c.$f.'">'.look_chmod($c.$f).'</a></td><td>'.strftime($date_format, $time).'</td><td>'.$i.'</td></tr>';
}
}
closedir($dir);

ksort($page,$sort);

foreach($page as $f){
echo $f;
}

return;
}

function fname($f,$name,$register,$i)
{
global $date_format;
// [n] - meter
// [f] - type
// [name] - name
// [date] - date

$info = pathinfo($f);
$name = str_replace('[n]',$i,$name);
$name = str_replace('[f]',$info['extension'],$name);
$name = str_replace('[name]',$info['filename'],$name);
$name = str_replace('[date]',strftime('%d_%m_%Y', time()),$name);

if($register == 1){
$name = strtolower($name);
}
elseif($register == 2){
$name = strtoupper($name);
}

if(rename($f,$info['dirname'].'/'.$name)){
return $info['basename'].' - '.$name.' Ok<br/>';
}
else{
return $info['basename'].' - '.$name.' Error<br/>';
}
}


function sql_parser($sql){
$arr = explode("\n",$sql);
$size = sizeof($arr);

for($i=0; $i<=$size; ++$i){
if(trim($arr[$i]) && $arr[$i][0].$arr[$i][1] != '--'){
$str.=$arr[$i];
}
}

$str = preg_replace('/;[\s+](SELECT|CREATE|DROP|UPDATE|INSERT|SHOW|REPLACE|REVOKE|MATCH|LIKE|GRANT|DESCRIBE|OPTIMIZE|COUNT|ALTER|AGAINST|SET|TRUNCATE|REFERENCES|INDEX|LOCK|EXECUTE)\s+/i',";\n$1 ",$str);
return preg_split('/;[\t\r\n]+/i', $str);
}


function sql_installer($host,$name,$pass,$db,$charset,$sql){
global $lng;

if(!$sql ){
return;
}

if(!$query = sql_parser($sql)){
return;
}

$php = '<?php
// SQL Installer
// Created in Gmanager 0.6.1
// http://wapinet.ru/gmanager/

error_reporting(0);

if(substr_count($_SERVER[\'HTTP_USER_AGENT\'], \'MSIE\')){
	header(\'Content-type: text/html; charset=UTF-8\');
}
else{
	header(\'Content-type: application/xhtml+xml; charset=UTF-8\');
}

echo \'<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru">
<head>
<title>SQL Installer</title>
<style type="text/css">
body{background-color:#ccc;color:#000;}
</style>
</head>
<body>
<div>\';


if(!$_POST){
echo \'<form action="\'.$_SERVER[\'PHP_SELF\'].\'" method="post">
<div>
'.$lng['mysql_user'].'<br/>
<input type="text" name="name" value="'.$name.'"/><br/>
'.$lng['mysql_pass'].'<br/>
<input type="text" name="pass" value="'.$pass.'"/><br/>
'.$lng['mysql_host'].'<br/>
<input type="text" name="host" value="'.$host.'"/><br/>
'.$lng['mysql_db'].'<br/>
<input type="text" name="db" value="'.$db.'"/><br/>
<input type="submit" value="'.$lng['install'].'"/>
</div>
</form>
</div></body></html>\';
exit;
}

mysql_connect($_POST[\'host\'], $_POST[\'name\'], $_POST[\'pass\']) or die (\'<html><body>Can not connect to MySQL</body></html>\');
mysql_select_db($_POST[\'db\']) or die (\'<html><body>Error select the database</body></html>\');
mysql_query(\'SET NAMES `'.preg_replace('/utf-8/i','utf8',$charset).'`\');'."\n\n";

foreach($query as $q){
$php.= '$sql = "'.str_replace('"','\"',$q).';";
mysql_query($sql);
if($err = mysql_error()){
	$error[] = $err."\n SQL:\n".$sql;
}'."\n\n";
}

$php.= 'if($error){
	echo \'Error:<pre>\'.htmlspecialchars(print_r($error, 1)).\'</pre>\';
}else{
	echo \'Ok\';
}

echo \'</div></body></html>\'
?>';

return $php;
}



function sql($name,$pass,$host,$db,$data,$charset)
{
global $lng;
if(!mysql_connect($host, $name, $pass)){return $lng['mysq_connect_false'];}
if($charset)
{mysql_query('SET NAMES `'.preg_replace('/utf-8/i','utf8',$charset).'`');}
if($db){
if(!mysql_select_db($db)){return $lng['mysq_select_db_false'];}
}

$query = sql_parser($data);

$i=0;
$out = '';
foreach($query as $q)
{
$result = array();
$str = '';

if(!$q = mysql_query($q.';')){
return $lng['mysq_query_false'].'<br/><code>'.mysql_error().'</code>';
}
else{
while($arr = mysql_fetch_assoc($q)){
if($arr && $arr!==true){
$result[] = $arr;
}
}
}
$i++;

$str.= '<tr>';
foreach($result[0] as $k => $value){
$str.= '<th>'.htmlspecialchars($k).'</th>';
}
$str.= '</tr>';

foreach($result as $v){
$str.= '<tr class="border">';
foreach($v as $k => $value){
$str.= '<td><a href="javascript:paste(\''.addslashes(htmlspecialchars($value)).'\');">'.htmlspecialchars($value).'</a></td>';
}
$str.= '</tr>';
}

if($str != '<tr></tr>'){
$out.= '<br/><table class="telo">'.$str.'</table>';
}
else{
$out.= '';
}
}

mysql_close();
return $lng['mysql_true'].$i.$out;
}


function go($pg,$all,$text){
global $limit, $_SERVER;

$page1 = $pg - 2;
$page2 = $pg - 1;
$page3 = $pg + 1;
$page4 = $pg + 2;

if($page1 > 0)
{$go.= '<a href="'.$_SERVER['PHP_SELF'].'?pg='.$page1.$text.'">'.$page1.'</a> ';}

if($page2 > 0)
{$go.= '<a href="'.$_SERVER['PHP_SELF'].'?pg='.$page2.$text.'">'.$page2.'</a> ';}

$go.= $pg.' ';

if($page3 <= $all)
{$go.= '<a href="'.$_SERVER['PHP_SELF'].'?pg='.$page3.$text.'">'.$page3.'</a> ';}
if($page4 <= $all)
{$go.= '<a href="'.$_SERVER['PHP_SELF'].'?pg='.$page4.$text.'">'.$page4.'</a> ';}

if($all > 3 && $all > $page4)
{$go.= '... <a href="'.$_SERVER['PHP_SELF'].'?pg='.$all.$text.'">'.$all.'</a>';}

if($page1 > 1)
{$go = '<a href="'.$_SERVER['PHP_SELF'].'?pg=1'.$text.'">1</a> ... '.$go;}

if($go == $pg.' ')
{return;}
else
{return '<tr><td class="border" colspan="9">&#160;'.$go.'</td></tr>';}
}


function str_link($str){
global $link;

$tmp['strlen'] = iconv_strlen($str);
$tmp['tmp'] = intval($link/2);
$tmp['start'] = $tmp['tmp']+2;

if($tmp['strlen']>$link){
return iconv_substr($str, 0, $tmp['start']).' ... '.iconv_substr($str, ($tmp['strlen']-$tmp['start']));
}

return $str;
}




// Содержимое файла, имя файла, аттач (опционально), MIME (опционально)
function getf($f, $name, $attach, $mime){
ob_implicit_flush(1);
set_time_limit(999);

ini_set('zlib.output_compression', 0);
ini_set('output_handler', '');

//iconv_set_encoding('internal_encoding', 'windows-1251');

// Длина файла
$sz = $len = strlen($f);

$out = $f;

// "От" и  "До" по умолчанию
$file_range = array('from' => 0, 'to' => $len);

// Если докачка
if($_SERVER['HTTP_RANGE'])
{
if(preg_match('/bytes=(\d+)-(\d*)/i', $_SERVER['HTTP_RANGE'], $matches))
{
// "От", "До" если "До" нету, "До" равняется размеру файла
$file_range = array('from' => $matches[1], 'to' => (!$matches[2]) ? $len : $matches[2]);
// Режем переменную в соответствии с данными
if($file_range){
$out = substr($out, $file_range['from'], $file_range['to']);
$sz = $file_range['to']-$file_range['from'];
}
}
}


// Заголовки...
if($file_range['from'])
{header('HTTP/1.0 206 Partial Content');}
else
{header('HTTP/1.0 200 OK');}

// Ставим MIME в зависимости от расширения
if(!$mime)
{
$info = pathinfo($name);

switch(strtolower($info['extension']))
{
default:
$mime = 'application/octet-stream';
break;

case 'jar':
$mime = 'application/java-archive';
break;

case 'jad':
$mime = 'text/vnd.sun.j2me.app-descriptor';
break;

case 'cab':
$mime = 'application/vnd.ms-cab-compressed';
break;

case 'sis':
$mime = 'application/vnd.symbian.install';
break;

case 'zip':
$mime = 'application/x-zip';
break;

case 'rar':
$mime = 'application/x-rar-compressed';
break;

case '7z':
$mime = 'application/x-7z-compressed';
break;

case 'gz':
case 'tgz':
$mime = 'application/x-gzip';
break;

case 'bz':
case 'bz2':
$mime = 'application/x-bzip';
break;

case 'jpg':
case 'jpe':
case 'jpeg':
$mime = 'image/jpeg';
break;

case 'gif':
$mime = 'image/gif';
break;

case 'png':
$mime = 'image/png';
break;

case 'txt':
case 'dat':
case 'php':
case 'php5':
case 'htm':
case 'html':
case 'wml':
case 'css':
case 'js':
$mime = 'text/plain';
break;

case 'mmf':
$mime = 'application/x-smaf';
break;

case 'mid':
$mime = 'audio/mid';
break;

case 'mp3':
$mime = 'audio/mpeg';
break;

case 'amr':
$mime = 'audio/amr';
break;

case 'wav':
$mime = 'audio/x-wav';
break;

case 'mp4':
$mime = 'video/mp4';
break;

case 'wmv':
$mime = 'video/x-ms-wmv';
break;

case '3gp':
$mime = 'video/3gpp';
break;

case 'avi':
$mime = 'video/x-msvideo';
break;

case 'mpg':
case 'mpe':
case 'mpeg':
$mime = 'video/mpeg';
break;

case 'pdf':
$mime = 'application/pdf';
break;
}
}


//header('Date: '.gmdate('r', time()));
//header('Content-Transfer-Encoding: binary');
//header('Last-Modified: '.gmdate('r', 1234));

// Кэш
header('Cache-Control: public, must-revalidate, max-age=0');
header('Pragma: cache');

// Хэш
$etag = md5($f);
$etag = substr($etag, 0, 4).'-'.substr($etag, 5, 5).'-'.substr($etag, 10, 8);
header('ETag: "'.$etag.'"');



//header('Connection: close');
header('Keep-Alive: timeout=15, max=50');
header('Connection: Keep-Alive');

header('Accept-Ranges: bytes');
header('Content-Length: '.$sz);


// Если докачка
if($_SERVER['HTTP_RANGE']){
header('Content-Range: bytes '.$file_range['from'].'-'.$file_range['to'].'/'.$len);
}


// Если отдаем как аттач
if($attach){
header('Content-Type: '.$mime);
header('Content-Disposition: attachment; filename="'.$name.'"');
}
elseif($mime == 'text/plain'){
header('Content-Type: text/plain; charset='.$charset);
}
else{
header('Content-Type: '.$mime);
}

exit($out);
return;
}
?>