<?php

function show_user($user = array (), $status = 0, $ip = 0, $str = '', $text = '', $sub = '') {
    ////////////////////////////////////////////////////////////
    // Отображение пользователей                              //
    ////////////////////////////////////////////////////////////
    // $user (array)     - массив запроса в таблицу `users`   //
    // $status (boolean) - показать статус                    //
    // $ip (int)         - отображение IP и UserAgent         //
    //                     0 - не показывать                  //
    //                     1 - показать                       //
    //                     2 - показать ссылку на IP поиск    //
    // $str (string)     - строка выводится после Ника юзера  //
    // $text (string)    - выводится после строки со статусом //
    // $sub (string)     - строка выводится в области "sub"   //
    ////////////////////////////////////////////////////////////
    global $set_user, $realtime, $user_id, $admp, $home;
    $out = false;
    if (!$user['id']) {
        $out = '<b>Гость</b>';
        if (!empty($user['name']))
            $out .= ': ' . $user['name'];
        if (!empty($str))
            $out .= ' ' . $str;
    } else {
        if ($set_user['avatar']) {
            $out .= '<table cellpadding="0" cellspacing="0"><tr><td>';
            if (file_exists(('../files/avatar/' . $user['id'] . '.png')))
                $out .= '<img src="../files/avatar/' . $user['id'] . '.png" width="32" height="32" alt="' . $user['name'] . '" />&nbsp;';
            else
                $out .= '<img src="../images/empty.png" width="32" height="32" alt="' . $user['name'] . '" />&nbsp;';
            $out .= '</td><td>';
        }
        if ($user['sex'])
            $out .= '<img src="../theme/' . $set_user['skin'] . '/images/' . ($user['sex'] == 'm' ? 'm' : 'w') . ($user['datereg'] > $realtime - 86400 ? '_new' : '') . '.png" width="16" height="16" align="middle" />&nbsp;';
        else
            $out .= '<img src="../images/del.png" width="12" height="12" align="middle" />&nbsp;';
        $rights = array (
            0 => '',
            1 => '',
            2 => '',
            3 => '',
            4 => '',
            5 => '',
            6 => '',
            7 => 'green',
            9 => 'red'
        );
        $out .='<span class="color: '.$rights[$user['rights']].'">';
        $out .= !$user_id || $user_id == $user['id'] ? '<b>' . $user['name'] . '</b></span>' : '<a href="../str/anketa.php?id=' . $user['id'] . '"><b>' . $user['name'] . '</b></a></span>';
        $rights = array (
            0 => '',
            1 => '(GMod)',
            2 => '(CMod)',
            3 => '(FMod)',
            4 => '(DMod)',
            5 => '(LMod)',
            6 => '(Smd)',
            7 => '(Adm)',
            9 => '(SV!)'
        );
        $out .= ' ' . $rights[$user['rights']];
        $out .= ($realtime > $user['lastdate'] + 300 ? '<span class="red"> [Off]</span>' : '<span class="green"> [ON]</span>');
        if (!empty($str))
            $out .= ' ' . $str;
        if ($status && !empty($user['status']))
            $out .= '<div class="status"><img src="../theme/' . $set_user['skin'] . '/images/label.png" alt="" align="middle" />&nbsp;' . $user['status'] . '</div>';
        if ($set_user['avatar'])
            $out .= '</td></tr></table>';
    }
    if ($text)
        $out .= '<div>' . $text . '</div>';
    if ($sub || $ip) {
        $out .= '<div class="sub">';
        if (!empty($sub))
            $out .= $sub;
        if ($ip) {
            $out .= '<div class="gray"><u>UserAgent</u>:&nbsp;' . $user['browser'] . '<br />';
            if ($ip == 2)
                $out .= '<u>IP Address</u>:&nbsp;<a href="../' . $admp . '/index.php?act=usr_search_ip&amp;ip=' . $user['ip'] . '">' . long2ip($user['ip']) . '</a></div>';
            else
                $out .= '<u>IP Address</u>:&nbsp;' . long2ip($user['ip']) . '</div>';
        }
        $out .= '</div>';
    }
    return $out;
}

?>
