<?php
/*
 * Naijadev Clone 3.1.0 (http://naijadev.ml or http://naijadev.in)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Project
 * @email		Tunzxywalex@gmail.com
 * @Whatsapp	+2349076642400
 * @copyright   Copyright (C) Naijadev Community 2018
 * @license     Premium Version Licence
 */
define('_IN_JOHNCMS', 1);

if (!defined('AJAX')) {
    define('AJAX', isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) &&
        strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
}

require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);
$args = [
         'post' =>FILTER_VALIDATE_INT,
         'type' => [
                    'filter'    => FILTER_VALIDATE_INT,
                    'options'   => [
                            'max_range' => 1,
                            'min_range' => 0
                                ]
                   ]
         ];
$post = filter_input_array(AJAX ? INPUT_POST : INPUT_GET, $args);
file_put_contents('FORUM_AJAX_LOG.txt', '<pre>' . print_r($post, 1) . '</pre>' . PHP_EOL, FILE_APPEND | LOCK_EX);
if ($post['post'] && in_array($post['type'], [0, 1])) {
    $like = new Johncms\Forum\Voter($post['post']);
    if ($like->add($post['type'])) {
        if (AJAX) {
            echo $like->newVote($post['post']);
        } else {
            header('Location: ' . $_SERVER['HTTP_REFERER']);
        }
    }
} else {
    require('../system/head.php');
    echo $tools->displayError(_t('Empty blank'), '<a href="index.php">' . _t('Forum') . '</a>');
    require('../system/end.php');
}
