<?php
/*
 * AlphaCMS Bootstrap 1.5.4 Johncms 7.1.0 (http://socialbux.epizy.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @CMS          Johncms 7.1.0
 * @link         http://facebook.com   Emmanuel Oyewale
 * @email       Tunzxywalexdevmaster@gmail.com
 * @Whatsapp    +2349076642400
 * @copyright   Copyright (C) Socialbux Community 2018-2023
 * @license     Premium Version Licence
 */

define('_IN_JOHNCMS', 1);

require('../system/bootstrap.php');
$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';
$do = isset($_REQUEST['do']) ? trim($_REQUEST['do']) : false;
$page = isset($_REQUEST['page']) && $_REQUEST['page'] > 0 ? intval($_REQUEST['page']) : 1;
$start = isset($_REQUEST['page']) ? $page * $kmess - $kmess : (isset($_GET['start']) ? abs(intval($_GET['start'])) : 0);

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Counters $counters */
$counters = App::getContainer()->get('counters');

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

if (isset($_SESSION['ref'])) {
    unset($_SESSION['ref']);
}

// Настройки форума
$set_forum = $systemUser->isValid() ? unserialize($systemUser->set_forum) : [
    'farea'    => 0,
    'upfp'     => 0,
    'preview'  => 1,
    'postclip' => 1,
    'postcut'  => 2,
];

// Список расширений файлов, разрешенных к выгрузке

// Файлы архивов
$ext_arch = [
    'zip',
    'rar',
    '7z',
    'tar',
    'gz',
    'apk',
];
// Звуковые файлы
$ext_audio = [
    'mp3',
    'amr',
];
// Файлы документов и тексты
$ext_doc = [
    'txt',
    'pdf',
    'doc',
    'docx',
    'rtf',
    'djvu',
    'xls',
    'xlsx',
];
// Файлы Java
$ext_java = [
    'sis',
    'sisx',
    'apk',
];
// Файлы картинок
$ext_pic = [
    'jpg',
    'jpeg',
    'gif',
    'png',
    'bmp',
];
// Файлы SIS
$ext_sis = [
    'sis',
    'sisx',
];
// Файлы видео
$ext_video = [
    '3gp',
    'avi',
    'flv',
    'mpeg',
    'mp4',
];
// Файлы Windows
$ext_win = [
    'exe',
    'msi',
];
// Другие типы файлов (что не перечислены выше)
$ext_other = ['wmf'];

// Ограничиваем доступ к Форуму
$error = '';

if (!$config->mod_forum && $systemUser->rights < 7) {
    $error = _t('Forum is closed');
} elseif ($config->mod_forum == 1 && !$systemUser->isValid()) {
    $error = _t('For registered users only');
}

if ($error) {
    require('../system/head.php');
    echo '<div class="rmenu"><p>' . $error . '</p></div>';
    require('../system/end.php');
    exit;
}

$headmod = $id ? 'forum,' . $id : 'forum';

// Заголовки страниц форума
if (empty($id)) {
    $textl = _t('Forum');
} else {
    $res = $db->query("SELECT `text` FROM `forum` WHERE `id`= " . $id)->fetch();
    $hdr = preg_replace('#\[c\](.*?)\[/c\]#si', '', $res['text']);
    $hdr = strtr($hdr, [
        '&laquo;' => '',
        '&raquo;' => '',
        '&quot;'  => '',
        '&amp;'   => '',
        '&lt;'    => '',
        '&gt;'    => '',
        '&#039;'  => '',
    ]);
    $hdr = mb_substr($hdr, 0, 30);
    $hdr = $tools->checkout($hdr, 2, 2);
    $textl = empty($hdr) ? _t('Forum') : $hdr;
}

// Переключаем режимы работы
$mods = [
    'addfile',
    'import',
    'addvote',
    'close',
    'deltema',
    'delvote',
    'editpost',
    'editvote',
    'file',
    'files',
    'filter',
    'loadtem',
    'massdel',
    'new',
    'nt',
    'per',
    'post',
    'ren',
    'restore',
    'say',
    'tema',
    'users',
    'vip',
    'vote',
    'who',
    'curators',
    'tag',
    'subscribe',
];

if ($act && ($key = array_search($act, $mods)) !== false && file_exists('includes/' . $mods[$key] . '.php')) {
    require('includes/' . $mods[$key] . '.php');
} else {
//    require('../system/head.php');
   if ($agent_web == 'wap') {
    require('../system/headforum.php');
            }
   if ($agent_web == 'web') {
   require('../themes/default/head.php');
   }
//Top Online
$users = $db->query("SELECT COUNT(*) FROM `users` WHERE `lastdate` > '" . (time() - 300) . "'")->fetchColumn();
$guests = $db->query("SELECT COUNT(*) FROM `cms_sessions` WHERE `lastdate` > '" . (time() - 300) . "'")->fetchColumn();
$online = $_GET['online'];
echo'<div class="online">
<a href="' . $config['homeurl'] . '/users/index.php"><i style="font-size: 16px; vertical-align: middle" class="fa fa-user "></i> Online: <span>' . $users . '</span></a>
<a href="' . $config['homeurl'] . '/users/index.php?act=online&amp;mod=guest"><i style="font-size: 15px; vertical-align: middle" class="fa fa-user-secret "></i> Guests: <span>' . $guests . '</span></a>
</div><div class="search-main-optimize">
<form method="post" class="ajax-form2" action="' . $config['homeurl'] . '/users/search.php">
<input type="text" name="search" class="search-main" placeholder="Site search"> 
<button class="search-main-button ajax-button-search"><i style="font-size: 20px; vertical-align: middle" class="fa fa-search "></i></button>
</form>
</div>';

if (!empty($systemUser->ban)) {
    echo '<h2><div class="alarm">' . _t('Ban', 'system') . '&#160;<a href="' . $config['homeurl'] . '/profile/?act=ban">' . _t('Details', 'system') . '</a></div></h2>';
}




// Notofications after Header codes
if ($systemUser->id) {
    $list = [];
    $new_sys_mail = $db->query("SELECT COUNT(*) FROM `cms_mail` WHERE `from_id`='" . $systemUser->id . "' AND `read`='0' AND `sys`='1' AND `delete`!='" . $systemUser->id . "'")->fetchColumn();

    if ($new_sys_mail) {
        $list[] = '<a href="' . $config['homeurl'] . '/mail/index.php?act=systems">' . _t('System', 'system') . '</a> (+' . $new_sys_mail . ')';
    }

    $new_mail = $db->query("SELECT COUNT(*) FROM `cms_mail`
                            LEFT JOIN `cms_contact` ON `cms_mail`.`user_id`=`cms_contact`.`from_id` AND `cms_contact`.`user_id`='" . $systemUser->id . "'
                            WHERE `cms_mail`.`from_id`='" . $systemUser->id . "'
                            AND `cms_mail`.`sys`='0'
                            AND `cms_mail`.`read`='0'
                            AND `cms_mail`.`delete`!='" . $systemUser->id . "'
                            AND `cms_contact`.`ban`!='1'")->fetchColumn();

    if ($new_mail) {
        $list[] = '<a href="' . $config['homeurl'] . '/mail/index.php?act=new">' . _t('You have a new Mail', 'system') . '</a> (+' . $new_mail . ')';
    }

    if ($systemUser->comm_count > $systemUser->comm_old) {
        $list[] = '<br><a href="' . $config['homeurl'] . '/profile/?act=guestbook&amp;user=' . $systemUser->id . '"> You have ' . ($systemUser->comm_count - $systemUser->comm_old) . ' new Comments on your  Profile</a>';
    }

    $new_album_comm = $db->query('SELECT COUNT(*) FROM `cms_album_files` WHERE `user_id` = ' . $systemUser->id . ' AND `unread_comments` = 1')->fetchColumn();

    if ($new_album_comm) {
        $list[] = '<br><a href="' . $config['homeurl'] . '/album/index.php?act=top&amp;mod=my_new_comm">' . _t('Comments', 'system') . '</a>';
    }

   # @var notif forum
   if ($systemUser->notif_forum) {
       $list[] = '<br><a href="' . $config['homeurl'] . '/profile/notif.php">New Forum Notification</a>&#160;(' . $systemUser->notif_forum . ')';
   }

    if (!empty($list)) {
        echo '<div>' . _t('Unread', 'system') . ': ' . implode(', ', $list) . '</div>';
    }
}

if ($systemUser->isValid() && !$systemUser->premium) {
   echo '<br><div>Update your account with premium to have full access see <a href="'.$config['homeurl'].'/help/?act=premium">here</a></div>';
}
!$systemUser->id ?: include '../system/bonus.inc.php';
    

if ($user['dayb'] == date('j', time()) && $user['monthb'] == date('n', time())) {
        echo '<div class="gmenu">' . _t('We Greet you a Happy Birthday') . ' ' . $user['name'] . '!!!</div>';
}
// End Notifications Codes




    // Если форум закрыт, то для Админов выводим напоминание
    if (!$config->mod_forum) {
        echo '<div class="alarm"><div class="gmenu"><div class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
<i class="fa fa-info-circle"></i><strong>Forum is closed</strong></div></div>';
    } elseif ($config->mod_forum == 3) {
        echo '<div class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
<i class="fa fa-info-circle"></i><strong>Read only</strong></div></div>';
    }

    if (!$systemUser->isValid()) {
        if (isset($_GET['newup'])) {
            $_SESSION['uppost'] = 1;
        }

        if (isset($_GET['newdown'])) {
            $_SESSION['uppost'] = 0;
        }
    }

    if ($id) {
        // Определяем тип запроса (каталог, или тема)
        $type = $db->query("SELECT * FROM `forum` WHERE `id`= '$id'");

        if (!$type->rowCount()) {
            // Если темы не существует, показываем ошибку
            echo $tools->displayError(_t('<div class="gmenu"><div class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
<i class="fa fa-info-circle"></i><strong>Topic has been deleted or does not exists'), '<a href="index.php">' . _t('Forum') . '</a></strong></div></div>');
            require('../system/end.php');
            exit;
        }


        $type1 = $type->fetch();

        // Forum Sub Categories here
        if ($systemUser->isValid() && $type1['type'] == 't') {
            $req_r = $db->query("SELECT * FROM `cms_forum_rdm` WHERE `topic_id` = '$id' AND `user_id` = '" . $systemUser->id . "' LIMIT 1");

            if ($req_r->rowCount()) {
                $res_r = $req_r->fetch();

                if ($type1['time'] > $res_r['time']) {
                    $db->exec("UPDATE `cms_forum_rdm` SET `time` = '" . time() . "' WHERE `topic_id` = '$id' AND `user_id` = '" . $systemUser->id . "' LIMIT 1");
                }
            } else {
                $db->exec("INSERT INTO `cms_forum_rdm` SET `topic_id` = '$id', `user_id` = '" . $systemUser->id . "', `time` = '" . time() . "'");
            }
        }

        // Получаем структуру форума
        $res = true;
        $allow = 0;
        $parent = $type1['refid'];

        while ($parent != '0' && $res != false) {
            $res = $db->query("SELECT * FROM `forum` WHERE `id` = '$parent' LIMIT 1")->fetch();

            if ($res['type'] == 'f' || $res['type'] == 'r') {

                $tree[] = '<b><a href="index.php?id=' . $parent . '"><font color="red">' . $res['text'] . '</font></a></b>';

                if ($res['type'] == 'r' && !empty($res['edit'])) {
                    $allow = intval($res['edit']);
                }
            }
            $parent = $res['refid'];
        }

     
        $tree[] = '<div class="menu-nav-content"><a href="index.php" class="menu-nav"><b>' . _t('Forum') . '</b></a>';
        krsort($tree);

        if ($type1['type'] != 't' && $type1['type'] != 'm') {
            $tree[] = '<font color="blue"><b>' . $type1['text'] . '</b></font>';
        }

        // Счетчик файлов и ссылка на них
        $sql = ($systemUser->rights == 9) ? "" : " AND `del` != '1'";

        if ($type1['type'] == 'f') {
            $count = $db->query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `cat` = '$id'" . $sql)->fetchColumn();

            if ($count > 0) {
                $filelink = '<a href="index.php?act=files&amp;c=' . $id . '">' . _t('Category Files') . '</a>';
            }
        } elseif ($type1['type'] == 'r') {
            $count = $db->query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `subcat` = '$id'" . $sql)->fetchColumn();

            if ($count > 0) {
                $filelink = '<a href="index.php?act=files&amp;s=' . $id . '">' . _t('Section Files') . '</a>';
            }
        } elseif ($type1['type'] == 't') {
            $count = $db->query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `topic` = '$id'" . $sql)->fetchColumn();

            if ($count > 0) {
                $filelink = '<a href="index.php?act=files&amp;t=' . $id . '">' . _t('Topic Files') . '</a>';
            }
        }

        $filelink = isset($filelink) ? $filelink . '&#160;<span>(' . $count . ')</span>' : false;

        // Счетчик "Кто в теме?"
        $wholink = false;

       if ($systemUser->isValid() && $type1['type'] == 't') {
            $online_u = $db->query("SELECT COUNT(*) FROM `users` WHERE `lastdate` > " . (time() - 300) . " AND `place` = 'forum,$id'")->fetchColumn();
            $online_g = $db->query("SELECT COUNT(*) FROM `cms_sessions` WHERE `lastdate` > " . (time() - 300) . " AND `place` = 'forum,$id'")->fetchColumn();
            $wholink = '<div class="list hover back_or_forward"><a href="index.php?act=who&amp;id=' . $id . '">' . _t('Who is here') . '?</a>&#160;<span>(' . $online_u . '&#160;/&#160;' . $online_g . ')</span></div><br>';
        }
echo '<a id="up"></a>' . $counters->forumNew(1) . '' .
            '' . implode(' / ', $tree) . '</div>' .
            '<div class="topmenu">' . ($filelink ? ' | ' . $filelink : '') .  '</div>';



        switch ($type1['type']) {
            case 'f':
                ////////////////////////////////////////////////////////////
                // Список разделов форума                                 //
                ////////////////////////////////////////////////////////////
                $req = $db->query("SELECT `id`, `text`, `soft`, `edit` FROM `forum` WHERE `type`='r' AND `refid`='$id' ORDER BY `realid`");
                $total = $req->rowCount();

                if ($total) {
                    $i = 0;

                    while ($res = $req->fetch()) {
                        echo $i % 2 ? '<div class="list-body">' : '<div class="list-body">';
                        $coltem = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 't' AND `refid` = '" . $res['id'] . "'")->fetchColumn();
                        echo '<div class="list-menu hover"><i style="font-size: 23px; vertical-align: middle" class="fa fa-angle-double-right fa-fw"></i> <b>~<a href="?id=' . $res['id'] . '"><font color="red">' . $res['text'] . '</font></a>'; 
                        
                        if ($coltem) {
                            echo " [$coltem]";
                        }

                        if (!empty($res['soft'])) {
                            echo '<br><font color="#7B8285"><small>' . $res['soft'] . '</small></div></div>';
                        }

//                     echo '</div></div>';
                        ++$i;
                    }

                    unset($_SESSION['fsort_id']);
                    unset($_SESSION['fsort_users']);
                } else {
                    echo '<div class="gmenu"><div class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
<i class="fa fa-info-circle"></i><strong>There are no sections in this category</strong></div></div>';
                }

                echo '<div class="list hover back_or_forward">' . _t('Total') . ': ' . $total . '</div>';

                //Footer for all pages
echo'<div class="end"><div class="menu-wrapper-info"><div class="menu-container"><div class="menu-wrapper-center">
<a class="menu-container_item-info" href="' . $config['homeurl'] . '/users/index.php?act=admlist"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-user "></i></span> Administration</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/contacts.php"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-at "></i></span> Contacts</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/info.php"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-info "></i></span> Information</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/help/"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-exclamation-triangle "></i></span> Rules</div></a></div>
</div></div><br></div><br><center><div class="msgop"></div><div class="panel-top-optimize3"></div></center></div></div>';
                break;

            case 'r':
                // Forum Topic Sections
                $total = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='t' AND `refid`='$id'" . ($systemUser->rights >= 7 ? '' : " AND `close`!='1'"))->fetchColumn();

                if (($systemUser->isValid() && !isset($systemUser->ban['1']) && !isset($systemUser->ban['11']) && $config->mod_forum != 4) || $systemUser->rights) {
                    // Кнопка создания новой темы
                    echo '<div class="list"><a href="index.php?act=nt&amp;id=' . $id . '" class="btn"><i style="font-size: 15px; vertical-align: middle" class="fa fa-plus "></i> Create a topic</a></div>';
                }



                if ($total) {
                    $req = $db->query("SELECT * FROM `forum` WHERE `type`='t'" . ($systemUser->rights >= 7 ? '' : " AND `close`!='1'") . " AND `refid`='$id' ORDER BY `vip` DESC, `time` DESC LIMIT $start, $kmess");
                    $i = 0;

            $res = $db->query("SELECT * FROM `forum` WHERE `id` = '$parent' LIMIT 1")->fetch();
            if ($res['type'] == 'f' || $res['type'] == 'r') {

                $tree[] = '<div class="list">Subsection Topics "<b><b><a href="index.php?id=' . $parent . '"><font color="red">' . $res['text'] . '</font></a></b></div>';
            }

                    while ($res = $req->fetch()) {
                        if ($res['close']) {
                            echo '<div>';
                        } else {
                            echo $i % 2 ? '<div class="list-body">' : '<div class="list-body">';
                        }

                        $nam = $db->query("SELECT `from` FROM `forum` WHERE `type` = 'm' AND `close` != '1' AND `refid` = '" . $res['id'] . "' ORDER BY `time` DESC LIMIT 1")->fetch();
                        $colmes = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='m' AND `refid`='" . $res['id'] . "'" . ($systemUser->rights >= 7 ? '' : " AND `close` != '1'"))->fetchColumn();
                        $cpg = ceil($colmes / $kmess);
                        $np = $db->query("SELECT COUNT(*) FROM `cms_forum_rdm` WHERE `time` >= '" . $res['time'] . "' AND `topic_id` = '" . $res['id'] . "' AND `user_id` = " . $systemUser->id)->fetchColumn();
                        // Значки

$prfx = $db->query("SELECT * FROM `prefix_forum` ORDER BY `id` ");
            if ($prfx) {
                while ($prefix = $prfx->fetch()) {
                   if ($res['nircable'] == $prefix['id']) {
	                    $aan = '<div class="list-menu hover"><span class="' . $prefix['label'] . '">' . $prefix['name'] . '</span>&#160;';
                    } elseif ($res['nircable'] ==0 ) {
                        $aan = '';
                    }
                  }
            }
                      
                       $icons = [
                            ($np ? (!$res['vip'] ? $tools->image('op.gif') : '') : $tools->image('np.gif')),
                            ($res['vip'] ? $tools->image('pt.gif') : ''),
                            ($res['realid'] ? $tools->image('rate.gif') : ''),
                            ($res['edit'] ? $tools->image('tz.gif') : ''),
                        ];
                        echo implode('', array_filter($icons));
                        echo '&#160;'.$aan.'&#160;';
                      
                        echo '<a href="index.php?id=' . $res['id'] . '"><b> <i style="font-size: 15px; vertical-align: middle" class="fa fa-comments fa-fw"></i>' . (empty($res['text']) ? '' : $res['text']) . '</b></a><font color="#7B8285"><small>[' . $colmes . ']</small></font>'; 

                        if ($cpg > 1) {
                      
                            echo '<a href="index.php?id=' . $res['id'] . '&amp;page=' . $cpg . '">&#160;&gt;&gt;</a>';
                        }


                        echo '<br><br><span class="time">Topic author: <font color="black"><b>';
                        //echo $res['from'];
                        echo $tools->nick($res['user_id']);
                        //if (!empty($nam['from'])) {
                            echo '</b></font><br>';
                        //}
                     if (!empty($nam['from'])) {
                       $as = $db->query("SELECT * FROM `users` WHERE `name` = '".$nam['from']."'");
                       $nickmem = $as->fetch();
                        echo 'Last  comment: <font color="black"><b>' . $tools->nick($nickmem['id']);
                        }


                        echo ' </b></font> -' . $tools->displayDate($res['time']) . '</span>';
echo'</div>';

                        ++$i;

                    }
                    unset($_SESSION['fsort_id']);
                    unset($_SESSION['fsort_users']);
                } else {
                    echo '<div class="menu"><p>' . _t('No topics in this section') . '</p></div>';
                }
echo'</div>';

                echo '<div class="phdr">' . _t('Total') . ': ' . $total . '</div>';

//Footer for all pages
echo'<div class="end"><div class="menu-wrapper-info"><div class="menu-container"><div class="menu-wrapper-center">
<a class="menu-container_item-info" href="' . $config['homeurl'] . '/users/index.php?act=admlist"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-user "></i></span> Administration</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/contacts.php"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-at "></i></span> Contacts</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/info.php"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-info "></i></span> Information</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/help/"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-exclamation-triangle "></i></span> Rules</div></a></div>
</div></div><br></div><br><center><div class="msgop"></div><div class="panel-top-optimize3"></div></center></div></div>';



                if ($total > $kmess) {
                    echo '<div class="topmenu">' . $tools->displayPagination('index.php?id=' . $id . '&amp;', $start, $total, $kmess) . '</div>';
                   
                        '<p><form action="index.php?id=' . $id . '" method="post">' .
                        '<input type="text" name="page" size="2"/>' .
                        '<input type="submit" value="' . _t('To Page') . ' &gt;&gt;"/>' .
                        '</form></p>';
                }
                break;

            case 't':
                ////////////////////////////////////////////////////////////
                // Forum Topic                              //
                ////////////////////////////////////////////////////////////
                $filter = isset($_SESSION['fsort_id']) && $_SESSION['fsort_id'] == $id ? 1 : 0;
                $sql = '';

                if ($filter && !empty($_SESSION['fsort_users'])) {
                    // Подготавливаем запрос на фильтрацию юзеров
                    $sw = 0;
                    $sql = ' AND (';
                    $fsort_users = unserialize($_SESSION['fsort_users']);

                    foreach ($fsort_users as $val) {
                        if ($sw) {
                            $sql .= ' OR ';
                        }

                        $sortid = intval($val);
                        $sql .= "`forum`.`user_id` = '$sortid'";
                        $sw = 1;
                    }
                    $sql .= ')';
                }

                // Если тема помечена для удаления, разрешаем доступ только администрации
                if ($systemUser->rights < 6 && $type1['close'] == 1) {
                    echo '<div class="rmenu"><p>' . _t('Topic deleted') . '<br><a href="?id=' . $type1['refid'] . '">' . _t('Go to Section') . '</a></p></div>';
                    require('../system/end.php');
                    exit;
                }

                // Счетчик постов темы
                $colmes = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='m'$sql AND `refid`='$id'" . ($systemUser->rights >= 7 ? '' : " AND `close` != '1'"))->fetchColumn();

                if ($start >= $colmes) {
                    // Исправляем запрос на несуществующую страницу
                    $start = max(0, $colmes - (($colmes % $kmess) == 0 ? $kmess : ($colmes % $kmess)));
                }






## Mod prefix
echo '<div class="phdr"><a href="#down">' . $tools->image('down.png', ['class' => '']) . '</a>&#160;&#160;';

$prfx = $db->query("SELECT * FROM `prefix_forum` ORDER BY `id` ");
    if ($prfx) {
        while ($prefix = $prfx->fetch()) {
           if ($type1['nircable'] == $prefix['id']) {
               echo '<span class="' . $prefix['label'] . '">' . $prefix['name'] . '</span>&#160;';
           } elseif ($type1['nircable'] == 0) {
               echo '';
           }
        }
     }
echo '<b>' . (empty($type1['text']) ? '-----' : $type1['text']) . '</b></div>';
                // Выводим название топика
                //echo '<div class="phdr"><a href="#down">' . $tools->image('down.png', ['class' => '']) . '</a>&#160;&#160;<b>' . (empty($type1['text']) ? '-----' : $type1['text']) . '</b></div>';

                if ($colmes > $kmess) {
                    echo '<div class="topmenu">' . $tools->displayPagination('index.php?id=' . $id . '&amp;', $start, $colmes, $kmess) . '</div>';
                }

                // Метка удаления темы
                if ($type1['close']) {
                    echo '<div class="rmenu">' . _t('Topic deleted by') . ': <b>' . $type1['close_who'] . '</b></div>';
                } elseif (!empty($type1['close_who']) && $systemUser->rights >= 7) {
                    echo '<div class="gmenu"><small>' . _t('Undelete topic') . ': <b>' . $type1['close_who'] . '</b></small></div>';
                }

                // Метка закрытия темы
                if ($type1['edit']) {
                    echo '<center>' . $tools->image('closed_t.gif') . '</center>';
                }
include '../forum/like/Notif.php';

                // Блок голосований
                if ($type1['realid']) {
                    $clip_forum = isset($_GET['clip']) ? '&amp;clip' : '';
                    $vote_user = $db->query("SELECT COUNT(*) FROM `cms_forum_vote_users` WHERE `user`='" . $systemUser->id . "' AND `topic`='$id'")->fetchColumn();
                    $topic_vote = $db->query("SELECT `name`, `time`, `count` FROM `cms_forum_vote` WHERE `type`='1' AND `topic`='$id' LIMIT 1")->fetch();
                    echo '<div  class="gmenu"><b>' . $tools->checkout($topic_vote['name']) . '</b><br />';
                    $vote_result = $db->query("SELECT `id`, `name`, `count` FROM `cms_forum_vote` WHERE `type`='2' AND `topic`='" . $id . "' ORDER BY `id` ASC");

                    if (!$type1['edit'] && !isset($_GET['vote_result']) && $systemUser->isValid() && $vote_user == 0) {
                        // Выводим форму с опросами
                        echo '<form action="index.php?act=vote&amp;id=' . $id . '" method="post">';

                        while ($vote = $vote_result->fetch()) {
                            echo '<input type="radio" value="' . $vote['id'] . '" name="vote"/> ' . $tools->checkout($vote['name'], 0, 1) . '<br />';
                        }

                        echo '<p><input type="submit" name="submit" class="btn btn-success" value="' . _t('Vote') . '"/><br /><a href="index.php?id=' . $id . '&amp;start=' . $start . '&amp;vote_result' . $clip_forum .
                            '">' . _t('Results') . '</a></p></form></div>';
                    } else {
                        // Выводим результаты голосования
                        echo '<small>';

                        while ($vote = $vote_result->fetch()) {
                            $count_vote = $topic_vote['count'] ? round(100 / $topic_vote['count'] * $vote['count']) : 0;
                            echo $tools->checkout($vote['name'], 0, 1) . ' [' . $vote['count'] . ']<br />';
                            echo '<img src="vote_img.php?img=' . $count_vote . '" alt="' . _t('Rating') . ': ' . $count_vote . '%" /><br />';
                        }

                        echo '</small></div><div class="bmenu">' . _t('Total votes') . ': ';

                        if ($systemUser->rights > 6) {
                            echo '<a href="index.php?act=users&amp;id=' . $id . '">' . $topic_vote['count'] . '</a>';
                        } else {
                            echo $topic_vote['count'];
                        }

                        echo '</div>';

                        if ($systemUser->isValid() && $vote_user == 0) {
                            echo '<div class="bmenu"><a class="btn btn-primary" href="index.php?id=' . $id . '&amp;start=' . $start . $clip_forum . '">' . _t('Vote') . '</a></div>';
                        }
                    }
                }

                // Получаем данные о кураторах темы
                $curators = !empty($type1['curators']) ? unserialize($type1['curators']) : [];
                $curator = false;

                if ($systemUser->rights < 6 && $systemUser->rights != 3 && $systemUser->isValid()) {
                    if (array_key_exists($systemUser->id, $curators)) {
                        $curator = true;
                    }
                }

                // Фиксация первого поста в теме
                if (($set_forum['postclip'] == 2 && ($set_forum['upfp'] ? $start < (ceil($colmes - $kmess)) : $start > 0)) || isset($_GET['clip'])) {
                    $postres = $db->query("SELECT `forum`.*, `users`.`sex`, `users`.`rights`, `users`.`lastdate`, `users`.`status`, `users`.`datereg`
                    FROM `forum` LEFT JOIN `users` ON `forum`.`user_id` = `users`.`id`
                    WHERE `forum`.`type` = 'm' AND `forum`.`refid` = '$id'" . ($systemUser->rights >= 7 ? "" : " AND `forum`.`close` != '1'") . "
                    ORDER BY `forum`.`id` LIMIT 1")->fetch();
                    echo '<div class="topmenu"><p>';

                    if ($systemUser->isValid() && $systemUser->id != $postres['user_id']) {
                        echo '<a href="../profile/?user=' . $postres['user_id'] . '&amp;fid=' . $postres['id'] . '"><b>' . $tools->nick($postres['id']) . '</b></a> ' .
                            '<a href="index.php?act=say&amp;id=' . $postres['id'] . '&amp;start=' . $start . '"> ' . _t('[r]') . '</a> ' .
                            '<a href="index.php?act=say&amp;id=' . $postres['id'] . '&amp;start=' . $start . '&amp;cyt"> ' . _t('[q]') . '</a> ';
                    } else {
                        echo '<b>' . $tools->nick($postres['id']) . '</b> ';
                    }

                    $user_rights = [
                       0 => '(Novice)',
                       3 => '(VIP)',
                        6 => '(Super Mod)',
                        7 => '(Admin)',
                        9 => '(Site-Owner)',
                    ];
                    if ($postres['id'] == 1) {
                        echo ' (Author)';
                    } else {
                        echo @$user_rights[$postres['rights']];
                    }
                    echo(time() > $postres['lastdate'] + 300 ? '<span class="red"> [Off]</span>' : '<span class="green"> [ON]</span>');
                    echo ' <span class="gray">(' . $tools->displayDate($postres['time']) . ')</span><br>';

                    if ($postres['close']) {
                        echo '<span class="red">' . _t('Post deleted') . '</span><br>';
                    }

                    echo $tools->checkout(mb_substr($postres['text'], 0, 500), 0, 2);

                    if (mb_strlen($postres['text']) > 500) {
                      
                         //echo '...<a href="'.$config['homeurl'].'/forum/'.$tools->Rewrite($type1['text']) . '_p' . $postres['id'] . '.html">' . _t('Read more') . '</a>';
                        echo '...<a href="index.php?act=post&amp;id=' . $postres['id'] . '">' . _t('Read more') . '</a>';
                    }

                    echo '</p></div>';
                }

                // Памятка, что включен фильтр
                if ($filter) {
                    echo '<div class="rmenu">' . _t('<div class="gmenu"><div class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
<i class="fa fa-info-circle"></i><strong>Filter by author is activated</strong></div></div>') . '</div>';
                }

                // Задаем правила сортировки (новые внизу / вверху)
                if ($systemUser->isValid()) {
                    $order = $set_forum['upfp'] ? 'DESC' : 'ASC';
                } else {
                    $order = ((empty($_SESSION['uppost'])) || ($_SESSION['uppost'] == 0)) ? 'ASC' : 'DESC';
                }

                ////////////////////////////////////////////////////////////
                // Основной запрос в базу, получаем список постов темы    //
                ////////////////////////////////////////////////////////////
                $req = $db->query("
                  SELECT `forum`.*, `users`.`sex`, `users`.`rights`, `users`.`lastdate`, `users`.`status`, `users`.`datereg`
                  FROM `forum` LEFT JOIN `users` ON `forum`.`user_id` = `users`.`id`
                  WHERE `forum`.`type` = 'm' AND `forum`.`refid` = '$id'"
                    . ($systemUser->rights >= 7 ? "" : " AND `forum`.`close` != '1'") . "$sql
                  ORDER BY `forum`.`id` $order LIMIT $start, $kmess
                ");

echo "\n<script type='text/javascript'>
/*<![CDATA[*/
function like(id, type) {
  var elem = document.getElementById('vote_' + id);
  var type = type;
  var post = id;
  var url = 'ajaxlike.php';
  $.ajax({
    type: 'POST',
    cache: false,
    url: url,
    data: {
      post: post,
      type: type,
    },
    success: function (result) {
      if (result) {
        $(elem).replaceWith(result);
      } else {
        alert('Error XMLHttpRequest');
      }
    }
  });
};
//]]>
</script>\n";

                                // Верхнее поле "Написать"
                if (($systemUser->isValid() && !$type1['edit'] && $set_forum['upfp'] && $config->mod_forum != 3 && $allow != 4) || ($systemUser->rights >= 7 && $set_forum['upfp'])) {
                    echo '<form name="form1" action="index.php?act=say&amp;id=' . $id . '" method="post" class="ajax-form">';

                    if ($set_forum['farea']) {
                        $token = mt_rand(1000, 100000);
                        $_SESSION['token'] = $token;
                        echo '<center>' .
                            $container->get(Johncms\Api\BbcodeInterface::class)->buttons('form1', 'msg') .
                            '</center><textarea rows="' . $systemUser->getConfig()->fieldHeight . '" name="msg" class="form-control-textarea"></textarea></p>' .
                            '<p><input type="checkbox" name="addfiles" value="1" /> ' . _t('Attach Zip or Files here') .
                            '</p><p><input type="submit" class="btn btn-success" name="submit" value="' . _t('Reply to this topic') . '" style="width: 650px; cursor: pointer;"/> ' .
                          //  (isset($set_forum['preview']) && $set_forum['preview'] ? '<input type="submit" class="button ajax-button OnBottom" value="' . _t('Preview') . '" style="width: 107px; cursor: pointer;"/>' : '') .
                            '<input type="hidden" name="token" value="' . $token . '"/>' .
                            '</p></form>';
                    } else {
                        echo '<p><input type="submit" class="button ajax-button OnBottom" name="submit" value="' . _t('Write') . '"/></p></form>';
                    }
                }




                // Для администрации включаем форму массового удаления постов
                if ($systemUser->rights == 3 || $systemUser->rights >= 6) {
                    echo '<form action="index.php?act=massdel" method="post">';
                }
                $i = 1;

                ////////////////////////////////////////////////////////////
                // Main Theme for Forum Post v2.0                                 //
                ////////////////////////////////////////////////////////////
                echo'<div class="list-body">';
                while ($res = $req->fetch()) {
                    // Фон поста
                    if ($res['close']) {
                        echo '<div class="list-menu hover">';
                    } else {
                    echo $i % 2 ? '<div class="list-menu hover"><table width="100%" cellpadding="0" cellspacing="0"><tr>' .
'<td width="auto"><img src="' . $config['homeurl'] . '/images/op.gif"> ' . $tools->displayDate($res['time']) . ' </td>' .
'<td width="auto" align="right">#<a href="index.php?act=post&amp;id=' . $res['id'] . '#' . ($start + $i) . '">' . ($start + $i) . '</a></td></tr></table></div><br>' : '<br><div class="list-menu hover"><table width="100%" cellpadding="0" cellspacing="0"><tr>' .
'<td width="auto"><img src="' . $config['homeurl'] . '/images/op.gif"> ' . $tools->displayDate($res['time']) . ' </td>' .
'<td width="auto" align="right">#<a href="index.php?act=post&amp;id=' . $res['id'] . '#' . ($start + $i) . '">' . ($start + $i) . '</a></td></tr></table></div>';
                    }

                    //echo "</div>";

                    if (file_exists(('../files/users/photo/' . $res['user_id'] . '.jpg'))) {
                        echo '<img class="avatar" style=" font-size: 20.5px; width: 45px; height: 45px;" src="../files/users/photo/' . $res['user_id'] . '.jpg" width="32" height="32" alt="' . $res['from'] . '" />&#160;';
                    } else {
                        echo '<img class="avatar" style=" font-size: 20.5px; width: 45px; height: 45px;" src="../images/empty.png" width="32" height="32" alt="' . $res['from'] . '" />&#160;';
                    }
                    //echo '</span>';

                    // Метка пола
                    if ($res['sex']) {
                        echo $tools->image(($res['sex'] == 'm' ? 'm' : 'w') . ($res['datereg'] > time() - 86400 ? '_new' : '') . '.png', ['class' => 'icon-inline']);
                    } else {
                        echo $tools->image('del.png');
                    }

                    // Ник юзера и ссылка на его анкету
                    if ($systemUser->isValid() && $systemUser->id != $res['user_id']) {
                        echo '<a href="../profile/?user=' . $res['user_id'] . '" style="color: black"><b>' . $tools->nick($res['user_id']) . '</b></a> ';
                    } else {
                        echo '<b>' . $tools->nick($res['user_id']) . '</b> ';
                    }

                    // Метка должности
                    $user_rights = [
                        0 => '(Novice)',
                        1 => '(<font color="purple">Moder</font>)',
                        2 => '(<font color="gold">Super Mod</font>)',
                        3 => '(<font color="yellow">VIP</font>)',
                        4 => '(<font color="pink">Vip Pro</font>)',
                        5 => '(<font color="blue">Junior Admin</font>)',
                        6 => '(<font color="gold">Senior Admin</font>)',
                        7 => '(<font color="orange">Admin</font>)',
                        9 => '(<font color="red">Owner/Founder</font>)',
                    ];
                    if ($res['user_id'] == 1) {
                        echo ' (Owner/Founder)';
                    } else {
                        echo(isset($user_rights[$res['rights']]) ? $user_rights[$res['rights']] : '');
                   }
                    // Метка онлайн/офлайн
                    echo(time() > $res['lastdate'] + 300 ? '<span class="red"> Offline</span> ' : '<span class="green"> Online</span> ');

                    // Ссылка на пост
                    //echo '<a href="index.php?act=post&amp;id=' . $res['id'] . '" title="Link to post">[#]</a>';

                    // Ссылки на ответ и цитирование
 
                    //if ($systemUser->isValid() && $systemUser->id != $res['user_id']) {
                       // echo '&#160;<a href="index.php?act=say&amp;id=' . $res['id'] . '&amp;start=' . $start . '">' . _t('[r]') . '</a>&#160;' .
                          //  '<a href="index.php?act=say&amp;id=' . $res['id'] . '&amp;start=' . $start . '&amp;cyt">' . _t('[q]') . '</a> ';
                  //  }

                    // Время поста
                   // echo ' <span class="gray">(' . $tools->displayDate($res['time']) . ')</span><br />';

                    // Статус пользователя
                    if (!empty($res['status'])) {
                        echo '<div>' . $tools->image('label.png', ['class' => 'icon-inline']) . $res['status'] . '</div>';
                    }

                    // Закрываем таблицу с аватаром
                    //echo '</div></div>';

                    ////////////////////////////////////////////////////////////
                    // Voter codes                                    //
                    ////////////////////////////////////////////////////////////
                    
                    $text = $res['text'];
                    $text = $tools->checkout($text, 1, 1);
                    $text = $tools->smilies($text, $res['rights'] ? 1 : 0);
                    echo $text;
                    $like = new Johncms\Forum\Voter($res['id']);
                    echo $like->view($res['id']);
                    // Если пост редактировался, показываем кем и когда
                    if ($res['kedit']) {
                        echo '<br /><span><small>' . _t('Edited') . ' <b>' . $res['edit'] . '</b> (' . $tools->displayDate($res['tedit']) . ') <b>[' . $res['kedit'] . ']</b></small></span>';
                    }

                    // Задаем права на редактирование постов
                    if (
                        (($systemUser->rights == 3 || $systemUser->rights >= 6 || $curator) && $systemUser->rights >= $res['rights'])
                        || ($res['user_id'] == $systemUser->id && !$set_forum['upfp'] && ($start + $i) == $colmes && $res['time'] > time() - 300)
                        || ($res['user_id'] == $systemUser->id && $set_forum['upfp'] && $start == 0 && $i == 1 && $res['time'] > time() - 300)
                        || ($i == 1 && $allow == 2 && $res['user_id'] == $systemUser->id)
                    ) {
                        $allowEdit = true;
                    } else {
                        $allowEdit = false;
                    }

                    // Если есть прикрепленные файлы, выводим их
                    $freq = $db->query("SELECT * FROM `cms_forum_files` WHERE `post` = '" . $res['id'] . "'");

                    if ($freq->rowCount()) {
                        //echo '<div class="post-files">';
                        while ($fres = $freq->fetch()) {
                            $fls = round(@filesize('../files/forum/attach/' . $fres['filename']) / 1024, 2);
                            echo '' . _t('Attachment') . ':';
                            // Предпросмотр изображений
                            $att_ext = strtolower(pathinfo('./files/forum/attach/' . $fres['filename'], PATHINFO_EXTENSION));
                            $pic_ext = [
                                'gif',
                                'jpg',
                                'jpeg',
                                'png',
                            ];

                            if (in_array($att_ext, $pic_ext)) {
                                echo '<div><a href="index.php?act=file&amp;id=' . $fres['id'] . '">';
                                echo '<img src="thumbinal.php?file=' . (urlencode($fres['filename'])) . '" alt="' . _t('Click to view image') . '" /></a></div>';
                            } else {                      
                     
                $checkthank = $db->query('SELECT COUNT(*) FROM `forum_thank` WHERE `userthank` = "'.$systemUser->id.'" and `topic` = "'.$res['id'] .'" and `user` = "'.$res['user_id'] .'"');
                 $thankcheck = $checkthank->fetchColumn();
                  if ($systemUser->premium == '1') {
                      echo '<br><a href="index.php?act=file&amp;id=' . $fres['id'] . '">' . $fres['filename'] . '</a>';
                  } elseif ($thankcheck < 1 && $systemUser->id !=$res['user_id']) {
                     echo 'Thanks Before';
                     echo '<br/><a href="index.php?act=file&amp;id=' . $fres['id'] . '">Download Now</a>'; 
                  } else {
                        echo '<br><a href="index.php?act=file&amp;id=' . $fres['id'] . '">Download</a>';
                        echo '<br/>' . $fres['filename'] . ''; 
                   }

                                             }

                            echo ' (' . $fls . ' кб.)<br>';
                            echo _t('Downloads') . ': ' . $fres['dlcount'] . ' ' . _t('Time');

                            if ($allowEdit) {
                                echo '<a href="?act=editpost&amp;do=delfile&amp;fid=' . $fres['id'] . '&amp;id=' . $res['id'] . '">' . _t('Delete') . '</a>';
                            }

                            //echo '</div></div>';
                            $file_id = $fres['id'];
                        }
                       //echo '</td></tr></table></div></div>';
                    }
include '../forum/like/Button.php';
include '../forum/like/Show.php';
                    // Ссылки на редактирование / удаление постов
                    if ($allowEdit) {
                        echo '<div class="sub">';

                        // Чекбокс массового удаления постов
                        if ($systemUser->rights == 3 || $systemUser->rights >= 6) {
                            echo '<input type="checkbox" name="delch[]" value="' . $res['id'] . '"/>&#160;';
                        }

                        // Служебное меню поста
                        $menu = [
                            '<a href="index.php?act=editpost&amp;id=' . $res['id'] . '">' . _t('Edit') . '</a>',
                            ($systemUser->rights >= 7 && $res['close'] == 1 ? '<a href="index.php?act=editpost&amp;do=restore&amp;id=' . $res['id'] . '">' . _t('Restore') . '</a>' : ''),
                            ($res['close'] == 1 ? '' : '<a href="index.php?act=editpost&amp;do=del&amp;id=' . $res['id'] . '">' . _t('Delete') . '</a>'),
                        ];
                        echo implode(' | ', array_filter($menu));

                        // Показываем, кто удалил пост
                        if ($res['close']) {
                            echo '<div class="red">' . _t('Post deleted') . ': <b>' . $res['close_who'] . '</b></div>';
                        } elseif (!empty($res['close_who'])) {
                            echo '<div class="green">' . _t('Post restored by') . ': <b>' . $res['close_who'] . '</b></div>';
                        }

                        // Показываем IP и Useragent
                        if ($systemUser->rights == 3 || $systemUser->rights >= 6) {
                            if ($res['ip_via_proxy']) {
                                echo '<div><b class="red"><a href="' . $config->homeurl . '/admin/index.php?act=search_ip&amp;ip=' . long2ip($res['ip']) . '">' . long2ip($res['ip']) . '</a></b> - ' .
                                    '<a href="' . $config->homeurl . '/admin/index.php?act=search_ip&amp;ip=' . long2ip($res['ip_via_proxy']) . '">' . long2ip($res['ip_via_proxy']) . '</a>' .
                                    ' - ' . $res['soft'] . '</div><br>';
                            } else {
                                echo '<div><a href="' . $config->homeurl . '/admin/index.php?act=search_ip&amp;ip=' . long2ip($res['ip']) . '">' . long2ip($res['ip']) . '</a> - ' . $res['soft'] . '</div><br>';
                            }
                        }

//                       echo '</div>';
                    }

              //      echo '</div><hr>';
                    ++$i;
 //      echo '</div></div>';
                
                }

                // Кнопка массового удаления постов
                if ($systemUser->rights == 3 || $systemUser->rights >= 6) {
                    echo '</div></div></div></div></div></div></div></div></div></div></div><div class="rmenu"><input type="submit" class="btn btn-success" value=" ' . _t('Delete') . ' "/></div>';
                    echo '</form>';
                }
//               echo '</div><hr><br>';
                // Нижнее поле "Написать"
                if (($systemUser->isValid() && !$type1['edit'] && !$set_forum['upfp'] && $config->mod_forum != 3 && $allow != 4) || ($systemUser->rights >= 7 && !$set_forum['upfp'])) {
                    echo '<form name="form2" action="index.php?act=say&amp;id=' . $id . '" method="post" class="ossn-form">';

                    if ($set_forum['farea']) {
                        $token = mt_rand(1000, 100000);
                        $_SESSION['token'] = $token;
                        echo '<p>';
                        echo $container->get(Johncms\Api\BbcodeInterface::class)->buttons('form2', 'msg');
                        echo '<textarea rows="' . $systemUser->getConfig()->fieldHeight . '" name="msg"></textarea><br></p>' .
                            '<p><input type="checkbox" name="addfiles" value="1" /> ' . _t('Attach Zip or Files here');

                        echo '</p><p><input type="submit" class="btn btn-success" class="btn btn-success" name="submit" value="' . _t('Write') . '" style="width: 107px; cursor: pointer;"/> ' .
                            (isset($set_forum['preview']) && $set_forum['preview'] ? '<input type="submit" class="button ajax-button OnBottom" value="' . _t('Preview') . '" style="width: 107px; cursor: pointer;"/>' : '') .
                            '<input type="hidden" name="token" value="' . $token . '"/>' .
                            '</p></form>';
                    } else {
                        echo '<p><input type="submit" class="button ajax-button OnBottom" name="submit" value="' . _t('Write') . '"/></p></form>';
                    }
                }

                echo '<div class="phdr"><a id="down"></a><a href="#up">' . $tools->image('up.png', ['class' => '']) . '</a>' .
                    '&#160;&#160;' . _t('Total') . ': ' . $colmes . '</div>';

echo '<div>';
echo '<div>Tags :</div>';
echo '<div>'.$tools->createTags($type1['text'], 1).'</div>';
echo '<div>';

$w_tag=substr_count($type1['tags'],',')+1;
for($t=0; $t<$w_tag; $t++) {
$w_exp_label=explode(',',$type1['tags']);
if (!empty($w_exp_label) ? ', ' : '') {
echo ' <span class="button-tag"> <a href="' . $config['homeurl'] . '/forum/tags='.urlencode($w_exp_label[$t]).'">'.$w_exp_label[$t].'</a></span>';
}
}
if ($systemUser->id == $type1['user_id'] && $systemUser->rights >= 6) {
echo '<br><b><a class="btn btn-success" href="index.php?act=tag&amp;id=' . $id . '">Edit</a></b>';
}
echo '</div>';
echo '</div>';




                // Постраничная навигация
                if ($colmes > $kmess) {
                    echo '<div class="topmenu">' . $tools->displayPagination('index.php?id=' . $id . '&amp;', $start, $colmes, $kmess) . '</div>';
                    //echo '<div class="topmenu">' . $tools->displayPagination2(''.$config['homeurl'].'/forum/'.$tools->Rewrite($type1["text"]).'_' . $id, $start, $colmes, $kmess) . '</div>' .
                        '<p><form action="index.php?id=' . $id . '" method="post">' .
                        '<input type="text" name="page" size="2"/>' .
                        '<input type="submit" value="' . _t('To Page') . ' &gt;&gt;"/>' .
                        '</form></p>';
                } else {
                    echo '<hr />';
                }


                //box sharing topic 
                    $res = $db->query("SELECT `text` FROM `forum` WHERE `id`= " . $id)->fetch();
                echo '<div class="gmenu"><b>' . _t('Share') . ':</b> ' .
                        '<a href="http://facebook.com/share.php?u=' . $config['homeurl'] . '/forum/index.php?id=' . $id . '" target="_blank" title="Share on Facebook">' . $tools->image('facebook.png', ['alt' => 'Facebook']) . '</a>
                        <a href="http://twitter.com/home?status=' . $config['homeurl'] . '/forum/index.php?id=' . $id . '" target="_blank" title="Share on Twitter">' . $tools->image('twitter.png', ['alt' => 'Twitter']) . '</a>
                        <a href="https://www.google.com.vn/bookmarks/mark?op=add&amp;bkmk=' . $config['homeurl'] . '/forum/index.php?id=' . $id . '" target="_blank" title="Share on Google+">' . $tools->image('google.png', ['alt' => 'Google+']) . '</a>';
                echo '<br/><b>BBcode:</b> <textarea>[url=' . $config['homeurl'] . '/forum/index.php?id=' . $id . ']' . $res['text']. '[/url]</textarea></div>';
                //other topics
                
                $reqt = $db->query("SELECT `id`, `text` FROM 
                    ((SELECT `id`, `text` FROM `forum` WHERE `type` = 't' AND `close` != 1 AND `user_id`='" . $type1['user_id'] . "' AND MATCH (`text`) AGAINST (" . $db->quote($resText) . " IN BOOLEAN MODE) AND `id` != '$id' LIMIT 5)
                    UNION
                    (SELECT `id`, `text` FROM `forum` WHERE `type` = 't' AND `close` != 1 AND `id` < '$id' AND `refid` = '" . $type1['refid'] . "' LIMIT 5)) AS `forum`
                    ORDER BY `id` DESC;");
                if ($reqt->rowCount()) {
                    echo '<div class="phdr"><b>' . _t('Other topics') . '</b></div><div class="list-body">';
                    while ($rest = $reqt->fetch()) {
                        echo '<a href="' . $tools->rewriteUrl($rest['text'], $rest['id']) . '"><div class="list-menu hover"><b> <i style="font-size: 15px; vertical-align: middle" class="fa fa-comments fa-fw"></i>' . $rest['text'] . ' </b></div></a>';
                    }
                    echo'</div></div></div>';
                }


                // Список кураторов
                if ($curators) {
                    $array = [];

                    foreach ($curators as $key => $value) {
                        $array[] = '<a href="../profile/?user=' . $key . '">' . $value . '</a>';
                    }

                    echo '<p><div class="func">' . _t('Curators') . ': ' . implode(', ', $array) . '</div></p>';
                }


                

                // Ссылки на модерские функции управления темой
                if ($systemUser->rights == 3 || $systemUser->rights >= 6) {
                    echo '<p><div class="func">Forum Options<hr>';

                    if ($systemUser->rights >= 7) {
                        echo '<a class="btn btn-success" href="index.php?act=curators&amp;id=' . $id . '&amp;start=' . $start . '">' . _t('Curators of the Topic') . '</a><br />';
                    }

                    echo isset($topic_vote) && $topic_vote > 0
                        ? '<a class="btn btn-warning" href="index.php?act=editvote&amp;id=' . $id . '">' . _t('Edit Poll') . '</a><br><a href="index.php?act=delvote&amp;id=' . $id . '">' . _t('Delete Poll') . '</a><br>'
                        : '<a class="btn btn-primary" href="index.php?act=addvote&amp;id=' . $id . '">' . _t('Add Poll') . '</a><br>';
                    echo '<a class="btn btn-primary" href="index.php?act=ren&amp;id=' . $id . '">' . _t('Rename Topic') . '</a><br>';

                    // Закрыть - открыть тему
                    if ($type1['edit'] == 1) {
                        echo '<a class="btn btn-success" href="index.php?act=close&amp;id=' . $id . '">' . _t('Open Topic') . '</a><br>';
                    } else {
                        echo '<a class="btn btn-warning" href="index.php?act=close&amp;id=' . $id . '&amp;closed">' . _t('Close Topic') . '</a><br>';
                    }

                    // Удалить - восстановить тему
                    if ($type1['close'] == 1) {
                        echo '<a class="btn btn-warning" href="index.php?act=restore&amp;id=' . $id . '">' . _t('Restore Topic') . '</a><br>';
                    }

                    echo '<a class="btn btn-danger" href="index.php?act=deltema&amp;id=' . $id . '">' . _t('Delete Topic') . '</a><br>';

                    if ($type1['vip'] == 1) {
                        echo '<a class="btn btn-primary" href="index.php?act=vip&amp;id=' . $id . '">' . _t('Unfix Topic') . '</a>';
                    } else {
                        echo '<a class="btn btn-primary" href="index.php?act=vip&amp;id=' . $id . '&amp;vip">' . _t('Pin Topic') . '</a>';
                    }

                    echo '<br><a class="btn btn-primary" href="index.php?act=per&amp;id=' . $id . '">' . _t('Move Topic') . '</a></div></p>';
                }

                // Ссылка на список "Кто в теме"
                if ($wholink) {
                    echo '<hr><div>' . $wholink . '</div>';
                }

                // Ссылка на фильтр постов
                if ($filter) {
                    echo '<div><a class="btn btn-primary" href="index.php?act=filter&amp;id=' . $id . '&amp;do=unset">' . _t('Cancel Filter') . '</a></div>';
                } else {
                    echo '<div><a class="btn btn-primary" href="index.php?act=filter&amp;id=' . $id . '&amp;start=' . $start . '">' . _t('Filter by author') . '</a></div>';
                }

                // Ссылка на скачку темы
                echo '<a class="btn btn-primary" href="index.php?act=tema&amp;id=' . $id . '">' . _t('Download Topic') . '</a>';
               
//Footer for all pages
echo'<div class="end"><div class="menu-wrapper-info"><div class="menu-container"><div class="menu-wrapper-center">
<a class="menu-container_item-info" href="' . $config['homeurl'] . '/users/index.php?act=admlist"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-user "></i></span> Administration</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/contacts.php"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-at "></i></span> Contacts</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/info.php"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-info "></i></span> Information</div></a><a class="menu-container_item-info" href="' . $config['homeurl'] . '/help/"><div><span class="icons-circle" style="background-color: #53a5e0" ;="" color:="" white=""><i style="font-size: 12px; vertical-align: middle" class="fa fa-exclamation-triangle "></i></span> Rules</div></a></div>
</div></div><br></div><br><center><div class="msgop"></div><div class="panel-top-optimize3"></div></center></div></div>';
                break;

            default:
                // Если неверные данные, показываем ошибку
                echo $tools->displayError(_t('Wrong data'));
                break;
        }
    } else {
        ////////////////////////////////////////////////////////////
        // Список Категорий форума                                //
        ////////////////////////////////////////////////////////////


        $count = $db->query("SELECT COUNT(*) FROM `cms_forum_files`" . ($systemUser->rights >= 7 ? '' : " WHERE `del` != '1'"))->fetchColumn();
        echo '<div class="menu-nav-content">' . $counters->forumNew(1) .
            '<a class="menu-nav h" href="">' . _t('Forum') . '</b>' .
            '<a class="menu-nav" href="index.php?act=files">' . _t('Files') . ' (' . $count . ')</a></div>';



   $req = $db->query("SELECT `id`, `text`, `soft` FROM `forum` WHERE `type`='f' ORDER BY `realid`");
        $i = 0;

       while ($res = $req->fetch()) {
            echo $i % 2 ? '<div class="list-body">' : '<div class="list-body">';
           $count = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='r' AND `refid`='" . $res['id'] . "'")->fetchColumn();

//   Becareful of forum category folder  here manual 
 echo '<div class="list-menu hover">
  <i style="font-size: 23px; vertical-align: middle" class="fa fa-angle-double-right fa-fw"></i> <b>~';
		 echo '<a href="index.php?id=' . $res['id'] . '"><font color="red">' . $res['text'] . '</font></a> [' . $count . ']<br>'; 
			if (!empty($res['soft'])) {
			    echo '<font color="#7B8285"><small>' . $res['soft'] . '</small></font></div></div>';
            }

          
           ++$i;
        }
        $online_u = $db->query("SELECT COUNT(*) FROM `users` WHERE `lastdate` > " . (time() - 300) . " AND `place` LIKE 'forum%'")->fetchColumn();
        $online_g = $db->query("SELECT COUNT(*) FROM `cms_sessions` WHERE `lastdate` > " . (time() - 300) . " AND `place` LIKE 'forum%'")->fetchColumn();
        echo '<div class="list hover back_or_forward">' . ($systemUser->isValid() ? '<a href="index.php?act=who">' . _t('Who in Forum') . '</a>' : _t('Who in Forum')) . '&#160;(' . $online_u . '&#160;/&#160;' . $online_g . ')</div>';
        unset($_SESSION['fsort_id']);
        unset($_SESSION['fsort_users']);
//    }

 echo '</div>';
    // Навигация внизу страницы
    echo '<br>' . ($id ? '<a href="' . $referer . '"><div class="list hover back_or_forward">
  <i style="font-size: 21px; vertical-align: middle" class="fa fa-arrow-circle-left fa-fw"></i>Homepage</div></a>
  <br />' : '<a href="' . $referer . '"><div class="list hover back_or_forward">
  <i style="font-size: 21px; vertical-align: middle" class="fa fa-arrow-circle-left fa-fw"></i>Homepage</div></a>
  <br />');

//Footer for all pages
echo'</div>';
  }

   // echo '</p>';

    if (!$systemUser->isValid()) {
        if ((empty($_SESSION['uppost'])) || ($_SESSION['uppost'] == 0)) {
            echo '<a href="index.php?id=' . $id . '&amp;page=' . $page . '&amp;newup">' . _t('New at the top') . '</a>';
        } else {
            echo '<a href="index.php?id=' . $id . '&amp;page=' . $page . '&amp;newdown">' . _t('New at the bottom') . '</a>';
        }
    }

}

//echo  '</div></div></div></div>';
     
   if ($agent_web == 'wap') {
    require('../system/end.php');
            }
   if ($agent_web == 'web') {
   require('../themes/default/end.php');
   }