<?php
/*
 * Naijadev Clone 3.1.0 (http://naijadev.ml or http://naijadev.in)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Project
 * @email       Tunzxywalex@gmail.com
 * @Whatsapp    +2349076642400
 * @copyright   Copyright (C) Naijadev Community 2018
 * @license     Premium Version Licence
 */

define('_IN_JOHNCMS', 1);

require('./system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

$textl = _t('Registration');
$headmod = 'registration';
require('./system/head.php');

// Если регистрация закрыта, выводим предупреждение
if (!$config->mod_reg || $systemUser->isValid()) {
    echo '<p>' . _t('Registration is temporarily closed') . '</p>';
    require('./system/end.php');
    exit;
}

$captcha = isset($_POST['captcha']) ? trim($_POST['captcha']) : null;
$reg_nick = isset($_POST['nick']) ? trim($_POST['nick']) : '';
$lat_nick = $tools->rusLat($reg_nick);
$reg_pass = isset($_POST['password']) ? trim($_POST['password']) : '';
if ($reg_nick && $reg_pass) {
      if ($tools->Anti($reg_nick, $reg_pass) == '1') {
                   session_name('SESID');
                   session_start();
                   setcookie('cuid', '');
                   setcookie('cups', '');                  
                   session_destroy();
                   echo '<div class="mainblok">';
                   echo '<div class="phdr">STOP</div>';
                   echo '<div class="rmenu">Invalid char. Please use a normal method</div>';
                   echo '<div class="phdr"><a href="javascript:history.back(2)"><b>Back</b></a></div>';
                   echo '</div>';         
                   require('./system/end.php');
                   exit;
    }
}
$user['dayb'] = isset($_POST['dayb']) ? intval($_POST['dayb']) : '';
$user['monthb'] = isset($_POST['monthb']) ? intval($_POST['monthb']) : '';
$user['yearofbirth'] = isset($_POST['yearofbirth']) ? intval($_POST['yearofbirth']) : '';
$reg_mail = isset($_POST['mail']) ? trim($_POST['mail']) : '';
$reg_name = isset($_POST['imname']) ? trim($_POST['imname']) : '';
$reg_about = isset($_POST['about']) ? trim($_POST['about']) : '';
$reg_sex = isset($_POST['sex']) ? trim($_POST['sex']) : '';

$subject = "Registration at " . $config['copyright'] . "";
$mail = "Hello $reg_nick.. This email has been sent from " . $config['copyright'] . "\r\n
You have received this mail because this email address was used during registration at our forum..\r\n If you did not register at our forums, please disregard this email.. You do not need to unsubscribe or take any further action..\r\n\r\n -------------------------------------------------\r\n Welcome on board\r\n -------------------------------------------------\r\n\r\n Thank you for joining us.. We suggest you save this email in a safe place.. This reminds, in case you forget your login detail..\r\n And your details are shown below:\r\n\r\n Username: $reg_nick\r\n Password: $reg_pass\r\n Email: $reg_mail\r\n\r\n And to go to our site please visit this page:\r\n $home/index.php\r\n It will ask you for a username, and your password..\r\n You may copy and paste, or type those username and password into the corresponding fields in the form.. If you still cannot login to your account, its possible that the account has been removed.. If this is the case, please contact the administrator (" . $config['email'] . ") to rectify the problem.. Thank you for registering and enjoy your stay..\r\n dont forget to update your profile after you login..\r\n and please dont reply this email, because its automatically sent from our servers..\r\n\r\n Please do ignore this message if you didn't sign-up or register at our website...\r\n -------------------------------------------------\r\n\r\n Regards,\r\n Administrators of " . $config['copyright'] . "";
$adds = "From: <no-reply@".$_SERVER['HTTP_HOST'].">\n";


if (isset($_POST['submit'])) {
    /** @var PDO $db */
    $db = $container->get(PDO::class);

    // Принимаем переменные
    $error = [];

    // Проверка Логина
    if (empty($reg_nick)) {
        $error['login'][] = _t('You have not entered Nickname');
    } elseif (mb_strlen($reg_nick) < 2 || mb_strlen($reg_nick) > 20) {
        $error['login'][] = _t('Nickname wrong length');
    }

    if (preg_match('/[^\da-z\-\@\*\(\)\?\!\~\_\=\[\]]+/', $lat_nick)) {
        $error['login'][] = _t('Invalid characters');
    }

    // Проверка пароля
    if (empty($reg_pass)) {
        $error['password'][] = _t('You have not entered password');
    } elseif (mb_strlen($reg_pass) < 3) {
        $error['password'][] = _t('Invalid length');
    }

    if (empty($reg_mail)) { 
        $error['mail'][] = _t('E-mail address cannot be empty..!!');
    } elseif (mb_strlen($reg_mail) < 3 || mb_strlen($reg_mail) > 40) { 
        $error[] = _t('E-mail length is not valid');
    } 
    if (!preg_match("#^[a-z0-9\.\-_\+]+?@(.*?\.)*?[a-z0-9\-_]+?\.[a-z]{2,4}$#i", $reg_mail)) { 
        $error[] = _t('E-mail format is not valid'); 
    } 

    if ($user['dayb'] < 1 || $user['dayb'] > 31 || $user['monthb'] < 1 || $user['monthb'] > 12) {
        $error[] = 'Your birthday is not valid..!!';
        } 

    // Проверка пола
    if ($reg_sex != 'm' && $reg_sex != 'zh') {
        $error['sex'] = _t('You have not selected gender');
    }

    // Проверка кода CAPTCHA
    if (!$captcha
        || !isset($_SESSION['code'])
        || mb_strlen($captcha) < 4
        || $captcha != $_SESSION['code']
    ) {
        $error['captcha'] = _t('The security code is not correct');
    }

    unset($_SESSION['code']);

    // Проверка переменных
    if (empty($error)) {
        $pass = md5(md5($reg_pass));
        $reg_name = htmlspecialchars(mb_substr($reg_name, 0, 50));
        $reg_mail = htmlspecialchars(mb_substr($reg_mail, 0, 40));
        $reg_about = htmlspecialchars(mb_substr($reg_about, 0, 1000));
        // Проверка, занят ли ник
        $stmt = $db->prepare('SELECT * FROM `users` WHERE `name_lat` = ?');
        $stmt->execute([$lat_nick]);

        if ($stmt->rowCount()) {
            $error['login'][] = _t('Selected Nickname is already in use');
        }
        $stmail = $db->prepare('SELECT * FROM `users` WHERE `mail` = ?');
        $stmail->execute([$reg_mail]);

        if ($stmail->rowCount()) {
            $error['mail'][] = _t('Selected Email is already in use');
        }
    }

    if (empty($error)) {
        /** @var Johncms\Api\EnvironmentInterface $env */
        $env = $container->get(Johncms\Api\EnvironmentInterface::class);
  if ($config['bot_reg']) {
         $id = $config['bot_id'];
         $name = $config['bot_name'];
         $bot = 'New Member Notification,
         Hello @'.$reg_nick.', Welcome you may please update your profile for introduce your self
    , please kindly message '.$reg_sex.' 
         About: '.$reg_about.'';
         $admset ='0';
         $ip = '10.8.3.8';
         $browser = 'System Administration';
         $db->prepare("INSERT INTO `guest` SET
                `adm` = ?,
                `time` = ?,
                `user_id` = ?,
                `name` = ?,
                `text` = ?,
                `ip` = ?,
                `browser` = ?,
                `otvet` = ''
            ")->execute([
                $admset,
                time(),
                $id,
                $name,
                $bot,
                $ip,
                $browser,
            ]);
       }
        $preg = $config->mod_reg > 1 ? 1 : 0;
        $db->prepare('
          INSERT INTO `users` SET
          `name` = ?,
          `name_lat` = ?,
          `mail` = ?,
          `dayb` = ?,
          `monthb` = ?,
          `yearofbirth` = ?,
          `password` = ?,
          `imname` = ?,
          `about` = ?,
          `sex` = ?,
          `rights` = 0,
          `ip` = ?,
          `ip_via_proxy` = ?,
          `browser` = ?,
          `datereg` = ?,
          `lastdate` = ?,
          `sestime` = ?,
          `preg` = ?,
          `set_user` = \'\',
          `set_forum` = \'\',
          `set_mail` = \'\',
          `smileys` = \'\'
        ')->execute([
            $reg_nick,
            $lat_nick,
            $reg_mail,
            $user['dayb'],
            $user['monthb'],
            $user['yearofbirth'],
            $pass,
            $reg_name,
            $reg_about,
            $reg_sex,
            $env->getIp(),
            $env->getIpViaProxy(),
            $env->getUserAgent(),
            time(),
            time(),
            time(),
            $preg,
        ]);

            $set_mail = $config['mailReg']; 
            if (!isset($set_mail['message_include'])) { 
                $set_mail['message_include'] = 0; 
            } 
            if ($set_mail['message_include']) { 
                $array = array('{LOGIN}', '{TIME}'); 
                $array_replace = array($reg_nick, '{TIME=' . time() .               '}'); 
                    if (empty($config['messageTheme'])) { 
                    $config['messageTheme'] = _t('Welcome Message'); 
                } 
                    if (empty($config['regMessage'])) { 
                        $config['regMessage'] = _t('Hi') . ", {LOGIN}\r\n" . _t('We are pleased to see you on our website.') . "\r\n" . _t('This Community is for learning Web School.') . "\r\n" . _t('Yours faithfully, Supporting Staffs'); 
                } 
            $theme = str_replace($array, $array_replace, $config['messageTheme']); 
            $system = str_replace($array, $array_replace, $config['regMessage']); 
                        $db->prepare('
                          INSERT INTO `cms_mail` SET
                          `user_id` = 0,
                          `from_id` = ?,
                          `text` = ?,
                          `time` = ?,
                          `sys` = 1,
                          `them` = ?
                        ')->execute([
                            $usid = $db->lastInsertId(),
                            $system,
                            time(),
                            $theme,
                        ]);

}
            mail($reg_mail, $subject, $mail, $adds);

 echo '<div class="menu"><p><h3>' . _t('Your registratiton data') . '</h3>'
            . _t('Your ID') . ': <b>' . $usid . '</b><br>'
            . _t('Username') . ': <b>' . $reg_nick . '</b><br>'
            . _t('Password') . ': <b>' . $reg_pass . '</b></p>'
            . _t('Mail') . ': <b>' . $reg_mail . '</b></p>'
            . _t('Detail') . ': <b>' . $reg_about . '</b></p>';
            echo 'Thank you for register with Us';


        if ($config->mod_reg == 1) {
            echo '<p><span class="red"><b>' . _t('You can get authorized on the site after confirmation of your registration') . '</b></span></p>';
        } else {
            $_SESSION['uid'] = $usid;
            $_SESSION['ups'] = md5(md5($reg_pass));
           
            echo '<div><a href="' . $config->homeurl . '" class="btn btn-primary">Goto SIte Now!</a><div>';
        }

        echo '</div></div>';
        require('./system/end.php');
        exit;
    }
}

// Форма регистрации
if ($config->mod_reg == 1) {
    echo '<div class="rmenu"><p>' . _t('You can get authorized on the site after confirmation of your registration.') . '</p></div>';
}


echo '
        <div class="ossn-widget ">
    <div class="widget-heading">Sign Up an account with Us!</div>
    <div class="widget-contents">
        <p>Its free and always will be.</p><form action="index.php" method="post" class="ossn-form"><fieldset>' .
    '<div>Username' .
    (isset($error['login']) ? '<span class="red"><small>' . implode('<br />',
            $error['login']) . '</small></span><br />' : '') .
    '<input type="text" name="nick" size="20" class="bz-in" value="' . htmlspecialchars($reg_nick) . '"' . (isset($error['login']) ? ' ' : '') . '/><br />' .
    '</div>' .
    '<div>Password' .
    (isset($error['password']) ? '<span class="red"><small>' . implode('<br />',
            $error['password']) . '</small></span><br />' : '') .
    '<input type="text" name="password" size="20" class="bz-in" value="' . htmlspecialchars($reg_pass) . '"' . (isset($error['password']) ? ' ' : '') . '/><br>' .
    '</div>' .
    '<h3>' . _t('Enter Email') . '</h3>' .
    (isset($error['mail']) ? '<span class="red"><small>' . implode('<br />',
            $error['mail']) . '</small></span><br />' : '') .
    '<input type="text" name="mail" maxlength="40" value="' . htmlspecialchars($reg_mail) . '"' . (isset($error['mail']) ? ' style="background-color: #FFCCCC"' : '') . '/><br>' .
    '<small>' . _t('Ensure to insert valid email address because your login details will be forwarded to it') . '</small></p>' .
     '<p><h3>' . _t('Date of birth') . '</h3>' .
     '<select name="dayb"
size="1">
    <option value="01"> 01 </option>
    <option value="02"> 02 </option>
    <option value="03"> 03 </option>
    <option value="04"> 04 </option>
    <option value="05"> 05 </option>
    <option value="06"> 06 </option>
    <option value="07"> 07 </option>
    <option value="08"> 08 </option>
    <option value="09"> 09 </option>
    <option value="10"> 10 </option>
    <option value="11"> 11 </option>
    <option value="12"> 12 </option>
    <option value="13"> 13 </option>
    <option value="14"> 14 </option>
    <option value="15"> 15 </option>
    <option value="16"> 16 </option>
    <option value="17"> 17 </option>
    <option value="18"> 18 </option>
    <option value="19"> 19 </option>
    <option value="20"> 20 </option>
    <option value="21"> 21 </option>
    <option value="22"> 22 </option>
    <option value="23"> 23 </option>
    <option value="24"> 24 </option>
    <option value="25"> 25 </option>
    <option value="26"> 26 </option>
    <option value="27"> 27 </option>
    <option value="28"> 28 </option>
    <option value="29"> 29 </option>
    <option value="30"> 30 </option>
    <option value="31"> 31 </option>
    </select>&#160;-&#160;<select name="monthb"
size="1">
    <option value="01"> January </option>
    <option value="02"> February </option>
    <option value="03"> March </option>
    <option value="04"> April </option>
    <option value="05"> May </option>
    <option value="06"> June </option>
    <option value="07"> July </option>
    <option value="08"> August </option>
    <option value="09"> September </option>
    <option value="10"> October </option>
    <option value="11"> November </option>
    <option value="12"> December </option></select>&#160;-&#160;<select name="yearofbirth"
size="1">
    <option value="2009"> 2009 </option>
    <option value="2008"> 2008 </option>
    <option value="2007"> 2007 </option>
    <option value="2006"> 2006 </option>
    <option value="2005"> 2005 </option>
    <option value="2004"> 2004 </option>
    <option value="2003"> 2003 </option>
    <option value="2002"> 2002 </option>
    <option value="2001"> 2001 </option>
    <option value="2000"> 2000 </option>
    <option value="1999"> 1999 </option>
    <option value="1998"> 1998 </option>
    <option value="1997"> 1997 </option>
    <option value="1996"> 1996 </option>
    <option value="1995"> 1995 </option>
    <option value="1994"> 1994 </option>
    <option value="1993"> 1993 </option>
    <option value="1992"> 1992 </option>
    <option value="1991"> 1991 </option>
    <option value="1990"> 1990 </option>
    <option value="1989"> 1989 </option>
    <option value="1988"> 1988 </option>
    <option value="1987"> 1987 </option>
    <option value="1986"> 1986 </option>
    <option value="1985"> 1985 </option>
    <option value="1984"> 1984 </option>
    <option value="1983"> 1983 </option>
    <option value="1982"> 1982 </option>
    <option value="1981"> 1981 </option>
    <option value="1980"> 1980 </option>
    <option value="1979"> 1979 </option>
    <option value="1978"> 1978 </option>
    <option value="1977"> 1977 </option>
    <option value="1976"> 1976 </option>
    <option value="1975"> 1975 </option>
    <option value="1974"> 1974 </option>
    <option value="1973"> 1973 </option>
    <option value="1972"> 1972 </option>
    <option value="1971"> 1971 </option>
    <option value="1970"> 1970 </option>
    <option value="1969"> 1969 </option>
    <option value="1968"> 1968 </option>
    <option value="1967"> 1967 </option>
    <option value="1966"> 1966 </option>
    <option value="1965"> 1965 </option>
    <option value="1964"> 1964 </option>
    <option value="1963"> 1963 </option>
    <option value="1962"> 1962 </option>
    <option value="1961"> 1961 </option>
    <option value="1960"> 1960 </option>
    <option value="1959"> 1959 </option>
    <option value="1958"> 1958 </option>
    <option value="1957"> 1957 </option>
    <option value="1956"> 1956 </option>
    <option value="1955"> 1955 </option>
    <option value="1954"> 1954 </option>
    <option value="1953"> 1953 </option>
    <option value="1952"> 1952 </option>
    <option value="1951"> 1951 </option>
    <option value="1950"> 1950 </option>
    <option value="1949"> 1949 </option>
    <option value="1948"> 1948 </option>
    <option value="1947"> 1947 </option>
    <option value="1946"> 1946 </option>
    <option value="1945"> 1945 </option>
    <option value="1944"> 1944 </option>
    <option value="1943"> 1943</option>
    <option value="1942"> 1942 </option>
    <option value="1941"> 1941 </option>
    </select></p>' .
    '<div><div class="radio-block"><div class="radio-block">' .
    (isset($error['sex']) ? '<span class="red"><small>' . $error['sex'] . '</small></span><br />' : '') .
    '<select name="sex"' . (isset($error['sex']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
    '<option value="?">-Gender-</option>' .
    '<option value="m"' . ($reg_sex == 'm' ? ' selected="selected"' : '') . '>' . _t('Man') . '</option>' .
    '<option value="zh"' . ($reg_sex == 'zh' ? ' selected="selected"' : '') . '>' . _t('Woman') . '</option>' .
    '</select>' .
    '</div></div></div>' .
    '<div>' . _t('Your name') . '' .
    '<input type="text" class="long-input" name="imname" size="20" value="' . htmlspecialchars($reg_name) . '" /><br />' .
    '</div>' .
    '<span class="grey">' . _t('Tell us a little about yourself') . ':</span><br/>' .
    '<textarea rows="3" class="long-input" name="about">' . htmlspecialchars($reg_about) . '</textarea><br />' .
    '<small>' . _t('Max. 1000 characters') . '</small></div>' .
    '<div class="gmenu">' .
    '<h3>' . _t('Verification code') . '</h3>' .
    '<img src="./captcha.php?r=' . rand(1000, 9999) . '" alt="' . _t('Captcha code') . '" border="1"/>' .
    (isset($error['captcha']) ? '<span class="red"><small>' . $error['captcha'] . '</small></span><br />' : '') .
    '<input type="text" size="11" maxlength="19"  name="captcha" ' . (isset($error['captcha']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '<p>
    By clicking Create an account, you agree to our        <a target="_blank" href="' . $config['homeurl'] . '/terms.php">Terms and Conditions</a>
</p>
<div class="ossn-loading ossn-hidden"></div>
' .
    '<input type="submit" name="submit" class="btn btn-success" value="Create an account"/></form>' .
    '</div>
</div>                  
       </div>     
</div>  
                </div>
            </div>
        </div>';

echo "</div></div>";
require('./system/end.php');
