<?php

/**
 * This file is part of JohnCMS Content Management System.
 *
 * @copyright JohnCMS Community
 * @license   https://opensource.org/licenses/GPL-3.0 GPL-3.0
 * @link      https://johncms.com JohnCMS Project
 */

declare(strict_types=1);

use Johncms\NavChain;
use Johncms\System\Http\Request;

defined('_IN_JOHNADM') || die('Error: restricted access');

/**
 * @var NavChain $nav_chain
 * @var Johncms\System\Users\User $user
 */

if ($user->rights < 9) {
    exit(__('Access denied'));
}

/** @var Request $request */
$request = di(Request::class);

$config = di('config')['indexpage'];
$nav_chain->add('Главная страница');

if (isset($_POST['submit'])) {
    // Сохраняем настройки системы
    $config['last_themes'] = $request->getPost('last_themes', 0, FILTER_VALIDATE_INT);
    $config['last_files'] = $request->getPost('last_files', 0, FILTER_VALIDATE_INT);
    $config['last_lib'] = $request->getPost('last_lib', 0, FILTER_VALIDATE_INT);

    $configFile = "<?php\n\n" . 'return ' . var_export(['indexpage' => $config], true) . ";\n";

    if (! file_put_contents(CONFIG_PATH . 'autoload/indexpage.local.php', $configFile)) {
        echo 'ERROR: Can not write system.local.php</body></html>';
        exit;
    }

    $confirmation = true;

    if (function_exists('opcache_reset')) {
        opcache_reset();
    }
    
        header('location: /admin/indexpage/');
}


echo $view->render(
    'admin::indexpage',
    [
        'config'      => $config,
        'confirmation' => $confirmation ?? false,
    ]
);