<?php

declare(strict_types=1);

namespace App\Http\Controllers;

use App\Rezka\FilmPageParser;
use App\Rezka\ListParser;
use Illuminate\Http\Request;

class FilmsController extends Controller
{
    public function index(ListParser $listParser, Request $request)
    {
        return $listParser->getFilms($request->input('url', '/'));
    }

    public function film(FilmPageParser $filmPageParser, Request $request)
    {
        //$filmPageParser->getFilm('/series/documentary/35875-kroshechnyy-mir-2020.html');
        //return $filmPageParser->getFilm('/films/fiction/46909-skvoz-realnosti-2020.html');
        if (!$request->has('url')) {
            abort(404);
        }
        return $filmPageParser->getFilm($request->input('url'));
    }

    public function episodes(FilmPageParser $filmPageParser, Request $request)
    {
        if (!$request->has('id', 'translator_id')) {
            abort(404);
        }
        return $filmPageParser->getEpisodesFromSite((int)$request->input('id'), (int)$request->input('translator_id'));
    }

    public function getStreamByEpisode(FilmPageParser $filmPageParser, Request $request)
    {
        if (!$request->has('id', 'translator_id', 'season', 'episode')) {
            abort(404);
        }
        return $filmPageParser->getStreamsByEpisode(
            (int)$request->input('id'),
            (int)$request->input('translator_id'),
            (int)$request->input('season'),
            (int)$request->input('episode'),
        );
    }

    public function getStreamForFilmTranslation(FilmPageParser $filmPageParser, Request $request)
    {
        if (!$request->has('id', 'translator_id')) {
            abort(404);
        }
        return $filmPageParser->getStreamForFilmTranslation(
            (int)$request->input('id'),
            (int)$request->input('translator_id')
        );
    }
}
