<?php
##### Немного информации
##### Модуль Кинотеатр для JohnCMS
##### Автор Гальцев Тимофей
##### VK: https://vk.com/galtsev_t
##### TG: https://t.me/galtsev_t

declare(strict_types=1);

namespace Films\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
//use Illuminate\Database\Eloquent\Relations\HasOne;
use Johncms\Casts\SpecialChars;
use stdClass;

//use Johncms\Casts\TimeToDate;
//use Johncms\Media\MediaEmbed;
//use Johncms\Security\HTMLPurifier;
//use Johncms\System\Legacy\Tools;
//use Johncms\Users\User;


class Films extends Model
{
    protected $table = 'films';
    public $timestamps = false;

    protected $casts = [
        'nameRu'            => SpecialChars::class,
        'nameEn'            => SpecialChars::class,
        'kinopoiskId'       => 'integer',
        'description'       => SpecialChars::class,
        'shortDescription'  => SpecialChars::class,
        'type'              => SpecialChars::class,
        'ratingAgeLimits'   => SpecialChars::class,
        'countries'         => 'array',
        'genres'            => 'array',
		'year'              => 'integer',
        'filmLength'        => 'integer',
    ];

    protected $fillable = [
        'nameRu',
        'nameEn',
        'kinopoiskId',
        'ratingKinopoisk',
        'ratingImdb',
        'description',
        'shortDescription',
        'type',
        'ratingAgeLimits',
        'countries',
        'genres',
        'year',
        'filmLength',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        //$this->connection = \Illuminate\Database\Capsule\Manager::connection();
    }

    public static function getSettings(string $name) {
        $connection = \Illuminate\Database\Capsule\Manager::connection();
        $sql = $connection->table('films_settings')->where('name', $name)->first();
        if(!$sql) {
            $sql = new stdClass();
            $sql->apiKinopoisk = 'null';
            $sql->apiVideoCDN = 'null';
            $sql->year = 'null';
        } else {
        $sql = json_decode($sql->value);
        }
        return $sql;
    }

    public function addFilm(array $filmInfo) {
        $connection = \Illuminate\Database\Capsule\Manager::connection();
        if($filmInfo['type'] == 'TV_SERIES' or $filmInfo['type'] == 'MINI_SERIES' or $filmInfo['type'] == 'TV_SHOW') {
            $filmInfo['type'] = 'SERIAL';
        }
        foreach($filmInfo['genres'] as $key => $value) {
            if($value['genre'] == 'мультфильм') {
                $filmInfo['type'] = 'CARTOON';
            }
        }
        $fileName = UPLOAD_PATH.'/films/'.$filmInfo['kinopoiskId'].'.jpg';
        $posterUrl = file_get_contents($filmInfo['posterUrlPreview']);
        if(file_put_contents($fileName, $posterUrl)) {
            return $connection->table('films')->insert(
                [
                    'nameRu'            => $filmInfo['nameRu'],
                    'nameEn'            => $filmInfo['nameRu'],
                    'kinopoiskId'       => $filmInfo['kinopoiskId'],
                    'ratingKinopoisk'   => $filmInfo['ratingKinopoisk'],
                    'ratingImdb'        => $filmInfo['ratingImdb'],
                    'description'       => $filmInfo['description'],
                    'shortDescription'  => $filmInfo['shortDescription'],
                    'type'              => $filmInfo['type'],
                    'ratingAgeLimits'   => $filmInfo['ratingAgeLimits'],
                    'countries'         => json_encode($filmInfo['countries'], JSON_UNESCAPED_UNICODE),
                    'genres'            => json_encode($filmInfo['genres'], JSON_UNESCAPED_UNICODE),
                    'year'              => $filmInfo['year'],
                    'filmLength'        => $filmInfo['filmLength'],
                ]
            );
        } else {
            return False;
        }

    }

    public function UpdateSettings (array $attributes = []) {
        $connection = \Illuminate\Database\Capsule\Manager::connection();
        $sql = $connection->table('films_settings')
        ->updateOrInsert(
            [
                'name' => 'base',
            ],
            [
                'value' => json_encode($attributes),
            ]
        );
        return $sql;
    }

}
