<?php
##### Немного информации
##### Модуль Кинотеатр для JohnCMS
##### Автор Гальцев Тимофей
##### VK: https://vk.com/galtsev_t
##### TG: https://t.me/galtsev_t

declare(strict_types=1);

namespace Films\Services;


class Plus
{
    public static function getApi(string $url, object $setting) { 
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_USERAGENT => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.192 Safari/537.36 OPR/74.0.3911.218",
        CURLOPT_TIMEOUT => 60,
        CURLOPT_HTTPHEADER => [
            'X-API-KEY: '.$setting->apiKinopoisk,
            'content-type: application/json'
            ],
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if($err) {
            return $err; 
        } else {
            return json_decode($response, TRUE);
        }
    }

    public static function getApiVideoCdn(int $kinopoiskId, object $setting) { 
        $url = 'https://videocdn.tv/api/short/?kinopoisk_id='. $kinopoiskId.'&api_token='.$setting->apiVideoCDN;
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_USERAGENT => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.192 Safari/537.36 OPR/74.0.3911.218",
        CURLOPT_TIMEOUT => 60,
        CURLOPT_HTTPHEADER => [
            'API_TOKEN: '.$setting->apiVideoCDN,
            'content-type: application/json'
            ],
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if($err) {
            return $err; 
        } else {
            return json_decode($response, TRUE);
        }
    }

    public static function translitSelf($value) {
        $converter = array(
            'а' => 'a',    'б' => 'b',    'в' => 'v',    'г' => 'g',    'д' => 'd',
            'е' => 'e',    'ё' => 'e',    'ж' => 'zh',   'з' => 'z',    'и' => 'i',
            'й' => 'y',    'к' => 'k',    'л' => 'l',    'м' => 'm',    'н' => 'n',
            'о' => 'o',    'п' => 'p',    'р' => 'r',    'с' => 's',    'т' => 't',
            'у' => 'u',    'ф' => 'f',    'х' => 'h',    'ц' => 'c',    'ч' => 'ch',
            'ш' => 'sh',   'щ' => 'sch',  'ь' => '',     'ы' => 'y',    'ъ' => '',
            'э' => 'e',    'ю' => 'yu',   'я' => 'ya',
        );
     
        $value = mb_strtolower($value);
        $value = strtr($value, $converter);
        $value = mb_ereg_replace('[^-0-9a-z]', '-', $value);
        $value = mb_ereg_replace('[-]+', '-', $value);
        $value = trim($value, '-');	
     
        return $value;
    }


}
