<?php
##### Немного информации
##### Модуль Кинотеатр для JohnCMS
##### Автор Гальцев Тимофей
##### VK: https://vk.com/galtsev_t
##### TG: https://t.me/galtsev_t

declare(strict_types=1);

namespace Films\Controllers\Admin;

use Admin\Controllers\BaseAdminController;
use Illuminate\Database\Eloquent\ModelNotFoundException;
//use Illuminate\Support\Str;
//use Johncms\Users\User;
use Johncms\System\Http\Session;
use Johncms\System\Http\Request;
use Johncms\Validator\Validator;
use Films\Models\Films;
use Films\Models\Category;
use Films\Services\Plus;
use Johncms\Exceptions\PageNotFoundException;

class FilmsAdminController extends BaseAdminController
{
    protected $module_name = 'films';
    public $settings;
    public $model;
    function __construct() {
        parent::__construct();
        $this->settings = Films::getSettings('base');
    }

    public function index(Request $request) {
        $model = new Films();
        if ($request->getMethod() === 'POST') {
            $film_data = Plus::getApi('https://kinopoiskapiunofficial.tech/api/v2.2/films/'. $request->getPost('kinopoiskId', 0, FILTER_VALIDATE_INT), $this->settings);
            //var_dump($film_data);
            if($film_data === NULL) {
                $this->render->addData(['errorMsg'  => 'Неверный kinopoiskId']);
            } else {
                $data = [
                    'kinopoiskId' => $film_data['kinopoiskId'],
                ];
                $rules = [
                    'kinopoiskId' => [
                        'ModelNotExists' => [
                            'model'   => \Films\Models\Films::class,
                            'field'   => 'kinopoiskId',
                        ],
                    ],
                ];
                $validator = new Validator($data, $rules);
                if($validator->isValid()) {
                if($model->addFilm($film_data)) {
                    $this->render->addData(['confirmation'  => true]);
                } } else {
                    $this->render->addData(['errorMsg'  => 'Фильм уже в базе']);
                }
            }
        }
        
        $data = $model->orderByDesc('id')->paginate(24);
        $this->render->addData(
            [
                'title'       => 'Список фильмов в базе',
                'page_title'  => 'Список фильмов в базе',
                'films_menu' => ['films_list' => true],
                'pagination' => $data->render(),
            ]
        );
        return $this->render->render('films::admin/index', ['data' => $data]);
    }

    public function settings (Request $request) {
        $model = new Films();
        if ($request->getMethod() === 'POST') {
            $form_data = [
                'apiKinopoisk'   => $request->getPost('apiKinopoisk', '', FILTER_SANITIZE_FULL_SPECIAL_CHARS),
                'apiVideoCDN'    => $request->getPost('apiVideoCDN', '', FILTER_SANITIZE_FULL_SPECIAL_CHARS),
                'year'           => $request->getPost('year', 0, FILTER_VALIDATE_INT),
            ];

            $model->updateSettings($form_data);
            $this->render->addData(['confirmation'  => true]);
        }
        $data = $model->getSettings('base');
        $this->render->addData(
            [
                'title'       => 'Изменение настроек',
                'page_title'  => 'Изменение настроек',
                'films_menu'  => ['film_settings' => true],
            ]
        );

        return $this->render->render('films::admin/settings', ['data' => $data]);
    }

    public function deleteFilm (int $delete_id) {
        $film = (new Films())
        ->where('id', $delete_id)
        ->first();
        if ($film === null) {
            throw new PageNotFoundException('Фильм не найден');
        } else {
            $fileName = UPLOAD_PATH.'/films/'.$film['kinopoiskId'].'.jpg';
            $film->delete();
            unlink($fileName);
            redirect('/admin/films/index/');
        }
    }

    public function categoryFilms (Request $request) {
        $data = new Category();
        if ($request->getMethod() === 'POST') {
            $form_data = [
                'nameRu'        => $request->getPost('nameRu', '', FILTER_SANITIZE_FULL_SPECIAL_CHARS),
                'nameEn'        => Plus::translitSelf($request->getPost('nameRu', '', FILTER_SANITIZE_FULL_SPECIAL_CHARS)),
                'films'         => $request->getPost('films', '', FILTER_VALIDATE_INT),
                'serials'       => $request->getPost('serials', '', FILTER_VALIDATE_INT),
                'cartoons'      => $request->getPost('cartoons', '', FILTER_VALIDATE_INT) 
            ];

            $data_validator = [
                'nameRu' => $form_data['nameRu'],
            ];
            $rules = [
                'nameRu' => [
                    'ModelNotExists' => [
                        'model'   => \Films\Models\Category::class,
                        'field'   => 'nameRu',
                    ],
                    'NotEmpty'      => [
                        'type'    => [
                            'string',
                        ]
                        ],
                ],
            ];
            $validator = new Validator($data_validator, $rules);
            if($validator->isValid()) {
                $data->create($form_data);
                $this->render->addData(['confirmation'  => true]);
            }  else {
                $this->render->addData(['errorMsg'  => 'Ошибка категория уже существует или не соответствует параметрам']);
            }
        }

        $category = $data->orderByDesc('id')->paginate(20);
        $this->render->addData(
            [
                'title'         => 'Категории',
                'page_title'    => 'Управление категориями',
                'films_menu'    => ['film_category' => true],
                'count'         => $data->count(),
            ]
            );
        return $this->render->render('films::admin/category', ['data' => $category]);
    }

    public function deleteCategory (int $delete_id) {
        $category = (new Category())
        ->where('id', $delete_id)
        ->first();
        if ($category === null) {
            throw new PageNotFoundException('Категория не найдена');
        } else {
            $category->delete();
            redirect('/admin/films/category/');
        }
    }

    public function editCategory (int $edit_id, Request $request) {
        $category = (new Category())
        ->where('id', $edit_id)
        ->first();
        if ($category === null) {
            throw new PageNotFoundException('Категория не найдена');
        } else {
            if ($request->getMethod() === 'POST') {
                $form_data = [
                    'nameRu'        => $request->getPost('nameRu', '', FILTER_SANITIZE_FULL_SPECIAL_CHARS),
                    'nameEn'        => Plus::translitSelf($request->getPost('nameRu', '', FILTER_SANITIZE_FULL_SPECIAL_CHARS)),
                    'films'         => $request->getPost('films', '', FILTER_VALIDATE_INT),
                    'serials'       => $request->getPost('serials', '', FILTER_VALIDATE_INT),
                    'cartoons'      => $request->getPost('cartoons', '', FILTER_VALIDATE_INT) 
                ];
    
                $data_validator = [
                    'nameRu' => $form_data['nameRu'],
                ];
                $rules = [
                    'nameRu' => [
                        'NotEmpty'      => [
                            'type'    => [
                                'string',
                            ]
                            ],
                    ],
                ];
                $validator = new Validator($data_validator, $rules);
                if($validator->isValid()) {
                    $category->update($form_data);
                    $this->render->addData(['confirmation'  => 'Изменения сохранены']);
                }  else {
                    $this->render->addData(['errorMsg'  => 'Заполните название']);
                }
            }

            $this->render->addData(
                [
                    'title'         => 'Изменение категории',
                    'page_title'    => 'Изменение категории '. $category->nameRu,
                    'films_menu'    => ['film_category' => true],
                ]
                );
            return $this->render->render('films::admin/editcategory', ['data' => $category]);
        }
    }


}
