<?php

declare(strict_types=1);

/**
 * @var FastRoute\RouteCollector $map
 */

// Пример файла для маршрутов дополнительных модулей.
// Для использования файла, убрать расширение .example
// Должно получиться routes.local.php

/*
 * /contacts/ - Это адрес страницы по которому будет доступен наш модуль
 * modules/contacts/index.php - Это путь к точке входа в наш модуль
 */

$map->addRoute(['GET', 'POST'], '/contacts/[{city}/[{id:\d+}/[{street}/]]]', 'modules/contacts/index.php');
$map->get('/', [Indexpage\Controllers\IndexpageController::class, 'index']);