<?php
declare(strict_types=1);
use Johncms\NavChain;

defined('_IN_JOHNADM') || die('Error: restricted access');
$data = [
	'title' => 'Не важно )))', 
	'page_title' => 'Просмотр ошибок', 
];
$nav_chain->add('Просмотр ошибок');

/*	Функция форматированного вывода размера файла	*/
function read_file($file) {
	if (file_exists($file) && is_file($file)) {
		return format_size(filesize($file));
	} else {
		return 0;
	}
}

/*	Функция подсчета веса директории	*/
function read_cat($cat) {
	if (empty($allsize)) { $allsize = 0; }
	if ($path = opendir($cat)) {
		while ($file_name = readdir($path)) {
			if (($file_name !== '.') && ($file_name !== '..')) {
				if (is_dir($cat."/".$file_name)) {
					$allsize += read_cat($cat."/".$file_name);
				} else {
					$allsize += filesize($cat."/".$file_name);
				}
			}
		}	closedir ($path);
	}	return $allsize;
}

#	Проверяем права доступа
if ($user->rights < 9) {
	echo $view->render(
		'system::pages/result', [
			'title'       => 'Мал еще',
			'type'        => 'alert-danger',
			'message'     => 'У вас недостаточно прав!',
			'admin'       => true,
			'menu_item'   => 'errorlog',
			'parent_menu' => 'sys_menu',
		]
	);
	exit();
}

$data['deg']	 = (DEBUG == 1) ? '<b class="badge badge-pill badge-success">On</b>' : '<b class="badge badge-pill badge-primary">Off</b>' ;
$data['deg_all'] = (DEBUG_FOR_ALL == 1) ? '<b class="badge badge-pill badge-danger">On</b>' : '<b class="badge badge-pill badge-success">Off</b>' ;

$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';
switch ($mod) {
	############################################################
	## 					Удаление всех  файлоф				  ##
	############################################################
    case 'clear':
		$log_files = glob(LOG_PATH.'*.log');
		foreach ($log_files as $file) {
			unlink ($file);
		}
		header('Location: ?');
	break;
	
	############################################################
	## 					Удаление отдельного файла			  ##
	############################################################
    case 'del':
		$log_file = ($_GET['log']);
			if (! empty($log_file)) {
				//if (preg_match('|^[\w\.\-]+$|i', $log_file)) {
					if (file_exists(LOG_PATH.''.$log_file)) {
						unlink (LOG_PATH.''.$log_file);
							
						echo $view->render(
							'system::pages/result', [
								'title'         => 'Очистка логов',
								'type'          => 'alert-success',
								'message'       => 'Файл успешно удален!',
								'back_url'      => '?',
								'back_url_name' => 'Продолжить',
							]
						);
						// header('Location: ?');
						$error_show = '';
					} else { $error_show = 'Ошибка! Данного файла не существует!'; }
				//} else { $error_show = 'Ошибка! Недопустимое название файла!'; }
			} else { $error_show = 'Ошибка! Вы не выбрали файл для удаления!'; }
				
				echo $view->render(
					'system::pages/result',	[
						'title'    => 'Очистка логов',
						'type'     => 'alert-danger',
						'message'  => $error_show,
						'back_url' => '/admin/errorlog/',
					]
				);
	break;
	
	############################################################
	##						 Обзор файла					  ##
	############################################################
	case 'obzor':
		$file					= ($_GET['file']);
		if (file_exists(LOG_PATH . "$file")) {
			$data['file']		= $file;
			$data['count']		= (int)count(file(LOG_PATH . "$file")); // Строк
			$data['text']		= file_get_contents(LOG_PATH . "$file"); // text
		} else {
			echo $view->render(
				'system::pages/result',	[
					'title'    => 'Ошибка',
					'type'     => 'alert-danger',
					'message'  => 'Ошибка! Данного файла не существует!',
					'back_url' => '/admin/errorlog/',
				]
			);
		}

		#	Подключаем шаблон view.phtml и передаем в него собранные выше данные
		echo $view->render(
			'admin::errorlog/view', [
				'data'			=> $data,
			]
		);
	break;


	############################################################
	##			Вывод всех файлов с размером и датой		  ##
	############################################################
    default:
		$log_files			= glob(LOG_PATH.'*.log');
		$total				= count($log_files);
		
		foreach ($log_files as $file) {
			$data['errorlog']	[]	= [
				'name'		=> basename($file),
				'size'		=> read_file($file),
				'date'		=> $tools->displayDate(filemtime($file)),
			];
		}

		$data['total']		= $total;
		$data['size_dir']	= format_size(read_cat(LOG_PATH));

		#	Подключаем шаблон index.phtml и передаем в него собранные выше данные
		echo $view->render(
			'admin::errorlog/index', [
				'data'		=> $data
			]
		);
	break; // Добавил break для симетрии кода
}
