<?php
declare(strict_types=1);
defined('_IN_JOHNADM') || die('Error: restricted access');
$data = ['title' => 'кэш', 'page_title' => 'Очистить кэш', ];
$nav_chain->add('Очистить кэш', '?');

// --------------- Функция правильного вывода веса файла -------------------//
function formatsize($file_size) {
	if ($file_size >= 1048576000) {
		$file_size = round(($file_size / 1073741824), 2)." Gb";
	} elseif ($file_size >= 1024000) {
		$file_size = round(($file_size / 1048576), 2)." Mb";
	} elseif ($file_size >= 1000) {
		$file_size = round(($file_size / 1024), 2)." Kb";
	} else {
		$file_size = round($file_size)." byte";
	}
	return $file_size;
}

// --------------- Функция форматированного вывода размера файла -------------------//
function read_file($file) {
	if (file_exists($file) && is_file($file)) {
		return formatsize(filesize($file));
	} else {
		return 0;
	}
}
function clearCache() {
	#	Выбираем все файлы с названием и расширением
	$cachefiles = glob(CACHE_PATH.'*.*');
	$cachefiles = array_diff(
		$cachefiles, array(
			#Запрещаем удаление снимка Антишпион
			CACHE_PATH.'security-scanner-snapshot.cache',
			#	'Через 3апетую можно добовить другие исключения',
		)
	);

	if (is_array($cachefiles) && count($cachefiles)>0){
		foreach ($cachefiles as $file) {
			unlink ($file);
		}
	}
	return true;
}

// Проверяем права доступа
if ($user->rights < 9) {
	echo $view->render(
		'system::pages/result', [
			'title'       => 'Мал еще',
			'type'        => 'alert-danger',
			'message'     => 'У вас недостаточно прав!',
			'admin'       => true,
			'menu_item'   => 'caches',
			'parent_menu' => 'sys_menu',
		]
	);
	exit();
}

$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';
switch ($mod) {
	############################################################
	## 					Удаление файлоф кэш					  ##
	############################################################
    case 'clear':
		clearCache();
		header('Location: ?');
	break;

	############################################################
	##			Вывод всех файлов с размером и датой		  ##
	############################################################
    default:
	
		$chefiles = glob(CACHE_PATH.'*.*');
		$total = count($chefiles);

		if (is_array($chefiles) && $total > 0) {
			foreach ($chefiles as $file) {
				$data['caches'] [] = [
                    'name' => basename($file),
                    'size' => read_file($file),
                    'date' => $tools->displayDate(filemtime($file)),
                ];
			}

			$data['total'] = $total;
			// Подключаем шаблон index.phtml и передаем в него собранные выше данные
			echo $view->render('admin::caches', ['data' => $data]);

			//echo '<a href="/admin/caches/?mod=clear">Очистить кэш</a><br />';
		} else {
			echo 'Нет данных';
		}
		echo '<br />Всего файлов: '. $total .'<br /><br />';

}
