<?php
declare(strict_types=1);

namespace Qa;

use Qa\Actions\AbstractAction;

class Responder
{
    public function findAction(Context $context) : ?AbstractAction
    {
        switch ($context->routeAction()) {
            case 'index':
                return new \Qa\Actions\Index($context);
            case 'tag':
                return new \Qa\Actions\Tag($context);
            case 'search':
                return new \Qa\Actions\Search($context);
            case 'unread':
                return new \Qa\Actions\Unread($context);

            case 'answers':
                return new \Qa\Actions\Answers($context);
            case 'comments':
                return new \Qa\Actions\Comments($context);
            case 'reset':
                return new \Qa\Actions\Reset($context);

            case 'show':
                return new \Qa\Actions\Show($context);
            case 'findanswer':
                return new \Qa\Actions\FindAnswer($context);

            case 'ask':
              return new \Qa\Actions\Ask($context);
            case 'edit':
              return new \Qa\Actions\EditQuestion($context);
            case 'delete':
              return new \Qa\Actions\DeleteQuestion($context);

            case 'answer':
                return new \Qa\Actions\Answer($context);
            case 'editanswer':
                return new \Qa\Actions\EditAnswer($context);
            case 'delanswer':
                return new \Qa\Actions\DeleteAnswer($context);

            case 'comment':
                return new \Qa\Actions\Comment($context);
            case 'editcomment':
                return new \Qa\Actions\EditComment($context);
            case 'delcomment':
                return new \Qa\Actions\DeleteComment($context);

            case 'file':
                return new \Qa\Actions\File($context);

            case 'votequestion':
            case 'voteanswer':
                return new \Qa\Actions\Vote($context);

            case 'install':
                return new \Qa\Actions\Install($context);

            default:
                return null;
        }
    }
}
