<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Unread extends Index
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Непрочитанные';
    }

    public function invoke() : void
    {
        $user = $this->context->user();
        if (!$user->isValid()) {
            $this->resultUnauthorized();
        } else {
            parent::listQuestions('unread');
        }
    }

    protected function getQuestions($mode, $param, $start, $limit): array
    {
        $questionsEntity = $this->context->questionsEntity();
        return $questionsEntity->getUnread($start, $limit);
    }
}
