<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Reset extends AbstractAction
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
    }

    public function invoke() : void
    {
        $user = $this->context->user();
        if (!$user->isValid()) {
            header('Location: /qa/');
            return;
        }

        $entity = $this->context->routeParam() ?: 'questions';
        if ($entity == 'questions') {
            $this->context->questionsEntity()->resetUnread();
            $_SESSION['alert'] = [
                'type' => 'alert-success',
                'content' => 'Непрочитанные вопросы сброшены'
            ];
        } else {
            $this->context->answersEntity()->resetUnread();
            $_SESSION['alert'] = [
                'type' => 'alert-success',
                'content' => 'Непрочитанные ответы сброшены'
            ];
        }
        header('Location: /qa/');
    }
}
